/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.CoordinatedReactiveControlAdder;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControlAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegulatingControlMappingForGenerators {
    private static final String QPERCENT = "qPercent";
    private final RegulatingControlMapping parent;
    private final Map<String, CgmesRegulatingControlForGenerator> mapping;
    private final Context context;
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingControlMappingForGenerators.class);

    RegulatingControlMappingForGenerators(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.mapping = new HashMap<String, CgmesRegulatingControlForGenerator>();
    }

    public static void initialize(GeneratorAdder adder) {
        adder.setVoltageRegulatorOn(false);
    }

    public void add(String generatorId, PropertyBag sm) {
        String cgmesRegulatingControlId = RegulatingControlMapping.getRegulatingControlId(sm);
        double qPercent = sm.asDouble(QPERCENT);
        if (this.mapping.containsKey(generatorId)) {
            throw new CgmesModelException("Generator already added, IIDM Generator Id: " + generatorId);
        }
        CgmesRegulatingControlForGenerator rd = new CgmesRegulatingControlForGenerator();
        rd.regulatingControlId = cgmesRegulatingControlId;
        rd.qPercent = qPercent;
        rd.controlEnabled = sm.asBoolean("controlEnabled", false);
        this.mapping.put(generatorId, rd);
    }

    void applyRegulatingControls(Network network) {
        network.getGeneratorStream().forEach(this::apply);
    }

    private void apply(Generator gen) {
        CgmesRegulatingControlForGenerator rd = this.mapping.get(gen.getId());
        this.apply(gen, rd);
    }

    private void apply(Generator gen, CgmesRegulatingControlForGenerator rc) {
        if (rc == null) {
            return;
        }
        String controlId = rc.regulatingControlId;
        if (controlId == null) {
            LOG.trace("Regulating control Id not present for generator {}", (Object)gen.getId());
            return;
        }
        RegulatingControlMapping.RegulatingControl control = this.parent.cachedRegulatingControls().get(controlId);
        if (control == null) {
            this.context.missing(String.format("Regulating control %s", controlId));
            return;
        }
        boolean okSet = false;
        if (RegulatingControlMapping.isControlModeVoltage(control.mode)) {
            okSet = this.setRegulatingControlVoltage(controlId, control, rc.qPercent, rc.controlEnabled, gen);
        } else if (RegulatingControlMapping.isControlModeReactivePower(control.mode)) {
            okSet = this.setRegulatingControlReactivePower(controlId, control, rc.qPercent, rc.controlEnabled, gen);
        } else {
            this.context.ignored(control.mode, "Unsupported regulation mode for generator " + gen.getId());
        }
        control.setCorrectlySet(okSet);
    }

    private boolean setRegulatingControlVoltage(String controlId, RegulatingControlMapping.RegulatingControl control, double qPercent, boolean eqControlEnabled, Generator gen) {
        double targetV;
        Terminal regulatingTerminal = RegulatingTerminalMapper.mapForVoltageControl(control.cgmesTerminal, this.context).orElse(gen.getTerminal());
        if (control.targetValue <= 0.0 || Double.isNaN(control.targetValue)) {
            targetV = regulatingTerminal.getVoltageLevel().getNominalV();
            regulatingTerminal = gen.getTerminal();
            this.context.fixed(controlId, "Invalid value for regulating target value. Regulation considered as local.", control.targetValue, targetV);
        } else {
            targetV = control.targetValue;
        }
        boolean voltageRegulatorOn = control.enabled && eqControlEnabled;
        gen.setRegulatingTerminal(regulatingTerminal).setTargetV(targetV).setVoltageRegulatorOn(voltageRegulatorOn);
        if (!Double.isNaN(qPercent)) {
            ((CoordinatedReactiveControlAdder)gen.newExtension(CoordinatedReactiveControlAdder.class)).withQPercent(qPercent).add();
        }
        gen.setProperty("CGMES.RegulatingControl", controlId);
        return true;
    }

    private boolean setRegulatingControlReactivePower(String controlId, RegulatingControlMapping.RegulatingControl control, double qPercent, boolean eqControlEnabled, Generator gen) {
        RegulatingTerminalMapper.TerminalAndSign mappedRegulatingTerminal = RegulatingTerminalMapper.mapForFlowControl(control.cgmesTerminal, this.context).orElseGet(() -> new RegulatingTerminalMapper.TerminalAndSign(null, 1));
        if (mappedRegulatingTerminal.getTerminal() == null) {
            this.context.ignored(controlId, String.format("Regulation terminal %s is not mapped or mapped to a switch", control.cgmesTerminal));
            return false;
        }
        if (Double.isNaN(control.targetValue)) {
            this.context.fixed(controlId, "Invalid value for regulating target value. Real flows are considered targets.");
            return false;
        }
        double targetQ = control.targetValue;
        ((RemoteReactivePowerControlAdder)gen.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(targetQ * (double)mappedRegulatingTerminal.getSign()).withRegulatingTerminal(mappedRegulatingTerminal.getTerminal()).withEnabled(control.enabled && eqControlEnabled).add();
        if (!Double.isNaN(qPercent)) {
            ((CoordinatedReactiveControlAdder)gen.newExtension(CoordinatedReactiveControlAdder.class)).withQPercent(qPercent).add();
        }
        gen.setProperty("CGMES.RegulatingControl", controlId);
        return true;
    }

    private static final class CgmesRegulatingControlForGenerator {
        String regulatingControlId;
        double qPercent;
        boolean controlEnabled;

        private CgmesRegulatingControlForGenerator() {
        }
    }
}

