/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegulatingControlMappingForShuntCompensators {
    private final RegulatingControlMapping parent;
    private final Context context;
    private final Map<String, CgmesRegulatingControlForShuntCompensator> mapping;
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingControlMappingForShuntCompensators.class);

    RegulatingControlMappingForShuntCompensators(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.mapping = new HashMap<String, CgmesRegulatingControlForShuntCompensator>();
    }

    public void add(String iidmId, PropertyBag p) {
        String rcId = RegulatingControlMapping.getRegulatingControlId(p);
        boolean controlEnabled = p.asBoolean("controlEnabled", false);
        if (this.mapping.containsKey(iidmId)) {
            throw new CgmesModelException("ShuntCompensator already added, IIDM ShuntCompensator Id: " + iidmId);
        }
        this.mapping.put(iidmId, new CgmesRegulatingControlForShuntCompensator(rcId, controlEnabled));
    }

    void applyRegulatingControls(Network network) {
        network.getShuntCompensatorStream().forEach(this::apply);
    }

    private void apply(ShuntCompensator shuntCompensator) {
        CgmesRegulatingControlForShuntCompensator cgmesRc = this.mapping.get(shuntCompensator.getId());
        this.apply(shuntCompensator, cgmesRc);
    }

    private void apply(ShuntCompensator shuntCompensator, CgmesRegulatingControlForShuntCompensator cgmesRc) {
        if (cgmesRc == null) {
            return;
        }
        String rcId = cgmesRc.regulatingControlId;
        if (!cgmesRc.controlEnabled) {
            RegulatingControlMapping.RegulatingControl rc;
            if (rcId != null && (rc = this.parent.cachedRegulatingControls().get(rcId)) != null) {
                this.setRegulatingControl(shuntCompensator, rcId, rc, cgmesRc.controlEnabled);
            }
            return;
        }
        if (rcId == null) {
            LOG.trace("Regulating control Id not present for shunt compensator {}", (Object)shuntCompensator.getId());
            this.setDefaultRegulatingControl(shuntCompensator);
            return;
        }
        RegulatingControlMapping.RegulatingControl rc = this.parent.cachedRegulatingControls().get(rcId);
        if (rc == null) {
            this.context.missing(String.format("Regulating control %s", rcId));
            this.setDefaultRegulatingControl(shuntCompensator);
            return;
        }
        this.setRegulatingControl(shuntCompensator, rcId, rc, cgmesRc.controlEnabled);
        rc.setCorrectlySet(true);
    }

    private void setDefaultRegulatingControl(ShuntCompensator shuntCompensator) {
        shuntCompensator.setTargetV(Optional.ofNullable(shuntCompensator.getTerminal().getBusView().getBus()).map(Bus::getV).filter(v -> !Double.isNaN(v)).orElseGet(() -> shuntCompensator.getTerminal().getVoltageLevel().getNominalV()).doubleValue()).setTargetDeadband(0.0).setVoltageRegulatorOn(true);
    }

    private void setRegulatingControl(ShuntCompensator shuntCompensator, String rcId, RegulatingControlMapping.RegulatingControl rc, boolean controlEnabled) {
        shuntCompensator.setTargetV(rc.targetValue).setTargetDeadband(rc.targetDeadband);
        if (rc.targetValue > 0.0) {
            shuntCompensator.setVoltageRegulatorOn(rc.enabled && controlEnabled);
        } else {
            shuntCompensator.setVoltageRegulatorOn(false);
        }
        shuntCompensator.setRegulatingTerminal(RegulatingTerminalMapper.mapForVoltageControl(rc.cgmesTerminal, this.context).orElse(shuntCompensator.getTerminal()));
        shuntCompensator.setProperty("CGMES.RegulatingControl", rcId);
    }

    private static class CgmesRegulatingControlForShuntCompensator {
        String regulatingControlId;
        boolean controlEnabled;

        CgmesRegulatingControlForShuntCompensator(String regulatingControlId, boolean controlEnabled) {
            this.regulatingControlId = regulatingControlId;
            this.controlEnabled = controlEnabled;
        }
    }
}

