/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;

public class RegulatingControlMappingForVscConverters {
    private final Map<String, CgmesRegulatingControlForVscConverter> mapping;
    private final Context context;

    RegulatingControlMappingForVscConverters(Context context) {
        this.context = context;
        this.mapping = new HashMap<String, CgmesRegulatingControlForVscConverter>();
    }

    public static void initialize(VscConverterStationAdder adder) {
        adder.setVoltageRegulatorOn(false).setReactivePowerSetpoint(0.0);
    }

    public void add(String vscConverterId, PropertyBag sm) {
        if (this.mapping.containsKey(vscConverterId)) {
            throw new CgmesModelException("VscConverter already added, IIDM VscConverter Id: " + vscConverterId);
        }
        CgmesRegulatingControlForVscConverter rd = new CgmesRegulatingControlForVscConverter();
        rd.vscRegulation = sm.getLocal("qPccControl");
        rd.voltageSetpoint = sm.asDouble("targetUpcc");
        rd.reactivePowerSetpoint = -sm.asDouble("targetQpcc");
        rd.pccTerminal = sm.getId("PccTerminal");
        this.mapping.put(vscConverterId, rd);
    }

    private static VscRegulation decodeVscRegulation(String qPccControl) {
        if (qPccControl != null) {
            if (qPccControl.endsWith("voltagePcc")) {
                return VscRegulation.VOLTAGE;
            }
            if (qPccControl.endsWith("reactivePcc")) {
                return VscRegulation.REACTIVE_POWER;
            }
        }
        return null;
    }

    void applyRegulatingControls(Network network) {
        network.getVscConverterStationStream().forEach(this::apply);
    }

    private void apply(VscConverterStation vscConverter) {
        CgmesRegulatingControlForVscConverter rd = this.mapping.get(vscConverter.getId());
        this.apply(vscConverter, rd);
    }

    private void apply(VscConverterStation vscConverter, CgmesRegulatingControlForVscConverter rc) {
        if (rc == null) {
            return;
        }
        VscRegulation vscRegulation = RegulatingControlMappingForVscConverters.decodeVscRegulation(rc.vscRegulation);
        if (vscRegulation == VscRegulation.VOLTAGE) {
            this.setRegulatingControlVoltage(rc, vscConverter);
        } else if (vscRegulation == VscRegulation.REACTIVE_POWER) {
            this.setRegulatingControlReactivePower(rc, vscConverter);
        } else {
            String what = rc.vscRegulation;
            if (rc.vscRegulation == null) {
                what = "EmptyVscRegulation";
            }
            this.context.ignored(what, "Unsupported regulation mode for vscConverter " + vscConverter.getId());
        }
    }

    private void setRegulatingControlVoltage(CgmesRegulatingControlForVscConverter rc, VscConverterStation vscConverter) {
        Terminal regulatingTerminal = RegulatingTerminalMapper.mapForVoltageControl(rc.pccTerminal, this.context).orElse(vscConverter.getTerminal());
        vscConverter.setVoltageSetpoint(rc.voltageSetpoint).setReactivePowerSetpoint(0.0).setRegulatingTerminal(regulatingTerminal).setVoltageRegulatorOn(true);
    }

    private void setRegulatingControlReactivePower(CgmesRegulatingControlForVscConverter rc, VscConverterStation vscConverter) {
        RegulatingTerminalMapper.TerminalAndSign mappedRegulatingTerminal = RegulatingTerminalMapper.mapForFlowControl(rc.pccTerminal, this.context).orElseGet(() -> new RegulatingTerminalMapper.TerminalAndSign(vscConverter.getTerminal(), 1));
        vscConverter.setVoltageSetpoint(0.0).setReactivePowerSetpoint(rc.reactivePowerSetpoint * (double)mappedRegulatingTerminal.getSign()).setRegulatingTerminal(mappedRegulatingTerminal.getTerminal()).setVoltageRegulatorOn(false);
    }

    private static class CgmesRegulatingControlForVscConverter {
        String vscRegulation;
        double voltageSetpoint;
        double reactivePowerSetpoint;
        String pccTerminal;

        private CgmesRegulatingControlForVscConverter() {
        }
    }

    static enum VscRegulation {
        REACTIVE_POWER,
        VOLTAGE;

    }
}

