/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForGenerators;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.triplestore.api.PropertyBag;

public class ExternalNetworkInjectionConversion
extends AbstractReactiveLimitsOwnerConversion {
    public ExternalNetworkInjectionConversion(PropertyBag sm, Context context) {
        super("ExternalNetworkInjection", sm, context);
    }

    @Override
    public void convert() {
        double minP = this.p.asDouble("minP", -1.7976931348623157E308);
        double maxP = this.p.asDouble("maxP", Double.MAX_VALUE);
        double targetP = 0.0;
        double targetQ = 0.0;
        PowerFlow f = this.powerFlow();
        if (f.defined()) {
            targetP = -f.p();
            targetQ = -f.q();
        }
        GeneratorAdder adder = this.voltageLevel().newGenerator();
        RegulatingControlMappingForGenerators.initialize(adder);
        this.setMinPMaxP(adder, minP, maxP);
        adder.setTargetP(targetP).setTargetQ(targetQ).setEnergySource(EnergySource.OTHER);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        Generator g = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)g);
        this.convertedTerminals(g.getTerminal());
        this.convertReactiveLimits((ReactiveLimitsHolder)g);
        this.context.regulatingControlMapping().forGenerators().add(g.getId(), this.p);
        ExternalNetworkInjectionConversion.addSpecificProperties(g, this.p);
    }

    private static void addSpecificProperties(Generator generator, PropertyBag p) {
        generator.setProperty("CGMES.originalClass", "ExternalNetworkInjection");
        double governorSCD = p.asDouble("governorSCD");
        if (!Double.isNaN(governorSCD)) {
            generator.setProperty("CGMES.governorSCD", String.valueOf(governorSCD));
        }
    }
}

