/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;
import java.util.function.Supplier;

public class OperationalLimitConversion
extends AbstractIdentifiedObjectConversion {
    private static final String LIMIT_TYPE = "limitType";
    private static final String OPERATIONAL_LIMIT = "Operational limit";
    private static final String OPERATIONAL_LIMIT_TYPE_NAME = "operationalLimitTypeName";
    private static final String OPERATIONAL_LIMIT_SUBCLASS = "OperationalLimitSubclass";
    private static final String OPERATIONAL_LIMIT_SET_ID = "OperationalLimitSet";
    private static final String OPERATIONAL_LIMIT_SET_NAME = "OperationalLimitSetName";
    private static final String PERMANENT_LIMIT = "Permanent Limit";
    private static final String TEMPORARY_LIMIT = "Temporary Limit";
    private final String terminalId;
    private final String equipmentId;
    private LoadingLimitsAdder<?, ?> loadingLimitsAdder;
    private LoadingLimitsAdder<?, ?> loadingLimitsAdder1;
    private LoadingLimitsAdder<?, ?> loadingLimitsAdder2;
    private VoltageLevel vl;

    public OperationalLimitConversion(PropertyBag l, Context context) {
        super("OperationalLimit", l, context);
        String limitSubclass = this.p.getLocal(OPERATIONAL_LIMIT_SUBCLASS);
        String limitSetId = this.p.getId(OPERATIONAL_LIMIT_SET_ID);
        String limitSetName = this.p.getLocal(OPERATIONAL_LIMIT_SET_NAME);
        limitSetName = limitSetName != null ? limitSetName : limitSetId;
        this.terminalId = l.getId("Terminal");
        this.equipmentId = l.getId("Equipment");
        Terminal terminal = null;
        if (limitSubclass == null || limitSubclass.equals("ActivePowerLimit") || limitSubclass.equals("ApparentPowerLimit") || limitSubclass.equals("CurrentLimit")) {
            if (limitSubclass == null) {
                limitSubclass = "CurrentLimit";
            }
            if (this.terminalId != null) {
                terminal = context.terminalMapping().findForFlowLimits(this.terminalId);
            }
            if (terminal != null) {
                this.checkAndCreateLimitsAdder(context.terminalMapping().number(this.terminalId), limitSubclass, limitSetId, limitSetName, (Identifiable<?>)terminal.getConnectable());
            } else if (this.equipmentId != null) {
                Identifiable identifiable = context.network().getIdentifiable(this.equipmentId);
                this.checkAndCreateLimitsAdder(-1, limitSubclass, limitSetId, limitSetName, identifiable);
            }
        } else if (limitSubclass.equals("VoltageLimit")) {
            if (this.terminalId != null) {
                terminal = context.terminalMapping().findForVoltageLimits(this.terminalId);
            }
            this.setVoltageLevelForVoltageLimit(terminal);
        } else {
            this.notAssigned();
        }
    }

    private void setVoltageLevelForVoltageLimit(Terminal terminal) {
        if (terminal != null) {
            this.vl = terminal.getVoltageLevel();
        } else if (this.equipmentId != null) {
            Identifiable i = this.context.network().getIdentifiable(this.equipmentId);
            if (i == null) {
                this.vl = this.context.network().getVoltageLevel(this.p.getId("EquipmentContainer"));
            } else if (i instanceof Injection) {
                Injection injection = (Injection)i;
                this.vl = injection.getTerminal().getVoltageLevel();
            }
        }
    }

    private void storeOperationalLimitSetIdentifiers(Identifiable<?> identifiable, String limitSetId, String limitSetName) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object node = identifiable.hasProperty("CGMES.OperationalLimitSet_identifiers") ? mapper.readTree(identifiable.getProperty("CGMES.OperationalLimitSet_identifiers")) : mapper.createObjectNode();
            node.put(limitSetId, limitSetName);
            identifiable.setProperty("CGMES.OperationalLimitSet_identifiers", mapper.writeValueAsString(node));
        }
        catch (JsonProcessingException e) {
            throw new PowsyblException(e.getMessage(), (Throwable)e);
        }
    }

    private void createLimitsAdder(int terminalNumber, String limitSubClass, String limitSetId, String limitSetName, Branch<?> b) {
        if (terminalNumber == 1) {
            OperationalLimitsGroup limitsGroup = b.getOperationalLimitsGroup1(limitSetId).orElseGet(() -> {
                this.storeOperationalLimitSetIdentifiers((Identifiable<?>)b, limitSetId, limitSetName);
                return b.newOperationalLimitsGroup1(limitSetId);
            });
            this.loadingLimitsAdder1 = this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubClass);
        } else if (terminalNumber == 2) {
            OperationalLimitsGroup limitsGroup = b.getOperationalLimitsGroup2(limitSetId).orElseGet(() -> {
                this.storeOperationalLimitSetIdentifiers((Identifiable<?>)b, limitSetId, limitSetName);
                return b.newOperationalLimitsGroup2(limitSetId);
            });
            this.loadingLimitsAdder2 = this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubClass);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void createLimitsAdder(String limitSubClass, String limitSetId, String limitSetName, DanglingLine dl) {
        OperationalLimitsGroup limitsGroup = dl.getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
            this.storeOperationalLimitSetIdentifiers((Identifiable<?>)dl, limitSetId, limitSetName);
            return dl.newOperationalLimitsGroup(limitSetId);
        });
        this.loadingLimitsAdder = this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubClass);
    }

    private void createLimitsAdder(int terminalNumber, String limitSubClass, String limitSetId, String limitSetName, ThreeWindingsTransformer twt) {
        if (terminalNumber == 1) {
            OperationalLimitsGroup limitsGroup = twt.getLeg1().getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
                this.storeOperationalLimitSetIdentifiers((Identifiable<?>)twt, limitSetId, limitSetName);
                return twt.getLeg1().newOperationalLimitsGroup(limitSetId);
            });
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubClass);
        } else if (terminalNumber == 2) {
            OperationalLimitsGroup limitsGroup = twt.getLeg2().getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
                this.storeOperationalLimitSetIdentifiers((Identifiable<?>)twt, limitSetId, limitSetName);
                return twt.getLeg2().newOperationalLimitsGroup(limitSetId);
            });
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubClass);
        } else if (terminalNumber == 3) {
            OperationalLimitsGroup limitsGroup = twt.getLeg3().getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
                this.storeOperationalLimitSetIdentifiers((Identifiable<?>)twt, limitSetId, limitSetName);
                return twt.getLeg3().newOperationalLimitsGroup(limitSetId);
            });
            this.loadingLimitsAdder = this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubClass);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void checkAndCreateLimitsAdder(int terminalNumber, String limitSubClass, String limitSetId, String limitSetName, Identifiable<?> identifiable) {
        if (identifiable instanceof Line) {
            Branch b = (Branch)identifiable;
            if (terminalNumber == -1) {
                this.createLimitsAdder(1, limitSubClass, limitSetId, limitSetName, b);
                this.createLimitsAdder(2, limitSubClass, limitSetId, limitSetName, b);
            } else if (terminalNumber == 1 || terminalNumber == 2) {
                this.createLimitsAdder(terminalNumber, limitSubClass, limitSetId, limitSetName, b);
            } else {
                this.notAssigned((Identifiable<?>)b);
            }
        } else if (identifiable instanceof TwoWindingsTransformer) {
            Branch b = (Branch)identifiable;
            if (terminalNumber == 1 || terminalNumber == 2) {
                this.createLimitsAdder(terminalNumber, limitSubClass, limitSetId, limitSetName, b);
            } else {
                if (terminalNumber == -1) {
                    this.context.ignored(limitSubClass, "Defined for Equipment TwoWindingsTransformer. Should be defined for one Terminal of Two");
                }
                this.notAssigned((Identifiable<?>)b);
            }
        } else if (identifiable instanceof DanglingLine) {
            DanglingLine dl = (DanglingLine)identifiable;
            this.createLimitsAdder(limitSubClass, limitSetId, limitSetName, dl);
        } else if (identifiable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)identifiable;
            if (terminalNumber == 1 || terminalNumber == 2 || terminalNumber == 3) {
                this.createLimitsAdder(terminalNumber, limitSubClass, limitSetId, limitSetName, twt);
            } else {
                if (terminalNumber == -1) {
                    this.context.ignored(limitSubClass, "Defined for Equipment ThreeWindingsTransformer. Should be defined for one Terminal of Three");
                }
                this.notAssigned((Identifiable<?>)twt);
            }
        } else if (identifiable instanceof Switch) {
            Switch aswitch = this.context.network().getSwitch(this.equipmentId);
            this.notAssigned((Identifiable<?>)aswitch);
        } else {
            this.notAssigned(identifiable);
        }
    }

    @Override
    public boolean valid() {
        if (this.vl == null && this.loadingLimitsAdder == null && this.loadingLimitsAdder1 == null && this.loadingLimitsAdder2 == null) {
            this.missing(String.format("Terminal %s or Equipment %s", this.terminalId, this.equipmentId));
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        double normalValue = this.p.asDouble("normalValue");
        double value = this.p.asDouble("value", normalValue);
        if (value <= 0.0) {
            this.context.ignored(OPERATIONAL_LIMIT, "value is <= 0");
            return;
        }
        if (this.vl != null) {
            this.convertVoltageLimit(value);
        } else if (this.isPatl()) {
            this.convertPatl(value);
        } else if (this.isTatl()) {
            this.convertTatl(value);
        }
    }

    private void convertVoltageLimit(double value) {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        if (limitTypeName.equalsIgnoreCase("highvoltage") || "LimitTypeKind.highVoltage".equals(limitType)) {
            if (value < this.vl.getLowVoltageLimit()) {
                this.context.ignored("HighVoltageLimit", "Inconsistent with low voltage limit (" + this.vl.getLowVoltageLimit() + "kV)");
            } else if (value < this.vl.getHighVoltageLimit() || Double.isNaN(this.vl.getHighVoltageLimit())) {
                this.vl.setHighVoltageLimit(value);
            }
        } else if (limitTypeName.equalsIgnoreCase("lowvoltage") || "LimitTypeKind.lowVoltage".equals(limitType)) {
            if (value > this.vl.getHighVoltageLimit()) {
                this.context.ignored("LowVoltageLimit", "Inconsistent with high voltage limit (" + this.vl.getHighVoltageLimit() + "kV)");
            } else if (value > this.vl.getLowVoltageLimit() || Double.isNaN(this.vl.getLowVoltageLimit())) {
                this.vl.setLowVoltageLimit(value);
            }
        } else {
            this.notAssigned((Identifiable<?>)this.vl);
        }
    }

    private boolean isPatl() {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        return limitTypeName.equals("PATL") || "LimitTypeKind.patl".equals(limitType) || "LimitKind.patl".equals(limitType);
    }

    private void addPatl(double value, LoadingLimitsAdder<?, ?> adder) {
        if (Double.isNaN(adder.getPermanentLimit())) {
            adder.setPermanentLimit(value);
        } else {
            if (this.terminalId != null) {
                this.context.fixed(PERMANENT_LIMIT, () -> String.format("Several permanent limits defined for Terminal %s. Only the lowest is kept.", this.terminalId));
            } else {
                this.context.fixed(PERMANENT_LIMIT, () -> String.format("Several permanent limits defined for Equipment %s. Only the lowest is kept.", this.equipmentId));
            }
            if (adder.getPermanentLimit() > value) {
                adder.setPermanentLimit(value);
            }
        }
    }

    private void convertPatl(double value) {
        if (this.loadingLimitsAdder != null) {
            this.addPatl(value, this.loadingLimitsAdder);
        } else {
            if (this.loadingLimitsAdder1 != null) {
                this.addPatl(value, this.loadingLimitsAdder1);
            }
            if (this.loadingLimitsAdder2 != null) {
                this.addPatl(value, this.loadingLimitsAdder2);
            }
        }
    }

    private boolean isTatl() {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        return limitTypeName.equals("TATL") || "LimitTypeKind.tatl".equals(limitType) || "LimitKind.tatl".equals(limitType);
    }

    private void addTatl(String name, double value, int acceptableDuration, LoadingLimitsAdder<?, ?> adder) {
        if (Double.isNaN(value)) {
            this.context.ignored(TEMPORARY_LIMIT, "Temporary limit value is undefined");
            return;
        }
        if (Double.isNaN(adder.getTemporaryLimitValue(acceptableDuration))) {
            adder.beginTemporaryLimit().setAcceptableDuration(acceptableDuration).setName(name).setValue(value).ensureNameUnicity().endTemporaryLimit();
        } else {
            if (this.terminalId != null) {
                this.context.fixed(TEMPORARY_LIMIT, () -> String.format("Several temporary limits defined for same acceptable duration (%d s) for Terminal %s. Only the lowest is kept.", acceptableDuration, this.terminalId));
            } else {
                this.context.fixed(TEMPORARY_LIMIT, () -> String.format("Several temporary limits defined for same acceptable duration (%d s) for Equipment %s. Only the lowest is kept.", acceptableDuration, this.equipmentId));
            }
            if (adder.getTemporaryLimitValue(acceptableDuration) > value) {
                adder.beginTemporaryLimit().setAcceptableDuration(acceptableDuration).setName(name).setValue(value).ensureNameUnicity().endTemporaryLimit();
            }
        }
    }

    private void convertTatl(double value) {
        int acceptableDuration = this.p.containsKey((Object)"acceptableDuration") ? (int)this.p.asDouble("acceptableDuration") : Integer.MAX_VALUE;
        String direction = this.p.getId("direction");
        if (direction == null || direction.endsWith("high") || direction.endsWith("absoluteValue")) {
            String name = Optional.ofNullable(this.p.getId("shortName")).orElse(this.p.getId("name"));
            if (this.loadingLimitsAdder != null) {
                this.addTatl(name, value, acceptableDuration, this.loadingLimitsAdder);
            } else {
                if (this.loadingLimitsAdder1 != null) {
                    this.addTatl(name, value, acceptableDuration, this.loadingLimitsAdder1);
                }
                if (this.loadingLimitsAdder2 != null) {
                    this.addTatl(name, value, acceptableDuration, this.loadingLimitsAdder2);
                }
            }
        } else if (direction.endsWith("low")) {
            this.context.invalid(TEMPORARY_LIMIT, () -> String.format("TATL %s is a low limit", this.id));
        } else {
            this.context.invalid(TEMPORARY_LIMIT, () -> String.format("TATL %s does not have a valid direction", this.id));
        }
    }

    private void notAssigned() {
        this.notAssigned(null);
    }

    private void notAssigned(Identifiable<?> eq) {
        String type = this.p.getLocal(LIMIT_TYPE);
        String typeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String subclass = this.p.getLocal(OPERATIONAL_LIMIT_SUBCLASS);
        Supplier<String> reason = () -> String.format("Not assigned for %s %s. Limit id, type, typeName, subClass, terminal : %s, %s, %s, %s, %s", eq != null ? OperationalLimitConversion.className(eq) : "", eq != null ? eq.getId() : "", this.id, type, typeName, subclass, this.terminalId);
        this.context.pending(OPERATIONAL_LIMIT, reason);
    }

    private static String className(Identifiable<?> o) {
        String s = o.getClass().getName();
        int dot = s.lastIndexOf(46);
        if (dot >= 0) {
            s = s.substring(dot + 1);
        }
        s = s.replace("Impl", "");
        return s;
    }
}

