/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModelAdder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Comparator;

public class ShuntConversion
extends AbstractConductingEquipmentConversion {
    private static final String SECTION_NUMBER = "sectionNumber";

    public ShuntConversion(PropertyBag sh, Context context) {
        super("ShuntCompensator", sh, context);
    }

    private int getSections(PropertyBag p, int normalSections) {
        switch (this.context.config().getProfileForInitialValuesShuntSectionsTapPositions()) {
            case SSH: {
                return ShuntConversion.fromContinuous(p.asDouble("SSHsections", p.asDouble("SVsections", (double)normalSections)));
            }
            case SV: {
                return ShuntConversion.fromContinuous(p.asDouble("SVsections", p.asDouble("SSHsections", (double)normalSections)));
            }
        }
        throw new PowsyblException("Unexpected profile used for initial values");
    }

    @Override
    public void convert() {
        int maximumSections = this.p.asInt("maximumSections", 0);
        int normalSections = this.p.asInt("normalSections", 0);
        int sections = this.getSections(this.p, normalSections);
        sections = Math.abs(sections);
        maximumSections = Math.max(maximumSections, sections);
        ShuntCompensatorAdder adder = this.voltageLevel().newShuntCompensator().setSectionCount(sections);
        String shuntType = this.p.getId("type");
        if ("LinearShuntCompensator".equals(shuntType)) {
            double bPerSection = this.p.asDouble("bPerSection", (double)1.4E-45f);
            double gPerSection = this.p.asDouble("gPerSection", Double.NaN);
            adder.newLinearModel().setBPerSection(bPerSection).setGPerSection(gPerSection).setMaximumSectionCount(maximumSections).add();
        } else if ("NonlinearShuntCompensator".equals(shuntType)) {
            ShuntCompensatorNonLinearModelAdder modelAdder = adder.newNonLinearModel();
            PropertyBags ss = this.context.nonlinearShuntCompensatorPoints(this.id);
            ss.stream().filter(s -> s.asInt(SECTION_NUMBER) > 0).sorted(Comparator.comparing(s -> s.asInt(SECTION_NUMBER))).forEach(sec -> {
                int sectionNumber = sec.asInt(SECTION_NUMBER);
                modelAdder.beginSection().setB(ss.stream().filter(s -> s.asInt(SECTION_NUMBER) <= sectionNumber).map(s -> s.asDouble("b")).reduce(0.0, Double::sum).doubleValue()).setG(ss.stream().filter(s -> s.asInt(SECTION_NUMBER) <= sectionNumber).map(s -> s.asDouble("g")).reduce(0.0, Double::sum).doubleValue()).endSection();
            });
            modelAdder.add();
        } else {
            throw new IllegalStateException("Unexpected shunt type: " + shuntType);
        }
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((InjectionAdder<?, ?>)adder);
        ShuntCompensator shunt = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)shunt);
        PowerFlow f = this.powerFlowSV();
        this.context.convertedTerminal(this.terminalId(), shunt.getTerminal(), 1, f);
        this.context.regulatingControlMapping().forShuntCompensators().add(shunt.getId(), this.p);
    }
}

