/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.CountryConversion;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.triplestore.api.PropertyBag;

public class SubstationConversion
extends AbstractIdentifiedObjectConversion {
    public SubstationConversion(PropertyBag s, Context context) {
        super("Substation", s, context);
    }

    @Override
    public boolean valid() {
        return !this.context.nodeContainerMapping().substationIsMapped(this.id);
    }

    @Override
    public void convert() {
        String subRegionName = (String)this.p.get((Object)"subRegionName");
        String regionName = (String)this.p.get((Object)"regionName");
        Country country = CountryConversion.fromRegionName(regionName).orElseGet(() -> CountryConversion.fromSubregionName(subRegionName).orElse(null));
        String iidmSubstationId = this.context.nodeContainerMapping().substationIidm(this.id);
        Substation substation = this.context.network().getSubstation(iidmSubstationId);
        if (substation != null) {
            throw new IllegalStateException("Substation should be null");
        }
        SubstationAdder adder = ((SubstationAdder)((SubstationAdder)((SubstationAdder)this.context.network().newSubstation().setId(iidmSubstationId)).setName(this.iidmName())).setEnsureIdUnicity(this.context.config().isEnsureIdAliasUnicity())).setCountry(country);
        if (subRegionName != null) {
            adder.setGeographicalTags(new String[]{subRegionName});
        }
        Substation s = adder.add();
        this.addAliasesAndProperties(s, this.p.getId("SubRegion"), this.p.getId("Region"), regionName);
    }

    private void addAliasesAndProperties(Substation s, String subRegionId, String regionId, String regionName) {
        int index = 0;
        for (String mergedSub : this.context.nodeContainerMapping().mergedSubstations(s.getId())) {
            s.addAlias(mergedSub, "MergedSubstation" + ++index, this.context.config().isEnsureIdAliasUnicity());
        }
        s.setProperty("CGMES.subRegionId", subRegionId);
        s.setProperty("CGMES.regionId", regionId);
        s.setProperty("CGMES.regionName", regionName);
    }
}

