/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.conversion.elements.hvdc.CgmesDcConversion;
import com.powsybl.cgmes.model.CgmesDcTerminal;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Objects;

public class DcLineSegmentConversion
extends AbstractIdentifiedObjectConversion {
    private static final double DEFAULT_MAXP_FACTOR = 1.2;
    private final HvdcLine.ConvertersMode mode;
    private final double r;
    private final double ratedUdc;
    private final DcLineSegmentConverter converter1;
    private final DcLineSegmentConverter converter2;
    private final boolean isDuplicated;

    DcLineSegmentConversion(PropertyBag l, HvdcLine.ConvertersMode mode, double r, double ratedUdc, DcLineSegmentConverter converter1, DcLineSegmentConverter converter2, Context context) {
        this(l, mode, r, ratedUdc, converter1, converter2, false, context);
    }

    DcLineSegmentConversion(PropertyBag l, HvdcLine.ConvertersMode mode, double r, double ratedUdc, DcLineSegmentConverter converter1, DcLineSegmentConverter converter2, boolean isDuplicated, Context context) {
        super("DCLineSegment", l, context);
        Objects.requireNonNull(converter1);
        Objects.requireNonNull(converter2);
        this.mode = mode;
        this.r = r;
        this.ratedUdc = ratedUdc;
        this.converter1 = converter1;
        this.converter2 = converter2;
        this.isDuplicated = isDuplicated;
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void convert() {
        double maxP = DcLineSegmentConversion.getMaxP(this.converter1.pAC, this.converter2.pAC, this.mode);
        this.missing("maxP", maxP);
        HvdcLineAdder adder = this.context.network().newHvdcLine().setR(this.r).setNominalV(this.ratedUdc).setActivePowerSetpoint(DcLineSegmentConversion.getActivePowerSetpoint(this.converter1.pAC, this.converter2.pAC, this.converter1.poleLossP, this.converter2.poleLossP, this.mode)).setMaxP(maxP).setConvertersMode(this.mode).setConverterStationId1(this.context.namingStrategy().getIidmId("ACDCConverter", this.converter1.converterId)).setConverterStationId2(this.context.namingStrategy().getIidmId("ACDCConverter", this.converter2.converterId));
        this.identify((IdentifiableAdder<?, ?>)adder, this.isDuplicated ? "-1" : "");
        HvdcLine hvdcLine = adder.add();
        DcLineSegmentConversion.addHvdcAliasesAndProperties(this.p, this.isDuplicated ? "-1" : "", this.context.cgmes(), hvdcLine);
    }

    private static void addHvdcAliasesAndProperties(PropertyBag pb, String duplicatedTag, CgmesModel cgmesModel, HvdcLine hvdcLine) {
        CgmesDcTerminal t1 = cgmesModel.dcTerminal(pb.getId("DCTerminal1"));
        String dcNode1 = CgmesDcConversion.getDcNode(cgmesModel, t1);
        CgmesDcTerminal t2 = cgmesModel.dcTerminal(pb.getId("DCTerminal2"));
        String dcNode2 = CgmesDcConversion.getDcNode(cgmesModel, t2);
        hvdcLine.addAlias(t1.id() + duplicatedTag, "CGMES.DCTerminal1");
        hvdcLine.addAlias(t2.id() + duplicatedTag, "CGMES.DCTerminal2");
        hvdcLine.addAlias(dcNode1 + duplicatedTag, "CGMES.DCNode1");
        hvdcLine.addAlias(dcNode2 + duplicatedTag, "CGMES.DCNode2");
    }

    private static double getMaxP(double pAC1, double pAC2, HvdcLine.ConvertersMode mode) {
        if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER)) {
            if (pAC1 != 0.0) {
                return 1.2 * pAC1;
            }
            return 1.2 * Math.abs(pAC2);
        }
        if (pAC2 != 0.0) {
            return 1.2 * pAC2;
        }
        return 1.2 * Math.abs(pAC1);
    }

    private static double getActivePowerSetpoint(double pAC1, double pAC2, double poleLossP1, double poleLossP2, HvdcLine.ConvertersMode mode) {
        if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER)) {
            if (pAC1 != 0.0) {
                return pAC1;
            }
            if (pAC2 != 0.0) {
                return Math.abs(pAC2) + poleLossP2 + poleLossP1;
            }
        } else if (mode.equals((Object)HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER)) {
            if (pAC2 != 0.0) {
                return pAC2;
            }
            if (pAC1 != 0.0) {
                return Math.abs(pAC1) + poleLossP1 + poleLossP2;
            }
        }
        return 0.0;
    }

    static class DcLineSegmentConverter {
        String converterId;
        double poleLossP;
        double pAC;

        DcLineSegmentConverter(String stationId, double poleLossP, double pAC) {
            this.converterId = stationId;
            this.poleLossP = poleLossP;
            this.pAC = pAC;
        }
    }
}

