/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.elements.hvdc.IslandEndHvdc;
import com.powsybl.cgmes.conversion.elements.hvdc.NodeEquipment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class Hvdc {
    private final List<HvdcEquipment> hvdcData = new ArrayList<HvdcEquipment>();

    Hvdc() {
    }

    void add(NodeEquipment nodeEquipment, IslandEndHvdc islandEndHvdc1, IslandEndHvdc islandEndHvdc2) {
        Associations associations = Hvdc.createAssociations(islandEndHvdc1, islandEndHvdc2);
        associations.associationList.forEach(match -> {
            IslandEndHvdc.HvdcEnd hvdcEnd1 = IslandEndHvdc.HvdcEnd.joinAll(match.end1);
            IslandEndHvdc.HvdcEnd hvdcEnd2 = IslandEndHvdc.HvdcEnd.joinAll(match.end2);
            this.add(nodeEquipment, hvdcEnd1, hvdcEnd2);
        });
    }

    private static Associations createAssociations(IslandEndHvdc islandEndHvdc1, IslandEndHvdc islandEndHvdc2) {
        Associations associations = new Associations();
        islandEndHvdc1.getHvdc().forEach(hvdcEnd -> {
            List<IslandEndHvdc.HvdcEnd> associatedEnd2 = islandEndHvdc2.getHvdc().stream().filter(otherHvdcEnd -> otherHvdcEnd.isAssociatedWith((IslandEndHvdc.HvdcEnd)hvdcEnd)).toList();
            associatedEnd2.forEach(otherHvdcEnd -> associations.add((IslandEndHvdc.HvdcEnd)hvdcEnd, (IslandEndHvdc.HvdcEnd)otherHvdcEnd));
        });
        return associations;
    }

    private void add(NodeEquipment nodeEquipment, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        if (!hvdc1.isMatchingTo(hvdc2)) {
            return;
        }
        IslandEndHvdc.HvdcEndType type = hvdc1.computeType();
        switch (type) {
            case HVDC_TN_C1_LS1: {
                this.addC1LSn(hvdc1, hvdc2);
                break;
            }
            case HVDC_TN_C2_LS1: {
                this.addC2LS1(nodeEquipment, hvdc1, hvdc2);
                break;
            }
            case HVDC_TN_CN_LSN: {
                this.addCnLSn(nodeEquipment, hvdc1, hvdc2);
                break;
            }
            case HVDC_TN_CN_LS2N: {
                this.addCnLS2n(nodeEquipment, hvdc1, hvdc2);
            }
        }
    }

    private void addC1LSn(IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        HvdcEquipment hvdcEq = new HvdcEquipment();
        HvdcConverter converter = new HvdcConverter(hvdc1.acDcConvertersEnd.iterator().next(), hvdc2.acDcConvertersEnd.iterator().next());
        hvdcEq.add(converter);
        hvdc1.dcLineSegmentsEnd.forEach(hvdcEq::add);
        this.hvdcData.add(hvdcEq);
    }

    private void addC2LS1(NodeEquipment nodeEquipment, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        String dcLineSegment = hvdc1.dcLineSegmentsEnd.iterator().next();
        HvdcConverter hvdcConverter1 = Hvdc.computeConverter(nodeEquipment, dcLineSegment, hvdc1, hvdc2);
        if (hvdcConverter1 == null) {
            return;
        }
        HvdcConverter hvdcConverter2 = Hvdc.computeOtherConverter(hvdcConverter1, hvdc1, hvdc2);
        if (hvdcConverter2 == null) {
            return;
        }
        HvdcEquipment hvdcEq = new HvdcEquipment();
        hvdcEq.add(hvdcConverter1, dcLineSegment);
        hvdcEq.add(hvdcConverter2);
        this.hvdcData.add(hvdcEq);
    }

    private void addCnLSn(NodeEquipment nodeEquipment, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        hvdc1.dcLineSegmentsEnd.forEach(dcLineSegment -> {
            HvdcConverter hvdcConverter = Hvdc.computeConverter(nodeEquipment, dcLineSegment, hvdc1, hvdc2);
            if (hvdcConverter == null) {
                return;
            }
            HvdcEquipment hvdcEq = new HvdcEquipment();
            hvdcEq.add(hvdcConverter, (String)dcLineSegment);
            this.hvdcData.add(hvdcEq);
        });
    }

    private void addCnLS2n(NodeEquipment nodeEquipment, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        HashSet<String> used = new HashSet<String>();
        Optional<String> dcLineSegment1 = Hvdc.nextDcLineSegment(hvdc1, used);
        while (dcLineSegment1.isPresent()) {
            used.add(dcLineSegment1.get());
            HvdcConverter hvdcConverter = Hvdc.computeConverter(nodeEquipment, dcLineSegment1.get(), hvdc1, hvdc2);
            if (hvdcConverter != null && !used.contains(hvdcConverter.acDcConvertersEnd1) && !used.contains(hvdcConverter.acDcConvertersEnd2)) {
                used.add(hvdcConverter.acDcConvertersEnd1);
                used.add(hvdcConverter.acDcConvertersEnd2);
                String dcLineSegment2 = Hvdc.computeOtherDcLineSegment(nodeEquipment, dcLineSegment1.get(), hvdcConverter, hvdc1, hvdc2).orElseThrow();
                used.add(dcLineSegment2);
                HvdcEquipment hvdcEq = new HvdcEquipment();
                hvdcEq.add(hvdcConverter);
                hvdcEq.add(dcLineSegment1.get());
                hvdcEq.add(dcLineSegment2);
                this.hvdcData.add(hvdcEq);
            }
            dcLineSegment1 = Hvdc.nextDcLineSegment(hvdc1, used);
        }
    }

    private static Optional<String> nextDcLineSegment(IslandEndHvdc.HvdcEnd hvdc1, Set<String> used) {
        return hvdc1.dcLineSegmentsEnd.stream().filter(adConverterEnd -> !used.contains(adConverterEnd)).findAny();
    }

    private static HvdcConverter computeConverter(NodeEquipment nodeEquipment, String dcLineSegment, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        String acDcConverter1 = Hvdc.computeEquipmentConnectedToEquipment(nodeEquipment, dcLineSegment, hvdc1.acDcConvertersEnd, hvdc1.nodesEnd);
        if (acDcConverter1 == null) {
            return null;
        }
        String acDcConverter2 = Hvdc.computeEquipmentConnectedToEquipment(nodeEquipment, dcLineSegment, hvdc2.acDcConvertersEnd, hvdc2.nodesEnd);
        if (acDcConverter2 == null) {
            return null;
        }
        return new HvdcConverter(acDcConverter1, acDcConverter2);
    }

    private static HvdcConverter computeOtherConverter(HvdcConverter converter, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        String acDcConverter1 = hvdc1.acDcConvertersEnd.stream().filter(c -> !converter.acDcConvertersEnd1.contentEquals((CharSequence)c)).findFirst().orElse(null);
        if (acDcConverter1 == null) {
            return null;
        }
        String acDcConverter2 = hvdc2.acDcConvertersEnd.stream().filter(c -> !converter.acDcConvertersEnd2.contentEquals((CharSequence)c)).findFirst().orElse(null);
        if (acDcConverter2 == null) {
            return null;
        }
        return new HvdcConverter(acDcConverter1, acDcConverter2);
    }

    private static Optional<String> computeOtherDcLineSegment(NodeEquipment nodeEquipment, String dcLineSegment, HvdcConverter converter, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        return hvdc1.dcLineSegmentsEnd.stream().filter(otherDcLineSegment -> Hvdc.isOtherDcLineSegment(nodeEquipment, otherDcLineSegment, dcLineSegment, converter, hvdc1, hvdc2)).findAny();
    }

    private static boolean isOtherDcLineSegment(NodeEquipment nodeEquipment, String otherDcLineSegment, String dcLineSegment, HvdcConverter converter, IslandEndHvdc.HvdcEnd hvdc1, IslandEndHvdc.HvdcEnd hvdc2) {
        if (otherDcLineSegment.equals(dcLineSegment)) {
            return false;
        }
        HvdcConverter sameConverter = Hvdc.computeConverter(nodeEquipment, otherDcLineSegment, hvdc1, hvdc2);
        if (sameConverter == null) {
            return false;
        }
        return converter.acDcConvertersEnd1.equals(sameConverter.acDcConvertersEnd1) && converter.acDcConvertersEnd2.equals(sameConverter.acDcConvertersEnd2);
    }

    private static String computeEquipmentConnectedToEquipment(NodeEquipment nodeEquipment, String equipment, Set<String> connectedEquipment, List<String> nodes) {
        return connectedEquipment.stream().filter(eq -> nodeEquipment.connectedEquipment(equipment, (String)eq, nodes)).findFirst().orElse(null);
    }

    List<HvdcEquipment> getHvdcData() {
        return this.hvdcData;
    }

    private static final class Associations {
        private final List<Association> associationList = new ArrayList<Association>();

        private Associations() {
        }

        private void add(IslandEndHvdc.HvdcEnd hvdcEnd1, IslandEndHvdc.HvdcEnd hvdcEnd2) {
            Optional<Association> association1 = this.associationList.stream().filter(m -> m.end1.contains(hvdcEnd1)).findFirst();
            if (association1.isPresent() && !association1.get().end2.contains(hvdcEnd2)) {
                association1.get().end2.add(hvdcEnd2);
                return;
            }
            Optional<Association> association2 = this.associationList.stream().filter(m -> m.end2.contains(hvdcEnd2)).findFirst();
            if (association2.isPresent() && !association2.get().end1.contains(hvdcEnd1)) {
                association2.get().end1.add(hvdcEnd1);
                return;
            }
            this.associationList.add(new Association(hvdcEnd1, hvdcEnd2));
        }

        private static final class Association {
            private final List<IslandEndHvdc.HvdcEnd> end1 = new ArrayList<IslandEndHvdc.HvdcEnd>();
            private final List<IslandEndHvdc.HvdcEnd> end2 = new ArrayList<IslandEndHvdc.HvdcEnd>();

            private Association(IslandEndHvdc.HvdcEnd hvdcEnd1, IslandEndHvdc.HvdcEnd hvdcEnd2) {
                this.end1.add(hvdcEnd1);
                this.end2.add(hvdcEnd2);
            }
        }
    }

    static class HvdcEquipment {
        final List<HvdcConverter> converters = new ArrayList<HvdcConverter>();
        final List<String> dcLineSegments = new ArrayList<String>();

        HvdcEquipment() {
        }

        void add(HvdcConverter converter, String dcLineSegment) {
            this.converters.add(converter);
            this.dcLineSegments.add(dcLineSegment);
        }

        void add(HvdcConverter converter) {
            this.converters.add(converter);
        }

        void add(String dcLineSegment) {
            this.dcLineSegments.add(dcLineSegment);
        }
    }

    static class HvdcConverter {
        String acDcConvertersEnd1;
        String acDcConvertersEnd2;

        HvdcConverter(String acDcConvertersEnd1, String acDcConvertersEnd2) {
            Objects.requireNonNull(acDcConvertersEnd1);
            Objects.requireNonNull(acDcConvertersEnd2);
            this.acDcConvertersEnd1 = acDcConvertersEnd1;
            this.acDcConvertersEnd2 = acDcConvertersEnd2;
        }
    }
}

