/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.elements.hvdc.Adjacency;
import com.powsybl.cgmes.conversion.elements.hvdc.NodeEquipment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class IslandsEnds {
    private final List<IslandEnd> islandsEndsNodes = new ArrayList<IslandEnd>();

    IslandsEnds() {
    }

    void add(Adjacency adjacency, NodeEquipment nodeEquipment, List<String> islandNodes) {
        if (islandNodes.isEmpty()) {
            return;
        }
        HashSet<String> visitedNodes = new HashSet<String>();
        String nodeEnd1 = islandNodes.get(0);
        List<String> adjacentNodeEnd1 = IslandsEnds.computeAdjacentNodes(nodeEnd1, adjacency, visitedNodes);
        String nodeEnd2 = IslandsEnds.getNodeOtherEnd(nodeEquipment, islandNodes, visitedNodes);
        if (nodeEnd2 == null) {
            return;
        }
        List<String> adjacentNodeEnd2 = IslandsEnds.computeAdjacentNodes(nodeEnd2, adjacency, visitedNodes);
        for (String node : islandNodes) {
            if (visitedNodes.contains(node)) continue;
            List<String> adjacentNodeEnd = IslandsEnds.computeAdjacentNodes(node, adjacency, visitedNodes);
            IslandsEnds.addToRightEnd(nodeEquipment, adjacentNodeEnd1, adjacentNodeEnd2, adjacentNodeEnd);
        }
        IslandEnd islandEnd = new IslandEnd(adjacentNodeEnd1, adjacentNodeEnd2);
        this.islandsEndsNodes.add(islandEnd);
    }

    private static String getNodeOtherEnd(NodeEquipment nodeEquipment, List<String> islandNodes, Set<String> visitedNodes) {
        return islandNodes.stream().filter(n -> IslandsEnds.isNodeOtherEnd(nodeEquipment, visitedNodes, n)).findFirst().orElse(null);
    }

    private static boolean isNodeOtherEnd(NodeEquipment nodeEquipment, Set<String> visitedNodes, String node) {
        if (visitedNodes.contains(node)) {
            return false;
        }
        return visitedNodes.stream().anyMatch(n -> nodeEquipment.existDcLineSegmentBetweenBothNodes((String)n, node));
    }

    private static void addToRightEnd(NodeEquipment nodeEquipment, List<String> nodesEnd1, List<String> nodesEnd2, List<String> nodes) {
        List<String> nodesConnectedToEnd2 = nodes.stream().filter(n -> nodesEnd2.stream().anyMatch(n2 -> nodeEquipment.existDcLineSegmentBetweenBothNodes((String)n, (String)n2))).toList();
        List<String> nodesConnectedToEnd1 = nodes.stream().filter(n -> nodesEnd1.stream().anyMatch(n1 -> nodeEquipment.existDcLineSegmentBetweenBothNodes((String)n, (String)n1))).toList();
        if (nodesConnectedToEnd1.isEmpty() && !nodesConnectedToEnd2.isEmpty()) {
            nodesEnd1.addAll(nodes);
        } else if (!nodesConnectedToEnd1.isEmpty() && nodesConnectedToEnd2.isEmpty()) {
            nodesEnd2.addAll(nodes);
        }
    }

    private static List<String> computeAdjacentNodes(String nodeId, Adjacency adjacency, Set<String> visitedNodes) {
        ArrayList<String> adjacentNodes = new ArrayList<String>();
        adjacentNodes.add(nodeId);
        visitedNodes.add(nodeId);
        for (int k = 0; k < adjacentNodes.size(); ++k) {
            String node = (String)adjacentNodes.get(k);
            if (!adjacency.get().containsKey(node)) continue;
            adjacency.get().get(node).forEach(adjacent -> {
                if (Adjacency.isDcLineSegment(adjacent.type)) {
                    return;
                }
                if (visitedNodes.contains(adjacent.node)) {
                    return;
                }
                adjacentNodes.add(adjacent.node);
                visitedNodes.add(adjacent.node);
            });
        }
        return adjacentNodes;
    }

    List<IslandEnd> getIslandsEndsNodes() {
        return this.islandsEndsNodes;
    }

    static class IslandEnd {
        private final List<String> nodes1;
        private final List<String> nodes2;

        IslandEnd(List<String> nodes1, List<String> nodes2) {
            this.nodes1 = nodes1;
            this.nodes2 = nodes2;
        }

        List<String> getNodes1() {
            return this.nodes1;
        }

        List<String> getNodes2() {
            return this.nodes2;
        }
    }
}

