/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.hvdc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.hvdc.AcDcConverterNodes;
import com.powsybl.cgmes.conversion.elements.hvdc.Adjacency;
import com.powsybl.cgmes.conversion.elements.hvdc.CgmesDcConversion;
import com.powsybl.cgmes.model.CgmesDcTerminal;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class NodeEquipment {
    private final Map<String, List<EquipmentReference>> nodeEquipment = new HashMap<String, List<EquipmentReference>>();

    NodeEquipment(CgmesModel cgmesModel, Context context, AcDcConverterNodes acDcConverterNodes, Adjacency adjacency) {
        cgmesModel.dcLineSegments().forEach(dcls -> this.computeDcLineSegment(cgmesModel, adjacency, (PropertyBag)dcls));
        acDcConverterNodes.getConverterNodes().values().forEach(value -> this.addEquipment(adjacency, value.id, value.acNode, value.dcNode, EquipmentType.AC_DC_CONVERTER));
        cgmesModel.transformers().stream().map(t -> context.transformerEnds(t.getId("PowerTransformer"))).forEach(ends -> {
            if (ends.size() == 2) {
                this.computeTwoWindingsTransformer(cgmesModel, adjacency, (PropertyBags)ends);
            } else if (ends.size() == 3) {
                this.computeThreeWindingsTransformer(cgmesModel, adjacency, (PropertyBags)ends);
            }
        });
    }

    private void computeDcLineSegment(CgmesModel cgmesModel, Adjacency adjacency, PropertyBag equipment) {
        CgmesDcTerminal t1 = cgmesModel.dcTerminal(equipment.getId("DCTerminal1"));
        CgmesDcTerminal t2 = cgmesModel.dcTerminal(equipment.getId("DCTerminal2"));
        String id = equipment.getId("DCLineSegment");
        this.addEquipment(adjacency, id, CgmesDcConversion.getDcNode(cgmesModel, t1), CgmesDcConversion.getDcNode(cgmesModel, t2), EquipmentType.DC_LINE_SEGMENT);
    }

    private void computeTwoWindingsTransformer(CgmesModel cgmesModel, Adjacency adjacency, PropertyBags ends) {
        PropertyBag end1 = (PropertyBag)ends.get(0);
        CgmesTerminal t1 = cgmesModel.terminal(end1.getId("Terminal"));
        PropertyBag end2 = (PropertyBag)ends.get(1);
        CgmesTerminal t2 = cgmesModel.terminal(end2.getId("Terminal"));
        String id = end1.getId("PowerTransformer");
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(CgmesDcConversion.getAcNode(cgmesModel, t1));
        nodes.add(CgmesDcConversion.getAcNode(cgmesModel, t2));
        if (this.isValidTransformer(adjacency, nodes)) {
            this.addTransformer(adjacency, id, nodes, EquipmentType.TRANSFORMER);
        }
    }

    private void computeThreeWindingsTransformer(CgmesModel cgmesModel, Adjacency adjacency, PropertyBags ends) {
        PropertyBag end1 = (PropertyBag)ends.get(0);
        CgmesTerminal t1 = cgmesModel.terminal(end1.getId("Terminal"));
        PropertyBag end2 = (PropertyBag)ends.get(1);
        CgmesTerminal t2 = cgmesModel.terminal(end2.getId("Terminal"));
        PropertyBag end3 = (PropertyBag)ends.get(2);
        CgmesTerminal t3 = cgmesModel.terminal(end3.getId("Terminal"));
        String id = end1.getId("PowerTransformer");
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(CgmesDcConversion.getAcNode(cgmesModel, t1));
        nodes.add(CgmesDcConversion.getAcNode(cgmesModel, t2));
        nodes.add(CgmesDcConversion.getAcNode(cgmesModel, t3));
        if (this.isValidTransformer(adjacency, nodes)) {
            this.addTransformer(adjacency, id, nodes, EquipmentType.TRANSFORMER);
        }
    }

    private void addEquipment(Adjacency adjacency, String id, String nodeId1, String nodeId2, EquipmentType type) {
        if (!adjacency.get().containsKey(nodeId1) || !adjacency.get().containsKey(nodeId2)) {
            return;
        }
        EquipmentReference eq = new EquipmentReference(type, id);
        this.nodeEquipment.computeIfAbsent(nodeId1, k -> new ArrayList()).add(eq);
        this.nodeEquipment.computeIfAbsent(nodeId2, k -> new ArrayList()).add(eq);
    }

    private void addEquipment(Adjacency adjacency, String id, String acNodeId, List<String> dcNodeIds, EquipmentType type) {
        if (!adjacency.get().containsKey(acNodeId)) {
            return;
        }
        if (dcNodeIds.stream().anyMatch(n -> !adjacency.get().containsKey(n))) {
            return;
        }
        EquipmentReference eq = new EquipmentReference(type, id);
        this.nodeEquipment.computeIfAbsent(acNodeId, k -> new ArrayList()).add(eq);
        dcNodeIds.forEach(n -> this.nodeEquipment.computeIfAbsent((String)n, k -> new ArrayList()).add(eq));
    }

    private boolean isValidTransformer(Adjacency adjacency, List<String> nodes) {
        return nodes.stream().anyMatch(adjacency::containsAcDcConverter);
    }

    private void addTransformer(Adjacency adjacency, String id, List<String> nodes, EquipmentType type) {
        EquipmentReference eq = new EquipmentReference(type, id);
        nodes.stream().filter(n -> adjacency.get().containsKey(n)).forEach(n -> this.nodeEquipment.computeIfAbsent((String)n, k -> new ArrayList()).add(eq));
    }

    boolean containsAnyTransformer(String node) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return false;
        }
        return listEquipment.stream().anyMatch(eq -> eq.type == EquipmentType.TRANSFORMER);
    }

    boolean containsAnyAcDcConverter(String node) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return false;
        }
        return listEquipment.stream().anyMatch(eq -> eq.type == EquipmentType.AC_DC_CONVERTER);
    }

    boolean containsAnyNotUsedAcDcConverter(String node, Set<String> usedAcDcConverters) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return false;
        }
        return listEquipment.stream().anyMatch(eq -> eq.type == EquipmentType.AC_DC_CONVERTER && !usedAcDcConverters.contains(eq.equipmentId));
    }

    boolean multiAcDcConverter(String node) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return false;
        }
        return listEquipment.stream().filter(eq -> eq.type == EquipmentType.AC_DC_CONVERTER).map(eq -> eq.equipmentId).collect(Collectors.toSet()).size() >= 2;
    }

    boolean containsAcDcConverter(String node, String acDcConverter) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return false;
        }
        return listEquipment.stream().anyMatch(eq -> eq.equipmentId.equals(acDcConverter) && eq.type == EquipmentType.AC_DC_CONVERTER);
    }

    int acDcConvertersConnectedTo(String node) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return 0;
        }
        return listEquipment.stream().filter(eq -> eq.type == EquipmentType.AC_DC_CONVERTER).map(eq -> eq.equipmentId).collect(Collectors.toSet()).size();
    }

    boolean existDcLineSegmentBetweenBothNodes(String node1, String node2) {
        List<EquipmentReference> listEquipment1 = this.nodeEquipment.get(node1);
        List<EquipmentReference> listEquipment2 = this.nodeEquipment.get(node2);
        if (listEquipment1 == null || listEquipment2 == null) {
            return false;
        }
        return listEquipment1.stream().anyMatch(eq -> eq.type == EquipmentType.DC_LINE_SEGMENT && listEquipment2.contains(eq));
    }

    boolean connectedEquipment(String equipment1, String equipment2, List<String> nodes) {
        return nodes.stream().anyMatch(n -> this.connectedEquipment((String)n, equipment1, equipment2));
    }

    private boolean connectedEquipment(String node, String equipment1, String equipment2) {
        List<EquipmentReference> listEquipment = this.nodeEquipment.get(node);
        if (listEquipment == null) {
            return false;
        }
        return listEquipment.stream().filter(eq -> eq.equipmentId.equals(equipment1) || eq.equipmentId.equals(equipment2)).collect(Collectors.toSet()).size() == 2;
    }

    Map<String, List<EquipmentReference>> getNodeEquipment() {
        return this.nodeEquipment;
    }

    static enum EquipmentType {
        TRANSFORMER,
        AC_DC_CONVERTER,
        DC_LINE_SEGMENT;

    }

    static class EquipmentReference {
        EquipmentType type;
        String equipmentId;

        EquipmentReference(EquipmentType type, String equipmentId) {
            this.type = type;
            this.equipmentId = equipmentId;
        }
    }
}

