/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.transformers.AbstractCgmesTapChangerBuilder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TapChanger {
    private int lowTapPosition = 0;
    private Integer tapPosition;
    private final List<Step> steps = new ArrayList<Step>();
    private boolean ltcFlag = false;
    private String id = null;
    private String type = null;
    private boolean regulating = false;
    private String regulatingControlId = null;
    private String tculControlMode = null;
    private boolean tapChangerControlEnabled = false;
    private TapChanger hiddenCombinedTapChanger = null;

    public static TapChanger ratioTapChangerFromEnd(PropertyBag end, Context context) {
        Objects.requireNonNull(end);
        Objects.requireNonNull(context);
        PropertyBag rtc = context.ratioTapChangers(end.getId("PowerTransformer")).stream().filter(tc -> end.getId("TransformerEnd").equals(tc.getId("TransformerEnd"))).findFirst().orElse(null);
        return rtc != null ? AbstractCgmesTapChangerBuilder.newRatioTapChanger(rtc, context).build() : null;
    }

    public static TapChanger phaseTapChangerFromEnd(PropertyBag end, double x, Context context) {
        Objects.requireNonNull(end);
        Objects.requireNonNull(context);
        PropertyBag ptc = context.phaseTapChangers(end.getId("PowerTransformer")).stream().filter(tc -> end.getId("TransformerEnd").equals(tc.getId("TransformerEnd"))).findFirst().orElse(null);
        return ptc != null ? AbstractCgmesTapChangerBuilder.newPhaseTapChanger(ptc, x, context).build() : null;
    }

    public TapChanger setLowTapPosition(int lowTapPosition) {
        this.lowTapPosition = lowTapPosition;
        return this;
    }

    public TapChanger setTapPosition(int tapPosition) {
        this.tapPosition = tapPosition;
        return this;
    }

    public TapChanger setLtcFlag(boolean ltcFlag) {
        this.ltcFlag = ltcFlag;
        return this;
    }

    public TapChanger setType(String type) {
        this.type = type;
        return this;
    }

    public TapChanger setId(String id) {
        this.id = id;
        return this;
    }

    public TapChanger setRegulating(boolean regulating) {
        this.regulating = regulating;
        return this;
    }

    public TapChanger setRegulatingControlId(String regulatingControlId) {
        this.regulatingControlId = regulatingControlId;
        return this;
    }

    public TapChanger setTculControlMode(String tculControlMode) {
        this.tculControlMode = tculControlMode;
        return this;
    }

    public TapChanger setTapChangerControlEnabled(boolean tapChangerControlEnabled) {
        this.tapChangerControlEnabled = tapChangerControlEnabled;
        return this;
    }

    public TapChanger setHiddenCombinedTapChanger(TapChanger hiddenCombinedTapChanger) {
        this.hiddenCombinedTapChanger = hiddenCombinedTapChanger;
        return this;
    }

    public Step beginStep() {
        return new Step();
    }

    public int getLowTapPosition() {
        return this.lowTapPosition;
    }

    public Integer getTapPosition() {
        return this.tapPosition;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public int getHighTapPosition() {
        return this.lowTapPosition + this.steps.size() - 1;
    }

    public boolean isLtcFlag() {
        return this.ltcFlag;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRegulating() {
        return this.regulating;
    }

    public String getRegulatingControlId() {
        return this.regulatingControlId;
    }

    public String getTculControlMode() {
        return this.tculControlMode;
    }

    public boolean isTapChangerControlEnabled() {
        return this.tapChangerControlEnabled;
    }

    public TapChanger getHiddenCombinedTapChanger() {
        return this.hiddenCombinedTapChanger;
    }

    class Step {
        private double angleRad = 0.0;
        private double ratio = 1.0;
        private double r = 0.0;
        private double x = 0.0;
        private double g1 = 0.0;
        private double b1 = 0.0;
        private double g2 = 0.0;
        private double b2 = 0.0;

        Step() {
        }

        public Step setAngle(double angle) {
            this.angleRad = angle;
            return this;
        }

        public Step setRatio(double ratio) {
            this.ratio = ratio;
            return this;
        }

        public Step setR(double r) {
            this.r = r;
            return this;
        }

        public Step setX(double x) {
            this.x = x;
            return this;
        }

        public Step setG1(double g1) {
            this.g1 = g1;
            return this;
        }

        public Step setB1(double b1) {
            this.b1 = b1;
            return this;
        }

        public Step setG2(double g2) {
            this.g2 = g2;
            return this;
        }

        public Step setB2(double b2) {
            this.b2 = b2;
            return this;
        }

        public TapChanger endStep() {
            TapChanger.this.steps.add(this);
            return TapChanger.this;
        }

        public double getAngle() {
            return this.angleRad;
        }

        public double getRatio() {
            return this.ratio;
        }

        public double getR() {
            return this.r;
        }

        public double getX() {
            return this.x;
        }

        public double getG1() {
            return this.g1;
        }

        public double getB1() {
            return this.b1;
        }

        public double getG2() {
            return this.g2;
        }

        public double getB2() {
            return this.b2;
        }
    }
}

