/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.elements.transformers.AbstractTransformerConversion;
import com.powsybl.cgmes.conversion.elements.transformers.CgmesT3xModel;
import com.powsybl.cgmes.conversion.elements.transformers.ConvertedT3xModel;
import com.powsybl.cgmes.conversion.elements.transformers.InterpretedT3xModel;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.util.TwtData;
import com.powsybl.triplestore.api.PropertyBags;

public class ThreeWindingsTransformerConversion
extends AbstractTransformerConversion {
    public ThreeWindingsTransformerConversion(PropertyBags ends, Context context) {
        super("PowerTransformer", ends, context);
    }

    @Override
    public void convert() {
        CgmesT3xModel cgmesT3xModel = new CgmesT3xModel(this.ps, this.context);
        InterpretedT3xModel interpretedT3xModel = new InterpretedT3xModel(cgmesT3xModel, this.context.config());
        ConvertedT3xModel convertedT3xModel = new ConvertedT3xModel(interpretedT3xModel, this.context);
        this.setToIidm(convertedT3xModel);
    }

    public static void calculateVoltageAndAngleInStarBus(ThreeWindingsTransformer twt) {
        ThreeWindingsTransformerPhaseAngleClock phaseAngleClock = (ThreeWindingsTransformerPhaseAngleClock)twt.getExtensionByName("threeWindingsTransformerPhaseAngleClock");
        int phaseAngleClock2 = 0;
        int phaseAngleClock3 = 0;
        if (phaseAngleClock != null) {
            phaseAngleClock2 = phaseAngleClock.getPhaseAngleClockLeg2();
            phaseAngleClock3 = phaseAngleClock.getPhaseAngleClockLeg3();
        }
        boolean splitShuntAdmittance = false;
        TwtData twtData = new TwtData(twt, phaseAngleClock2, phaseAngleClock3, 0.0, false, splitShuntAdmittance);
        double starBusV = twtData.getStarU();
        double starBusTheta = Math.toDegrees(twtData.getStarTheta());
        if (!Double.isNaN(starBusV) && !Double.isNaN(starBusTheta)) {
            twt.setProperty("v", Double.toString(starBusV));
            twt.setProperty("angle", Double.toString(starBusTheta));
        }
    }

    private void setToIidm(ConvertedT3xModel convertedT3xModel) {
        ThreeWindingsTransformerAdder txadder = this.substation().map(Substation::newThreeWindingsTransformer).orElseThrow(() -> new PowsyblException("Substation null! Transformer must be within a substation")).setRatedU0(convertedT3xModel.ratedU0);
        this.identify((IdentifiableAdder<?, ?>)txadder);
        ThreeWindingsTransformerAdder.LegAdder l1adder = txadder.newLeg1();
        ThreeWindingsTransformerConversion.setToIidmWindingAdder(convertedT3xModel.winding1, l1adder);
        this.connect(l1adder, 1);
        l1adder.add();
        ThreeWindingsTransformerAdder.LegAdder l2adder = txadder.newLeg2();
        ThreeWindingsTransformerConversion.setToIidmWindingAdder(convertedT3xModel.winding2, l2adder);
        this.connect(l2adder, 2);
        l2adder.add();
        ThreeWindingsTransformerAdder.LegAdder l3adder = txadder.newLeg3();
        ThreeWindingsTransformerConversion.setToIidmWindingAdder(convertedT3xModel.winding3, l3adder);
        this.connect(l3adder, 3);
        l3adder.add();
        ThreeWindingsTransformer tx = txadder.add();
        this.addAliasesAndProperties((Identifiable<?>)tx);
        this.convertedTerminals(tx.getLeg1().getTerminal(), tx.getLeg2().getTerminal(), tx.getLeg3().getTerminal());
        ThreeWindingsTransformerConversion.setToIidmWindingTapChanger(convertedT3xModel, convertedT3xModel.winding1, tx, this.context);
        ThreeWindingsTransformerConversion.setToIidmWindingTapChanger(convertedT3xModel, convertedT3xModel.winding2, tx, this.context);
        ThreeWindingsTransformerConversion.setToIidmWindingTapChanger(convertedT3xModel, convertedT3xModel.winding3, tx, this.context);
        this.setRegulatingControlContext(convertedT3xModel, tx);
        ThreeWindingsTransformerConversion.addCgmesReferences(tx, convertedT3xModel.winding1.end1.ratioTapChanger);
        ThreeWindingsTransformerConversion.addCgmesReferences(tx, convertedT3xModel.winding1.end1.phaseTapChanger);
        ThreeWindingsTransformerConversion.addCgmesReferences(tx, convertedT3xModel.winding2.end1.ratioTapChanger);
        ThreeWindingsTransformerConversion.addCgmesReferences(tx, convertedT3xModel.winding2.end1.phaseTapChanger);
        ThreeWindingsTransformerConversion.addCgmesReferences(tx, convertedT3xModel.winding3.end1.ratioTapChanger);
        ThreeWindingsTransformerConversion.addCgmesReferences(tx, convertedT3xModel.winding3.end1.phaseTapChanger);
    }

    private static void setToIidmWindingAdder(ConvertedT3xModel.ConvertedWinding convertedModelWinding, ThreeWindingsTransformerAdder.LegAdder ladder) {
        ladder.setR(convertedModelWinding.r).setX(convertedModelWinding.x).setG(convertedModelWinding.end1.g).setB(convertedModelWinding.end1.b).setRatedU(convertedModelWinding.end1.ratedU);
        if (convertedModelWinding.ratedS != null) {
            ladder.setRatedS(convertedModelWinding.ratedS.doubleValue());
        }
    }

    private static void setToIidmWindingTapChanger(ConvertedT3xModel convertedT3xModel, ConvertedT3xModel.ConvertedWinding convertedModelWinding, ThreeWindingsTransformer tx, Context context) {
        ThreeWindingsTransformerConversion.setToIidmRatioTapChanger(convertedT3xModel, convertedModelWinding, tx);
        ThreeWindingsTransformerConversion.setToIidmPhaseTapChanger(convertedT3xModel, convertedModelWinding, tx, context);
    }

    private static void setToIidmRatioTapChanger(ConvertedT3xModel convertedT3xModel, ConvertedT3xModel.ConvertedWinding convertedWinding, ThreeWindingsTransformer tx) {
        TapChanger rtc = convertedWinding.end1.ratioTapChanger;
        if (rtc == null) {
            return;
        }
        RatioTapChangerAdder rtca = ThreeWindingsTransformerConversion.newRatioTapChanger(convertedT3xModel, tx, convertedWinding.end1.terminal);
        ThreeWindingsTransformerConversion.setToIidmRatioTapChanger(rtc, rtca);
    }

    private static void setToIidmPhaseTapChanger(ConvertedT3xModel convertedT3xModel, ConvertedT3xModel.ConvertedWinding convertedWinding, ThreeWindingsTransformer tx, Context context) {
        TapChanger ptc = convertedWinding.end1.phaseTapChanger;
        if (ptc == null) {
            return;
        }
        PhaseTapChangerAdder ptca = ThreeWindingsTransformerConversion.newPhaseTapChanger(convertedT3xModel, tx, convertedWinding.end1.terminal);
        ThreeWindingsTransformerConversion.setToIidmPhaseTapChanger(ptc, ptca, context);
    }

    private static RatioTapChangerAdder newRatioTapChanger(ConvertedT3xModel convertedT3xModel, ThreeWindingsTransformer tx, String terminal) {
        if (convertedT3xModel.winding1.end1.terminal.equals(terminal)) {
            return tx.getLeg1().newRatioTapChanger();
        }
        if (convertedT3xModel.winding2.end1.terminal.equals(terminal)) {
            return tx.getLeg2().newRatioTapChanger();
        }
        if (convertedT3xModel.winding3.end1.terminal.equals(terminal)) {
            return tx.getLeg3().newRatioTapChanger();
        }
        return null;
    }

    private static PhaseTapChangerAdder newPhaseTapChanger(ConvertedT3xModel convertedT3xModel, ThreeWindingsTransformer tx, String terminal) {
        if (convertedT3xModel.winding1.end1.terminal.equals(terminal)) {
            return tx.getLeg1().newPhaseTapChanger();
        }
        if (convertedT3xModel.winding2.end1.terminal.equals(terminal)) {
            return tx.getLeg2().newPhaseTapChanger();
        }
        if (convertedT3xModel.winding3.end1.terminal.equals(terminal)) {
            return tx.getLeg3().newPhaseTapChanger();
        }
        return null;
    }

    private void setRegulatingControlContext(ConvertedT3xModel convertedT3xModel, ThreeWindingsTransformer tx) {
        RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio rcRtc1 = this.setContextRegulatingDataRatio(convertedT3xModel.winding1.end1.ratioTapChanger);
        RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase rcPtc1 = this.setContextRegulatingDataPhase(convertedT3xModel.winding1.end1.phaseTapChanger);
        RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio rcRtc2 = this.setContextRegulatingDataRatio(convertedT3xModel.winding2.end1.ratioTapChanger);
        RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase rcPtc2 = this.setContextRegulatingDataPhase(convertedT3xModel.winding2.end1.phaseTapChanger);
        RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio rcRtc3 = this.setContextRegulatingDataRatio(convertedT3xModel.winding3.end1.ratioTapChanger);
        RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase rcPtc3 = this.setContextRegulatingDataPhase(convertedT3xModel.winding3.end1.phaseTapChanger);
        this.context.regulatingControlMapping().forTransformers().add(tx.getId(), rcRtc1, rcPtc1, rcRtc2, rcPtc2, rcRtc3, rcPtc3);
    }
}

