/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.cgmes.conversion.elements.transformers.AbstractTransformerConversion;
import com.powsybl.cgmes.conversion.elements.transformers.CgmesT2xModel;
import com.powsybl.cgmes.conversion.elements.transformers.ConvertedT2xModel;
import com.powsybl.cgmes.conversion.elements.transformers.InterpretedT2xModel;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Optional;

public class TwoWindingsTransformerConversion
extends AbstractTransformerConversion
implements EquipmentAtBoundaryConversion {
    private DanglingLine danglingLine;

    public TwoWindingsTransformerConversion(PropertyBags ends, Context context) {
        super("PowerTransformer", ends, context);
    }

    @Override
    public boolean valid() {
        for (int k = 1; k <= 2; ++k) {
            if (this.nodeId(k) != null) continue;
            this.missing(this.nodeIdPropertyName() + k);
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        CgmesT2xModel cgmesT2xModel = new CgmesT2xModel(this.ps, this.context);
        InterpretedT2xModel interpretedT2xModel = new InterpretedT2xModel(cgmesT2xModel, this.context.config(), this.context);
        ConvertedT2xModel convertedT2xModel = new ConvertedT2xModel(interpretedT2xModel, this.context);
        this.setToIidm(convertedT2xModel);
    }

    @Override
    public void convertAtBoundary() {
        if (this.context.config().convertBoundary()) {
            this.convert();
            return;
        }
        String eqInstance = (String)((PropertyBag)this.ps.get(0)).get((Object)"graph");
        if (this.isBoundary(1)) {
            this.convertTwoWindingsTransformerAtBoundary(eqInstance, 1);
        } else if (this.isBoundary(2)) {
            this.convertTwoWindingsTransformerAtBoundary(eqInstance, 2);
        } else {
            throw new ConversionException("Boundary must be at one end of the twoWindingsTransformer");
        }
    }

    @Override
    public Optional<DanglingLine> getDanglingLine() {
        return Optional.ofNullable(this.danglingLine);
    }

    private void convertTwoWindingsTransformerAtBoundary(String eqInstance, int boundarySide) {
        CgmesT2xModel cgmesT2xModel = new CgmesT2xModel(this.ps, this.context);
        InterpretedT2xModel interpretedT2xModel = new InterpretedT2xModel(cgmesT2xModel, this.context.config(), this.context);
        ConvertedT2xModel convertedT2xModel = new ConvertedT2xModel(interpretedT2xModel, this.context);
        this.danglingLine = this.convertToDanglingLine(eqInstance, boundarySide, TwoWindingsTransformerConversion.getR(convertedT2xModel), TwoWindingsTransformerConversion.getX(convertedT2xModel), TwoWindingsTransformerConversion.getG(convertedT2xModel), TwoWindingsTransformerConversion.getB(convertedT2xModel));
    }

    private void setToIidm(ConvertedT2xModel convertedT2xModel) {
        TwoWindingsTransformerAdder adder = this.substation().map(Substation::newTwoWindingsTransformer).orElseThrow(() -> new PowsyblException("Substation null! Transformer must be within a substation")).setR(convertedT2xModel.r).setX(convertedT2xModel.x).setG(Double.isNaN(convertedT2xModel.end1.g) ? 0.0 : convertedT2xModel.end1.g).setB(Double.isNaN(convertedT2xModel.end1.b) ? 0.0 : convertedT2xModel.end1.b).setRatedU1(convertedT2xModel.end1.ratedU).setRatedU2(convertedT2xModel.end2.ratedU);
        if (convertedT2xModel.ratedS != null) {
            adder.setRatedS(convertedT2xModel.ratedS.doubleValue());
        }
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connect((BranchAdder<?, ?>)adder);
        TwoWindingsTransformer tx = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)tx);
        this.convertedTerminals(tx.getTerminal1(), tx.getTerminal2());
        TwoWindingsTransformerConversion.setToIidmRatioTapChanger(convertedT2xModel, tx);
        TwoWindingsTransformerConversion.setToIidmPhaseTapChanger(convertedT2xModel, tx, this.context);
        this.setRegulatingControlContext(convertedT2xModel, tx);
        TwoWindingsTransformerConversion.addCgmesReferences(tx, convertedT2xModel.end1.ratioTapChanger);
        TwoWindingsTransformerConversion.addCgmesReferences(tx, convertedT2xModel.end1.phaseTapChanger);
    }

    private static void setToIidmRatioTapChanger(ConvertedT2xModel convertedT2xModel, TwoWindingsTransformer tx) {
        TapChanger rtc = convertedT2xModel.end1.ratioTapChanger;
        if (rtc == null) {
            return;
        }
        RatioTapChangerAdder rtca = TwoWindingsTransformerConversion.newRatioTapChanger(tx);
        TwoWindingsTransformerConversion.setToIidmRatioTapChanger(rtc, rtca);
    }

    private static void setToIidmPhaseTapChanger(ConvertedT2xModel convertedT2xModel, TwoWindingsTransformer tx, Context context) {
        TapChanger ptc = convertedT2xModel.end1.phaseTapChanger;
        if (ptc == null) {
            return;
        }
        PhaseTapChangerAdder ptca = TwoWindingsTransformerConversion.newPhaseTapChanger(tx);
        TwoWindingsTransformerConversion.setToIidmPhaseTapChanger(ptc, ptca, context);
    }

    private static RatioTapChangerAdder newRatioTapChanger(TwoWindingsTransformer tx) {
        return tx.newRatioTapChanger();
    }

    private static PhaseTapChangerAdder newPhaseTapChanger(TwoWindingsTransformer tx) {
        return tx.newPhaseTapChanger();
    }

    private void setRegulatingControlContext(ConvertedT2xModel convertedT2xModel, TwoWindingsTransformer tx) {
        RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio rcRtc = this.setContextRegulatingDataRatio(convertedT2xModel.end1.ratioTapChanger);
        RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase rcPtc = this.setContextRegulatingDataPhase(convertedT2xModel.end1.phaseTapChanger);
        this.context.regulatingControlMapping().forTransformers().add(tx.getId(), rcRtc, rcPtc);
    }

    private static int getStepIndex(TapChanger tapChanger) {
        return tapChanger.getTapPosition();
    }

    private static double getStepR(TapChanger tapChanger) {
        if (tapChanger != null) {
            return tapChanger.getSteps().get(TwoWindingsTransformerConversion.getStepIndex(tapChanger)).getR();
        }
        return 0.0;
    }

    private static double getStepX(TapChanger tapChanger) {
        if (tapChanger != null) {
            return tapChanger.getSteps().get(TwoWindingsTransformerConversion.getStepIndex(tapChanger)).getX();
        }
        return 0.0;
    }

    private static double getStepG1(TapChanger tapChanger) {
        if (tapChanger != null) {
            return tapChanger.getSteps().get(TwoWindingsTransformerConversion.getStepIndex(tapChanger)).getG1();
        }
        return 0.0;
    }

    private static double getStepB1(TapChanger tapChanger) {
        if (tapChanger != null) {
            return tapChanger.getSteps().get(TwoWindingsTransformerConversion.getStepIndex(tapChanger)).getB1();
        }
        return 0.0;
    }

    private static double getValue(double initialValue, double rtcStepValue, double ptcStepValue) {
        return initialValue * (1.0 + rtcStepValue / 100.0) * (1.0 + ptcStepValue / 100.0);
    }

    private static double getR(ConvertedT2xModel convertedT2xModel) {
        return TwoWindingsTransformerConversion.getValue(convertedT2xModel.r, TwoWindingsTransformerConversion.getStepR(convertedT2xModel.end1.ratioTapChanger), TwoWindingsTransformerConversion.getStepR(convertedT2xModel.end1.phaseTapChanger));
    }

    private static double getX(ConvertedT2xModel convertedT2xModel) {
        return TwoWindingsTransformerConversion.getValue(convertedT2xModel.x, TwoWindingsTransformerConversion.getStepX(convertedT2xModel.end1.ratioTapChanger), TwoWindingsTransformerConversion.getStepX(convertedT2xModel.end1.phaseTapChanger));
    }

    private static double getG(ConvertedT2xModel convertedT2xModel) {
        return TwoWindingsTransformerConversion.getValue(convertedT2xModel.end1.g, TwoWindingsTransformerConversion.getStepG1(convertedT2xModel.end1.ratioTapChanger), TwoWindingsTransformerConversion.getStepG1(convertedT2xModel.end1.phaseTapChanger));
    }

    private static double getB(ConvertedT2xModel convertedT2xModel) {
        return TwoWindingsTransformerConversion.getValue(convertedT2xModel.end1.b, TwoWindingsTransformerConversion.getStepB1(convertedT2xModel.end1.ratioTapChanger), TwoWindingsTransformerConversion.getStepB1(convertedT2xModel.end1.phaseTapChanger));
    }
}

