/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.cgmes.conversion.CgmesExport;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.conversion.export.LoadGroup;
import com.powsybl.cgmes.conversion.export.LoadGroups;
import com.powsybl.cgmes.conversion.export.elements.AcLineSegmentEq;
import com.powsybl.cgmes.conversion.export.elements.BaseVoltageEq;
import com.powsybl.cgmes.conversion.export.elements.BusbarSectionEq;
import com.powsybl.cgmes.conversion.export.elements.ConnectivityNodeEq;
import com.powsybl.cgmes.conversion.export.elements.ControlAreaEq;
import com.powsybl.cgmes.conversion.export.elements.CurveDataEq;
import com.powsybl.cgmes.conversion.export.elements.DCConverterUnitEq;
import com.powsybl.cgmes.conversion.export.elements.DCLineSegmentEq;
import com.powsybl.cgmes.conversion.export.elements.DCNodeEq;
import com.powsybl.cgmes.conversion.export.elements.DCTerminalEq;
import com.powsybl.cgmes.conversion.export.elements.EnergyConsumerEq;
import com.powsybl.cgmes.conversion.export.elements.EquivalentInjectionEq;
import com.powsybl.cgmes.conversion.export.elements.EquivalentShuntEq;
import com.powsybl.cgmes.conversion.export.elements.ExternalNetworkInjectionEq;
import com.powsybl.cgmes.conversion.export.elements.GeneratingUnitEq;
import com.powsybl.cgmes.conversion.export.elements.GeographicalRegionEq;
import com.powsybl.cgmes.conversion.export.elements.HvdcConverterStationEq;
import com.powsybl.cgmes.conversion.export.elements.LoadAreaEq;
import com.powsybl.cgmes.conversion.export.elements.LoadResponseCharacteristicEq;
import com.powsybl.cgmes.conversion.export.elements.LoadingLimitEq;
import com.powsybl.cgmes.conversion.export.elements.OperationalLimitSetEq;
import com.powsybl.cgmes.conversion.export.elements.OperationalLimitTypeEq;
import com.powsybl.cgmes.conversion.export.elements.PowerTransformerEq;
import com.powsybl.cgmes.conversion.export.elements.ReactiveCapabilityCurveEq;
import com.powsybl.cgmes.conversion.export.elements.RegulatingControlEq;
import com.powsybl.cgmes.conversion.export.elements.ShuntCompensatorEq;
import com.powsybl.cgmes.conversion.export.elements.StaticVarCompensatorEq;
import com.powsybl.cgmes.conversion.export.elements.SubGeographicalRegionEq;
import com.powsybl.cgmes.conversion.export.elements.SubstationEq;
import com.powsybl.cgmes.conversion.export.elements.SwitchEq;
import com.powsybl.cgmes.conversion.export.elements.SynchronousMachineEq;
import com.powsybl.cgmes.conversion.export.elements.TapChangerEq;
import com.powsybl.cgmes.conversion.export.elements.TerminalEq;
import com.powsybl.cgmes.conversion.export.elements.TieFlowEq;
import com.powsybl.cgmes.conversion.export.elements.VoltageLevelEq;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.extensions.BaseVoltageMapping;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaBoundary;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.ExponentialLoadModel;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadModel;
import com.powsybl.iidm.network.LoadModelType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.MinMaxReactiveLimits;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.ReactiveLimitsKind;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.ZipLoadModel;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.iidm.network.extensions.VoltagePerReactivePowerControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EquipmentExport {
    private static final String AC_DC_CONVERTER_DC_TERMINAL = "ACDCConverterDCTerminal";
    private static final String TERMINAL_BOUNDARY = "Terminal_Boundary";
    private static final Logger LOG = LoggerFactory.getLogger(EquipmentExport.class);

    public static void write(Network network, XMLStreamWriter writer) {
        EquipmentExport.write(network, writer, new CgmesExportContext(network));
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context) {
        CgmesMetadataModel model = CgmesExport.initializeModelForExport(network, CgmesSubset.EQUIPMENT, context, true, false);
        EquipmentExport.write(network, writer, context, model);
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context, CgmesMetadataModel model) {
        try {
            String cimNamespace = context.getCim().getNamespace();
            String euNamespace = context.getCim().getEuNamespace();
            CgmesExportUtil.writeRdfRoot(cimNamespace, context.getCim().getEuPrefix(), euNamespace, writer);
            if (context.getCimVersion() >= 16) {
                CgmesExportUtil.writeModelDescription(network, CgmesSubset.EQUIPMENT, writer, model, context);
            }
            HashMap<String, String> mapNodeKey2NodeId = new HashMap<String, String>();
            HashMap<Terminal, String> mapTerminal2Id = new HashMap<Terminal, String>();
            HashSet<String> regulatingControlsWritten = new HashSet<String>();
            HashSet<Double> exportedBaseVoltagesByNominalV = new HashSet<Double>();
            HashSet<String> exportedLimitTypes = new HashSet<String>();
            LoadGroups loadGroups = new LoadGroups();
            EquipmentExport.writeConnectivityNodes(network, mapNodeKey2NodeId, cimNamespace, writer, context);
            EquipmentExport.writeTerminals(network, mapTerminal2Id, mapNodeKey2NodeId, cimNamespace, writer, context);
            EquipmentExport.writeSwitches(network, cimNamespace, writer, context);
            EquipmentExport.writeSubstations(network, cimNamespace, writer, context);
            EquipmentExport.writeVoltageLevels(network, cimNamespace, writer, context, exportedBaseVoltagesByNominalV);
            EquipmentExport.writeBusbarSections(network, cimNamespace, writer, context);
            EquipmentExport.writeLoads(network, loadGroups, cimNamespace, writer, context);
            String loadAreaId = EquipmentExport.writeLoadGroups(network, loadGroups.found(), cimNamespace, writer, context);
            EquipmentExport.writeGenerators(network, mapTerminal2Id, regulatingControlsWritten, cimNamespace, writer, context);
            EquipmentExport.writeBatteries(network, cimNamespace, writer, context);
            EquipmentExport.writeShuntCompensators(network, mapTerminal2Id, regulatingControlsWritten, cimNamespace, writer, context);
            EquipmentExport.writeStaticVarCompensators(network, mapTerminal2Id, regulatingControlsWritten, cimNamespace, writer, context);
            EquipmentExport.writeLines(network, mapTerminal2Id, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
            EquipmentExport.writeTwoWindingsTransformers(network, mapTerminal2Id, regulatingControlsWritten, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
            EquipmentExport.writeThreeWindingsTransformers(network, mapTerminal2Id, regulatingControlsWritten, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
            EquipmentExport.writeDanglingLines(network, mapTerminal2Id, cimNamespace, euNamespace, exportedLimitTypes, writer, context, exportedBaseVoltagesByNominalV);
            EquipmentExport.writeHvdcLines(network, mapTerminal2Id, mapNodeKey2NodeId, cimNamespace, writer, context);
            EquipmentExport.writeControlAreas(loadAreaId, network, cimNamespace, euNamespace, writer, context);
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeConnectivityNodes(Network network, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        if (!context.isCim16BusBranchExport()) {
            for (VoltageLevel vl : network.getVoltageLevels()) {
                String cgmesVlId = context.getNamingStrategy().getCgmesId((Identifiable<?>)vl);
                if (vl.getTopologyKind() == TopologyKind.NODE_BREAKER && !context.isBusBranchExport()) {
                    EquipmentExport.writeNodes(vl, cgmesVlId, new VoltageLevelAdjacency(vl, context), mapNodeKey2NodeId, cimNamespace, writer, context);
                    EquipmentExport.writeSwitchesConnectivity(vl, cgmesVlId, mapNodeKey2NodeId, cimNamespace, writer, context);
                    EquipmentExport.writeBusbarSectionsConnectivity(vl, mapNodeKey2NodeId, cimNamespace, writer, context);
                    continue;
                }
                EquipmentExport.writeBuses(vl, cgmesVlId, mapNodeKey2NodeId, cimNamespace, writer, context);
            }
        }
    }

    private static void writeSwitchesConnectivity(VoltageLevel vl, String cgmesVlId, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        String[] nodeKeys = new String[2];
        for (Switch sw : vl.getSwitches()) {
            EquipmentExport.fillSwitchNodeKeys(vl, sw, nodeKeys, context);
            EquipmentExport.writeSwitchConnectivity(nodeKeys[0], vl, cgmesVlId, mapNodeKey2NodeId, cimNamespace, writer, context);
            EquipmentExport.writeSwitchConnectivity(nodeKeys[1], vl, cgmesVlId, mapNodeKey2NodeId, cimNamespace, writer, context);
        }
    }

    private static void writeSwitchConnectivity(String nodeKey, VoltageLevel vl, String cgmesVlId, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        mapNodeKey2NodeId.computeIfAbsent(nodeKey, k -> {
            try {
                String node = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(vl), CgmesObjectReference.ref(nodeKey), CgmesObjectReference.Part.CONNECTIVITY_NODE);
                ConnectivityNodeEq.write(node, nodeKey, cgmesVlId, cimNamespace, writer, context);
                return node;
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
    }

    private static String buildNodeKey(VoltageLevel vl, int node) {
        return vl.getId() + "_" + node;
    }

    private static String buildNodeKey(Bus bus) {
        return bus.getId();
    }

    private static void writeBusbarSectionsConnectivity(VoltageLevel vl, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (BusbarSection bbs : vl.getNodeBreakerView().getBusbarSections()) {
            String connectivityNodeId = EquipmentExport.connectivityNodeId(mapNodeKey2NodeId, bbs.getTerminal(), context);
            if (connectivityNodeId != null) continue;
            String node = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(bbs), CgmesObjectReference.Part.CONNECTIVITY_NODE);
            ConnectivityNodeEq.write(node, bbs.getNameOrId(), context.getNamingStrategy().getCgmesId((Identifiable<?>)vl), cimNamespace, writer, context);
            String key = EquipmentExport.buildNodeKey(vl, bbs.getTerminal().getNodeBreakerView().getNode());
            mapNodeKey2NodeId.put(key, node);
        }
    }

    private static void writeNodes(VoltageLevel vl, String cgmesVlId, VoltageLevelAdjacency vlAdjacencies, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (List<Integer> nodes : vlAdjacencies.getNodes()) {
            String cgmesNodeId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(vl), CgmesObjectReference.ref(nodes.get(0)), CgmesObjectReference.Part.CONNECTIVITY_NODE);
            ConnectivityNodeEq.write(cgmesNodeId, CgmesExportUtil.format(nodes.get(0)), cgmesVlId, cimNamespace, writer, context);
            for (Integer nodeNumber : nodes) {
                mapNodeKey2NodeId.put(EquipmentExport.buildNodeKey(vl, nodeNumber), cgmesNodeId);
            }
        }
    }

    private static void writeBuses(VoltageLevel vl, String cgmesVlId, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Bus bus : vl.getBusBreakerView().getBuses()) {
            String cgmesNodeId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(bus), CgmesObjectReference.Part.CONNECTIVITY_NODE);
            ConnectivityNodeEq.write(cgmesNodeId, bus.getNameOrId(), cgmesVlId, cimNamespace, writer, context);
            mapNodeKey2NodeId.put(EquipmentExport.buildNodeKey(bus), cgmesNodeId);
        }
    }

    private static void writeSwitches(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Switch sw : network.getSwitches()) {
            if (!context.isExportedEquipment((Identifiable<?>)sw)) continue;
            VoltageLevel vl = sw.getVoltageLevel();
            String switchType = sw.getProperty("CGMES.originalClass");
            boolean exportAsRetained = sw.isRetained() && EquipmentExport.hasDifferentTNsAtBothEnds(sw);
            SwitchEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)sw), sw.getNameOrId(), switchType, sw.getKind(), context.getNamingStrategy().getCgmesId((Identifiable<?>)vl), sw.isOpen(), exportAsRetained, cimNamespace, writer, context);
        }
    }

    public static boolean hasDifferentTNsAtBothEnds(Switch sw) {
        Bus bus2;
        Bus bus1 = sw.getVoltageLevel().getBusBreakerView().getBus1(sw.getId());
        return bus1 != (bus2 = sw.getVoltageLevel().getBusBreakerView().getBus2(sw.getId()));
    }

    private static void fillSwitchNodeKeys(VoltageLevel vl, Switch sw, String[] nodeKeys, CgmesExportContext context) {
        if (vl.getTopologyKind().equals((Object)TopologyKind.NODE_BREAKER) && !context.isBusBranchExport()) {
            nodeKeys[0] = EquipmentExport.buildNodeKey(vl, vl.getNodeBreakerView().getNode1(sw.getId()));
            nodeKeys[1] = EquipmentExport.buildNodeKey(vl, vl.getNodeBreakerView().getNode2(sw.getId()));
        } else {
            nodeKeys[0] = EquipmentExport.buildNodeKey(vl.getBusBreakerView().getBus1(sw.getId()));
            nodeKeys[1] = EquipmentExport.buildNodeKey(vl.getBusBreakerView().getBus2(sw.getId()));
        }
    }

    private static void writeSubstations(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (String geographicalRegionId : context.getRegionsIds()) {
            String cgmesRegionId = context.getNamingStrategy().getCgmesId(geographicalRegionId);
            EquipmentExport.writeGeographicalRegion(cgmesRegionId, context.getRegionName(geographicalRegionId), cimNamespace, writer, context);
        }
        ArrayList<String> writtenSubRegions = new ArrayList<String>();
        for (Substation substation : network.getSubstations()) {
            String subGeographicalRegionId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)substation, "CGMES.subRegionId");
            String geographicalRegionId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)substation, "CGMES.regionId");
            if (!writtenSubRegions.contains(subGeographicalRegionId)) {
                EquipmentExport.writeSubGeographicalRegion(subGeographicalRegionId, Optional.ofNullable(context.getSubRegionName(subGeographicalRegionId)).orElse("N/A"), geographicalRegionId, cimNamespace, writer, context);
                writtenSubRegions.add(subGeographicalRegionId);
            }
            SubstationEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)substation), substation.getNameOrId(), subGeographicalRegionId, cimNamespace, writer, context);
        }
    }

    private static void writeGeographicalRegion(String geographicalRegionId, String geoName, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            GeographicalRegionEq.write(geographicalRegionId, geoName, cimNamespace, writer, context);
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeSubGeographicalRegion(String subGeographicalRegionId, String subGeographicalRegionName, String geographicalRegionId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            SubGeographicalRegionEq.write(subGeographicalRegionId, subGeographicalRegionName, geographicalRegionId, cimNamespace, writer, context);
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeVoltageLevels(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context, Set<Double> exportedBaseVoltagesByNominalV) throws XMLStreamException {
        String fictSubstationId = null;
        for (VoltageLevel voltageLevel : network.getVoltageLevels()) {
            Optional<String> substationId;
            double nominalV = voltageLevel.getNominalV();
            BaseVoltageMapping.BaseVoltageSource baseVoltage = context.getBaseVoltageByNominalVoltage(nominalV);
            if (!exportedBaseVoltagesByNominalV.contains(nominalV) && baseVoltage.getSource().equals((Object)Source.IGM)) {
                BaseVoltageEq.write(baseVoltage.getId(), nominalV, cimNamespace, writer, context);
                exportedBaseVoltagesByNominalV.add(nominalV);
            }
            if ((substationId = voltageLevel.getSubstation().map(s -> context.getNamingStrategy().getCgmesId((Identifiable<?>)s))).isEmpty() && fictSubstationId == null) {
                fictSubstationId = EquipmentExport.writeFictitiousSubstationFor(network, cimNamespace, writer, context);
            }
            VoltageLevelEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)voltageLevel), voltageLevel.getNameOrId(), voltageLevel.getLowVoltageLimit(), voltageLevel.getHighVoltageLimit(), substationId.orElse(fictSubstationId), baseVoltage.getId(), cimNamespace, writer, context);
        }
    }

    private static void writeBusbarSections(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (BusbarSection bbs : network.getBusbarSections()) {
            BusbarSectionEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)bbs), bbs.getNameOrId(), context.getNamingStrategy().getCgmesId((Identifiable<?>)bbs.getTerminal().getVoltageLevel()), context.getBaseVoltageByNominalVoltage(bbs.getTerminal().getVoltageLevel().getNominalV()).getId(), cimNamespace, writer, context);
        }
    }

    private static String writeLoadGroups(Network network, Collection<LoadGroup> foundLoadGroups, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String loadAreaId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(network), CgmesObjectReference.Part.LOAD_AREA);
        String subLoadAreaId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(network), CgmesObjectReference.Part.SUB_LOAD_AREA);
        if (!context.isCim16BusBranchExport()) {
            String baseName = network.getNameOrId();
            LoadAreaEq.write(loadAreaId, baseName, cimNamespace, writer, context);
            LoadAreaEq.writeSubArea(subLoadAreaId, loadAreaId, baseName, cimNamespace, writer, context);
        }
        for (LoadGroup loadGroup : foundLoadGroups) {
            CgmesExportUtil.writeStartIdName(loadGroup.className, loadGroup.id, loadGroup.name, cimNamespace, writer, context);
            if (!context.isCim16BusBranchExport()) {
                CgmesExportUtil.writeReference("LoadGroup.SubLoadArea", subLoadAreaId, cimNamespace, writer, context);
            }
            writer.writeEndElement();
        }
        return loadAreaId;
    }

    private static void writeLoads(Network network, LoadGroups loadGroups, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        block13: for (Load load : network.getLoads()) {
            if (!context.isExportedEquipment((Identifiable<?>)load)) continue;
            String className = CgmesExportUtil.loadClassName(load);
            String loadId = context.getNamingStrategy().getCgmesId((Identifiable<?>)load);
            switch (className) {
                case "AsynchronousMachine": {
                    EquipmentExport.writeAsynchronousMachine(loadId, load.getNameOrId(), cimNamespace, writer, context);
                    continue block13;
                }
                case "EnergySource": {
                    EquipmentExport.writeEnergySource(loadId, load.getNameOrId(), context.getNamingStrategy().getCgmesId((Identifiable<?>)load.getTerminal().getVoltageLevel()), cimNamespace, writer, context);
                    continue block13;
                }
                case "EnergyConsumer": 
                case "ConformLoad": 
                case "NonConformLoad": 
                case "StationSupply": {
                    String loadGroup = loadGroups.groupFor(className, context);
                    String loadResponseCharacteristicId = EquipmentExport.writeLoadResponseCharacteristic(load, cimNamespace, writer, context);
                    EnergyConsumerEq.write(className, loadId, load.getNameOrId(), loadGroup, context.getNamingStrategy().getCgmesId((Identifiable<?>)load.getTerminal().getVoltageLevel()), loadResponseCharacteristicId, cimNamespace, writer, context);
                    continue block13;
                }
            }
            throw new PowsyblException("Unexpected class name: " + className);
        }
    }

    private static String writeLoadResponseCharacteristic(Load load, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        Optional optionalLoadModel = load.getModel();
        if (optionalLoadModel.isEmpty()) {
            return null;
        }
        if (((LoadModel)optionalLoadModel.get()).getType() == LoadModelType.EXPONENTIAL) {
            ExponentialLoadModel exponentialLoadModel = (ExponentialLoadModel)optionalLoadModel.get();
            boolean exponentModel = exponentialLoadModel.getNp() != 0.0 || exponentialLoadModel.getNq() != 0.0;
            return EquipmentExport.writeLoadResponseCharacteristicModel(load, exponentModel, exponentialLoadModel.getNp(), exponentialLoadModel.getNq(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, cimNamespace, writer, context);
        }
        if (((LoadModel)optionalLoadModel.get()).getType() == LoadModelType.ZIP) {
            ZipLoadModel zipLoadModel = (ZipLoadModel)optionalLoadModel.get();
            return EquipmentExport.writeLoadResponseCharacteristicModel(load, false, 0.0, 0.0, zipLoadModel.getC0p(), zipLoadModel.getC0q(), zipLoadModel.getC1p(), zipLoadModel.getC1q(), zipLoadModel.getC2p(), zipLoadModel.getC2q(), cimNamespace, writer, context);
        }
        return null;
    }

    private static String writeLoadResponseCharacteristicModel(Load load, boolean exponentModel, double pVoltageExponent, double qVoltageExponent, double pConstantPower, double qConstantPower, double pConstantCurrent, double qConstantCurrent, double pConstantImpedance, double qConstantImpedance, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String loadResponseId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(load), CgmesObjectReference.Part.LOAD_RESPONSE_CHARACTERISTICS);
        String loadResponseName = "LRC_" + load.getNameOrId();
        LoadResponseCharacteristicEq.write(loadResponseId, loadResponseName, exponentModel, pVoltageExponent, qVoltageExponent, pConstantPower, qConstantPower, pConstantCurrent, qConstantCurrent, pConstantImpedance, qConstantImpedance, cimNamespace, writer, context);
        return loadResponseId;
    }

    private static void writeAsynchronousMachine(String id, String name, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("AsynchronousMachine", id, name, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    public static void writeEnergySource(String id, String name, String equipmentContainer, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("EnergySource", id, name, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("Equipment.EquipmentContainer", equipmentContainer, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeGenerators(Network network, Map<Terminal, String> mapTerminal2Id, Set<String> regulatingControlsWritten, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        HashSet<String> generatingUnitsWritten = new HashSet<String>();
        block10: for (Generator generator : network.getGenerators()) {
            String cgmesOriginalClass = generator.getProperty("CGMES.originalClass", "SynchronousMachine");
            RemoteReactivePowerControl rrpc = (RemoteReactivePowerControl)generator.getExtension(RemoteReactivePowerControl.class);
            String mode = CgmesExportUtil.getGeneratorRegulatingControlMode(generator, rrpc);
            Terminal regulatingTerminal = mode.equals("RegulatingControlModeKind.reactivePower") ? rrpc.getRegulatingTerminal() : (context.isExportGeneratorsInLocalRegulationMode() ? generator.getTerminal() : generator.getRegulatingTerminal());
            switch (cgmesOriginalClass) {
                case "EquivalentInjection": {
                    String reactiveCapabilityCurveId = EquipmentExport.writeReactiveCapabilityCurve(generator, cimNamespace, writer, context);
                    String baseVoltageId = context.getBaseVoltageByNominalVoltage(generator.getTerminal().getVoltageLevel().getNominalV()).getId();
                    EquivalentInjectionEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)generator), generator.getNameOrId(), generator.isVoltageRegulatorOn(), generator.getMinP(), generator.getMaxP(), EquipmentExport.obtainMinQ(generator), EquipmentExport.obtainMaxQ(generator), reactiveCapabilityCurveId, baseVoltageId, cimNamespace, writer, context);
                    continue block10;
                }
                case "ExternalNetworkInjection": {
                    String regulatingControlId = RegulatingControlEq.writeRegulatingControlEq(generator, EquipmentExport.exportedTerminalId(mapTerminal2Id, regulatingTerminal), regulatingControlsWritten, mode, cimNamespace, writer, context);
                    ExternalNetworkInjectionEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)generator), generator.getNameOrId(), context.getNamingStrategy().getCgmesId((Identifiable<?>)generator.getTerminal().getVoltageLevel()), EquipmentExport.obtainGeneratorGovernorScd(generator), generator.getMaxP(), EquipmentExport.obtainMaxQ(generator), generator.getMinP(), EquipmentExport.obtainMinQ(generator), regulatingControlId, cimNamespace, writer, context);
                    continue block10;
                }
                case "SynchronousMachine": {
                    String regulatingControlId = RegulatingControlEq.writeRegulatingControlEq(generator, EquipmentExport.exportedTerminalId(mapTerminal2Id, regulatingTerminal), regulatingControlsWritten, mode, cimNamespace, writer, context);
                    EquipmentExport.writeSynchronousMachine(generator, cimNamespace, generator.getMinP(), generator.getMaxP(), generator.getTargetP(), generator.getRatedS(), generator.getEnergySource(), regulatingControlId, writer, context, generatingUnitsWritten);
                    continue block10;
                }
            }
            throw new PowsyblException("Unexpected cgmes equipment " + cgmesOriginalClass);
        }
    }

    private static double obtainGeneratorGovernorScd(Generator generator) {
        String governorScd = generator.getProperty("CGMES.governorSCD");
        return governorScd == null ? 0.0 : Double.parseDouble(governorScd);
    }

    private static void writeBatteries(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        HashSet<String> generatingUnitsWritten = new HashSet<String>();
        for (Battery battery : network.getBatteries()) {
            EquipmentExport.writeSynchronousMachine(battery, cimNamespace, battery.getMinP(), battery.getMaxP(), battery.getTargetP(), Double.NaN, EnergySource.HYDRO, null, writer, context, generatingUnitsWritten);
        }
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> void writeSynchronousMachine(I i, String cimNamespace, double minP, double maxP, double targetP, double ratedS, EnergySource energySource, String regulatingControlId, XMLStreamWriter writer, CgmesExportContext context, Set<String> generatingUnitsWritten) throws XMLStreamException {
        String generatingUnit = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable)i, "CGMES.GeneratingUnit");
        double minQ = EquipmentExport.obtainMinQ(i);
        double maxQ = EquipmentExport.obtainMaxQ(i);
        double defaultRatedS = EquipmentExport.computeDefaultRatedS(i, minP, maxP);
        String reactiveLimitsId = EquipmentExport.writeReactiveCapabilityCurve(i, cimNamespace, writer, context);
        String kind = CgmesExportUtil.obtainSynchronousMachineKind(i, minP, maxP, CgmesExportUtil.obtainCurve(i));
        SynchronousMachineEq.write(context.getNamingStrategy().getCgmesId((Identifiable)i), ((Identifiable)i).getNameOrId(), context.getNamingStrategy().getCgmesId((Identifiable<?>)((Injection<I>)i).getTerminal().getVoltageLevel()), generatingUnit, regulatingControlId, reactiveLimitsId, minQ, maxQ, ratedS, defaultRatedS, kind, cimNamespace, writer, context);
        if (generatingUnit != null && !generatingUnitsWritten.contains(generatingUnit)) {
            String hydroPowerPlantId = EquipmentExport.generatingUnitWriteHydroPowerPlantAndFossilFuel(i, cimNamespace, energySource, generatingUnit, writer, context);
            String windGenUnitType = ((Identifiable)i).getProperty("CGMES.windGenUnitType", "onshore");
            String generatingUnitName = "GU_" + ((Identifiable)i).getNameOrId();
            GeneratingUnitEq.write(generatingUnit, generatingUnitName, energySource, minP, maxP, targetP, cimNamespace, ((Injection<I>)i).getTerminal().getVoltageLevel().getSubstation().map(s -> context.getNamingStrategy().getCgmesId((Identifiable<?>)s)).orElse(null), hydroPowerPlantId, windGenUnitType, writer, context);
            generatingUnitsWritten.add(generatingUnit);
        }
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> String writeReactiveCapabilityCurve(I i, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        ReactiveCapabilityCurve curve;
        String reactiveLimitsId = null;
        if (i.getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.CURVE) && EquipmentExport.curveMustBeWritten(curve = (ReactiveCapabilityCurve)i.getReactiveLimits(ReactiveCapabilityCurve.class))) {
            reactiveLimitsId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped((Identifiable)i), CgmesObjectReference.Part.REACTIVE_CAPABILITY_CURVE);
            int pointIndex = 0;
            for (ReactiveCapabilityCurve.Point point : curve.getPoints()) {
                String pointId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped((Identifiable)i), CgmesObjectReference.ref(pointIndex), CgmesObjectReference.Part.REACTIVE_CAPABIILITY_CURVE_POINT);
                CurveDataEq.write(pointId, point.getP(), point.getMinQ(), point.getMaxQ(), reactiveLimitsId, cimNamespace, writer, context);
                ++pointIndex;
            }
            String reactiveCapabilityCurveName = "RCC_" + ((Identifiable)i).getNameOrId();
            ReactiveCapabilityCurveEq.write(reactiveLimitsId, reactiveCapabilityCurveName, i, cimNamespace, writer, context);
        }
        return reactiveLimitsId;
    }

    private static boolean curveMustBeWritten(ReactiveCapabilityCurve curve) {
        double minQ = Double.min(curve.getMinQ(curve.getMinP()), curve.getMinQ(curve.getMaxP()));
        double maxQ = Double.max(curve.getMaxQ(curve.getMinP()), curve.getMaxQ(curve.getMaxP()));
        return maxQ > minQ;
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> double obtainMinQ(I i) {
        if (i.getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.CURVE)) {
            ReactiveCapabilityCurve curve = (ReactiveCapabilityCurve)i.getReactiveLimits(ReactiveCapabilityCurve.class);
            return Double.min(curve.getMinQ(curve.getMinP()), curve.getMinQ(curve.getMaxP()));
        }
        if (i.getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.MIN_MAX)) {
            return ((MinMaxReactiveLimits)i.getReactiveLimits(MinMaxReactiveLimits.class)).getMinQ();
        }
        throw new PowsyblException("Unexpected ReactiveLimits type in the generator " + ((Identifiable)i).getNameOrId());
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> double obtainMaxQ(I i) {
        if (i.getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.CURVE)) {
            ReactiveCapabilityCurve curve = (ReactiveCapabilityCurve)i.getReactiveLimits(ReactiveCapabilityCurve.class);
            return Double.max(curve.getMaxQ(curve.getMinP()), curve.getMaxQ(curve.getMaxP()));
        }
        if (i.getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.MIN_MAX)) {
            return ((MinMaxReactiveLimits)i.getReactiveLimits(MinMaxReactiveLimits.class)).getMaxQ();
        }
        throw new PowsyblException("Unexpected ReactiveLimits type in the generator " + ((Identifiable)i).getNameOrId());
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> String generatingUnitWriteHydroPowerPlantAndFossilFuel(I i, String cimNamespace, EnergySource energySource, String generatingUnit, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String fossilFuelType;
        String hydroPlantStorageType = ((Identifiable)i).getProperty("CGMES.hydroPlantStorageKind");
        String hydroPowerPlantId = null;
        if (hydroPlantStorageType != null && energySource.equals((Object)EnergySource.HYDRO)) {
            String hydroPowerPlantName = ((Identifiable)i).getNameOrId();
            hydroPowerPlantId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref((Identifiable)i), CgmesObjectReference.Part.HYDRO_POWER_PLANT);
            EquipmentExport.writeHydroPowerPlant(hydroPowerPlantId, hydroPowerPlantName, hydroPlantStorageType, cimNamespace, writer, context);
        }
        if ((fossilFuelType = ((Identifiable)i).getProperty("CGMES.fuelType")) != null && !fossilFuelType.isEmpty() && energySource.equals((Object)EnergySource.THERMAL)) {
            String[] fossilFuelTypeArray = fossilFuelType.split(";");
            for (int j = 0; j < fossilFuelTypeArray.length; ++j) {
                String fossilFuelName = ((Identifiable)i).getNameOrId();
                String fossilFuelId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped((Identifiable)i), CgmesObjectReference.ref(j), CgmesObjectReference.Part.THERMAL_GENERATING_UNIT, CgmesObjectReference.Part.FOSSIL_FUEL);
                EquipmentExport.writeFossilFuel(fossilFuelId, fossilFuelName, fossilFuelTypeArray[j], generatingUnit, cimNamespace, writer, context);
            }
        }
        return hydroPowerPlantId;
    }

    private static void writeHydroPowerPlant(String id, String name, String hydroPlantStorageType, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("HydroPowerPlant", id, name, cimNamespace, writer, context);
        writer.writeEmptyElement(cimNamespace, "HydroPowerPlant.hydroPlantStorageType");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", String.format("%s%s", cimNamespace, "HydroPlantStorageKind." + hydroPlantStorageType));
        writer.writeEndElement();
    }

    private static void writeFossilFuel(String id, String name, String fuelType, String generatingUnit, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("FossilFuel", id, name, cimNamespace, writer, context);
        writer.writeEmptyElement(cimNamespace, "FossilFuel.fossilFuelType");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", String.format("%s%s", cimNamespace, "FuelType." + fuelType));
        CgmesExportUtil.writeReference("FossilFuel.ThermalGeneratingUnit", generatingUnit, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static <I extends ReactiveLimitsHolder & Injection<I>> double computeDefaultRatedS(I i, double minP, double maxP) {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(Math.abs(minP));
        values.add(Math.abs(maxP));
        ReactiveLimits limits = i.getReactiveLimits();
        if (limits.getKind() == ReactiveLimitsKind.MIN_MAX) {
            values.add(Math.abs(((MinMaxReactiveLimits)i.getReactiveLimits(MinMaxReactiveLimits.class)).getMinQ()));
            values.add(Math.abs(((MinMaxReactiveLimits)i.getReactiveLimits(MinMaxReactiveLimits.class)).getMaxQ()));
        } else {
            ReactiveCapabilityCurve curve = (ReactiveCapabilityCurve)i.getReactiveLimits(ReactiveCapabilityCurve.class);
            for (ReactiveCapabilityCurve.Point p : curve.getPoints()) {
                values.add(Math.abs(p.getP()));
                values.add(Math.abs(p.getMinQ()));
                values.add(Math.abs(p.getMaxQ()));
                values.add(Math.sqrt(p.getP() * p.getP() + p.getMinQ() * p.getMinQ()));
                values.add(Math.sqrt(p.getP() * p.getP() + p.getMaxQ() * p.getMaxQ()));
            }
        }
        values.sort(Double::compareTo);
        return (Double)values.get(values.size() - 1);
    }

    private static void writeShuntCompensators(Network network, Map<Terminal, String> mapTerminal2Id, Set<String> regulatingControlsWritten, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (ShuntCompensator s : network.getShuntCompensators()) {
            if ("true".equals(s.getProperty("CGMES.isEquivalentShunt"))) {
                EquivalentShuntEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)s), s.getNameOrId(), s.getG(s.getMaximumSectionCount()), s.getB(s.getMaximumSectionCount()), context.getNamingStrategy().getCgmesId((Identifiable<?>)s.getTerminal().getVoltageLevel()), cimNamespace, writer, context);
                continue;
            }
            String mode = "RegulatingControlModeKind.voltage";
            double bPerSection = 0.0;
            double gPerSection = Double.NaN;
            if (s.getModelType().equals((Object)ShuntCompensatorModelType.LINEAR)) {
                bPerSection = ((ShuntCompensatorLinearModel)s.getModel()).getBPerSection();
                gPerSection = ((ShuntCompensatorLinearModel)s.getModel()).getGPerSection();
            }
            String regulatingControlId = RegulatingControlEq.writeRegulatingControlEq(s, EquipmentExport.exportedTerminalId(mapTerminal2Id, s.getRegulatingTerminal()), regulatingControlsWritten, mode, cimNamespace, writer, context);
            ShuntCompensatorEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)s), s.getNameOrId(), s.getSectionCount(), s.getMaximumSectionCount(), s.getTerminal().getVoltageLevel().getNominalV(), s.getModelType(), bPerSection, gPerSection, regulatingControlId, context.getNamingStrategy().getCgmesId((Identifiable<?>)s.getTerminal().getVoltageLevel()), cimNamespace, writer, context);
            if (!s.getModelType().equals((Object)ShuntCompensatorModelType.NON_LINEAR)) continue;
            double b = 0.0;
            double g = 0.0;
            for (int section = 1; section <= s.getMaximumSectionCount(); ++section) {
                String pointId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(s), CgmesObjectReference.ref(section), CgmesObjectReference.Part.SHUNT_COMPENSATOR);
                ShuntCompensatorEq.writePoint(pointId, context.getNamingStrategy().getCgmesId((Identifiable<?>)s), section, s.getB(section) - b, s.getG(section) - g, cimNamespace, writer, context);
                b = s.getB(section);
                g = s.getG(section);
            }
        }
    }

    private static void writeStaticVarCompensators(Network network, Map<Terminal, String> mapTerminal2Id, Set<String> regulatingControlsWritten, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (StaticVarCompensator svc : network.getStaticVarCompensators()) {
            String mode = CgmesExportUtil.getSvcMode(svc);
            String regulatingControlId = RegulatingControlEq.writeRegulatingControlEq(svc, EquipmentExport.exportedTerminalId(mapTerminal2Id, svc.getRegulatingTerminal()), regulatingControlsWritten, mode, cimNamespace, writer, context);
            double inductiveRating = svc.getBmin() != 0.0 ? 1.0 / svc.getBmin() : 0.0;
            double capacitiveRating = svc.getBmax() != 0.0 ? 1.0 / svc.getBmax() : 0.0;
            StaticVarCompensatorEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)svc), svc.getNameOrId(), context.getNamingStrategy().getCgmesId((Identifiable<?>)svc.getTerminal().getVoltageLevel()), regulatingControlId, inductiveRating, capacitiveRating, (VoltagePerReactivePowerControl)svc.getExtension(VoltagePerReactivePowerControl.class), svc.getRegulationMode(), svc.getVoltageSetpoint(), cimNamespace, writer, context);
        }
    }

    private static void writeLines(Network network, Map<Terminal, String> mapTerminal2Id, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Line line : network.getLines()) {
            String baseVoltage = null;
            if (line.getTerminal1().getVoltageLevel().getNominalV() == line.getTerminal2().getVoltageLevel().getNominalV()) {
                baseVoltage = context.getBaseVoltageByNominalVoltage(line.getTerminal1().getVoltageLevel().getNominalV()).getId();
            }
            AcLineSegmentEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)line), line.getNameOrId(), baseVoltage, line.getR(), line.getX(), line.getG1() + line.getG2(), line.getB1() + line.getB2(), cimNamespace, writer, context);
            EquipmentExport.writeBranchLimits(line, EquipmentExport.exportedTerminalId(mapTerminal2Id, line.getTerminal1()), EquipmentExport.exportedTerminalId(mapTerminal2Id, line.getTerminal2()), cimNamespace, euNamespace, exportedLimitTypes, writer, context);
        }
    }

    private static void writeTwoWindingsTransformers(Network network, Map<Terminal, String> mapTerminal2Id, Set<String> regulatingControlsWritten, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (TwoWindingsTransformer twt : network.getTwoWindingsTransformers()) {
            CgmesExportUtil.addUpdateCgmesTapChangerExtension(twt, context);
            PowerTransformerEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), twt.getNameOrId(), twt.getSubstation().map(s -> context.getNamingStrategy().getCgmesId((Identifiable<?>)s)).orElse(null), cimNamespace, writer, context);
            String end1Id = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.TransformerEnd1");
            EndNumberAssignerForTwoWindingsTransformer endNumberAssigner = new EndNumberAssignerForTwoWindingsTransformer(twt, context.exportTransformersWithHighestVoltageAtEnd1());
            PowerTransformerEndsParameters p = new PowerTransformerEndsParameters(twt, endNumberAssigner.getEndNumberForSide1());
            BaseVoltageMapping.BaseVoltageSource baseVoltage1 = context.getBaseVoltageByNominalVoltage(twt.getTerminal1().getVoltageLevel().getNominalV());
            PowerTransformerEq.writeEnd(end1Id, twt.getNameOrId() + "_1", context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), endNumberAssigner.getEndNumberForSide1(), p.getEnd1R(), p.getEnd1X(), p.getEnd1G(), p.getEnd1B(), twt.getRatedS(), twt.getRatedU1(), EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getTerminal1()), baseVoltage1.getId(), cimNamespace, writer, context);
            String end2Id = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.TransformerEnd2");
            BaseVoltageMapping.BaseVoltageSource baseVoltage2 = context.getBaseVoltageByNominalVoltage(twt.getTerminal2().getVoltageLevel().getNominalV());
            PowerTransformerEq.writeEnd(end2Id, twt.getNameOrId() + "_2", context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), endNumberAssigner.getEndNumberForSide2(), p.getEnd2R(), p.getEnd2X(), p.getEnd2G(), p.getEnd2B(), twt.getRatedS(), twt.getRatedU2(), EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getTerminal2()), baseVoltage2.getId(), cimNamespace, writer, context);
            int endNumber = 1;
            EquipmentExport.adjustTapChangerAliases2wt(twt, twt.getPhaseTapChanger(), "PhaseTapChanger");
            EquipmentExport.adjustTapChangerAliases2wt(twt, twt.getRatioTapChanger(), "RatioTapChanger");
            EquipmentExport.writePhaseTapChanger(twt, twt.getPhaseTapChanger(), twt.getNameOrId(), endNumber, end1Id, twt.getRatedU1(), regulatingControlsWritten, cimNamespace, writer, context);
            EquipmentExport.writeRatioTapChanger(twt, twt.getRatioTapChanger(), twt.getNameOrId(), endNumber, end1Id, twt.getRatedU1(), regulatingControlsWritten, cimNamespace, writer, context);
            EquipmentExport.writeBranchLimits(twt, EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getTerminal1()), EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getTerminal2()), cimNamespace, euNamespace, exportedLimitTypes, writer, context);
        }
    }

    private static void adjustTapChangerAliases2wt(TwoWindingsTransformer transformer, TapChanger<?, ?, ?, ?> tc, String tapChangerKind) {
        String aliasType2;
        Optional tc2id;
        String aliasType1;
        if (tc != null && transformer.getAliasFromType(aliasType1 = "CGMES." + tapChangerKind + "1").isEmpty() && (tc2id = transformer.getAliasFromType(aliasType2 = "CGMES." + tapChangerKind + "2")).isPresent()) {
            transformer.removeAlias((String)tc2id.get());
            transformer.addAlias((String)tc2id.get(), aliasType1);
        }
    }

    private static void writeThreeWindingsTransformers(Network network, Map<Terminal, String> mapTerminal2Id, Set<String> regulatingControlsWritten, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (ThreeWindingsTransformer twt : network.getThreeWindingsTransformers()) {
            CgmesExportUtil.addUpdateCgmesTapChangerExtension(twt, context);
            PowerTransformerEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), twt.getNameOrId(), twt.getSubstation().map(s -> context.getNamingStrategy().getCgmesId((Identifiable<?>)s)).orElse(null), cimNamespace, writer, context);
            double ratedU0 = twt.getRatedU0();
            EndNumberAssignerForThreeWindingsTransformer endNumberAssigner = new EndNumberAssignerForThreeWindingsTransformer(twt, context.exportTransformersWithHighestVoltageAtEnd1());
            String end1Id = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.TransformerEnd1");
            EquipmentExport.writeThreeWindingsTransformerEnd(twt, context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), twt.getNameOrId() + "_1", end1Id, endNumberAssigner.getEndNumberForLeg1(), 1, twt.getLeg1(), ratedU0, EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getLeg1().getTerminal()), regulatingControlsWritten, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
            String end2Id = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.TransformerEnd2");
            EquipmentExport.writeThreeWindingsTransformerEnd(twt, context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), twt.getNameOrId() + "_2", end2Id, endNumberAssigner.getEndNumberForLeg2(), 2, twt.getLeg2(), ratedU0, EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getLeg2().getTerminal()), regulatingControlsWritten, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
            String end3Id = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.TransformerEnd3");
            EquipmentExport.writeThreeWindingsTransformerEnd(twt, context.getNamingStrategy().getCgmesId((Identifiable<?>)twt), twt.getNameOrId() + "_3", end3Id, endNumberAssigner.getEndNumberForLeg3(), 3, twt.getLeg3(), ratedU0, EquipmentExport.exportedTerminalId(mapTerminal2Id, twt.getLeg3().getTerminal()), regulatingControlsWritten, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
        }
    }

    private static void writeThreeWindingsTransformerEnd(ThreeWindingsTransformer twt, String twtId, String twtName, String endId, int endNumber, int legNumber, ThreeWindingsTransformer.Leg leg, double ratedU0, String terminalId, Set<String> regulatingControlsWritten, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        double a0 = leg.getRatedU() / ratedU0;
        double a02 = a0 * a0;
        double r = leg.getR() * a02;
        double x = leg.getX() * a02;
        double g = leg.getG() / a02;
        double b = leg.getB() / a02;
        BaseVoltageMapping.BaseVoltageSource baseVoltage = context.getBaseVoltageByNominalVoltage(leg.getTerminal().getVoltageLevel().getNominalV());
        PowerTransformerEq.writeEnd(endId, twtName, twtId, endNumber, r, x, g, b, leg.getRatedS(), leg.getRatedU(), terminalId, baseVoltage.getId(), cimNamespace, writer, context);
        EquipmentExport.writePhaseTapChanger(twt, leg.getPhaseTapChanger(), twtName, legNumber, endId, leg.getRatedU(), regulatingControlsWritten, cimNamespace, writer, context);
        EquipmentExport.writeRatioTapChanger(twt, leg.getRatioTapChanger(), twtName, legNumber, endId, leg.getRatedU(), regulatingControlsWritten, cimNamespace, writer, context);
        EquipmentExport.writeFlowsLimits(twt, (FlowsLimitsHolder)leg, terminalId, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
    }

    private static <C extends Connectable<C>> void writePhaseTapChanger(C eq, PhaseTapChanger ptc, String twtName, int endNumber, String endId, double neutralU, Set<String> regulatingControlsWritten, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        if (ptc != null) {
            String aliasType = "CGMES.PhaseTapChanger" + endNumber;
            String tapChangerId = (String)eq.getAliasFromType(aliasType).orElseThrow();
            String cgmesTapChangerId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)eq, aliasType);
            int neutralStep = EquipmentExport.getPhaseTapChangerNeutralStep(ptc);
            Optional<String> regulatingControlId = EquipmentExport.getTapChangerControlId(eq, tapChangerId);
            String cgmesRegulatingControlId = null;
            if (regulatingControlId.isPresent() && CgmesExportUtil.regulatingControlIsDefined(ptc)) {
                String mode = CgmesExportUtil.getPhaseTapChangerRegulationMode(ptc);
                String controlName = twtName + "_PTC_RC";
                String terminalId = CgmesExportUtil.getTerminalId(ptc.getRegulationTerminal(), context);
                cgmesRegulatingControlId = context.getNamingStrategy().getCgmesId(regulatingControlId.get());
                if (!regulatingControlsWritten.contains(cgmesRegulatingControlId)) {
                    TapChangerEq.writeControl(cgmesRegulatingControlId, controlName, mode, terminalId, cimNamespace, writer, context);
                    regulatingControlsWritten.add(cgmesRegulatingControlId);
                }
            }
            String phaseTapChangerTableId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(eq), CgmesObjectReference.ref(endNumber), CgmesObjectReference.Part.PHASE_TAP_CHANGER_TABLE);
            String typeTabular = "PhaseTapChangerTabular";
            CgmesExportUtil.setCgmesTapChangerType(eq, tapChangerId, typeTabular);
            boolean ltcFlag = EquipmentExport.obtainPhaseTapChangerLtcFlag(ptc.getRegulationMode());
            TapChangerEq.writePhase(typeTabular, cgmesTapChangerId, twtName + "_PTC", endId, ptc.getLowTapPosition(), ptc.getHighTapPosition(), neutralStep, ptc.getTapPosition(), neutralU, ltcFlag, phaseTapChangerTableId, cgmesRegulatingControlId, cimNamespace, writer, context);
            TapChangerEq.writePhaseTable(phaseTapChangerTableId, twtName + "_TABLE", cimNamespace, writer, context);
            for (Map.Entry step : ptc.getAllSteps().entrySet()) {
                String stepId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(eq), CgmesObjectReference.ref(endNumber), CgmesObjectReference.ref((Integer)step.getKey()), CgmesObjectReference.Part.PHASE_TAP_CHANGER_STEP);
                TapChangerEq.writePhaseTablePoint(stepId, phaseTapChangerTableId, ((PhaseTapChangerStep)step.getValue()).getR(), ((PhaseTapChangerStep)step.getValue()).getX(), ((PhaseTapChangerStep)step.getValue()).getG(), ((PhaseTapChangerStep)step.getValue()).getB(), 1.0 / ((PhaseTapChangerStep)step.getValue()).getRho(), -((PhaseTapChangerStep)step.getValue()).getAlpha(), (Integer)step.getKey(), cimNamespace, writer, context);
            }
        }
    }

    private static boolean obtainPhaseTapChangerLtcFlag(PhaseTapChanger.RegulationMode regulationMode) {
        return regulationMode == PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL || regulationMode == PhaseTapChanger.RegulationMode.CURRENT_LIMITER;
    }

    private static <C extends Connectable<C>> Optional<String> getTapChangerControlId(C eq, String tcId) {
        CgmesTapChanger cgmesTc;
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)eq.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && (cgmesTc = cgmesTcs.getTapChanger(tcId)) != null) {
            return Optional.ofNullable(cgmesTc.getControlId());
        }
        return Optional.empty();
    }

    private static int getPhaseTapChangerNeutralStep(PhaseTapChanger ptc) {
        int neutralStep = ptc.getLowTapPosition();
        double minAlpha = Math.abs(((PhaseTapChangerStep)ptc.getStep(neutralStep)).getAlpha());
        for (Map.Entry step : ptc.getAllSteps().entrySet()) {
            double tempAlpha = Math.abs(((PhaseTapChangerStep)step.getValue()).getAlpha());
            if (!(tempAlpha < minAlpha)) continue;
            minAlpha = tempAlpha;
            neutralStep = (Integer)step.getKey();
        }
        return neutralStep;
    }

    private static <C extends Connectable<C>> void writeRatioTapChanger(C eq, RatioTapChanger rtc, String twtName, int endNumber, String endId, double neutralU, Set<String> regulatingControlsWritten, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        if (rtc != null) {
            String aliasType = "CGMES.RatioTapChanger" + endNumber;
            String tapChangerId = (String)eq.getAliasFromType(aliasType).orElseThrow();
            String cgmesTapChangerId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)eq, aliasType);
            int neutralStep = EquipmentExport.getRatioTapChangerNeutralStep(rtc);
            double stepVoltageIncrement = rtc.getHighTapPosition() == rtc.getLowTapPosition() ? 100.0 : 100.0 * (1.0 / ((RatioTapChangerStep)rtc.getStep(rtc.getLowTapPosition())).getRho() - 1.0 / ((RatioTapChangerStep)rtc.getStep(rtc.getHighTapPosition())).getRho()) / (double)(rtc.getLowTapPosition() - rtc.getHighTapPosition());
            String ratioTapChangerTableId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(eq), CgmesObjectReference.ref(endNumber), CgmesObjectReference.Part.RATIO_TAP_CHANGER_TABLE);
            Optional<String> regulatingControlId = EquipmentExport.getTapChangerControlId(eq, tapChangerId);
            String cgmesRegulatingControlId = null;
            String controlMode = "volt";
            if (regulatingControlId.isPresent() && CgmesExportUtil.regulatingControlIsDefined(rtc)) {
                String controlName = twtName + "_RTC_RC";
                String terminalId = CgmesExportUtil.getTerminalId(rtc.getRegulationTerminal(), context);
                cgmesRegulatingControlId = context.getNamingStrategy().getCgmesId(regulatingControlId.get());
                if (!regulatingControlsWritten.contains(cgmesRegulatingControlId)) {
                    String tccMode = CgmesExportUtil.getTcMode(rtc);
                    if (tccMode.equals("RegulatingControlModeKind.reactivePower")) {
                        controlMode = "reactive";
                    }
                    TapChangerEq.writeControl(cgmesRegulatingControlId, controlName, tccMode, terminalId, cimNamespace, writer, context);
                    regulatingControlsWritten.add(cgmesRegulatingControlId);
                }
            }
            TapChangerEq.writeRatio(cgmesTapChangerId, twtName + "_RTC", endId, rtc.getLowTapPosition(), rtc.getHighTapPosition(), neutralStep, rtc.getTapPosition(), neutralU, rtc.hasLoadTapChangingCapabilities(), stepVoltageIncrement, ratioTapChangerTableId, cgmesRegulatingControlId, controlMode, cimNamespace, writer, context);
            TapChangerEq.writeRatioTable(ratioTapChangerTableId, twtName + "_TABLE", cimNamespace, writer, context);
            for (Map.Entry step : rtc.getAllSteps().entrySet()) {
                String stepId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(eq), CgmesObjectReference.ref(endNumber), CgmesObjectReference.ref((Integer)step.getKey()), CgmesObjectReference.Part.RATIO_TAP_CHANGER_STEP);
                TapChangerEq.writeRatioTablePoint(stepId, ratioTapChangerTableId, ((RatioTapChangerStep)step.getValue()).getR(), ((RatioTapChangerStep)step.getValue()).getX(), ((RatioTapChangerStep)step.getValue()).getG(), ((RatioTapChangerStep)step.getValue()).getB(), 1.0 / ((RatioTapChangerStep)step.getValue()).getRho(), (Integer)step.getKey(), cimNamespace, writer, context);
            }
        }
    }

    private static int getRatioTapChangerNeutralStep(RatioTapChanger rtc) {
        int neutralStep = rtc.getLowTapPosition();
        double minRatio = Math.abs(1.0 - ((RatioTapChangerStep)rtc.getStep(neutralStep)).getRho());
        for (Map.Entry step : rtc.getAllSteps().entrySet()) {
            double tempRatio = Math.abs(1.0 - ((RatioTapChangerStep)step.getValue()).getRho());
            if (!(tempRatio < minRatio)) continue;
            minRatio = tempRatio;
            neutralStep = (Integer)step.getKey();
        }
        return neutralStep;
    }

    private static void writeDanglingLines(Network network, Map<Terminal, String> mapTerminal2Id, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context, Set<Double> exportedBaseVoltagesByNominalV) throws XMLStreamException {
        ArrayList<String> exported = new ArrayList<String>();
        for (DanglingLine danglingLine2 : network.getDanglingLines(DanglingLineFilter.UNPAIRED)) {
            EquipmentExport.writeUnpairedOrPairedDanglingLines(Collections.singletonList(danglingLine2), mapTerminal2Id, cimNamespace, euNamespace, exportedLimitTypes, writer, context, exportedBaseVoltagesByNominalV, exported);
        }
        Set pairingKeys = network.getDanglingLineStream(DanglingLineFilter.PAIRED).map(DanglingLine::getPairingKey).collect(Collectors.toSet());
        for (String pairingKey : pairingKeys) {
            List<DanglingLine> danglingLineList = network.getDanglingLineStream(DanglingLineFilter.PAIRED).filter(danglingLine -> pairingKey.equals(danglingLine.getPairingKey())).toList();
            EquipmentExport.writeUnpairedOrPairedDanglingLines(danglingLineList, mapTerminal2Id, cimNamespace, euNamespace, exportedLimitTypes, writer, context, exportedBaseVoltagesByNominalV, exported);
        }
    }

    private static void writeUnpairedOrPairedDanglingLines(List<DanglingLine> danglingLineList, Map<Terminal, String> mapTerminal2Id, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context, Set<Double> exportedBaseVoltagesByNominalV, List<String> exported) throws XMLStreamException {
        String baseVoltageId = EquipmentExport.writeDanglingLinesBaseVoltage(danglingLineList, cimNamespace, writer, context, exportedBaseVoltagesByNominalV);
        String connectivityNodeId = EquipmentExport.writeDanglingLinesConnectivity(danglingLineList, baseVoltageId, cimNamespace, writer, context);
        for (DanglingLine danglingLine : danglingLineList) {
            EquipmentExport.writeDanglingLineEquivalentInjection(danglingLine, cimNamespace, baseVoltageId, connectivityNodeId, exported, writer, context);
            AcLineSegmentEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)danglingLine), danglingLine.getNameOrId(), context.getBaseVoltageByNominalVoltage(danglingLine.getTerminal().getVoltageLevel().getNominalV()).getId(), danglingLine.getR(), danglingLine.getX(), danglingLine.getG(), danglingLine.getB(), cimNamespace, writer, context);
            EquipmentExport.writeFlowsLimits(danglingLine, (FlowsLimitsHolder)danglingLine, EquipmentExport.exportedTerminalId(mapTerminal2Id, danglingLine.getTerminal()), cimNamespace, euNamespace, exportedLimitTypes, writer, context);
            danglingLine.getAliasFromType("CGMES.Terminal_Boundary").ifPresent(terminalBdId -> {
                try {
                    EquipmentExport.writeFlowsLimits(danglingLine, (FlowsLimitsHolder)danglingLine, terminalBdId, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
                }
                catch (XMLStreamException e) {
                    throw new UncheckedXmlStreamException(e);
                }
            });
        }
    }

    private static void writeDanglingLineEquivalentInjection(DanglingLine danglingLine, String cimNamespace, String baseVoltageId, String connectivityNodeId, List<String> exported, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String equivalentInjectionTerminalId;
        String equivalentInjectionId;
        double minP = 0.0;
        double maxP = 0.0;
        double minQ = 0.0;
        double maxQ = 0.0;
        if (danglingLine.getGeneration() != null) {
            minP = danglingLine.getGeneration().getMinP();
            maxP = danglingLine.getGeneration().getMaxP();
            if (danglingLine.getGeneration().getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.MIN_MAX)) {
                minQ = ((MinMaxReactiveLimits)danglingLine.getGeneration().getReactiveLimits(MinMaxReactiveLimits.class)).getMinQ();
                maxQ = ((MinMaxReactiveLimits)danglingLine.getGeneration().getReactiveLimits(MinMaxReactiveLimits.class)).getMaxQ();
            } else {
                throw new PowsyblException("Unexpected type of ReactiveLimits on the dangling line " + danglingLine.getNameOrId());
            }
        }
        if ((equivalentInjectionId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)danglingLine, "CGMES.EquivalentInjection")) != null && !exported.contains(equivalentInjectionId)) {
            EquivalentInjectionEq.write(equivalentInjectionId, danglingLine.getNameOrId() + "_EI", danglingLine.getGeneration() != null, minP, maxP, minQ, maxQ, null, baseVoltageId, cimNamespace, writer, context);
            exported.add(equivalentInjectionId);
        }
        if ((equivalentInjectionTerminalId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)danglingLine, "CGMES.EquivalentInjectionTerminal")) != null && !exported.contains(equivalentInjectionTerminalId)) {
            TerminalEq.write(equivalentInjectionTerminalId, equivalentInjectionId, connectivityNodeId, 1, cimNamespace, writer, context);
            exported.add(equivalentInjectionTerminalId);
        }
    }

    private static String writeDanglingLinesBaseVoltage(List<DanglingLine> danglingLineList, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context, Set<Double> exportedBaseVoltagesByNominalV) throws XMLStreamException {
        double nominalV = (Double)danglingLineList.stream().map(danglingLine -> danglingLine.getTerminal().getVoltageLevel().getNominalV()).collect(Collectors.toSet()).stream().sorted().findFirst().orElseThrow();
        BaseVoltageMapping.BaseVoltageSource baseVoltage = context.getBaseVoltageByNominalVoltage(nominalV);
        if (!exportedBaseVoltagesByNominalV.contains(nominalV) && baseVoltage.getSource().equals((Object)Source.IGM)) {
            BaseVoltageEq.write(baseVoltage.getId(), nominalV, cimNamespace, writer, context);
            exportedBaseVoltagesByNominalV.add(nominalV);
        }
        return baseVoltage.getId();
    }

    private static String writeDanglingLinesConnectivity(List<DanglingLine> danglingLineList, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String connectivityNodeId = null;
        if (!context.isCim16BusBranchExport()) {
            connectivityNodeId = EquipmentExport.writeDanglingLinesConnectivityNode(danglingLineList, baseVoltageId, cimNamespace, writer, context);
        } else {
            EquipmentExport.writeDanglingLinesFictitiousContainer(danglingLineList, baseVoltageId, cimNamespace, writer, context);
        }
        for (DanglingLine danglingLine : danglingLineList) {
            String terminalId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)danglingLine, "CGMES.Terminal_Boundary");
            TerminalEq.write(terminalId, context.getNamingStrategy().getCgmesId((Identifiable<?>)danglingLine), connectivityNodeId, 2, cimNamespace, writer, context);
        }
        return connectivityNodeId;
    }

    private static String writeDanglingLinesConnectivityNode(List<DanglingLine> danglingLineList, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String connectivityNodeId;
        Set connectevityNodeIdSet = danglingLineList.stream().map(danglingLine -> EquipmentExport.obtainConnectivityNodeId(danglingLine, context)).flatMap(Optional::stream).collect(Collectors.toSet());
        if (connectevityNodeIdSet.size() > 1) {
            throw new PowsyblException("Paired danglingLines with different connectivityNode on the boundarySide. ParingKey: " + danglingLineList.get(0).getPairingKey());
        }
        if (connectevityNodeIdSet.size() == 1) {
            connectivityNodeId = (String)connectevityNodeIdSet.iterator().next();
            EquipmentExport.setDanglingLinesProperty(danglingLineList, "CGMES.ConnectivityNode_Boundary", connectivityNodeId);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Dangling line(s) not connected to a connectivity node in boundaries files: a fictitious substation and voltage level are created: {}", (Object)EquipmentExport.danglingLinesId(danglingLineList));
            }
            DanglingLine danglingLine2 = danglingLineList.stream().min(Comparator.comparing(Identifiable::getId)).orElseThrow();
            connectivityNodeId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(danglingLine2), CgmesObjectReference.Part.CONNECTIVITY_NODE);
            String connectivityNodeContainerId = EquipmentExport.createFictitiousContainerFor(danglingLineList, baseVoltageId, cimNamespace, writer, context);
            ConnectivityNodeEq.write(connectivityNodeId, danglingLine2.getNameOrId() + "_NODE", connectivityNodeContainerId, cimNamespace, writer, context);
            EquipmentExport.setDanglingLinesProperty(danglingLineList, "CGMES.ConnectivityNode_Boundary", connectivityNodeId);
        }
        return connectivityNodeId;
    }

    private static Optional<String> obtainConnectivityNodeId(DanglingLine danglingLine, CgmesExportContext context) {
        return danglingLine.hasProperty("CGMES.ConnectivityNode_Boundary") ? Optional.of(context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)danglingLine, "CGMES.ConnectivityNode_Boundary")) : Optional.empty();
    }

    private static void setDanglingLinesProperty(List<DanglingLine> danglingLineList, String propertyKey, String connectivityNodeId) {
        danglingLineList.forEach(danglingLine -> {
            if (!danglingLine.hasProperty(propertyKey)) {
                danglingLine.setProperty(propertyKey, connectivityNodeId);
            }
        });
    }

    private static void writeDanglingLinesFictitiousContainer(List<DanglingLine> danglingLineList, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        Set topologicalNodeIdSet = danglingLineList.stream().map(EquipmentExport::obtainTopologicalNodeId).flatMap(Optional::stream).collect(Collectors.toSet());
        if (topologicalNodeIdSet.size() > 1) {
            throw new PowsyblException("Paired danglingLines with different topologicalNode on the boundarySide. ParingKey: " + danglingLineList.get(0).getPairingKey());
        }
        if (topologicalNodeIdSet.size() == 1) {
            String topologicalNodeId = (String)topologicalNodeIdSet.iterator().next();
            EquipmentExport.setDanglingLinesProperty(danglingLineList, "CGMES.TopologicalNode_Boundary", topologicalNodeId);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Dangling line(s) not connected to a topology node in boundaries files: a fictitious substation and voltage level are created: {}", (Object)EquipmentExport.danglingLinesId(danglingLineList));
            }
            EquipmentExport.createFictitiousContainerFor(danglingLineList, baseVoltageId, cimNamespace, writer, context);
        }
    }

    private static Optional<String> obtainTopologicalNodeId(DanglingLine danglingLine) {
        return danglingLine.hasProperty("CGMES.TopologicalNode_Boundary") ? Optional.of(danglingLine.getProperty("CGMES.TopologicalNode_Boundary")) : Optional.empty();
    }

    private static String createFictitiousContainerFor(List<DanglingLine> danglingLineList, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        DanglingLine danglingLine = danglingLineList.stream().min(Comparator.comparing(Identifiable::getId)).orElseThrow();
        String substationId = EquipmentExport.writeFictitiousSubstationFor(danglingLine, cimNamespace, writer, context);
        String containerId = EquipmentExport.writeFictitiousVoltageLevelFor(danglingLine, substationId, baseVoltageId, cimNamespace, writer, context);
        danglingLineList.forEach(dl -> context.setFictitiousContainerFor((Identifiable<?>)dl, containerId));
        return containerId;
    }

    private static String danglingLinesId(List<DanglingLine> danglingLineList) {
        ArrayList strings = new ArrayList();
        danglingLineList.forEach(danglingLine -> strings.add(danglingLine.getId()));
        String string = String.join((CharSequence)", ", strings);
        return !danglingLineList.isEmpty() && danglingLineList.get(0).getPairingKey() != null ? string + " linked to X-node " + danglingLineList.get(0).getPairingKey() : string;
    }

    private static String writeFictitiousSubstationFor(Identifiable<?> identifiable, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String baseName = identifiable.getNameOrId();
        String geographicalRegionId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(identifiable), CgmesObjectReference.Part.FICTITIOUS, CgmesObjectReference.Part.GEOGRAPHICAL_REGION);
        GeographicalRegionEq.write(geographicalRegionId, "fictGR_" + baseName, cimNamespace, writer, context);
        String subGeographicalRegionId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(identifiable), CgmesObjectReference.Part.FICTITIOUS, CgmesObjectReference.Part.SUB_GEOGRAPHICAL_REGION);
        SubGeographicalRegionEq.write(subGeographicalRegionId, "fictSGR_" + baseName, geographicalRegionId, cimNamespace, writer, context);
        String substationId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(identifiable), CgmesObjectReference.Part.FICTITIOUS, CgmesObjectReference.Part.SUBSTATION);
        SubstationEq.write(substationId, "fictS_" + baseName, subGeographicalRegionId, cimNamespace, writer, context);
        return substationId;
    }

    private static String writeFictitiousVoltageLevelFor(Identifiable<?> identifiable, String substationId, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String voltageLevelId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(identifiable), CgmesObjectReference.Part.FICTITIOUS, CgmesObjectReference.Part.VOLTAGE_LEVEL);
        VoltageLevelEq.write(voltageLevelId, identifiable.getNameOrId() + "_VL", Double.NaN, Double.NaN, substationId, baseVoltageId, cimNamespace, writer, context);
        return voltageLevelId;
    }

    private static void writeBranchLimits(Branch<?> branch, String terminalId1, String terminalId2, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        ArrayList limitsGroups1 = new ArrayList();
        if (context.isExportAllLimitsGroup()) {
            limitsGroups1.addAll(branch.getOperationalLimitsGroups1());
        } else {
            branch.getSelectedOperationalLimitsGroup1().ifPresent(limitsGroups1::add);
        }
        for (OperationalLimitsGroup limitsGroup : limitsGroups1) {
            EquipmentExport.writeLimitsGroup(branch, limitsGroup, terminalId1, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
        }
        ArrayList limitsGroups2 = new ArrayList();
        if (context.isExportAllLimitsGroup()) {
            limitsGroups2.addAll(branch.getOperationalLimitsGroups2());
        } else {
            branch.getSelectedOperationalLimitsGroup2().ifPresent(limitsGroups2::add);
        }
        for (OperationalLimitsGroup limitsGroup : limitsGroups2) {
            EquipmentExport.writeLimitsGroup(branch, limitsGroup, terminalId2, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
        }
    }

    private static void writeFlowsLimits(Identifiable<?> identifiable, FlowsLimitsHolder holder, String terminalId, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        ArrayList limitsGroups = new ArrayList();
        if (context.isExportAllLimitsGroup()) {
            limitsGroups.addAll(holder.getOperationalLimitsGroups());
        } else {
            holder.getSelectedOperationalLimitsGroup().ifPresent(limitsGroups::add);
        }
        for (OperationalLimitsGroup limitsGroup : limitsGroups) {
            EquipmentExport.writeLimitsGroup(identifiable, limitsGroup, terminalId, cimNamespace, euNamespace, exportedLimitTypes, writer, context);
        }
    }

    private static void writeLimitsGroup(Identifiable<?> identifiable, OperationalLimitsGroup limitsGroup, String terminalId, String cimNamespace, String euNamespace, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        Optional currentLimits;
        Optional apparentPowerLimits;
        String operationalLimitSetName;
        String operationalLimitSetId;
        if (limitsGroup.getCurrentLimits().isEmpty() && context.isCim16BusBranchExport()) {
            return;
        }
        if (identifiable.hasProperty("CGMES.OperationalLimitSet_identifiers")) {
            operationalLimitSetId = limitsGroup.getId();
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode propertyNode = mapper.readTree(identifiable.getProperty("CGMES.OperationalLimitSet_identifiers"));
                JsonNode limitsGroupNode = propertyNode.get(operationalLimitSetId);
                operationalLimitSetName = limitsGroupNode != null ? limitsGroupNode.textValue() : operationalLimitSetId;
            }
            catch (JsonProcessingException e) {
                operationalLimitSetName = operationalLimitSetId;
            }
        } else {
            operationalLimitSetId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(terminalId), CgmesObjectReference.ref(limitsGroup.getId()), CgmesObjectReference.Part.OPERATIONAL_LIMIT_SET);
            operationalLimitSetName = limitsGroup.getId();
        }
        OperationalLimitSetEq.write(operationalLimitSetId, operationalLimitSetName, terminalId, cimNamespace, writer, context);
        Optional activePowerLimits = limitsGroup.getActivePowerLimits();
        if (activePowerLimits.isPresent()) {
            EquipmentExport.writeLoadingLimits((LoadingLimits)activePowerLimits.get(), cimNamespace, euNamespace, operationalLimitSetId, exportedLimitTypes, writer, context);
        }
        if ((apparentPowerLimits = limitsGroup.getApparentPowerLimits()).isPresent()) {
            EquipmentExport.writeLoadingLimits((LoadingLimits)apparentPowerLimits.get(), cimNamespace, euNamespace, operationalLimitSetId, exportedLimitTypes, writer, context);
        }
        if ((currentLimits = limitsGroup.getCurrentLimits()).isPresent()) {
            EquipmentExport.writeLoadingLimits((LoadingLimits)currentLimits.get(), cimNamespace, euNamespace, operationalLimitSetId, exportedLimitTypes, writer, context);
        }
    }

    private static void writeLoadingLimits(LoadingLimits limits, String cimNamespace, String euNamespace, String operationalLimitSetId, Set<String> exportedLimitTypes, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        if (!(limits instanceof CurrentLimits) && context.isCim16BusBranchExport()) {
            return;
        }
        String operationalLimitTypeId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.Part.PATL, CgmesObjectReference.Part.OPERATIONAL_LIMIT_TYPE);
        if (!exportedLimitTypes.contains(operationalLimitTypeId)) {
            OperationalLimitTypeEq.writePatl(operationalLimitTypeId, cimNamespace, euNamespace, writer, context);
            exportedLimitTypes.add(operationalLimitTypeId);
        }
        String className = LoadingLimitEq.loadingLimitClassName(limits);
        String operationalLimitId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(operationalLimitSetId), CgmesObjectReference.ref(className), CgmesObjectReference.Part.PATL, CgmesObjectReference.Part.OPERATIONAL_LIMIT_VALUE);
        LoadingLimitEq.write(operationalLimitId, limits, "PATL", limits.getPermanentLimit(), operationalLimitTypeId, operationalLimitSetId, cimNamespace, writer, context);
        if (!limits.getTemporaryLimits().isEmpty()) {
            for (LoadingLimits.TemporaryLimit temporaryLimit : limits.getTemporaryLimits()) {
                int acceptableDuration = temporaryLimit.getAcceptableDuration();
                operationalLimitTypeId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.Part.TATL, CgmesObjectReference.ref(acceptableDuration), CgmesObjectReference.Part.OPERATIONAL_LIMIT_TYPE);
                if (!exportedLimitTypes.contains(operationalLimitTypeId)) {
                    OperationalLimitTypeEq.writeTatl(operationalLimitTypeId, temporaryLimit.getAcceptableDuration(), cimNamespace, euNamespace, writer, context);
                    exportedLimitTypes.add(operationalLimitTypeId);
                }
                operationalLimitId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(operationalLimitSetId), CgmesObjectReference.ref(className), CgmesObjectReference.Part.TATL, CgmesObjectReference.ref(acceptableDuration), CgmesObjectReference.Part.OPERATIONAL_LIMIT_VALUE);
                LoadingLimitEq.write(operationalLimitId, limits, temporaryLimit.getName(), temporaryLimit.getValue(), operationalLimitTypeId, operationalLimitSetId, cimNamespace, writer, context);
            }
        }
    }

    private static void writeHvdcLines(Network network, Map<Terminal, String> mapTerminal2Id, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        NamingStrategy namingStrategy = context.getNamingStrategy();
        for (HvdcLine line : network.getHvdcLines()) {
            String lineId = context.getNamingStrategy().getCgmesId((Identifiable<?>)line);
            String converter1Id = namingStrategy.getCgmesId((Identifiable<?>)line.getConverterStation1());
            String converter2Id = namingStrategy.getCgmesId((Identifiable<?>)line.getConverterStation2());
            String substation1Id = namingStrategy.getCgmesId((Identifiable<?>)line.getConverterStation1().getTerminal().getVoltageLevel().getNullableSubstation());
            String substation2Id = namingStrategy.getCgmesId((Identifiable<?>)line.getConverterStation2().getTerminal().getVoltageLevel().getNullableSubstation());
            String dcConverterUnit1 = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DC_CONVERTER_UNIT, CgmesObjectReference.ref(1));
            EquipmentExport.writeDCConverterUnit(dcConverterUnit1, line.getNameOrId() + "_1", substation1Id, cimNamespace, writer, context);
            String dcNode1 = (String)line.getAliasFromType("CGMES.DCNode1").orElseThrow(PowsyblException::new);
            EquipmentExport.writeDCNode(dcNode1, line.getNameOrId() + "_1", dcConverterUnit1, cimNamespace, writer, context);
            String dcConverterUnit2 = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DC_CONVERTER_UNIT, CgmesObjectReference.ref(2));
            EquipmentExport.writeDCConverterUnit(dcConverterUnit2, line.getNameOrId() + "_1", substation2Id, cimNamespace, writer, context);
            String dcNode2 = (String)line.getAliasFromType("CGMES.DCNode2").orElseThrow(PowsyblException::new);
            EquipmentExport.writeDCNode(dcNode2, line.getNameOrId() + "_2", dcConverterUnit2, cimNamespace, writer, context);
            String dcTerminal1 = (String)line.getAliasFromType("CGMES.DCTerminal1").orElseThrow(PowsyblException::new);
            EquipmentExport.writeDCTerminal(dcTerminal1, lineId, dcNode1, 1, cimNamespace, writer, context);
            String dcTerminal2 = (String)line.getAliasFromType("CGMES.DCTerminal2").orElseThrow(PowsyblException::new);
            EquipmentExport.writeDCTerminal(dcTerminal2, lineId, dcNode2, 2, cimNamespace, writer, context);
            HvdcConverterStation converter = line.getConverterStation1();
            String terminalId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.refTyped(converter), CgmesObjectReference.Part.CONVERTER_STATION, CgmesObjectReference.ref(1));
            EquipmentExport.writeTerminal(converter.getTerminal(), mapTerminal2Id, terminalId, converter1Id, EquipmentExport.connectivityNodeId(mapNodeKey2NodeId, converter.getTerminal(), context), 1, cimNamespace, writer, context);
            String capabilityCurveId1 = EquipmentExport.writeVsCapabilityCurve(converter, cimNamespace, writer, context);
            String acdcConverterDcTerminal1 = (String)converter.getAliasFromType("CGMES.ACDCConverterDCTerminal").orElseThrow(PowsyblException::new);
            EquipmentExport.writeAcdcConverterDCTerminal(acdcConverterDcTerminal1, converter1Id, dcNode1, 2, cimNamespace, writer, context);
            converter = line.getConverterStation2();
            terminalId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.refTyped(converter), CgmesObjectReference.Part.CONVERTER_STATION, CgmesObjectReference.ref(2));
            EquipmentExport.writeTerminal(converter.getTerminal(), mapTerminal2Id, terminalId, converter2Id, EquipmentExport.connectivityNodeId(mapNodeKey2NodeId, converter.getTerminal(), context), 1, cimNamespace, writer, context);
            String capabilityCurveId2 = EquipmentExport.writeVsCapabilityCurve(converter, cimNamespace, writer, context);
            String acdcConverterDcTerminal2 = (String)converter.getAliasFromType("CGMES.ACDCConverterDCTerminal").orElseThrow(PowsyblException::new);
            EquipmentExport.writeAcdcConverterDCTerminal(acdcConverterDcTerminal2, converter2Id, dcNode2, 2, cimNamespace, writer, context);
            DCLineSegmentEq.write(lineId, line.getNameOrId(), line.getR(), cimNamespace, writer, context);
            EquipmentExport.writeHvdcConverterStation(line.getConverterStation1(), mapTerminal2Id, line.getNominalV(), dcConverterUnit1, capabilityCurveId1, cimNamespace, writer, context);
            EquipmentExport.writeHvdcConverterStation(line.getConverterStation2(), mapTerminal2Id, line.getNominalV(), dcConverterUnit2, capabilityCurveId2, cimNamespace, writer, context);
        }
    }

    private static String writeVsCapabilityCurve(HvdcConverterStation<?> converter, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        if (converter instanceof LccConverterStation) {
            return null;
        }
        VscConverterStation vscConverter = (VscConverterStation)converter;
        if (vscConverter.getReactiveLimits() == null) {
            return null;
        }
        String reactiveLimitsId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(vscConverter), CgmesObjectReference.Part.REACTIVE_CAPABILITY_CURVE);
        switch (vscConverter.getReactiveLimits().getKind()) {
            case CURVE: {
                ReactiveCapabilityCurve curve = (ReactiveCapabilityCurve)vscConverter.getReactiveLimits(ReactiveCapabilityCurve.class);
                int pointIndex = 0;
                for (ReactiveCapabilityCurve.Point point : curve.getPoints()) {
                    String pointId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(vscConverter), CgmesObjectReference.ref(pointIndex), CgmesObjectReference.Part.REACTIVE_CAPABIILITY_CURVE_POINT);
                    CurveDataEq.write(pointId, point.getP(), point.getMinQ(), point.getMaxQ(), reactiveLimitsId, cimNamespace, writer, context);
                    ++pointIndex;
                }
                String reactiveCapabilityCurveName = "RCC_" + vscConverter.getNameOrId();
                ReactiveCapabilityCurveEq.write(reactiveLimitsId, reactiveCapabilityCurveName, (ReactiveLimitsHolder)vscConverter, cimNamespace, writer, context);
                break;
            }
            case MIN_MAX: {
                reactiveLimitsId = null;
                break;
            }
            default: {
                throw new PowsyblException("Unexpected type of ReactiveLimits on the VsConverter " + converter.getNameOrId());
            }
        }
        return reactiveLimitsId;
    }

    private static void writeDCConverterUnit(String id, String dcConverterUnitName, String substationId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        DCConverterUnitEq.write(id, dcConverterUnitName, substationId, cimNamespace, writer, context);
    }

    private static void writeHvdcConverterStation(HvdcConverterStation<?> converterStation, Map<Terminal, String> mapTerminal2Id, double ratedUdc, String dcEquipmentContainerId, String capabilityCurveId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String pccTerminal = EquipmentExport.getConverterStationPccTerminal(converterStation, mapTerminal2Id);
        HvdcConverterStationEq.write(context.getNamingStrategy().getCgmesId((Identifiable<?>)converterStation), converterStation.getNameOrId(), converterStation.getHvdcType(), ratedUdc, dcEquipmentContainerId, pccTerminal, capabilityCurveId, cimNamespace, writer, context);
    }

    private static String getConverterStationPccTerminal(HvdcConverterStation<?> converterStation, Map<Terminal, String> mapTerminal2Id) {
        if (converterStation.getHvdcType().equals((Object)HvdcConverterStation.HvdcType.VSC)) {
            return EquipmentExport.exportedTerminalId(mapTerminal2Id, ((VscConverterStation)converterStation).getRegulatingTerminal());
        }
        return null;
    }

    private static void writeDCNode(String id, String dcNodeName, String dcEquipmentContainerId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        DCNodeEq.write(id, dcNodeName, dcEquipmentContainerId, cimNamespace, writer, context);
    }

    private static void writeDCTerminal(String id, String conductingEquipmentId, String dcNodeId, int sequenceNumber, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        DCTerminalEq.write("DCTerminal", id, conductingEquipmentId, dcNodeId, sequenceNumber, cimNamespace, writer, context);
    }

    private static void writeAcdcConverterDCTerminal(String id, String conductingEquipmentId, String dcNodeId, int sequenceNumber, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        DCTerminalEq.write(AC_DC_CONVERTER_DC_TERMINAL, id, conductingEquipmentId, dcNodeId, sequenceNumber, cimNamespace, writer, context);
    }

    private static void writeControlAreas(String energyAreaId, Network network, String cimNamespace, String euNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        long numControlAreas = network.getAreaStream().filter(a -> a.getAreaType().equals("ControlAreaTypeKind.Interchange")).count();
        int numSubnetworks = network.getSubnetworks().size();
        if (numControlAreas == 0L && numSubnetworks == 0) {
            LOG.warn("No control area of type interchange is being exported");
        }
        for (Area area : network.getAreas()) {
            if (!area.getAreaType().equals("ControlAreaTypeKind.Interchange")) continue;
            EquipmentExport.writeControlArea(area, energyAreaId, cimNamespace, euNamespace, writer, context);
        }
    }

    private static void writeControlArea(Area controlArea, String energyAreaId, String cimNamespace, String euNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String controlAreaCgmesId = context.getNamingStrategy().getCgmesId(controlArea.getId());
        String energyIdentCodeEic = controlArea.getAliasFromType("energyIdentCodeEic").orElse("");
        ControlAreaEq.write(controlAreaCgmesId, controlArea.getNameOrId(), energyIdentCodeEic, energyAreaId, cimNamespace, euNamespace, writer, context);
        for (AreaBoundary areaBoundary : controlArea.getAreaBoundaries()) {
            Optional<TieFlow> tieFlow = TieFlow.from(areaBoundary, context);
            if (!tieFlow.isPresent()) continue;
            TieFlowEq.write(tieFlow.get().id(), controlAreaCgmesId, tieFlow.get().terminalId(), cimNamespace, writer, context);
        }
    }

    private static String getTieFlowBoundaryTerminal(Boundary boundary, CgmesExportContext context) {
        DanglingLine dl = boundary.getDanglingLine();
        return context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)dl, "CGMES.Terminal_Boundary");
    }

    private static void writeTerminals(Network network, Map<Terminal, String> mapTerminal2Id, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Connectable c : network.getConnectables()) {
            if (!context.isExportedEquipment((Identifiable<?>)c)) continue;
            for (Terminal t : c.getTerminals()) {
                EquipmentExport.writeTerminal(t, mapTerminal2Id, mapNodeKey2NodeId, cimNamespace, writer, context);
            }
        }
        String[] switchNodesKeys = new String[2];
        for (Switch sw : network.getSwitches()) {
            if (!context.isExportedEquipment((Identifiable<?>)sw)) continue;
            VoltageLevel vl = sw.getVoltageLevel();
            EquipmentExport.fillSwitchNodeKeys(vl, sw, switchNodesKeys, context);
            String nodeId1 = mapNodeKey2NodeId.get(switchNodesKeys[0]);
            String terminalId1 = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)sw, "CGMES.Terminal1");
            TerminalEq.write(terminalId1, context.getNamingStrategy().getCgmesId((Identifiable<?>)sw), nodeId1, 1, cimNamespace, writer, context);
            String nodeId2 = mapNodeKey2NodeId.get(switchNodesKeys[1]);
            String terminalId2 = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)sw, "CGMES.Terminal2");
            TerminalEq.write(terminalId2, context.getNamingStrategy().getCgmesId((Identifiable<?>)sw), nodeId2, 2, cimNamespace, writer, context);
        }
    }

    private static void writeTerminal(Terminal t, Map<Terminal, String> mapTerminal2Id, Map<String, String> mapNodeKey2NodeId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        String equipmentId = context.getNamingStrategy().getCgmesId((Identifiable<?>)t.getConnectable());
        EquipmentExport.writeTerminal(t, mapTerminal2Id, CgmesExportUtil.getTerminalId(t, context), equipmentId, EquipmentExport.connectivityNodeId(mapNodeKey2NodeId, t, context), CgmesExportUtil.getTerminalSequenceNumber(t), cimNamespace, writer, context);
    }

    private static void writeTerminal(Terminal terminal, Map<Terminal, String> mapTerminal2Id, String id, String conductingEquipmentId, String connectivityNodeId, int sequenceNumber, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        mapTerminal2Id.computeIfAbsent(terminal, k -> {
            try {
                TerminalEq.write(id, conductingEquipmentId, connectivityNodeId, sequenceNumber, cimNamespace, writer, context);
                return id;
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
    }

    private static String exportedTerminalId(Map<Terminal, String> mapTerminal2Id, Terminal terminal) {
        if (mapTerminal2Id.containsKey(terminal)) {
            return mapTerminal2Id.get(terminal);
        }
        throw new PowsyblException("Terminal has not been exported");
    }

    private static String connectivityNodeId(Map<String, String> mapNodeKey2NodeId, Terminal terminal, CgmesExportContext context) {
        String key = terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER && !context.isBusBranchExport() ? EquipmentExport.buildNodeKey(terminal.getVoltageLevel(), terminal.getNodeBreakerView().getNode()) : EquipmentExport.buildNodeKey(terminal.getBusBreakerView().getConnectableBus());
        return mapNodeKey2NodeId.get(key);
    }

    private EquipmentExport() {
    }

    private static class VoltageLevelAdjacency {
        private final List<List<Integer>> voltageLevelNodes = new ArrayList<List<Integer>>();

        VoltageLevelAdjacency(VoltageLevel vl, CgmesExportContext context) {
            NodeAdjacency adjacency = new NodeAdjacency(vl, context);
            HashSet visitedNodes = new HashSet();
            adjacency.get().keySet().forEach(node -> {
                if (visitedNodes.contains(node)) {
                    return;
                }
                List<Integer> adjacentNodes = this.computeAdjacentNodes((int)node, adjacency, visitedNodes);
                this.voltageLevelNodes.add(adjacentNodes);
            });
        }

        private List<Integer> computeAdjacentNodes(int nodeId, NodeAdjacency adjacency, Set<Integer> visitedNodes) {
            ArrayList<Integer> adjacentNodes = new ArrayList<Integer>();
            adjacentNodes.add(nodeId);
            visitedNodes.add(nodeId);
            for (int k = 0; k < adjacentNodes.size(); ++k) {
                Integer node = (Integer)adjacentNodes.get(k);
                if (!adjacency.get().containsKey(node)) continue;
                adjacency.get().get(node).forEach(adjacent -> {
                    if (visitedNodes.contains(adjacent)) {
                        return;
                    }
                    adjacentNodes.add((Integer)adjacent);
                    visitedNodes.add((Integer)adjacent);
                });
            }
            return adjacentNodes;
        }

        List<List<Integer>> getNodes() {
            return this.voltageLevelNodes;
        }
    }

    private static class EndNumberAssignerForTwoWindingsTransformer
    extends EndNumberAssigner {
        private final TwoWindingsTransformer twt;
        private final boolean sorted;

        EndNumberAssignerForTwoWindingsTransformer(TwoWindingsTransformer twt, boolean sorted) {
            super(twt.getTerminal1().getVoltageLevel().getNominalV(), twt.getTerminal2().getVoltageLevel().getNominalV());
            this.twt = twt;
            this.sorted = sorted;
        }

        private int getEndNumberForSide1() {
            return this.sorted ? this.get(this.twt.getTerminal1().getVoltageLevel().getNominalV(), 1) : 1;
        }

        private int getEndNumberForSide2() {
            return this.sorted ? this.get(this.twt.getTerminal2().getVoltageLevel().getNominalV(), 2) : 2;
        }
    }

    private static final class PowerTransformerEndsParameters {
        private final int endNumberForSide1;
        private final TwoWindingsTransformer twt;
        private final double a02;

        private PowerTransformerEndsParameters(TwoWindingsTransformer twt, int endNumberForSide1) {
            this.twt = twt;
            this.endNumberForSide1 = endNumberForSide1;
            double a0 = twt.getRatedU1() / twt.getRatedU2();
            this.a02 = a0 * a0;
        }

        private double getEnd1R() {
            return this.endNumberForSide1 == 1 ? this.twt.getR() * this.a02 : 0.0;
        }

        private double getEnd1X() {
            return this.endNumberForSide1 == 1 ? this.twt.getX() * this.a02 : 0.0;
        }

        private double getEnd1G() {
            return this.endNumberForSide1 == 1 ? this.twt.getG() / this.a02 : 0.0;
        }

        private double getEnd1B() {
            return this.endNumberForSide1 == 1 ? this.twt.getB() / this.a02 : 0.0;
        }

        private double getEnd2R() {
            return this.endNumberForSide1 == 1 ? 0.0 : this.twt.getR();
        }

        private double getEnd2X() {
            return this.endNumberForSide1 == 1 ? 0.0 : this.twt.getX();
        }

        private double getEnd2G() {
            return this.endNumberForSide1 == 1 ? 0.0 : this.twt.getG();
        }

        private double getEnd2B() {
            return this.endNumberForSide1 == 1 ? 0.0 : this.twt.getB();
        }
    }

    private static class EndNumberAssignerForThreeWindingsTransformer
    extends EndNumberAssigner {
        private final ThreeWindingsTransformer twt;
        private final boolean sorted;

        EndNumberAssignerForThreeWindingsTransformer(ThreeWindingsTransformer twt, boolean sorted) {
            super(twt.getLeg1().getTerminal().getVoltageLevel().getNominalV(), twt.getLeg2().getTerminal().getVoltageLevel().getNominalV(), twt.getLeg3().getTerminal().getVoltageLevel().getNominalV());
            this.twt = twt;
            this.sorted = sorted;
        }

        private int getEndNumberForLeg1() {
            return this.sorted ? this.get(this.twt.getLeg1().getTerminal().getVoltageLevel().getNominalV(), 1) : 1;
        }

        private int getEndNumberForLeg2() {
            return this.sorted ? this.get(this.twt.getLeg2().getTerminal().getVoltageLevel().getNominalV(), 2) : 2;
        }

        private int getEndNumberForLeg3() {
            return this.sorted ? this.get(this.twt.getLeg3().getTerminal().getVoltageLevel().getNominalV(), 3) : 3;
        }
    }

    private record TieFlow(String id, String terminalId) {
        static Optional<TieFlow> from(AreaBoundary areaBoundary, CgmesExportContext context) {
            return areaBoundary.getTerminal().map(terminal -> TieFlow.from(terminal, context)).orElseGet(() -> areaBoundary.getBoundary().flatMap(boundary -> TieFlow.from(boundary, context)));
        }

        static Optional<TieFlow> from(Terminal terminal, CgmesExportContext context) {
            return Optional.of(new TieFlow(context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(terminal.getConnectable()), CgmesObjectReference.Part.TIE_FLOW), CgmesExportUtil.getTerminalId(terminal, context)));
        }

        static Optional<TieFlow> from(Boundary boundary, CgmesExportContext context) {
            String terminalId = EquipmentExport.getTieFlowBoundaryTerminal(boundary, context);
            if (terminalId != null) {
                return Optional.of(new TieFlow(context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(terminalId), CgmesObjectReference.Part.TIE_FLOW), terminalId));
            }
            return Optional.empty();
        }
    }

    private static class NodeAdjacency {
        private final Map<Integer, List<Integer>> adjacency = new HashMap<Integer, List<Integer>>();

        NodeAdjacency(VoltageLevel vl, CgmesExportContext context) {
            if (vl.getTopologyKind().equals((Object)TopologyKind.NODE_BREAKER)) {
                vl.getNodeBreakerView().getInternalConnections().forEach(this::addAdjacency);
                vl.getNodeBreakerView().getSwitchStream().filter(Objects::nonNull).filter(sw -> !context.isExportedEquipment((Identifiable<?>)sw)).forEach(this::addAdjacency);
            }
        }

        private void addAdjacency(VoltageLevel.NodeBreakerView.InternalConnection ic) {
            this.addAdjacency(ic.getNode1(), ic.getNode2());
        }

        private void addAdjacency(Switch sw) {
            this.addAdjacency(sw.getVoltageLevel().getNodeBreakerView().getNode1(sw.getId()), sw.getVoltageLevel().getNodeBreakerView().getNode2(sw.getId()));
        }

        private void addAdjacency(int node1, int node2) {
            this.adjacency.computeIfAbsent(node1, k -> new ArrayList()).add(node2);
            this.adjacency.computeIfAbsent(node2, k -> new ArrayList()).add(node1);
        }

        Map<Integer, List<Integer>> get() {
            return this.adjacency;
        }
    }

    private static class EndNumberAssigner {
        private final List<Pair<Double, Integer>> sortedNominalVoltagesSide = new ArrayList<Pair<Double, Integer>>();

        EndNumberAssigner(double ... nominalVoltagesSortedBySide) {
            for (int k = 0; k < nominalVoltagesSortedBySide.length; ++k) {
                this.sortedNominalVoltagesSide.add((Pair<Double, Integer>)Pair.of((Object)nominalVoltagesSortedBySide[k], (Object)(k + 1)));
            }
            this.sortedNominalVoltagesSide.sort((o1, o2) -> {
                if ((Double)o1.getLeft() > (Double)o2.getLeft()) {
                    return -1;
                }
                if (((Double)o1.getLeft()).equals(o2.getLeft())) {
                    return Integer.compare((Integer)o1.getRight(), (Integer)o2.getRight());
                }
                return 1;
            });
        }

        int get(double nominalV, int side) {
            return this.sortedNominalVoltagesSide.indexOf(Pair.of((Object)nominalV, (Object)side)) + 1;
        }
    }
}

