/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.naming;

import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.iidm.network.Identifiable;

public interface NamingStrategy {
    public String getName();

    public String getIidmId(String var1, String var2);

    public String getIidmName(String var1, String var2);

    public String getCgmesId(Identifiable<?> var1);

    default public String getCgmesIdFromAlias(Identifiable<?> identifiable, String aliasType) {
        return (String)identifiable.getAliasFromType(aliasType).orElseThrow(() -> new PowsyblException("Missing alias " + aliasType + " in " + identifiable.getId()));
    }

    default public String getCgmesIdFromProperty(Identifiable<?> identifiable, String propertyName) {
        return identifiable.getProperty(propertyName);
    }

    default public String getCgmesId(String identifier) {
        return identifier;
    }

    public void debug(String var1, DataSource var2);

    public String getCgmesId(CgmesObjectReference ... var1);

    public static final class Identity
    implements NamingStrategy {
        @Override
        public String getName() {
            return "identity";
        }

        @Override
        public String getIidmId(String type, String id) {
            return id;
        }

        @Override
        public String getCgmesId(Identifiable<?> identifiable) {
            return identifiable.getId();
        }

        @Override
        public String getIidmName(String type, String name) {
            return name;
        }

        @Override
        public void debug(String baseName, DataSource ds) {
        }

        @Override
        public String getCgmesId(CgmesObjectReference ... refs) {
            return CgmesObjectReference.combine(refs);
        }
    }
}

