/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.ACLineSegmentConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentBranchConversion;
import com.powsybl.cgmes.conversion.elements.SwitchConversion;
import com.powsybl.cgmes.conversion.elements.transformers.TwoWindingsTransformerConversion;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoundaryEquipment {
    private final BoundaryEquipmentType type;
    private final PropertyBags propertyBags = new PropertyBags();
    private static final Logger LOG = LoggerFactory.getLogger(BoundaryEquipment.class);

    BoundaryEquipment(BoundaryEquipmentType type, PropertyBag propertyBag) {
        this.type = type;
        this.propertyBags.add((Object)propertyBag);
    }

    BoundaryEquipment(BoundaryEquipmentType type, PropertyBags propertyBags) {
        this.type = type;
        this.propertyBags.addAll((Collection)propertyBags);
    }

    EquipmentAtBoundaryConversion createConversion(Context context) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ACLineSegmentConversion((PropertyBag)this.propertyBags.get(0), context);
            case 1 -> new SwitchConversion((PropertyBag)this.propertyBags.get(0), context);
            case 2 -> new TwoWindingsTransformerConversion(this.propertyBags, context);
            case 3 -> new EquivalentBranchConversion((PropertyBag)this.propertyBags.get(0), context);
        };
    }

    boolean isAcLineSegmentDisconnected(Context context) {
        if (this.type == BoundaryEquipmentType.AC_LINE_SEGMENT) {
            return !new ACLineSegmentConversion((PropertyBag)this.propertyBags.get(0), context).isConnectedAtBothEnds();
        }
        return false;
    }

    String getAcLineSegmentId() {
        if (this.type == BoundaryEquipmentType.AC_LINE_SEGMENT) {
            return ((PropertyBag)this.propertyBags.get(0)).getId("ACLineSegment");
        }
        return null;
    }

    void log() {
        if (LOG.isTraceEnabled()) {
            String title = "BoundaryEquipment " + this.type.toString();
            if (this.propertyBags.size() == 1) {
                LOG.trace(((PropertyBag)this.propertyBags.get(0)).tabulateLocals(title));
            } else {
                this.propertyBags.forEach(p -> LOG.trace(p.tabulateLocals(title)));
            }
        }
    }

    static enum BoundaryEquipmentType {
        AC_LINE_SEGMENT,
        SWITCH,
        TRANSFORMER,
        EQUIVALENT_BRANCH;

    }
}

