/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.conversion.CgmesBoundary;
import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.conversion.export.EquipmentExport;
import com.powsybl.cgmes.conversion.export.ReferenceDataProvider;
import com.powsybl.cgmes.conversion.export.StateVariablesExport;
import com.powsybl.cgmes.conversion.export.SteadyStateHypothesisExport;
import com.powsybl.cgmes.conversion.export.TopologyExport;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.conversion.naming.NamingStrategyFactory;
import com.powsybl.cgmes.extensions.CgmesMetadataModels;
import com.powsybl.cgmes.extensions.CgmesTopologyKind;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesMetadataModelImpl;
import com.powsybl.cgmes.model.CgmesNamespace;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.parameters.ConfiguredParameter;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBags;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Exporter.class})
public class CgmesExport
implements Exporter {
    private final ParameterDefaultValueConfig defaultValueConfig;
    private final CgmesImport importer;
    public static final String BASE_NAME = "iidm.export.cgmes.base-name";
    public static final String BOUNDARY_EQ_ID = "iidm.export.cgmes.boundary-EQ-identifier";
    public static final String BOUNDARY_TP_ID = "iidm.export.cgmes.boundary-TP-identifier";
    public static final String CIM_VERSION = "iidm.export.cgmes.cim-version";
    private static final String ENCODE_IDS = "iidm.export.cgmes.encode-ids";
    public static final String EXPORT_BOUNDARY_POWER_FLOWS = "iidm.export.cgmes.export-boundary-power-flows";
    public static final String EXPORT_POWER_FLOWS_FOR_SWITCHES = "iidm.export.cgmes.export-power-flows-for-switches";
    public static final String NAMING_STRATEGY = "iidm.export.cgmes.naming-strategy";
    public static final String PROFILES = "iidm.export.cgmes.profiles";
    public static final String TOPOLOGY_KIND = "iidm.export.cgmes.topology-kind";
    public static final String CGM_EXPORT = "iidm.export.cgmes.cgm_export";
    public static final String MODELING_AUTHORITY_SET = "iidm.export.cgmes.modeling-authority-set";
    public static final String MODEL_DESCRIPTION = "iidm.export.cgmes.model-description";
    public static final String EXPORT_TRANSFORMERS_WITH_HIGHEST_VOLTAGE_AT_END1 = "iidm.export.cgmes.export-transformers-with-highest-voltage-at-end1";
    public static final String EXPORT_LOAD_FLOW_STATUS = "iidm.export.cgmes.export-load-flow-status";
    public static final String EXPORT_ALL_LIMITS_GROUP = "iidm.export.cgmes.export-all-limits-group";
    public static final String EXPORT_GENERATORS_IN_LOCAL_REGULATION_MODE = "iidm.export.cgmes.export-generators-in-local-regulation-mode";
    public static final String MAX_P_MISMATCH_CONVERGED = "iidm.export.cgmes.max-p-mismatch-converged";
    public static final String MAX_Q_MISMATCH_CONVERGED = "iidm.export.cgmes.max-q-mismatch-converged";
    public static final String EXPORT_SV_INJECTIONS_FOR_SLACKS = "iidm.export.cgmes.export-sv-injections-for-slacks";
    public static final String SOURCING_ACTOR = "iidm.export.cgmes.sourcing-actor";
    public static final String UUID_NAMESPACE = "iidm.export.cgmes.uuid-namespace";
    public static final String MODEL_VERSION = "iidm.export.cgmes.model-version";
    public static final String BUSINESS_PROCESS = "iidm.export.cgmes.business-process";
    public static final String UPDATE_DEPENDENCIES = "iidm.export.cgmes.update-dependencies";
    private static final Parameter BASE_NAME_PARAMETER = new Parameter("iidm.export.cgmes.base-name", ParameterType.STRING, "Basename for output files", null);
    private static final Parameter CIM_VERSION_PARAMETER = new Parameter("iidm.export.cgmes.cim-version", ParameterType.STRING, "CIM version to export", null, CgmesNamespace.CIM_LIST.stream().map(cim -> Integer.toString(cim.getVersion())).collect(Collectors.toList()));
    private static final Parameter ENCODE_IDS_PARAMETERS = new Parameter("iidm.export.cgmes.encode-ids", ParameterType.BOOLEAN, "Encode IDs as valid URI", (Object)true);
    private static final Parameter EXPORT_BOUNDARY_POWER_FLOWS_PARAMETER = new Parameter("iidm.export.cgmes.export-boundary-power-flows", ParameterType.BOOLEAN, "Export boundaries' power flows", (Object)true);
    private static final Parameter EXPORT_POWER_FLOWS_FOR_SWITCHES_PARAMETER = new Parameter("iidm.export.cgmes.export-power-flows-for-switches", ParameterType.BOOLEAN, "Export power flows for switches", (Object)true);
    private static final Parameter NAMING_STRATEGY_PARAMETER = new Parameter("iidm.export.cgmes.naming-strategy", ParameterType.STRING, "Configure what type of naming strategy you want", (Object)"identity");
    private static final Parameter PROFILES_PARAMETER = new Parameter("iidm.export.cgmes.profiles", ParameterType.STRING_LIST, "Profiles to export", List.of("EQ", "TP", "SSH", "SV"), List.of("EQ", "TP", "SSH", "SV"));
    private static final Parameter TOPOLOGY_KIND_PARAMETER = new Parameter("iidm.export.cgmes.topology-kind", ParameterType.STRING, "Force the topology kind for the export (disable automatic detection)", null, List.of(CgmesTopologyKind.NODE_BREAKER.name(), CgmesTopologyKind.BUS_BRANCH.name()));
    private static final Parameter CGM_EXPORT_PARAMETER = new Parameter("iidm.export.cgmes.cgm_export", ParameterType.BOOLEAN, "True for a CGM export, False for an IGM export", (Object)false);
    private static final Parameter BOUNDARY_EQ_ID_PARAMETER = new Parameter("iidm.export.cgmes.boundary-EQ-identifier", ParameterType.STRING, "Boundary EQ model identifier", null);
    private static final Parameter BOUNDARY_TP_ID_PARAMETER = new Parameter("iidm.export.cgmes.boundary-TP-identifier", ParameterType.STRING, "Boundary TP model identifier", null);
    private static final Parameter MODELING_AUTHORITY_SET_PARAMETER = new Parameter("iidm.export.cgmes.modeling-authority-set", ParameterType.STRING, "Modeling authority set", null);
    private static final Parameter MODEL_DESCRIPTION_PARAMETER = new Parameter("iidm.export.cgmes.model-description", ParameterType.STRING, "Model description", null);
    private static final Parameter SOURCING_ACTOR_PARAMETER = new Parameter("iidm.export.cgmes.sourcing-actor", ParameterType.STRING, "Sourcing actor name (for CGM business processes)", null);
    private static final Parameter EXPORT_TRANSFORMERS_WITH_HIGHEST_VOLTAGE_AT_END1_PARAMETER = new Parameter("iidm.export.cgmes.export-transformers-with-highest-voltage-at-end1", ParameterType.BOOLEAN, "Export transformers with highest voltage at end1", (Object)false);
    private static final Parameter EXPORT_LOAD_FLOW_STATUS_PARAMETER = new Parameter("iidm.export.cgmes.export-load-flow-status", ParameterType.BOOLEAN, "Export load flow status of topological islands", (Object)true);
    private static final Parameter EXPORT_ALL_LIMITS_GROUP_PARAMETER = new Parameter("iidm.export.cgmes.export-all-limits-group", ParameterType.BOOLEAN, "True to export all OperationalLimitsGroup, False to export only the selected group", (Object)true);
    private static final Parameter EXPORT_GENERATORS_IN_LOCAL_REGULATION_MODE_PARAMETER = new Parameter("iidm.export.cgmes.export-generators-in-local-regulation-mode", ParameterType.BOOLEAN, "True to export voltage regulating generators in local regulation mode, False to keep their regulation mode unchanged.", (Object)false);
    private static final Parameter MAX_P_MISMATCH_CONVERGED_PARAMETER = new Parameter("iidm.export.cgmes.max-p-mismatch-converged", ParameterType.DOUBLE, "Max mismatch in active power to consider a bus converged when exporting load flow status of topological islands", (Object)0.1);
    private static final Parameter MAX_Q_MISMATCH_CONVERGED_PARAMETER = new Parameter("iidm.export.cgmes.max-q-mismatch-converged", ParameterType.DOUBLE, "Max mismatch in reactive power to consider a bus converged when exporting load flow status of topological islands", (Object)0.1);
    private static final Parameter EXPORT_SV_INJECTIONS_FOR_SLACKS_PARAMETER = new Parameter("iidm.export.cgmes.export-sv-injections-for-slacks", ParameterType.BOOLEAN, "Export SvInjections with the mismatch of slack buses", (Object)true);
    private static final Parameter UUID_NAMESPACE_PARAMETER = new Parameter("iidm.export.cgmes.uuid-namespace", ParameterType.STRING, "Namespace to use for name-based UUID generation. It must be a valid UUID itself", (Object)CgmesExportContext.DEFAULT_UUID_NAMESPACE.toString());
    private static final Parameter MODEL_VERSION_PARAMETER = new Parameter("iidm.export.cgmes.model-version", ParameterType.STRING, "Model version", null);
    private static final Parameter BUSINESS_PROCESS_PARAMETER = new Parameter("iidm.export.cgmes.business-process", ParameterType.STRING, "Business process", (Object)"1D");
    private static final Parameter UPDATE_DEPENDENCIES_PARAMETER = new Parameter("iidm.export.cgmes.update-dependencies", ParameterType.BOOLEAN, "True if dependencies should be updated automatically. False if the user has already put them in the extension for metadata models", (Object)true);
    private static final List<Parameter> STATIC_PARAMETERS = List.of(BASE_NAME_PARAMETER, CIM_VERSION_PARAMETER, EXPORT_BOUNDARY_POWER_FLOWS_PARAMETER, EXPORT_POWER_FLOWS_FOR_SWITCHES_PARAMETER, NAMING_STRATEGY_PARAMETER, PROFILES_PARAMETER, CGM_EXPORT_PARAMETER, BOUNDARY_EQ_ID_PARAMETER, BOUNDARY_TP_ID_PARAMETER, MODELING_AUTHORITY_SET_PARAMETER, MODEL_DESCRIPTION_PARAMETER, EXPORT_TRANSFORMERS_WITH_HIGHEST_VOLTAGE_AT_END1_PARAMETER, SOURCING_ACTOR_PARAMETER, EXPORT_LOAD_FLOW_STATUS_PARAMETER, MAX_P_MISMATCH_CONVERGED_PARAMETER, MAX_Q_MISMATCH_CONVERGED_PARAMETER, EXPORT_SV_INJECTIONS_FOR_SLACKS_PARAMETER, UUID_NAMESPACE_PARAMETER, MODEL_VERSION_PARAMETER, BUSINESS_PROCESS_PARAMETER, UPDATE_DEPENDENCIES_PARAMETER);
    private static final Logger LOG = LoggerFactory.getLogger(CgmesExport.class);

    public CgmesExport(PlatformConfig platformConfig) {
        this.defaultValueConfig = new ParameterDefaultValueConfig(platformConfig);
        this.importer = new CgmesImport(platformConfig);
    }

    public CgmesExport() {
        this(PlatformConfig.defaultConfig());
    }

    public List<Parameter> getParameters() {
        return ConfiguredParameter.load(STATIC_PARAMETERS, (String)this.getFormat(), (ParameterDefaultValueConfig)this.defaultValueConfig);
    }

    public void export(Network network, Properties parameters, DataSource dataSource, ReportNode reportNode) {
        Objects.requireNonNull(network);
        CgmesExportContext context = this.createContext(network, parameters, reportNode);
        if (Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)CGM_EXPORT_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)) {
            this.exportCGM(network, dataSource, context);
        } else {
            this.exportIGM(network, dataSource, context);
        }
    }

    public void createDefaultControlAreaInterchange(Network network) {
        this.createDefaultControlAreaInterchange(network, null);
    }

    public void createDefaultControlAreaInterchange(Network network, Properties parameters) {
        Objects.requireNonNull(network);
        CgmesExportContext context = this.createContext(network, parameters, ReportNode.NO_OP);
        String controlAreaId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(network), CgmesObjectReference.Part.CONTROL_AREA);
        Area area = ((AreaAdder)((AreaAdder)network.newArea().setAreaType("ControlAreaTypeKind.Interchange").setId(controlAreaId)).setName("Network")).add();
        ReferenceDataProvider referenceDataProvider = context.getReferenceDataProvider();
        if (referenceDataProvider != null && referenceDataProvider.getSourcingActor().containsKey((Object)"energyIdentCodeEic")) {
            area.addAlias((String)referenceDataProvider.getSourcingActor().get((Object)"energyIdentCodeEic"), "energyIdentCodeEic");
        }
        double currentInterchange = 0.0;
        Set<String> boundaryDcNodes = this.getBoundaryDcNodes(referenceDataProvider);
        for (DanglingLine danglingLine : CgmesExportUtil.getBoundaryDanglingLines(network)) {
            area.newAreaBoundary().setAc(this.isAcBoundary(danglingLine, boundaryDcNodes)).setBoundary(danglingLine.getBoundary()).add();
            currentInterchange += danglingLine.getBoundary().getP();
        }
        area.setInterchangeTarget(currentInterchange);
    }

    private CgmesExportContext createContext(Network network, Properties parameters, ReportNode reportNode) {
        String sourcingActorName = Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)SOURCING_ACTOR_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
        String countryName = CgmesExport.getCountry(network);
        ReferenceDataProvider referenceDataProvider = new ReferenceDataProvider(sourcingActorName, countryName, this.importer, parameters);
        String namingStrategyImpl = Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)NAMING_STRATEGY_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig);
        UUID uuidNamespace = UUID.fromString(Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)UUID_NAMESPACE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig));
        NamingStrategy namingStrategy = NamingStrategyFactory.create(namingStrategyImpl, uuidNamespace);
        ExportParameters exportParameters = this.readExportParameters(parameters);
        return new CgmesExportContext(network, referenceDataProvider, namingStrategy, reportNode, exportParameters);
    }

    private Set<String> getBoundaryDcNodes(ReferenceDataProvider referenceDataProvider) {
        if (referenceDataProvider == null) {
            return Collections.emptySet();
        }
        PropertyBags boundaryNodes = referenceDataProvider.getBoundaryNodes();
        if (boundaryNodes == null) {
            return Collections.emptySet();
        }
        return boundaryNodes.stream().filter(CgmesBoundary::isDcNode).map(node -> {
            ArrayList<String> nodeIds = new ArrayList<String>();
            nodeIds.add(node.getId("ConnectivityNode"));
            if (node.containsKey((Object)"TopologicalNode")) {
                nodeIds.add(node.getId("TopologicalNode"));
            }
            return nodeIds;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean isAcBoundary(DanglingLine danglingLine, Set<String> boundaryDcNodes) {
        String dlBoundaryNode = Conversion.getDanglingLineBoundaryNode(danglingLine);
        if (dlBoundaryNode != null) {
            return !boundaryDcNodes.contains(dlBoundaryNode);
        }
        return true;
    }

    private void exportCGM(Network network, DataSource dataSource, CgmesExportContext context) {
        this.checkCgmConsistency(network, context);
        HashMap<Network, Object> igmModels = new HashMap<Network, Object>();
        for (Network subnetwork : network.getSubnetworks()) {
            IgmModelsForCgm igmModelsForCgm = new IgmModelsForCgm(CgmesExport.initializeModelForExport(subnetwork, CgmesSubset.STEADY_STATE_HYPOTHESIS, context, false, true), CgmesExport.initializeModelForExport(subnetwork, CgmesSubset.EQUIPMENT, context, false, false), CgmesExport.initializeModelForExport(subnetwork, CgmesSubset.STEADY_STATE_HYPOTHESIS, context, false, false), CgmesExport.initializeModelForExport(subnetwork, CgmesSubset.TOPOLOGY, context, false, false), CgmesExport.initializeModelForExport(subnetwork, CgmesSubset.TOPOLOGY_BOUNDARY, context, false, false));
            igmModels.put(subnetwork, igmModelsForCgm);
        }
        CgmesMetadataModel updatedCgmSvModel = CgmesExport.initializeModelForExport(network, CgmesSubset.STATE_VARIABLES, context, true, true);
        if (context.updateDependencies()) {
            this.updateDependenciesCGM(igmModels.values(), updatedCgmSvModel, context.getBoundaryTpId());
        }
        String baseName = this.getBaseName(context, dataSource, network);
        for (Network subnetwork : network.getSubnetworks()) {
            context.addIidmMappings(subnetwork);
            String country = CgmesExport.getCountry(subnetwork);
            String igmName = country != null ? country : subnetwork.getNameOrId();
            String igmSshFileName = baseName + "_" + igmName + "_" + CgmesSubset.STEADY_STATE_HYPOTHESIS.getIdentifier() + ".xml";
            this.subsetExport(subnetwork, CgmesSubset.STEADY_STATE_HYPOTHESIS, igmSshFileName, dataSource, context, ((IgmModelsForCgm)igmModels.get((Object)subnetwork)).updatedSsh);
        }
        String cgmSvFileName = baseName + "_" + CgmesSubset.STATE_VARIABLES.getIdentifier() + ".xml";
        this.subsetExport(network, CgmesSubset.STATE_VARIABLES, cgmSvFileName, dataSource, context, updatedCgmSvModel);
    }

    private void exportIGM(Network network, DataSource dataSource, CgmesExportContext context) {
        List<CgmesSubset> requestedSubsets = Arrays.stream(CgmesSubset.values()).filter(s -> context.getProfiles().contains(s.getIdentifier())).toList();
        this.checkIgmConsistency(requestedSubsets, network, context);
        EnumMap<CgmesSubset, CgmesMetadataModel> subsetModels = new EnumMap<CgmesSubset, CgmesMetadataModel>(CgmesSubset.class);
        for (CgmesSubset exportableSubset : List.of(CgmesSubset.EQUIPMENT, CgmesSubset.TOPOLOGY, CgmesSubset.STEADY_STATE_HYPOTHESIS, CgmesSubset.STATE_VARIABLES)) {
            CgmesMetadataModel subsetModel = CgmesExport.initializeModelForExport(network, exportableSubset, context, true, false);
            subsetModels.put(exportableSubset, subsetModel);
        }
        if (context.updateDependencies()) {
            this.updateDependenciesIGM(subsetModels, context.getBoundaryEqId(), context.getBoundaryTpId());
        }
        context.setExportEquipment(requestedSubsets.contains(CgmesSubset.EQUIPMENT));
        String baseName = this.getBaseName(context, dataSource, network);
        for (CgmesSubset subset : requestedSubsets) {
            String fileName = baseName + "_" + subset.getIdentifier() + ".xml";
            this.subsetExport(network, subset, fileName, dataSource, context, (CgmesMetadataModel)subsetModels.get(subset));
        }
        context.getNamingStrategy().debug(baseName, dataSource);
    }

    public static CgmesMetadataModel initializeModelForExport(Network network, CgmesSubset subset, CgmesExportContext context, boolean mainNetwork, boolean modelUpdate) {
        CgmesMetadataModelImpl modelForExport = new CgmesMetadataModelImpl(subset, "powsybl.org");
        modelForExport.setProfile(context.getCim().getProfileUri(subset.getIdentifier()));
        CgmesMetadataModels networkModels = (CgmesMetadataModels)network.getExtension(CgmesMetadataModels.class);
        Optional networkSubsetModel = networkModels != null ? networkModels.getModelForSubset(subset) : Optional.empty();
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$2((CgmesMetadataModel)modelForExport, arg_0));
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$3((CgmesMetadataModel)modelForExport, arg_0));
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$4((CgmesMetadataModel)modelForExport, arg_0));
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$5((CgmesMetadataModel)modelForExport, arg_0));
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$6((CgmesMetadataModel)modelForExport, arg_0));
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$7((CgmesMetadataModel)modelForExport, arg_0));
        networkSubsetModel.ifPresent(arg_0 -> CgmesExport.lambda$initializeModelForExport$8((CgmesMetadataModel)modelForExport, arg_0));
        if ((mainNetwork || modelUpdate) && context.getModelDescription() != null) {
            modelForExport.setDescription(context.getModelDescription());
        }
        if ((mainNetwork || modelUpdate) && context.getModelVersion() != null) {
            modelForExport.setVersion(Integer.parseInt(context.getModelVersion()));
        }
        if (mainNetwork && context.getModelingAuthoritySet() != null) {
            modelForExport.setModelingAuthoritySet(context.getModelingAuthoritySet());
        }
        if (modelUpdate || modelForExport.getId() == null) {
            CgmesExportUtil.initializeModelId(network, (CgmesMetadataModel)modelForExport, context);
        }
        return modelForExport;
    }

    private void updateDependenciesCGM(Collection<IgmModelsForCgm> igmModels, CgmesMetadataModel updatedCgmSvModel, String boundaryTpId) {
        igmModels.forEach(m -> m.updatedSsh.addDependentOn(m.originalEq.getId()));
        igmModels.forEach(m -> m.updatedSsh.clearSupersedes());
        igmModels.forEach(m -> m.updatedSsh.addSupersedes(m.originalSsh.getId()));
        updatedCgmSvModel.addDependentOn((Collection)igmModels.stream().map(m -> m.updatedSsh.getId()).collect(Collectors.toSet()));
        updatedCgmSvModel.addDependentOn((Collection)igmModels.stream().map(m -> m.originalTp.getId()).collect(Collectors.toSet()));
        if (boundaryTpId != null) {
            updatedCgmSvModel.addDependentOn(boundaryTpId);
        } else {
            updatedCgmSvModel.addDependentOn((Collection)igmModels.stream().map(m -> m.originalTpBd.getId()).collect(Collectors.toSet()));
        }
    }

    private void updateDependenciesIGM(Map<CgmesSubset, CgmesMetadataModel> subsetModels, String boundaryEqId, String boundaryTpId) {
        String eqModelId = subsetModels.get(CgmesSubset.EQUIPMENT).getId();
        if (eqModelId == null || eqModelId.isEmpty()) {
            return;
        }
        subsetModels.get(CgmesSubset.TOPOLOGY).addDependentOn(eqModelId);
        subsetModels.get(CgmesSubset.STEADY_STATE_HYPOTHESIS).addDependentOn(eqModelId);
        subsetModels.get(CgmesSubset.STATE_VARIABLES).addDependentOn(subsetModels.get(CgmesSubset.TOPOLOGY).getId()).addDependentOn(subsetModels.get(CgmesSubset.STEADY_STATE_HYPOTHESIS).getId());
        if (boundaryEqId != null) {
            subsetModels.get(CgmesSubset.EQUIPMENT).addDependentOn(boundaryEqId);
        }
        if (boundaryTpId != null) {
            subsetModels.get(CgmesSubset.STATE_VARIABLES).addDependentOn(boundaryTpId);
        }
    }

    private void checkCgmConsistency(Network network, CgmesExportContext context) {
        if (network.getSubnetworks().size() < 2) {
            LOG.error("Network {} must have at least 2 subnetworks for a CGM export.", (Object)network.getId());
        }
        ZonedDateTime scenarioTime = network.getCaseDate();
        for (Object subnetwork : network.getSubnetworks()) {
            if (subnetwork.getCaseDate().equals(scenarioTime)) continue;
            LOG.error("Parent network doesn't have the same scenarioTime as subnetwork: {}.", (Object)subnetwork.getId());
        }
        if (context.getModelVersion() == null || context.getModelVersion().isEmpty()) {
            int currentVersion = this.getVersionNumber(network, CgmesSubset.STATE_VARIABLES);
            for (Network subnetwork : network.getSubnetworks()) {
                currentVersion = Math.max(this.getVersionNumber(subnetwork, CgmesSubset.STEADY_STATE_HYPOTHESIS), currentVersion);
            }
            int nextVersion = currentVersion >= 0 ? currentVersion + 1 : 2;
            context.setModelVersion(String.valueOf(nextVersion));
        }
    }

    private void checkIgmConsistency(List<CgmesSubset> requestedSubsets, Network network, CgmesExportContext context) {
        boolean networkIsNodeBreaker = network.getVoltageLevelStream().map(VoltageLevel::getTopologyKind).anyMatch(tk -> tk == TopologyKind.NODE_BREAKER);
        if (networkIsNodeBreaker && (requestedSubsets.contains(CgmesSubset.STEADY_STATE_HYPOTHESIS) || requestedSubsets.contains(CgmesSubset.STATE_VARIABLES)) && !requestedSubsets.contains(CgmesSubset.TOPOLOGY)) {
            CgmesReports.inconsistentProfilesTPRequiredReport(context.getReportNode(), network.getId());
            LOG.error("Network {} contains node/breaker information. References to Topological Nodes in SSH/SV files will not be valid if TP is not exported.", (Object)network.getId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void subsetExport(Network network, CgmesSubset subset, String fileName, DataSource dataSource, CgmesExportContext context, CgmesMetadataModel model) {
        try (BufferedOutputStream out = new BufferedOutputStream(dataSource.newOutputStream(fileName, false));){
            XMLStreamWriter writer = XmlUtil.initializeWriter((boolean)true, (String)"    ", (OutputStream)out);
            switch (subset) {
                case EQUIPMENT: {
                    EquipmentExport.write(network, writer, context, model);
                    return;
                }
                case TOPOLOGY: {
                    TopologyExport.write(network, writer, context, model);
                    return;
                }
                case STEADY_STATE_HYPOTHESIS: {
                    SteadyStateHypothesisExport.write(network, writer, context, model);
                    return;
                }
                case STATE_VARIABLES: {
                    StateVariablesExport.write(network, writer, context, model);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Invalid subset, one of the following value is expected: EQ/TP/SSH/SV.");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private int getVersionNumber(Network network, CgmesSubset subset) {
        CgmesMetadataModels networkModels = (CgmesMetadataModels)network.getExtension(CgmesMetadataModels.class);
        Optional networkSubsetModel = networkModels != null ? networkModels.getModelForSubset(subset) : Optional.empty();
        return networkSubsetModel.map(CgmesMetadataModel::getVersion).orElse(-1);
    }

    private static String getCountry(Network network) {
        Set countries = network.getSubstationStream().map(Substation::getCountry).flatMap(Optional::stream).map(Enum::name).collect(Collectors.toUnmodifiableSet());
        if (countries.size() == 1) {
            return (String)countries.iterator().next();
        }
        return null;
    }

    private ExportParameters readExportParameters(Properties params) {
        return new ExportParameters(Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_BOUNDARY_POWER_FLOWS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_POWER_FLOWS_FOR_SWITCHES_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_TRANSFORMERS_WITH_HIGHEST_VOLTAGE_AT_END1_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_LOAD_FLOW_STATUS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_ALL_LIMITS_GROUP_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_GENERATORS_IN_LOCAL_REGULATION_MODE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readDouble((String)this.getFormat(), (Properties)params, (Parameter)MAX_P_MISMATCH_CONVERGED_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readDouble((String)this.getFormat(), (Properties)params, (Parameter)MAX_Q_MISMATCH_CONVERGED_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)EXPORT_SV_INJECTIONS_FOR_SLACKS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)ENCODE_IDS_PARAMETERS, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)BUSINESS_PROCESS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)MODEL_DESCRIPTION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)MODEL_VERSION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)MODELING_AUTHORITY_SET_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readStringList((String)this.getFormat(), (Properties)params, (Parameter)PROFILES_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)BASE_NAME_PARAMETER), Parameter.readBoolean((String)this.getFormat(), (Properties)params, (Parameter)UPDATE_DEPENDENCIES_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)CIM_VERSION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)TOPOLOGY_KIND_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)BOUNDARY_EQ_ID_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig), Parameter.readString((String)this.getFormat(), (Properties)params, (Parameter)BOUNDARY_TP_ID_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig));
    }

    private String getBaseName(CgmesExportContext context, DataSource dataSource, Network network) {
        if (context.getBaseName() != null) {
            return context.getBaseName();
        }
        if (dataSource.getBaseName() != null && !dataSource.getBaseName().isEmpty()) {
            return dataSource.getBaseName();
        }
        return network.getNameOrId();
    }

    public String getComment() {
        return "ENTSO-E CGMES version 2.4.15";
    }

    public String getFormat() {
        return "CGMES";
    }

    private static /* synthetic */ void lambda$initializeModelForExport$8(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.setModelingAuthoritySet(m.getModelingAuthoritySet());
    }

    private static /* synthetic */ void lambda$initializeModelForExport$7(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.addProfiles((Collection)m.getProfiles());
    }

    private static /* synthetic */ void lambda$initializeModelForExport$6(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.addSupersedes((Collection)m.getSupersedes());
    }

    private static /* synthetic */ void lambda$initializeModelForExport$5(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.addDependentOn((Collection)m.getDependentOn());
    }

    private static /* synthetic */ void lambda$initializeModelForExport$4(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.setVersion(m.getVersion());
    }

    private static /* synthetic */ void lambda$initializeModelForExport$3(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.setDescription(m.getDescription());
    }

    private static /* synthetic */ void lambda$initializeModelForExport$2(CgmesMetadataModel modelForExport, CgmesMetadataModel m) {
        modelForExport.setId(m.getId());
    }

    public record ExportParameters(boolean exportBoundaryPowerFlows, boolean exportFlowsForSwitches, boolean exportTransformersWithHighestVoltageAtEnd1, boolean exportLoadFlowStatus, boolean exportAllLimitsGroup, boolean exportGeneratorsInLocalRegulationMode, double maxPMismatchConverged, double maxQMismatchConverged, boolean exportSvInjectionsForSlacks, boolean encodeIds, String businessProcess, String modelDescription, String modelVersion, String modelingAuthoritySet, List<String> profiles, String baseName, boolean updateDependencies, String cimVersion, String topologyKind, String boundaryEqId, String boundaryTpId) {
    }

    private static class IgmModelsForCgm {
        CgmesMetadataModel updatedSsh;
        CgmesMetadataModel originalEq;
        CgmesMetadataModel originalSsh;
        CgmesMetadataModel originalTp;
        CgmesMetadataModel originalTpBd;

        public IgmModelsForCgm(CgmesMetadataModel updatedSsh, CgmesMetadataModel originalEq, CgmesMetadataModel originalSsh, CgmesMetadataModel originalTp, CgmesMetadataModel originalTpBd) {
            this.updatedSsh = updatedSsh;
            this.originalEq = originalEq;
            this.originalSsh = originalSsh;
            this.originalTp = originalTp;
            this.originalTpBd = originalTpBd;
        }
    }
}

