/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;

public final class CgmesReports {
    private static final String EQUIPMENT_ID = "equipmentId";
    private static final String ELEMENT_TYPE = "elementType";
    private static final String CONVERTER_IDS = "converterIds";

    private CgmesReports() {
    }

    public static ReportNode applyingPreprocessorsReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.applyingPreprocessors")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void applyingProcessorReport(ReportNode reportNode, String processorName) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.applyingProcessor")).withUntypedValue("processorName", processorName)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode buildingMappingsReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.buildingMappings")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode convertingElementTypeReport(ReportNode reportNode, String elementType) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.convertingElementType")).withUntypedValue(ELEMENT_TYPE, elementType)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode convertingDuringUpdateElementTypeReport(ReportNode reportNode, String elementType) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.convertingDuringUpdateElementType")).withUntypedValue(ELEMENT_TYPE, elementType)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode updatingElementTypeReport(ReportNode reportNode, String elementType) {
        return ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.updatingElementType")).withUntypedValue(ELEMENT_TYPE, elementType)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode fixingDanglingLinesIssuesReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.fixingDanglingLinesIssues")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode settingVoltagesAndAnglesReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.settingVoltagesAndAngles")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static ReportNode applyingPostprocessorsReport(ReportNode reportNode) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.applyingPostprocessors")).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void importedCgmesNetworkReport(ReportNode reportNode, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.importedCgmesNetwork")).withUntypedValue("networkId", networkId)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void badVoltageTargetValueRegulatingControlReport(ReportNode reportNode, String eqId, double targetValue) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.badVoltageTargetValueRegulatingControl")).withUntypedValue(EQUIPMENT_ID, eqId)).withTypedValue("targetValue", targetValue, "VOLTAGE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void badTargetValueRegulatingControlReport(ReportNode reportNode, String eqId, double targetValue) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.badTargetValueRegulatingControl")).withUntypedValue(EQUIPMENT_ID, eqId)).withUntypedValue("targetValue", targetValue)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void badTargetDeadbandRegulatingControlReport(ReportNode reportNode, String eqId, double targetDeadband) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.badTargetDeadbandRegulatingControl")).withUntypedValue(EQUIPMENT_ID, eqId)).withUntypedValue("targetDeadband", targetDeadband)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void badLoadTapChangingCapabilityTapChangerReport(ReportNode reportNode, String tapChangerId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.badLoadTapChangingCapabilityTapChanger")).withUntypedValue("tapChangerId", tapChangerId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void invalidAngleVoltageReport(ReportNode reportNode, Bus bus, double v, double angle) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.invalidAngleVoltageBus")).withUntypedValue("substation", bus.getVoltageLevel().getSubstation().map(Identifiable::getNameOrId).orElse("unknown"))).withUntypedValue("voltageLevel", bus.getVoltageLevel().getNameOrId())).withUntypedValue("bus", bus.getId())).withTypedValue("voltage", v, "VOLTAGE")).withTypedValue("angle", angle, "ANGLE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void removingUnattachedHvdcConverterStationReport(ReportNode reportNode, String converterId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.removingUnattachedHvdcConverterStation")).withUntypedValue("converterId", converterId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void voltageLevelMappingReport(ReportNode reportNode, int voltageLevelMappingSize, String mapAsString) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.voltageLevelMapping")).withUntypedValue("voltageLevelMappingSize", voltageLevelMappingSize)).withUntypedValue("mapAsString", mapAsString)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void substationMappingReport(ReportNode reportNode, int substationMappingSize, String mapAsString) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.substationMapping")).withUntypedValue("substationMappingSize", substationMappingSize)).withUntypedValue("mapAsString", mapAsString)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void nominalVoltageIsZeroReport(ReportNode reportNode, String voltageLevelId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.nominalVoltageIsZero")).withUntypedValue("voltageLevelId", voltageLevelId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void inconsistentProfilesTPRequiredReport(ReportNode reportNode, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.inconsistentProfilesTPRequired")).withUntypedValue("networkId", networkId)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void danglingLineDisconnectedAtBoundaryHasBeenDisconnectedReport(ReportNode reportNode, String danglingLineId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.danglingLineDisconnectedAtBoundaryHasBeenDisconnected")).withUntypedValue("danglingLineId", danglingLineId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void multipleUnpairedDanglingLinesAtSameBoundaryReport(ReportNode reportNode, String danglingLineId, double p0, double q0, double p0Adjusted, double q0Adjusted) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.multipleUnpairedDanglingLinesAtSameBoundary")).withUntypedValue("danglingLineId", danglingLineId)).withUntypedValue("p0", p0)).withUntypedValue("q0", q0)).withUntypedValue("p0Adjusted", p0Adjusted)).withUntypedValue("q0Adjusted", q0Adjusted)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void missingMandatoryAttributeReport(ReportNode reportNode, String attributeName, String objectClass, String objectId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.missingMandatoryAttribute")).withUntypedValue("attributeName", attributeName)).withUntypedValue("objectClass", objectClass)).withUntypedValue("objectId", objectId)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static ReportNode importingCgmesFileReport(ReportNode reportNode, String basename) {
        return ((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.CGMESConversion")).withUntypedValue("basename", basename)).add();
    }

    public static ReportNode readingCgmesTriplestoreReport(ReportNode reportNode) {
        return ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.CGMESTriplestore")).add();
    }

    public static void exportedModelIdentifierReport(ReportNode reportNode, String description, String identifier, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.ExportedCgmesId")).withTypedValue("cgmesId", description, "URN_UUID")).withTypedValue("cgmesSubset", identifier, "CGMES_SUBSET")).withTypedValue("networkId", networkId, "ID")).add();
    }

    public static void notVisitedDcEquipmentReport(ReportNode reportNode, String dcEquipmentId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.notVisitedDcEquipment")).withUntypedValue("dcEquipmentId", dcEquipmentId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void dcLineSegmentNotInTwoDCIslandEndReport(ReportNode reportNode, String dcLineSegmentId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.dcLineSegmentNotInTwoDCIslandEnd")).withUntypedValue("dcLineSegmentId", dcLineSegmentId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void inconsistentNumberOfConvertersReport(ReportNode reportNode, String converterIds) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.inconsistentNumberOfConverters")).withUntypedValue(CONVERTER_IDS, converterIds)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void unsupportedDcConfigurationReport(ReportNode reportNode, String converterIds, String dcConfiguration) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.unsupportedDcConfiguration")).withUntypedValue(CONVERTER_IDS, converterIds)).withUntypedValue("dcConfiguration", dcConfiguration)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void unexpectedPointToPointDcConfigurationReport(ReportNode reportNode, String converterIds, int numberOfLines, int numberOfConverterPairs) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("core.cgmes.conversion.unexpectedPointToPointDcConfiguration")).withUntypedValue(CONVERTER_IDS, converterIds)).withUntypedValue("numberOfLines", numberOfLines)).withUntypedValue("numberOfConverterPairs", numberOfConverterPairs)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }
}

