/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.CgmesBoundary;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.LoadingLimitsMapping;
import com.powsybl.cgmes.conversion.NodeContainerMapping;
import com.powsybl.cgmes.conversion.NodeMapping;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.TerminalMapping;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private final CgmesModel cgmes;
    private final Network network;
    private final Conversion.Config config;
    private final boolean nodeBreaker;
    private final NamingStrategy namingStrategy;
    private final NodeContainerMapping nodeContainerMapping;
    private final CgmesBoundary cgmesBoundary;
    private final TerminalMapping terminalMapping;
    private final NodeMapping nodeMapping;
    private final LoadingLimitsMapping loadingLimitsMapping;
    private final RegulatingControlMapping regulatingControlMapping;
    private final Map<String, PropertyBags> cachedGroupedTransformerEnds;
    private final Map<String, PropertyBags> cachedGroupedRatioTapChangers;
    private final Map<String, PropertyBags> cachedGroupedRatioTapChangerTablePoints;
    private final Map<String, PropertyBags> cachedGroupedPhaseTapChangers;
    private final Map<String, PropertyBags> cachedGroupedPhaseTapChangerTablePoints;
    private final Map<String, PropertyBags> cachedGroupedShuntCompensatorPoints;
    private final Map<String, PropertyBags> cachedGroupedReactiveCapabilityCurveData;
    private final Map<String, PropertyBag> cgmesTerminals;
    private final Map<String, PropertyBag> ratioTapChangers;
    private final Map<String, PropertyBag> phaseTapChangers;
    private final Map<String, PropertyBag> regulatingControls;
    private final Map<String, PropertyBag> operationalLimits;
    private final Map<String, PropertyBag> generatingUnits;
    private final Map<String, PropertyBag> equivalentInjections;
    private final Map<String, PropertyBag> svVoltages;
    private final Map<String, PropertyBag> switches;
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);

    public Context(CgmesModel cgmes, Conversion.Config config, Network network) {
        this(cgmes, config, network, ReportNode.NO_OP);
    }

    public Context(CgmesModel cgmes, Conversion.Config config, Network network, ReportNode reportNode) {
        this.cgmes = Objects.requireNonNull(cgmes);
        this.config = Objects.requireNonNull(config);
        this.network = Objects.requireNonNull(network);
        this.pushReportNode(Objects.requireNonNull(reportNode));
        this.nodeBreaker = cgmes.isNodeBreaker() && !config.importNodeBreakerAsBusBreaker();
        this.namingStrategy = config.getNamingStrategy();
        this.cgmesBoundary = new CgmesBoundary(cgmes);
        this.nodeContainerMapping = new NodeContainerMapping(this);
        this.terminalMapping = new TerminalMapping();
        this.loadingLimitsMapping = new LoadingLimitsMapping(this);
        this.regulatingControlMapping = new RegulatingControlMapping(this);
        this.nodeMapping = new NodeMapping();
        this.cachedGroupedTransformerEnds = new HashMap<String, PropertyBags>();
        this.cachedGroupedRatioTapChangers = new HashMap<String, PropertyBags>();
        this.cachedGroupedRatioTapChangerTablePoints = new HashMap<String, PropertyBags>();
        this.cachedGroupedPhaseTapChangers = new HashMap<String, PropertyBags>();
        this.cachedGroupedPhaseTapChangerTablePoints = new HashMap<String, PropertyBags>();
        this.cachedGroupedShuntCompensatorPoints = new HashMap<String, PropertyBags>();
        this.cachedGroupedReactiveCapabilityCurveData = new HashMap<String, PropertyBags>();
        this.buildCaches();
        this.cgmesTerminals = new HashMap<String, PropertyBag>();
        this.ratioTapChangers = new HashMap<String, PropertyBag>();
        this.phaseTapChangers = new HashMap<String, PropertyBag>();
        this.regulatingControls = new HashMap<String, PropertyBag>();
        this.operationalLimits = new HashMap<String, PropertyBag>();
        this.generatingUnits = new HashMap<String, PropertyBag>();
        this.equivalentInjections = new HashMap<String, PropertyBag>();
        this.svVoltages = new HashMap<String, PropertyBag>();
        this.switches = new HashMap<String, PropertyBag>();
    }

    public CgmesModel cgmes() {
        return this.cgmes;
    }

    public Network network() {
        return this.network;
    }

    public Conversion.Config config() {
        return this.config;
    }

    public boolean nodeBreaker() {
        return this.nodeBreaker;
    }

    public NamingStrategy namingStrategy() {
        return this.namingStrategy;
    }

    public TerminalMapping terminalMapping() {
        return this.terminalMapping;
    }

    public void convertedTerminal(String terminalId, Terminal t, int n, PowerFlow f) {
        this.terminalMapping().add(terminalId, t, n);
        if (f.defined() && this.setPQAllowed(t)) {
            t.setP(f.p());
            t.setQ(f.q());
        }
    }

    public void convertedTerminalWithOnlyEq(String terminalId, Terminal t, int n) {
        this.terminalMapping().add(terminalId, t, n);
    }

    private boolean setPQAllowed(Terminal t) {
        return t.getConnectable().getType() != IdentifiableType.BUSBAR_SECTION;
    }

    public NodeMapping nodeMapping() {
        return this.nodeMapping;
    }

    public NodeContainerMapping nodeContainerMapping() {
        return this.nodeContainerMapping;
    }

    public CgmesBoundary boundary() {
        return this.cgmesBoundary;
    }

    public LoadingLimitsMapping loadingLimitsMapping() {
        return this.loadingLimitsMapping;
    }

    public RegulatingControlMapping regulatingControlMapping() {
        return this.regulatingControlMapping;
    }

    public static String boundaryVoltageLevelId(String nodeId) {
        Objects.requireNonNull(nodeId);
        return nodeId + "_VL";
    }

    public static String boundarySubstationId(String nodeId) {
        Objects.requireNonNull(nodeId);
        return nodeId + "_S";
    }

    private void buildCaches() {
        this.buildCache(this.cachedGroupedTransformerEnds, this.cgmes().transformerEnds(), "PowerTransformer");
        this.buildCache(this.cachedGroupedRatioTapChangers, this.cgmes().ratioTapChangers(), "PowerTransformer");
        this.buildCache(this.cachedGroupedRatioTapChangerTablePoints, this.cgmes().ratioTapChangerTablePoints(), "RatioTapChangerTable");
        this.buildCache(this.cachedGroupedPhaseTapChangers, this.cgmes().phaseTapChangers(), "PowerTransformer");
        this.buildCache(this.cachedGroupedPhaseTapChangerTablePoints, this.cgmes().phaseTapChangerTablePoints(), "PhaseTapChangerTable");
        this.buildCache(this.cachedGroupedShuntCompensatorPoints, this.cgmes().nonlinearShuntCompensatorPoints(), "Shunt");
        this.buildCache(this.cachedGroupedReactiveCapabilityCurveData, this.cgmes().reactiveCapabilityCurveData(), "ReactiveCapabilityCurve");
    }

    private void buildCache(Map<String, PropertyBags> cache, PropertyBags ps, String groupName) {
        ps.forEach(p -> {
            String groupId = p.getId(groupName);
            cache.computeIfAbsent(groupId, b -> new PropertyBags()).add(p);
        });
    }

    public PropertyBags transformerEnds(String transformerId) {
        return this.cachedGroupedTransformerEnds.getOrDefault(transformerId, new PropertyBags());
    }

    public PropertyBags ratioTapChangers(String transformerId) {
        return this.cachedGroupedRatioTapChangers.getOrDefault(transformerId, new PropertyBags());
    }

    public PropertyBags ratioTapChangerTablePoints(String tableId) {
        return this.cachedGroupedRatioTapChangerTablePoints.getOrDefault(tableId, new PropertyBags());
    }

    public PropertyBags phaseTapChangers(String transformerId) {
        return this.cachedGroupedPhaseTapChangers.getOrDefault(transformerId, new PropertyBags());
    }

    public PropertyBags phaseTapChangerTablePoints(String tableId) {
        return this.cachedGroupedPhaseTapChangerTablePoints.getOrDefault(tableId, new PropertyBags());
    }

    public PropertyBags nonlinearShuntCompensatorPoints(String shuntId) {
        return this.cachedGroupedShuntCompensatorPoints.getOrDefault(shuntId, new PropertyBags());
    }

    public PropertyBags reactiveCapabilityCurveData(String curveId) {
        return this.cachedGroupedReactiveCapabilityCurveData.getOrDefault(curveId, new PropertyBags());
    }

    public void buildUpdateCache() {
        Context.buildUpdateCache(this.cgmesTerminals, this.cgmes.terminals(), "Terminal");
        Context.buildUpdateCache(this.ratioTapChangers, this.cgmes.ratioTapChangers(), "RatioTapChanger");
        Context.buildUpdateCache(this.phaseTapChangers, this.cgmes.phaseTapChangers(), "PhaseTapChanger");
        Context.buildUpdateCache(this.regulatingControls, this.cgmes.regulatingControls(), "RegulatingControl");
        Context.buildUpdateCache(this.operationalLimits, this.cgmes.operationalLimits(), "OperationalLimit");
        Context.buildUpdateCache(this.generatingUnits, this.cgmes.generatingUnits(), "GeneratingUnit");
        Context.buildUpdateCache(this.equivalentInjections, this.cgmes.equivalentInjections(), "EquivalentInjection");
        Context.buildUpdateCache(this.svVoltages, this.cgmes.svVoltages(), "TopologicalNode");
        Context.buildUpdateCache(this.switches, this.cgmes.switches(), "Switch");
    }

    private static void buildUpdateCache(Map<String, PropertyBag> cache, PropertyBags cgmesPropertyBags, String tagId) {
        cgmesPropertyBags.forEach(p -> {
            String id = p.getId(tagId);
            cache.put(id, (PropertyBag)p);
        });
    }

    public PropertyBag cgmesTerminal(String id) {
        return this.cgmesTerminals.get(id);
    }

    public PropertyBag ratioTapChanger(String id) {
        return this.ratioTapChangers.get(id);
    }

    public PropertyBag phaseTapChanger(String id) {
        return this.phaseTapChangers.get(id);
    }

    public PropertyBag regulatingControl(String id) {
        return this.regulatingControls.get(id);
    }

    public PropertyBag operationalLimit(String id) {
        return this.operationalLimits.get(id);
    }

    public PropertyBag generatingUnit(String id) {
        return this.generatingUnits.get(id);
    }

    public PropertyBag equivalentInjection(String id) {
        return this.equivalentInjections.get(id);
    }

    public PropertyBag svVoltage(String id) {
        return this.svVoltages.get(id);
    }

    public PropertyBag cgmesSwitch(String id) {
        return this.switches.get(id);
    }

    public ReportNode getReportNode() {
        return this.network.getReportNodeContext().getReportNode();
    }

    public void pushReportNode(ReportNode node) {
        this.network.getReportNodeContext().pushReportNode(node);
    }

    public ReportNode popReportNode() {
        return this.network.getReportNodeContext().popReportNode();
    }

    public void invalid(String what, String reason) {
        this.handleIssue(ConversionIssueCategory.INVALID, what, reason);
    }

    public void invalid(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.INVALID, what, reason);
    }

    public void ignored(String what, String reason) {
        this.handleIssue(ConversionIssueCategory.IGNORED, what, reason);
    }

    public void ignored(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.IGNORED, what, reason);
    }

    public void pending(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.PENDING, what, reason);
    }

    public void fixed(String what, String reason) {
        this.handleIssue(ConversionIssueCategory.FIXED, what, reason);
    }

    public void fixed(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.FIXED, what, reason);
    }

    public void fixed(String what, String reason, double wrong, double fixed) {
        Supplier<String> reason1 = () -> String.format("%s. Wrong %.4f, was fixed to %.4f", reason, wrong, fixed);
        this.handleIssue(ConversionIssueCategory.FIXED, what, reason1);
    }

    public void missing(String what) {
        String reason1 = "";
        this.handleIssue(ConversionIssueCategory.MISSING, what, reason1);
    }

    public void missing(String what, Supplier<String> reason) {
        this.handleIssue(ConversionIssueCategory.MISSING, what, reason);
    }

    public void missing(String what, double defaultValue) {
        Supplier<String> reason1 = () -> String.format("Using default value %.4f", defaultValue);
        this.handleIssue(ConversionIssueCategory.MISSING, what, reason1);
    }

    private void handleIssue(ConversionIssueCategory category, String what, String reason) {
        this.handleIssue(category, what, () -> reason);
    }

    private void handleIssue(ConversionIssueCategory category, String what, Supplier<String> reason) {
        Context.logIssue(category, what, reason);
    }

    private static void logIssue(ConversionIssueCategory category, String what, Supplier<String> reason) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("{}: {}. Reason: {}", new Object[]{category, what, reason.get()});
        }
    }

    private static enum ConversionIssueCategory {
        INVALID("Invalid"),
        IGNORED("Ignored"),
        MISSING("Missing"),
        FIXED("Fixed"),
        PENDING("Pending");

        private final String description;

        private ConversionIssueCategory(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

