/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.BoundaryEquipment;
import com.powsybl.cgmes.conversion.CgmesConversionContextExtensionAdder;
import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.conversion.CgmesImportPostProcessor;
import com.powsybl.cgmes.conversion.CgmesImportPreProcessor;
import com.powsybl.cgmes.conversion.CgmesModelExtensionAdder;
import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.ReportTapChangers;
import com.powsybl.cgmes.conversion.Update;
import com.powsybl.cgmes.conversion.elements.ACLineSegmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.conversion.elements.AbstractObjectConversion;
import com.powsybl.cgmes.conversion.elements.AsynchronousMachineConversion;
import com.powsybl.cgmes.conversion.elements.BusbarSectionConversion;
import com.powsybl.cgmes.conversion.elements.ControlAreaConversion;
import com.powsybl.cgmes.conversion.elements.EnergyConsumerConversion;
import com.powsybl.cgmes.conversion.elements.EnergySourceConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentBranchConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentInjectionConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentShuntConversion;
import com.powsybl.cgmes.conversion.elements.ExternalNetworkInjectionConversion;
import com.powsybl.cgmes.conversion.elements.GroundConversion;
import com.powsybl.cgmes.conversion.elements.NodeConversion;
import com.powsybl.cgmes.conversion.elements.OperationalLimitConversion;
import com.powsybl.cgmes.conversion.elements.SeriesCompensatorConversion;
import com.powsybl.cgmes.conversion.elements.ShuntConversion;
import com.powsybl.cgmes.conversion.elements.StaticVarCompensatorConversion;
import com.powsybl.cgmes.conversion.elements.SubstationConversion;
import com.powsybl.cgmes.conversion.elements.SwitchConversion;
import com.powsybl.cgmes.conversion.elements.SynchronousMachineConversion;
import com.powsybl.cgmes.conversion.elements.TieFlowConversion;
import com.powsybl.cgmes.conversion.elements.TieLineConversion;
import com.powsybl.cgmes.conversion.elements.VoltageLevelConversion;
import com.powsybl.cgmes.conversion.elements.dc.DCConversion;
import com.powsybl.cgmes.conversion.elements.transformers.ThreeWindingsTransformerConversion;
import com.powsybl.cgmes.conversion.elements.transformers.TwoWindingsTransformerConversion;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.extensions.BaseVoltageMappingAdder;
import com.powsybl.cgmes.extensions.CgmesMetadataModels;
import com.powsybl.cgmes.extensions.CgmesMetadataModelsAdder;
import com.powsybl.cgmes.extensions.CgmesTopologyKind;
import com.powsybl.cgmes.extensions.CimCharacteristicsAdder;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesNamespace;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.triplestore.CgmesModelTripleStore;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversion {
    public static final String QUERY_CATALOG_NAME_INIT = "";
    public static final String QUERY_CATALOG_NAME_UPDATE = "-update";
    private final CgmesModel cgmes;
    private final Config config;
    private final List<CgmesImportPostProcessor> postProcessors;
    private final List<CgmesImportPreProcessor> preProcessors;
    private final NetworkFactory networkFactory;
    private static final Logger LOG = LoggerFactory.getLogger(Conversion.class);
    public static final String NETWORK_PS_CGMES_MODEL_DETAIL = "CGMESModelDetail";
    public static final String NETWORK_PS_CGMES_MODEL_DETAIL_BUS_BRANCH = "bus-branch";
    public static final String NETWORK_PS_CGMES_MODEL_DETAIL_NODE_BREAKER = "node-breaker";
    public static final String CGMES_PREFIX_ALIAS_PROPERTIES = "CGMES.";
    public static final String PROPERTY_IS_CREATED_FOR_DISCONNECTED_TERMINAL = "CGMES.isCreatedForDisconnectedTerminal";
    public static final String PROPERTY_IS_EQUIVALENT_SHUNT = "CGMES.isEquivalentShunt";
    public static final String PROPERTY_HYDRO_PLANT_STORAGE_TYPE = "CGMES.hydroPlantStorageKind";
    public static final String PROPERTY_FOSSIL_FUEL_TYPE = "CGMES.fuelType";
    public static final String PROPERTY_WIND_GEN_UNIT_TYPE = "CGMES.windGenUnitType";
    public static final String PROPERTY_CGMES_ORIGINAL_CLASS = "CGMES.originalClass";
    public static final String PROPERTY_BUSBAR_SECTION_TERMINALS = "CGMES.busbarSectionTerminals";
    public static final String PROPERTY_CGMES_GOVERNOR_SCD = "CGMES.governorSCD";
    public static final String PROPERTY_CGMES_SYNCHRONOUS_MACHINE_TYPE = "CGMES.synchronousMachineType";
    public static final String PROPERTY_CGMES_SYNCHRONOUS_MACHINE_OPERATING_MODE = "CGMES.synchronousMachineOperatingMode";
    public static final String PROPERTY_OPERATIONAL_LIMIT_SET_NAME = "CGMES.OperationalLimitSetName";
    public static final String PROPERTY_OPERATIONAL_LIMIT_SET_RDFID = "CGMES.OperationalLimitSetRdfID";
    public static final String PROPERTY_REGULATING_CONTROL = "CGMES.RegulatingControl";
    public static final String PROPERTY_CGMES_REGULATION_CAPABILITY = "CGMES.regulationCapability";

    public Conversion(CgmesModel cgmes) {
        this(cgmes, new Config());
    }

    public Conversion(CgmesModel cgmes, Config config) {
        this(cgmes, config, Collections.emptyList(), Collections.emptyList());
    }

    public Conversion(CgmesModel cgmes, Config config, List<CgmesImportPostProcessor> postProcessors) {
        this(cgmes, config, Collections.emptyList(), postProcessors, NetworkFactory.findDefault());
    }

    public Conversion(CgmesModel cgmes, Config config, List<CgmesImportPreProcessor> preProcessors, List<CgmesImportPostProcessor> postProcessors) {
        this(cgmes, config, preProcessors, postProcessors, NetworkFactory.findDefault());
    }

    public Conversion(CgmesModel cgmes, Config config, List<CgmesImportPreProcessor> activatedPreProcessors, List<CgmesImportPostProcessor> activatedPostProcessors, NetworkFactory networkFactory) {
        this.cgmes = Objects.requireNonNull(cgmes);
        this.config = Objects.requireNonNull(config);
        this.preProcessors = Objects.requireNonNull(activatedPreProcessors);
        this.postProcessors = Objects.requireNonNull(activatedPostProcessors);
        this.networkFactory = Objects.requireNonNull(networkFactory);
    }

    public void report(Consumer<String> out) {
        new ReportTapChangers(this.cgmes, out).report();
    }

    public Network convert() {
        return this.convert(ReportNode.NO_OP);
    }

    public Network convert(ReportNode reportNode) {
        PropertyBags nodes;
        Objects.requireNonNull(reportNode);
        if (!this.cgmes.hasEquipmentCore()) {
            throw new CgmesModelException("Data source does not contain EquipmentCore data");
        }
        ReportNode preProcessorsNode = CgmesReports.applyingPreprocessorsReport(reportNode);
        for (CgmesImportPreProcessor preProcessor : this.preProcessors) {
            CgmesReports.applyingProcessorReport(preProcessorsNode, preProcessor.getName());
            preProcessor.process(this.cgmes);
        }
        if (LOG.isTraceEnabled() && this.cgmes.baseVoltages() != null) {
            LOG.trace("{}{}{}", new Object[]{"BaseVoltages", System.lineSeparator(), this.cgmes.baseVoltages().tabulate()});
        }
        Network network = this.createNetwork();
        network.setMinimumAcceptableValidationLevel(ValidationLevel.EQUIPMENT);
        Context context = new Context(this.cgmes, this.config, network, reportNode);
        this.assignNetworkProperties(context);
        this.addMetadataModels(network, context);
        this.addCimCharacteristics(network);
        context.pushReportNode(CgmesReports.buildingMappingsReport(reportNode));
        context.nodeContainerMapping().build();
        BaseVoltageMappingAdder bvAdder = (BaseVoltageMappingAdder)network.newExtension(BaseVoltageMappingAdder.class);
        this.cgmes.baseVoltages().forEach(bv -> bvAdder.addBaseVoltage(bv.getId("BaseVoltage"), bv.asDouble("nominalVoltage"), this.isBoundaryBaseVoltage(bv.getLocal("graph"))));
        bvAdder.add();
        this.cgmes.computedTerminals().forEach(t -> context.terminalMapping().buildTopologicalNodeCgmesTerminalsMapping((CgmesTerminal)t));
        this.cgmes.regulatingControls().forEach(p -> context.regulatingControlMapping().cacheRegulatingControls((PropertyBag)p));
        context.popReportNode();
        this.convert(this.cgmes.substations(), "Substation", context);
        this.convert(this.cgmes.voltageLevels(), "VoltageLevel", context);
        this.createFictitiousVoltageLevelsForLineContainers(context);
        PropertyBags propertyBags = nodes = context.nodeBreaker() ? this.cgmes.connectivityNodes() : this.cgmes.topologicalNodes();
        if (context.nodeBreaker()) {
            this.convert(nodes, "ConnectivityNode", context);
        } else {
            this.convert(nodes, "TopologicalNode", context);
        }
        if (!context.config().createBusbarSectionForEveryConnectivityNode()) {
            this.convert(this.cgmes.busBarSections(), "BusbarSection", context);
        }
        this.convert(this.cgmes.grounds(), "Ground", context);
        this.convert(this.cgmes.energyConsumers(), "EnergyConsumer", context);
        this.convert(this.cgmes.energySources(), "EnergySource", context);
        this.convert(this.cgmes.equivalentInjections(), "EquivalentInjection", context);
        this.convert(this.cgmes.externalNetworkInjections(), "ExternalNetworkInjection", context);
        this.convert(this.cgmes.shuntCompensators(), "ShuntCompensator", context);
        this.convert(this.cgmes.equivalentShunts(), "EquivalentShunt", context);
        this.convert(this.cgmes.staticVarCompensators(), "StaticVarCompensator", context);
        this.convert(this.cgmes.asynchronousMachines(), "AsynchronousMachine", context);
        this.convert(this.cgmes.synchronousMachinesAll(), "SynchronousMachine", context);
        HashSet<String> delayedBoundaryNodes = new HashSet<String>();
        this.convertSwitches(context, delayedBoundaryNodes);
        this.convertACLineSegmentsToLines(context, delayedBoundaryNodes);
        this.convertEquivalentBranchesToLines(context, delayedBoundaryNodes);
        this.convert(this.cgmes.seriesCompensators(), "SeriesCompensator", context);
        this.convertTransformers(context, delayedBoundaryNodes);
        context.pushReportNode(CgmesReports.convertingElementTypeReport(reportNode, "equipments at boundaries"));
        delayedBoundaryNodes.forEach(node -> this.convertEquipmentAtBoundaryNode(context, (String)node));
        context.popReportNode();
        context.pushReportNode(CgmesReports.convertingElementTypeReport(reportNode, "DC network"));
        new DCConversion(this.cgmes, context);
        this.clearUnattachedHvdcConverterStations(network, context);
        context.popReportNode();
        this.convert(this.cgmes.operationalLimits(), "OperationalLimit", context);
        context.loadingLimitsMapping().addAll();
        this.setSelectedOperationalLimitsGroup(context);
        if (this.config.importControlAreas()) {
            this.convert(this.cgmes.controlAreas(), "ControlArea", context);
            this.convert(this.cgmes.tieFlows(), "TieFlow", context);
        }
        context.pushReportNode(CgmesReports.convertingElementTypeReport(reportNode, "RegulatingControl"));
        context.regulatingControlMapping().setAllRegulatingControls(network);
        context.popReportNode();
        if (this.config.debugTopology()) {
            this.debugTopology(context);
        }
        if (this.config.storeCgmesModelAsNetworkExtension()) {
            ((CgmesModelExtensionAdder)network.newExtension(CgmesModelExtensionAdder.class)).withModel(this.cgmes).add();
        }
        if (this.config.storeCgmesConversionContextAsNetworkExtension()) {
            ((CgmesConversionContextExtensionAdder)network.newExtension(CgmesConversionContextExtensionAdder.class)).withContext(context).add();
        }
        ReportNode postProcessorsNode = CgmesReports.applyingPostprocessorsReport(reportNode);
        for (CgmesImportPostProcessor postProcessor : this.postProcessors) {
            CgmesReports.applyingProcessorReport(postProcessorsNode, postProcessor.getName());
            postProcessor.process(network, this.cgmes.tripleStore());
        }
        CgmesReports.importedCgmesNetworkReport(reportNode, network.getId());
        this.updateWithAllInputs(network, reportNode);
        return network;
    }

    private void updateWithAllInputs(Network network, ReportNode reportNode) {
        if (!Conversion.sshOrSvIsIncludedInCgmesModel(this.cgmes)) {
            return;
        }
        this.cgmes.setQueryCatalog(QUERY_CATALOG_NAME_UPDATE);
        Context updateContext = this.createUpdateContext(network, reportNode);
        Update.createFictitiousSwitchesForDisconnectedTerminalsDuringUpdate(network, this.cgmes, updateContext);
        Update.createTieLinesWhenThereAreMoreThanTwoDanglingLinesAtBoundaryNodeDuringUpdate(network, updateContext);
        Update.createFictitiousLoadsForSvInjectionsDuringUpdate(network, this.cgmes, updateContext);
        this.update(network, updateContext, reportNode);
    }

    private static boolean sshOrSvIsIncludedInCgmesModel(CgmesModel cgmes) {
        return cgmes.fullModels().stream().map(fullModel -> fullModel.getId("profileList")).anyMatch(profileList -> profileList.contains("SteadyStateHypothesis") || profileList.contains("StateVariables"));
    }

    public void update(Network network, ReportNode reportNode) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(reportNode);
        Context updateContext = this.createUpdateContext(network, reportNode);
        this.addMetadataModels(network, updateContext);
        this.update(network, updateContext, reportNode);
    }

    private void update(Network network, Context updateContext, ReportNode reportNode) {
        if (LOG.isDebugEnabled()) {
            PropertyBags nts = this.cgmes.numObjectsByType();
            LOG.debug("CGMES objects read for the update:");
            nts.forEach(nt -> LOG.debug(String.format("  %5d %s", nt.asInt("numObjects"), nt.getLocal("Type"))));
            nts.forEach(nt -> LOG.debug(this.cgmes.allObjectsOfType(nt.getLocal("Type")).tabulateLocals()));
        }
        Update.updateSwitches(network, updateContext);
        Update.updateLoads(network, this.cgmes, updateContext);
        Update.updateGenerators(network, this.cgmes, updateContext);
        Update.updateLines(network, updateContext);
        Update.updateTransformers(network, updateContext);
        Update.updateStaticVarCompensators(network, this.cgmes, updateContext);
        Update.updateShuntCompensators(network, this.cgmes, updateContext);
        Update.updateHvdcLines(network, this.cgmes, updateContext);
        Update.updateDanglingLines(network, updateContext);
        updateContext.pushReportNode(CgmesReports.fixingDanglingLinesIssuesReport(reportNode));
        this.handleDangingLineDisconnectedAtBoundary(network, updateContext);
        this.adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode(network, updateContext);
        updateContext.popReportNode();
        Update.updateVoltageLevels(network, updateContext);
        Update.updateGrounds(network, updateContext);
        Update.updateAreas(network, this.cgmes, updateContext);
        Update.updateAndCompleteVoltageAndAngles(network, updateContext);
        network.runValidationChecks(false, reportNode);
        network.setMinimumAcceptableValidationLevel(ValidationLevel.STEADY_STATE_HYPOTHESIS);
    }

    private void setSelectedOperationalLimitsGroup(Context context) {
        context.network().getBranchStream().map(b -> b).forEach(branch -> {
            Collection limitsHolder2;
            Collection limitsHolder1 = branch.getOperationalLimitsGroups1();
            if (limitsHolder1.size() == 1) {
                branch.setSelectedOperationalLimitsGroup1(((OperationalLimitsGroup)limitsHolder1.iterator().next()).getId());
            }
            if ((limitsHolder2 = branch.getOperationalLimitsGroups2()).size() == 1) {
                branch.setSelectedOperationalLimitsGroup2(((OperationalLimitsGroup)limitsHolder2.iterator().next()).getId());
            }
        });
        context.network().getDanglingLineStream().forEach(dl -> {
            Collection limitsHolder = dl.getOperationalLimitsGroups();
            if (limitsHolder.size() == 1) {
                dl.setSelectedOperationalLimitsGroup(((OperationalLimitsGroup)limitsHolder.iterator().next()).getId());
            }
        });
        context.network().getThreeWindingsTransformerStream().flatMap(ThreeWindingsTransformer::getLegStream).forEach(leg -> {
            Collection limitsHolder = leg.getOperationalLimitsGroups();
            if (limitsHolder.size() == 1) {
                leg.setSelectedOperationalLimitsGroup(((OperationalLimitsGroup)limitsHolder.iterator().next()).getId());
            }
        });
    }

    private void handleDangingLineDisconnectedAtBoundary(Network network, Context context) {
        if (this.config.disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected()) {
            for (DanglingLine dl : network.getDanglingLines()) {
                if (AbstractConductingEquipmentConversion.isBoundaryTerminalConnected(dl, context) || !dl.getTerminal().isConnected()) continue;
                LOG.warn("DanglingLine {} was connected at network side and disconnected at boundary side. It has been disconnected also at network side.", (Object)dl.getId());
                CgmesReports.danglingLineDisconnectedAtBoundaryHasBeenDisconnectedReport(context.getReportNode(), dl.getId());
                dl.getTerminal().disconnect();
            }
        }
    }

    private void adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode(Network network, Context context) {
        network.getDanglingLineStream(DanglingLineFilter.UNPAIRED).filter(dl -> dl.getTerminal().isConnected()).collect(Collectors.groupingBy(Conversion::getDanglingLineBoundaryNode)).values().stream().filter(dls -> dls.size() > 1).forEach(dls -> this.adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode((List<DanglingLine>)dls, context));
    }

    private void adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode(List<DanglingLine> dls, Context context) {
        double p0 = dls.get(0).getP0();
        double q0 = dls.get(0).getQ0();
        long count = dls.size();
        double p0Adjusted = p0 / (double)count;
        double q0Adjusted = q0 / (double)count;
        dls.forEach(dl -> {
            LOG.warn("Multiple unpaired DanglingLines were connected at the same boundary side. Adjusted original injection from ({}, {}) to ({}, {}) for dangling line {}.", new Object[]{p0, q0, p0Adjusted, q0Adjusted, dl.getId()});
            CgmesReports.multipleUnpairedDanglingLinesAtSameBoundaryReport(context.getReportNode(), dl.getId(), p0, q0, p0Adjusted, q0Adjusted);
            dl.setP0(p0Adjusted);
            dl.setQ0(q0Adjusted);
        });
    }

    public static String getDanglingLineBoundaryNode(DanglingLine dl) {
        String node = dl.getProperty("CGMES.ConnectivityNode_Boundary");
        if (node == null) {
            node = dl.getProperty("CGMES.TopologicalNode_Boundary");
        }
        if (node == null) {
            LOG.warn("Dangling line {} does not have a boundary node identifier.", (Object)dl.getId());
            node = "unknown";
        }
        return node;
    }

    private Source isBoundaryBaseVoltage(String graph) {
        return graph.contains("EQ") && graph.contains("BD") ? Source.BOUNDARY : Source.IGM;
    }

    private void convert(PropertyBags elements, String elementType, Context context) {
        context.pushReportNode(CgmesReports.convertingElementTypeReport(context.getReportNode(), elementType));
        for (PropertyBag element : elements) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(element.tabulateLocals(elementType));
            }
            AbstractIdentifiedObjectConversion c = switch (elementType) {
                case "Substation" -> new SubstationConversion(element, context);
                case "VoltageLevel" -> new VoltageLevelConversion(element, context);
                case "ConnectivityNode", "TopologicalNode" -> new NodeConversion(elementType, element, context);
                case "BusbarSection" -> new BusbarSectionConversion(element, context);
                case "Ground" -> new GroundConversion(element, context);
                case "EnergyConsumer" -> new EnergyConsumerConversion(element, context);
                case "EnergySource" -> new EnergySourceConversion(element, context);
                case "EquivalentInjection" -> new EquivalentInjectionConversion(element, context);
                case "ExternalNetworkInjection" -> new ExternalNetworkInjectionConversion(element, context);
                case "ShuntCompensator" -> new ShuntConversion(element, context);
                case "EquivalentShunt" -> new EquivalentShuntConversion(element, context);
                case "StaticVarCompensator" -> new StaticVarCompensatorConversion(element, context);
                case "AsynchronousMachine" -> new AsynchronousMachineConversion(element, context);
                case "SynchronousMachine" -> new SynchronousMachineConversion(element, context);
                case "SeriesCompensator" -> new SeriesCompensatorConversion(element, context);
                case "OperationalLimit" -> new OperationalLimitConversion(element, context);
                case "ControlArea" -> new ControlAreaConversion(element, context);
                case "TieFlow" -> new TieFlowConversion(element, context);
                default -> throw new IllegalArgumentException("Invalid elementType.");
            };
            if (c.insideBoundary()) {
                c.convertInsideBoundary();
                continue;
            }
            if (!c.valid()) continue;
            c.convert();
        }
        context.popReportNode();
    }

    private Network createNetwork() {
        String networkId = this.cgmes.modelId();
        String sourceFormat = "CGMES";
        return this.networkFactory.createNetwork(networkId, sourceFormat);
    }

    private Context createUpdateContext(Network network, ReportNode reportNode) {
        Context context = new Context(this.cgmes, this.config, network, reportNode);
        context.buildUpdateCache();
        return context;
    }

    private void assignNetworkProperties(Context context) {
        context.network().setProperty(NETWORK_PS_CGMES_MODEL_DETAIL, context.nodeBreaker() ? NETWORK_PS_CGMES_MODEL_DETAIL_NODE_BREAKER : NETWORK_PS_CGMES_MODEL_DETAIL_BUS_BRANCH);
        PropertyBags modelProfiles = context.cgmes().modelProfiles();
        String fullModel = "FullModel";
        modelProfiles.sort(Comparator.comparing(p -> p.getId(fullModel)));
        for (PropertyBag modelProfile : modelProfiles) {
            String profile;
            if (modelProfile.getId(fullModel).equals(context.network().getId()) || (profile = CgmesNamespace.getProfile((String)modelProfile.getId("profile"))) == null || "EQ_OP".equals(profile) || "SV".equals(profile)) continue;
            context.network().setProperty(Identifiables.getUniqueId((String)(CGMES_PREFIX_ALIAS_PROPERTIES + profile + "_ID"), property -> context.network().hasProperty(property)), modelProfile.getId(fullModel));
        }
        ZonedDateTime modelScenarioTime = this.cgmes.scenarioTime();
        ZonedDateTime modelCreated = this.cgmes.created();
        long forecastDistance = Duration.between(modelCreated, modelScenarioTime).toMinutes();
        context.network().setForecastDistance(forecastDistance >= 0L ? (int)forecastDistance : 0);
        context.network().setCaseDate(modelScenarioTime);
        LOG.info("cgmes scenarioTime       : {}", (Object)modelScenarioTime);
        LOG.info("cgmes modelCreated       : {}", (Object)modelCreated);
        LOG.info("network caseDate         : {}", (Object)context.network().getCaseDate());
        LOG.info("network forecastDistance : {}", (Object)context.network().getForecastDistance());
    }

    private void addMetadataModels(Network network, Context context) {
        PropertyBags ps = this.cgmes.fullModels();
        if (ps.isEmpty()) {
            return;
        }
        CgmesMetadataModels previous = (CgmesMetadataModels)network.getExtension(CgmesMetadataModels.class);
        CgmesMetadataModelsAdder modelsAdder = (CgmesMetadataModelsAdder)network.newExtension(CgmesMetadataModelsAdder.class);
        if (previous != null) {
            previous.getModels().stream().filter(model -> !this.isSubSetIncluded(ps, model.getSubset())).forEach(model -> {
                CgmesMetadataModelsAdder.ModelAdder modelAdder = modelsAdder.newModel().setId(model.getId()).setSubset(model.getSubset()).setDescription(model.getDescription()).setVersion(model.getVersion()).setModelingAuthoritySet(model.getModelingAuthoritySet());
                model.getProfiles().forEach(arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addProfile(arg_0));
                model.getDependentOn().forEach(arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addDependentOn(arg_0));
                model.getSupersedes().forEach(arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addSupersedes(arg_0));
                modelAdder.add();
            });
            network.removeExtension(CgmesMetadataModels.class);
        }
        for (PropertyBag p : ps) {
            CgmesMetadataModelsAdder.ModelAdder modelAdder = modelsAdder.newModel().setId(p.getId("FullModel")).setSubset(this.subsetFromGraph(p.getLocal("graph"))).setDescription(p.getId("description")).setVersion(this.readVersion(p, context)).setModelingAuthoritySet(p.getId("modelingAuthoritySet"));
            this.addMetadataModelReferences(p, "profileList", arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addProfile(arg_0));
            this.addMetadataModelReferences(p, "dependentOnList", arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addDependentOn(arg_0));
            this.addMetadataModelReferences(p, "supersedesList", arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addSupersedes(arg_0));
            modelAdder.add();
        }
        modelsAdder.add();
    }

    private boolean isSubSetIncluded(PropertyBags ps, CgmesSubset subSet) {
        return ps.stream().anyMatch(p -> subSet == this.subsetFromGraph(p.getLocal("graph")));
    }

    private void addMetadataModelReferences(PropertyBag p, String refsProperty, Function<String, CgmesMetadataModelsAdder.ModelAdder> adder) {
        String refs = (String)p.get((Object)refsProperty);
        if (refs != null && !refs.isEmpty()) {
            for (String ref : refs.split(" ")) {
                adder.apply(ref);
            }
        }
    }

    private CgmesSubset subsetFromGraph(String graph) {
        return Stream.of(CgmesSubset.values()).filter(subset -> subset.isValidName(graph)).findFirst().orElse(CgmesSubset.UNKNOWN);
    }

    private int readVersion(PropertyBag propertyBag, Context context) {
        try {
            return propertyBag.asInt("version");
        }
        catch (NumberFormatException e) {
            context.fixed("Version", "The version is expected to be an integer: " + (String)propertyBag.get((Object)"version") + ". Fixed to 1");
            return 1;
        }
    }

    private void addCimCharacteristics(Network network) {
        CgmesModel cgmesModel = this.cgmes;
        if (cgmesModel instanceof CgmesModelTripleStore) {
            CgmesModelTripleStore cgmesModelTripleStore = (CgmesModelTripleStore)cgmesModel;
            ((CimCharacteristicsAdder)network.newExtension(CimCharacteristicsAdder.class)).setTopologyKind(this.cgmes.isNodeBreaker() ? CgmesTopologyKind.NODE_BREAKER : CgmesTopologyKind.BUS_BRANCH).setCimVersion(cgmesModelTripleStore.getCimVersion()).add();
        }
    }

    private void convertACLineSegmentsToLines(Context context, Set<String> delayedBoundaryNodes) {
        context.pushReportNode(CgmesReports.convertingElementTypeReport(context.getReportNode(), "ACLineSegment"));
        for (PropertyBag line : this.cgmes.acLineSegments()) {
            ACLineSegmentConversion c;
            if (LOG.isTraceEnabled()) {
                LOG.trace(line.tabulateLocals("ACLineSegment"));
            }
            if (!(c = new ACLineSegmentConversion(line, context)).valid()) continue;
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addAcLineSegmentAtNode(line, node);
                delayedBoundaryNodes.add(node);
                continue;
            }
            c.convert();
        }
        context.popReportNode();
    }

    private void createFictitiousVoltageLevelsForLineContainers(Context context) {
        context.nodeContainerMapping().getFictitiousVoltageLevelsForLineContainersToBeCreated().forEach(fictitiousVoltageLevelId -> {
            String containerId = context.nodeContainerMapping().getContainerId((String)fictitiousVoltageLevelId).orElseThrow();
            String containerName = context.nodeContainerMapping().getContainerName((String)fictitiousVoltageLevelId).orElseThrow();
            String referenceVoltageLevelId = context.nodeContainerMapping().getReferenceVoltageLevelId((String)fictitiousVoltageLevelId).orElseThrow();
            if (context.network().getVoltageLevel(fictitiousVoltageLevelId) == null) {
                VoltageLevel referenceVoltageLevel = context.network().getVoltageLevel(referenceVoltageLevelId);
                if (referenceVoltageLevel == null) {
                    throw new ConversionException("VoltageLevel not found for voltageLevelId: " + referenceVoltageLevelId);
                }
                this.createFictitiousVoltageLevelsForLineContainer(context, (String)fictitiousVoltageLevelId, containerId, containerName, referenceVoltageLevel);
            }
        });
    }

    private void createFictitiousVoltageLevelsForLineContainer(Context context, String fictitiousVoltageLevelId, String containerId, String containerName, VoltageLevel vlref) {
        LOG.warn("Fictitious Voltage Level {} created for Line container {} name {}", new Object[]{fictitiousVoltageLevelId, containerId, containerName});
        VoltageLevel vl = ((VoltageLevelAdder)((VoltageLevelAdder)((VoltageLevelAdder)((VoltageLevelAdder)context.network().newVoltageLevel().setNominalV(vlref.getNominalV()).setTopologyKind(context.nodeBreaker() ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER).setLowVoltageLimit(vlref.getLowVoltageLimit()).setHighVoltageLimit(vlref.getHighVoltageLimit()).setId(fictitiousVoltageLevelId)).setFictitious(true)).setName(containerName)).setEnsureIdUnicity(context.config().isEnsureIdAliasUnicity())).add();
        vl.setProperty("CGMES.LineContainerId", containerId);
    }

    private void convertSwitches(Context context, Set<String> delayedBoundaryNodes) {
        context.pushReportNode(CgmesReports.convertingElementTypeReport(context.getReportNode(), "Switch"));
        for (PropertyBag sw : this.cgmes.switches()) {
            SwitchConversion c;
            if (LOG.isTraceEnabled()) {
                LOG.trace(sw.tabulateLocals("Switch"));
            }
            if (!(c = new SwitchConversion(sw, context)).valid()) continue;
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addSwitchAtNode(sw, node);
                delayedBoundaryNodes.add(node);
                continue;
            }
            c.convert();
        }
        context.popReportNode();
    }

    private void convertEquivalentBranchesToLines(Context context, Set<String> delayedBoundaryNodes) {
        context.pushReportNode(CgmesReports.convertingElementTypeReport(context.getReportNode(), "EquivalentBranch"));
        for (PropertyBag equivalentBranch : this.cgmes.equivalentBranches()) {
            EquivalentBranchConversion c;
            if (LOG.isTraceEnabled()) {
                LOG.trace(equivalentBranch.tabulateLocals("EquivalentBranch"));
            }
            if (!(c = new EquivalentBranchConversion(equivalentBranch, context)).valid()) continue;
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addEquivalentBranchAtNode(equivalentBranch, node);
                delayedBoundaryNodes.add(node);
                continue;
            }
            c.convert();
        }
        context.popReportNode();
    }

    private void convertTransformers(Context context, Set<String> delayedBoundaryNodes) {
        context.pushReportNode(CgmesReports.convertingElementTypeReport(context.getReportNode(), "PowerTransformer"));
        this.cgmes.transformers().stream().map(t -> context.transformerEnds(t.getId("PowerTransformer"))).forEach(ends -> {
            String transformerId = ((PropertyBag)ends.get(0)).getId("PowerTransformer");
            if (LOG.isTraceEnabled()) {
                LOG.trace("Transformer {}, {}-winding", (Object)transformerId, (Object)ends.size());
                ends.forEach(e -> LOG.trace(e.tabulateLocals("TransformerEnd")));
            }
            if (ends.size() == 2) {
                Conversion.convertTwoWindingsTransformers(context, ends, delayedBoundaryNodes);
            } else if (ends.size() == 3) {
                Conversion.convertThreeWindingsTransformers(context, ends);
            } else {
                String what = "PowerTransformer " + transformerId;
                Supplier<String> reason = () -> String.format("Has %d ends. Only 2 or 3 ends are supported", ends.size());
                context.invalid(what, reason);
            }
        });
        context.popReportNode();
    }

    private static void convertTwoWindingsTransformers(Context context, PropertyBags ends, Set<String> delayedBoundaryNodes) {
        TwoWindingsTransformerConversion c = new TwoWindingsTransformerConversion(ends, context);
        if (((AbstractConductingEquipmentConversion)c).valid()) {
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addTransformerAtNode(ends, node);
                delayedBoundaryNodes.add(node);
            } else {
                ((AbstractObjectConversion)c).convert();
            }
        }
    }

    private static void convertThreeWindingsTransformers(Context context, PropertyBags ends) {
        ThreeWindingsTransformerConversion c = new ThreeWindingsTransformerConversion(ends, context);
        if (c.valid()) {
            ((AbstractObjectConversion)c).convert();
        }
    }

    private void convertEquipmentAtBoundaryNode(Context context, String node) {
        int numEquipmentsAtNode;
        List<BoundaryEquipment> beqs = context.boundary().boundaryEquipmentAtNode(node);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delayed boundary node {} with {} equipment at it", (Object)node, (Object)beqs.size());
            beqs.forEach(BoundaryEquipment::log);
        }
        if ((numEquipmentsAtNode = beqs.size()) == 1) {
            beqs.get(0).createConversion(context).convertAtBoundary();
        } else if (numEquipmentsAtNode == 2) {
            Conversion.convertTwoEquipmentsAtBoundaryNode(context, node, beqs.get(0), beqs.get(1));
        } else {
            context.fixed(node, "More than two AcLineSegments at boundary: only dangling lines are created. Please note that the converted IIDM network will probably not be equivalent to the CGMES network.");
            beqs.forEach(beq -> beq.createConversion(context).convertAtBoundary());
        }
    }

    private static void convertTwoEquipmentsAtBoundaryNode(Context context, String node, BoundaryEquipment beq1, BoundaryEquipment beq2) {
        EquipmentAtBoundaryConversion conversion1 = beq1.createConversion(context);
        EquipmentAtBoundaryConversion conversion2 = beq2.createConversion(context);
        TieLineConversion.create(node, conversion1, conversion2, context);
    }

    private void clearUnattachedHvdcConverterStations(Network network, Context context) {
        network.getHvdcConverterStationStream().filter(converter -> converter.getHvdcLine() == null).forEach(converter -> {
            CgmesReports.removingUnattachedHvdcConverterStationReport(context.getReportNode(), converter.getId());
            context.ignored("HVDC Converter Station " + converter.getId(), "No correct linked HVDC line found.");
            converter.remove();
        });
    }

    private void debugTopology(Context context) {
        context.network().getVoltageLevels().forEach(vl -> {
            Object name = vl.getSubstation().map(s -> s.getNameOrId() + "-").orElse(QUERY_CATALOG_NAME_INIT) + vl.getNameOrId();
            name = ((String)name).replace('/', '-');
            Path file = Paths.get(System.getProperty("java.io.tmpdir"), "temp-cgmes-" + (String)name + ".dot");
            try {
                vl.exportTopology(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static class Config {
        private boolean convertBoundary = false;
        private boolean createBusbarSectionForEveryConnectivityNode = false;
        private boolean convertSvInjections = true;
        private boolean storeCgmesModelAsNetworkExtension = true;
        private boolean storeCgmesConversionContextAsNetworkExtension = false;
        private boolean createActivePowerControlExtension = false;
        private CgmesImport.FictitiousSwitchesCreationMode createFictitiousSwitchesForDisconnectedTerminalsMode = CgmesImport.FictitiousSwitchesCreationMode.ALWAYS;
        private boolean ensureIdAliasUnicity = false;
        private boolean importControlAreas = true;
        private boolean importNodeBreakerAsBusBreaker = false;
        private boolean disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected = true;
        private NamingStrategy namingStrategy = new NamingStrategy.Identity();
        private Xfmr2RatioPhaseInterpretationAlternative xfmr2RatioPhase = Xfmr2RatioPhaseInterpretationAlternative.END1_END2;
        private Xfmr2ShuntInterpretationAlternative xfmr2Shunt = Xfmr2ShuntInterpretationAlternative.END1_END2;
        private Xfmr2StructuralRatioInterpretationAlternative xfmr2StructuralRatio = Xfmr2StructuralRatioInterpretationAlternative.X;
        private Xfmr3RatioPhaseInterpretationAlternative xfmr3RatioPhase = Xfmr3RatioPhaseInterpretationAlternative.NETWORK_SIDE;
        private Xfmr3ShuntInterpretationAlternative xfmr3Shunt = Xfmr3ShuntInterpretationAlternative.NETWORK_SIDE;
        private Xfmr3StructuralRatioInterpretationAlternative xfmr3StructuralRatio = Xfmr3StructuralRatioInterpretationAlternative.STAR_BUS_SIDE;
        private double missingPermanentLimitPercentage = 100.0;
        private boolean createFictitiousVoltageLevelsForEveryNode = true;
        private static final boolean UPDATE_TERMINAL_CONNECTION_IN_NODE_BREAKER_VOLTAGE_LEVEL = false;
        private boolean usePreviousValuesDuringUpdate = false;

        public List<String> substationIdsExcludedFromMapping() {
            return Collections.emptyList();
        }

        public boolean debugTopology() {
            return false;
        }

        public boolean importNodeBreakerAsBusBreaker() {
            return this.importNodeBreakerAsBusBreaker;
        }

        public Config setImportNodeBreakerAsBusBreaker(boolean importNodeBreakerAsBusBreaker) {
            this.importNodeBreakerAsBusBreaker = importNodeBreakerAsBusBreaker;
            return this;
        }

        public boolean convertBoundary() {
            return this.convertBoundary;
        }

        public Config setConvertBoundary(boolean convertBoundary) {
            this.convertBoundary = convertBoundary;
            return this;
        }

        public boolean computeFlowsAtBoundaryDanglingLines() {
            return true;
        }

        public boolean createBusbarSectionForEveryConnectivityNode() {
            return this.createBusbarSectionForEveryConnectivityNode;
        }

        public Config setCreateBusbarSectionForEveryConnectivityNode(boolean b) {
            this.createBusbarSectionForEveryConnectivityNode = b;
            return this;
        }

        public boolean convertSvInjections() {
            return this.convertSvInjections;
        }

        public Config setConvertSvInjections(boolean convertSvInjections) {
            this.convertSvInjections = convertSvInjections;
            return this;
        }

        public boolean storeCgmesModelAsNetworkExtension() {
            return this.storeCgmesModelAsNetworkExtension;
        }

        public Config setStoreCgmesModelAsNetworkExtension(boolean storeCgmesModelAsNetworkExtension) {
            this.storeCgmesModelAsNetworkExtension = storeCgmesModelAsNetworkExtension;
            return this;
        }

        public boolean storeCgmesConversionContextAsNetworkExtension() {
            return this.storeCgmesConversionContextAsNetworkExtension;
        }

        public Config setStoreCgmesConversionContextAsNetworkExtension(boolean storeCgmesTerminalMappingAsNetworkExtension) {
            this.storeCgmesConversionContextAsNetworkExtension = storeCgmesTerminalMappingAsNetworkExtension;
            return this;
        }

        public boolean createActivePowerControlExtension() {
            return this.createActivePowerControlExtension;
        }

        public Config setCreateActivePowerControlExtension(boolean createActivePowerControlExtension) {
            this.createActivePowerControlExtension = createActivePowerControlExtension;
            return this;
        }

        public boolean isEnsureIdAliasUnicity() {
            return this.ensureIdAliasUnicity;
        }

        public Config setEnsureIdAliasUnicity(boolean ensureIdAliasUnicity) {
            this.ensureIdAliasUnicity = ensureIdAliasUnicity;
            return this;
        }

        public boolean importControlAreas() {
            return this.importControlAreas;
        }

        public Config setImportControlAreas(boolean importControlAreas) {
            this.importControlAreas = importControlAreas;
            return this;
        }

        public NamingStrategy getNamingStrategy() {
            return this.namingStrategy;
        }

        public Config setNamingStrategy(NamingStrategy namingStrategy) {
            this.namingStrategy = Objects.requireNonNull(namingStrategy);
            return this;
        }

        public Xfmr2RatioPhaseInterpretationAlternative getXfmr2RatioPhase() {
            return this.xfmr2RatioPhase;
        }

        public void setXfmr2RatioPhase(Xfmr2RatioPhaseInterpretationAlternative alternative) {
            this.xfmr2RatioPhase = alternative;
        }

        public Xfmr2ShuntInterpretationAlternative getXfmr2Shunt() {
            return this.xfmr2Shunt;
        }

        public void setXfmr2Shunt(Xfmr2ShuntInterpretationAlternative alternative) {
            this.xfmr2Shunt = alternative;
        }

        public Xfmr2StructuralRatioInterpretationAlternative getXfmr2StructuralRatio() {
            return this.xfmr2StructuralRatio;
        }

        public void setXfmr2StructuralRatio(Xfmr2StructuralRatioInterpretationAlternative alternative) {
            this.xfmr2StructuralRatio = alternative;
        }

        public Xfmr3RatioPhaseInterpretationAlternative getXfmr3RatioPhase() {
            return this.xfmr3RatioPhase;
        }

        public void setXfmr3RatioPhase(Xfmr3RatioPhaseInterpretationAlternative alternative) {
            this.xfmr3RatioPhase = alternative;
        }

        public Xfmr3ShuntInterpretationAlternative getXfmr3Shunt() {
            return this.xfmr3Shunt;
        }

        public void setXfmr3Shunt(Xfmr3ShuntInterpretationAlternative alternative) {
            this.xfmr3Shunt = alternative;
        }

        public Xfmr3StructuralRatioInterpretationAlternative getXfmr3StructuralRatio() {
            return this.xfmr3StructuralRatio;
        }

        public void setXfmr3StructuralRatio(Xfmr3StructuralRatioInterpretationAlternative alternative) {
            this.xfmr3StructuralRatio = alternative;
        }

        public double getMissingPermanentLimitPercentage() {
            return this.missingPermanentLimitPercentage;
        }

        public Config setMissingPermanentLimitPercentage(double missingPermanentLimitPercentage) {
            if (missingPermanentLimitPercentage < 0.0 || missingPermanentLimitPercentage > 100.0) {
                throw new IllegalArgumentException("Missing permanent limit percentage must be between 0 and 100.");
            }
            this.missingPermanentLimitPercentage = missingPermanentLimitPercentage;
            return this;
        }

        public CgmesImport.FictitiousSwitchesCreationMode getCreateFictitiousSwitchesForDisconnectedTerminalsMode() {
            return this.createFictitiousSwitchesForDisconnectedTerminalsMode;
        }

        public Config createFictitiousSwitchesForDisconnectedTerminalsMode(CgmesImport.FictitiousSwitchesCreationMode createFictitiousSwitchesForDisconnectedTerminalsMode) {
            this.createFictitiousSwitchesForDisconnectedTerminalsMode = createFictitiousSwitchesForDisconnectedTerminalsMode;
            return this;
        }

        public Config setDisconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected(boolean b) {
            this.disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected = b;
            return this;
        }

        public boolean disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected() {
            return this.disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected;
        }

        public boolean updateTerminalConnectionInNodeBreakerVoltageLevel() {
            return false;
        }

        public List<DefaultValue> updateDefaultValuesPriority() {
            return this.usePreviousValuesDuringUpdate ? List.of(DefaultValue.PREVIOUS, DefaultValue.EQ, DefaultValue.DEFAULT, DefaultValue.EMPTY) : List.of(DefaultValue.EQ, DefaultValue.DEFAULT, DefaultValue.EMPTY);
        }

        public boolean getCreateFictitiousVoltageLevelsForEveryNode() {
            return this.createFictitiousVoltageLevelsForEveryNode;
        }

        public Config setCreateFictitiousVoltageLevelsForEveryNode(boolean b) {
            this.createFictitiousVoltageLevelsForEveryNode = b;
            return this;
        }

        public Config setUsePreviousValuesDuringUpdate(boolean use) {
            this.usePreviousValuesDuringUpdate = use;
            return this;
        }

        public static enum DefaultValue {
            EQ,
            DEFAULT,
            EMPTY,
            PREVIOUS;

        }
    }

    public static enum Xfmr3StructuralRatioInterpretationAlternative {
        NETWORK_SIDE,
        STAR_BUS_SIDE,
        END1,
        END2,
        END3;

    }

    public static enum Xfmr3ShuntInterpretationAlternative {
        NETWORK_SIDE,
        STAR_BUS_SIDE,
        SPLIT;

    }

    public static enum Xfmr3RatioPhaseInterpretationAlternative {
        NETWORK_SIDE,
        STAR_BUS_SIDE;

    }

    public static enum Xfmr2StructuralRatioInterpretationAlternative {
        END1,
        END2,
        X;

    }

    public static enum Xfmr2ShuntInterpretationAlternative {
        END1,
        END2,
        END1_END2,
        SPLIT;

    }

    public static enum Xfmr2RatioPhaseInterpretationAlternative {
        END1,
        END2,
        END1_END2,
        X;

    }
}

