/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.HashMap;
import java.util.Map;

public class NodeMapping {
    private final Map<String, Integer> cgmes2iidm = new HashMap<String, Integer>(100);
    private final Map<VoltageLevel, Integer> voltageLevelNumNodes = new HashMap<VoltageLevel, Integer>(100);

    public int iidmNodeForTopologicalNode(String id, int associatedNode, VoltageLevel vl) {
        String uniqueId;
        int i = 0;
        while (this.cgmes2iidm.containsKey(uniqueId = id + "#" + i++) && i < Integer.MAX_VALUE) {
        }
        int iidmNodeForTopologicalNode = this.newNode(vl);
        this.cgmes2iidm.put(uniqueId, iidmNodeForTopologicalNode);
        vl.getNodeBreakerView().newInternalConnection().setNode1(iidmNodeForTopologicalNode).setNode2(associatedNode).add();
        return iidmNodeForTopologicalNode;
    }

    public int iidmNodeForTerminal(CgmesTerminal t, VoltageLevel vl) {
        int iidmNodeForConductingEquipment = this.cgmes2iidm.computeIfAbsent(t.id(), id -> this.newNode(vl));
        int iidmNodeForConnectivityNode = this.cgmes2iidm.computeIfAbsent(t.connectivityNode(), id -> this.newNode(vl));
        vl.getNodeBreakerView().newInternalConnection().setNode1(iidmNodeForConductingEquipment).setNode2(iidmNodeForConnectivityNode).add();
        return iidmNodeForConductingEquipment;
    }

    public int iidmNodeForConnectivityNode(String id, VoltageLevel vl) {
        return this.cgmes2iidm.computeIfAbsent(id, k -> this.newNode(vl));
    }

    private int newNode(VoltageLevel vl) {
        int numNodes = this.voltageLevelNumNodes.merge(vl, 1, Integer::sum);
        return numNodes - 1;
    }
}

