/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;

public class RegulatingControlMappingForShuntCompensators {
    private final RegulatingControlMapping parent;
    private final Context context;
    private final Map<String, String> mapping;

    RegulatingControlMappingForShuntCompensators(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.mapping = new HashMap<String, String>();
    }

    public void add(String iidmId, PropertyBag p) {
        String rcId = RegulatingControlMapping.getRegulatingControlId(p);
        if (this.mapping.containsKey(iidmId)) {
            throw new CgmesModelException("ShuntCompensator already added, IIDM ShuntCompensator Id: " + iidmId);
        }
        this.mapping.put(iidmId, rcId);
    }

    void applyRegulatingControls(Network network) {
        network.getShuntCompensatorStream().forEach(this::apply);
    }

    private void apply(ShuntCompensator shuntCompensator) {
        String regulatingControlId = this.mapping.get(shuntCompensator.getId());
        if (regulatingControlId == null) {
            return;
        }
        RegulatingControlMapping.RegulatingControl rc = this.parent.cachedRegulatingControls().get(regulatingControlId);
        if (rc == null) {
            return;
        }
        this.setRegulatingControl(shuntCompensator, regulatingControlId, rc);
        rc.setCorrectlySet(true);
    }

    private void setRegulatingControl(ShuntCompensator shuntCompensator, String rcId, RegulatingControlMapping.RegulatingControl rc) {
        shuntCompensator.setRegulatingTerminal(RegulatingTerminalMapper.mapForVoltageControl(rc.cgmesTerminal, this.context).orElse(shuntCompensator.getTerminal()));
        shuntCompensator.setProperty("CGMES.RegulatingControl", rcId);
    }
}

