/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegulatingControlMappingForStaticVarCompensators {
    private final RegulatingControlMapping parent;
    private final Map<String, CgmesRegulatingControlForStaticVarCompensator> mapping;
    private final Context context;
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingControlMappingForStaticVarCompensators.class);

    RegulatingControlMappingForStaticVarCompensators(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.mapping = new HashMap<String, CgmesRegulatingControlForStaticVarCompensator>();
    }

    public static void initialize(StaticVarCompensatorAdder adder) {
        adder.setRegulating(false);
    }

    public void add(String iidmId, PropertyBag sm) {
        String rcId = RegulatingControlMapping.getRegulatingControlId(sm);
        double defaultTargetVoltage = sm.asDouble("voltageSetPoint");
        String defaultRegulationMode = sm.getId("controlMode");
        if (this.mapping.containsKey(iidmId)) {
            throw new CgmesModelException("StaticVarCompensator already added, IIDM StaticVarCompensator Id: " + iidmId);
        }
        CgmesRegulatingControlForStaticVarCompensator rc = new CgmesRegulatingControlForStaticVarCompensator();
        rc.regulatingControlId = rcId;
        rc.defaultTargetVoltage = defaultTargetVoltage;
        rc.defaultRegulationMode = defaultRegulationMode;
        this.mapping.put(iidmId, rc);
    }

    void applyRegulatingControls(Network network) {
        network.getStaticVarCompensatorStream().forEach(this::apply);
    }

    private void apply(StaticVarCompensator svc) {
        CgmesRegulatingControlForStaticVarCompensator rc = this.mapping.get(svc.getId());
        if (rc == null) {
            return;
        }
        String controlId = rc.regulatingControlId;
        if (controlId == null) {
            LOG.trace("Regulating control Id not present for static var compensator {}", (Object)svc.getId());
            this.setDefaultRegulatingControl(rc, svc);
            return;
        }
        RegulatingControlMapping.RegulatingControl control = this.parent.cachedRegulatingControls().get(controlId);
        if (control == null) {
            this.context.missing(String.format("Regulating control %s", controlId));
            this.setDefaultRegulatingControl(rc, svc);
            return;
        }
        this.setRegulatingControl(rc, control, svc);
    }

    private void setDefaultRegulatingControl(CgmesRegulatingControlForStaticVarCompensator rc, StaticVarCompensator svc) {
        svc.setRegulatingTerminal(svc.getTerminal());
        if (RegulatingControlMapping.isControlModeReactivePower(rc.defaultRegulationMode)) {
            svc.setRegulationMode(StaticVarCompensator.RegulationMode.REACTIVE_POWER);
        } else {
            if (!RegulatingControlMapping.isControlModeVoltage(rc.defaultRegulationMode)) {
                this.context.fixed("SVCDefaultControlMode", () -> String.format("Invalid default control mode for static var compensator %s. Default regulationMode set to VOLTAGE", svc.getId()));
            }
            this.setDefaultRegulatingControlData(rc, svc);
            svc.setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE);
        }
    }

    private void setRegulatingControl(CgmesRegulatingControlForStaticVarCompensator rc, RegulatingControlMapping.RegulatingControl control, StaticVarCompensator svc) {
        boolean okSet = false;
        if (RegulatingControlMapping.isControlModeVoltage(control.mode)) {
            okSet = this.setRegulatingControlVoltage(rc, control, svc);
        } else if (RegulatingControlMapping.isControlModeReactivePower(control.mode)) {
            okSet = this.setRegulatingControlReactivePower(rc, control, svc);
        } else {
            this.context.fixed("SVCControlMode", () -> String.format("Invalid control mode for static var compensator %s. RegulationMode set to VOLTAGE", svc.getId()));
            okSet = this.setRegulatingControlVoltage(rc, control, svc);
        }
        svc.setProperty("CGMES.RegulatingControl", rc.regulatingControlId);
        control.setCorrectlySet(okSet);
    }

    private boolean setRegulatingControlVoltage(CgmesRegulatingControlForStaticVarCompensator rc, RegulatingControlMapping.RegulatingControl control, StaticVarCompensator svc) {
        this.setDefaultRegulatingControlData(rc, svc);
        Terminal regulatingTerminal = RegulatingTerminalMapper.mapForVoltageControl(control.cgmesTerminal, this.context).orElse(svc.getTerminal());
        svc.setRegulatingTerminal(regulatingTerminal).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE);
        return true;
    }

    private boolean setRegulatingControlReactivePower(CgmesRegulatingControlForStaticVarCompensator rc, RegulatingControlMapping.RegulatingControl control, StaticVarCompensator svc) {
        RegulatingTerminalMapper.TerminalAndSign mappedRegulatingTerminal = RegulatingTerminalMapper.mapForFlowControl(control.cgmesTerminal, this.context).orElseGet(() -> new RegulatingTerminalMapper.TerminalAndSign(null, 1));
        if (mappedRegulatingTerminal.getTerminal() == null) {
            this.context.ignored(rc.regulatingControlId, String.format("Regulation terminal %s is not mapped or mapped to a switch", control.cgmesTerminal));
            return false;
        }
        svc.setRegulatingTerminal(mappedRegulatingTerminal.getTerminal()).setRegulationMode(StaticVarCompensator.RegulationMode.REACTIVE_POWER);
        svc.setProperty("CGMES.terminalSign", String.valueOf(mappedRegulatingTerminal.getSign()));
        return true;
    }

    private void setDefaultRegulatingControlData(CgmesRegulatingControlForStaticVarCompensator rc, StaticVarCompensator svc) {
        if (!Double.isNaN(rc.defaultTargetVoltage)) {
            svc.setProperty("CGMES.svcEquipmentVoltageSetPoint", String.valueOf(rc.defaultTargetVoltage));
        }
    }

    private static final class CgmesRegulatingControlForStaticVarCompensator {
        String regulatingControlId;
        double defaultTargetVoltage;
        String defaultRegulationMode;

        private CgmesRegulatingControlForStaticVarCompensator() {
        }
    }
}

