/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegulatingControlMappingForTransformers {
    private static final String TAP_CHANGER_CONTROL = "TapChangerControl";
    private final RegulatingControlMapping parent;
    private final Context context;
    private final Map<String, CgmesRegulatingControlForTwoWindingsTransformer> t2xMapping;
    private final Map<String, CgmesRegulatingControlForThreeWindingsTransformer> t3xMapping;
    private static final Logger LOG = LoggerFactory.getLogger(RegulatingControlMappingForTransformers.class);

    RegulatingControlMappingForTransformers(RegulatingControlMapping parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.t2xMapping = new HashMap<String, CgmesRegulatingControlForTwoWindingsTransformer>();
        this.t3xMapping = new HashMap<String, CgmesRegulatingControlForThreeWindingsTransformer>();
    }

    public void add(String transformerId, CgmesRegulatingControlRatio rcRtc, CgmesRegulatingControlPhase rcPtc) {
        CgmesRegulatingControlForTwoWindingsTransformer rc = new CgmesRegulatingControlForTwoWindingsTransformer();
        rc.ratioTapChanger = rcRtc;
        rc.phaseTapChanger = rcPtc;
        this.t2xMapping.put(transformerId, rc);
    }

    public void add(String transformerId, CgmesRegulatingControlRatio rcRtc1, CgmesRegulatingControlPhase rcPtc1, CgmesRegulatingControlRatio rcRtc2, CgmesRegulatingControlPhase rcPtc2, CgmesRegulatingControlRatio rcRtc3, CgmesRegulatingControlPhase rcPtc3) {
        CgmesRegulatingControlForThreeWindingsTransformer rc = new CgmesRegulatingControlForThreeWindingsTransformer();
        rc.ratioTapChanger1 = rcRtc1;
        rc.phaseTapChanger1 = rcPtc1;
        rc.ratioTapChanger2 = rcRtc2;
        rc.phaseTapChanger2 = rcPtc2;
        rc.ratioTapChanger3 = rcRtc3;
        rc.phaseTapChanger3 = rcPtc3;
        this.t3xMapping.put(transformerId, rc);
    }

    public CgmesRegulatingControlRatio buildRegulatingControlRatio(String id, String regulatingControlId, String tculControlMode) {
        CgmesRegulatingControlRatio rtc = new CgmesRegulatingControlRatio();
        rtc.id = id;
        rtc.regulatingControlId = regulatingControlId;
        rtc.tculControlMode = tculControlMode;
        return rtc;
    }

    public CgmesRegulatingControlPhase buildRegulatingControlPhase(String id, String regulatingControlId) {
        CgmesRegulatingControlPhase rtc = new CgmesRegulatingControlPhase();
        rtc.id = id;
        rtc.regulatingControlId = regulatingControlId;
        return rtc;
    }

    void applyTapChangersRegulatingControl(Network network) {
        network.getTwoWindingsTransformerStream().forEach(this::applyTapChangersRegulatingControl);
        network.getThreeWindingsTransformerStream().forEach(this::applyTapChangersRegulatingControl);
    }

    private void applyTapChangersRegulatingControl(TwoWindingsTransformer twt) {
        CgmesRegulatingControlForTwoWindingsTransformer rc = this.t2xMapping.get(twt.getId());
        if (rc == null) {
            return;
        }
        RegulatingControlMapping.RegulatingControl rtcControl = this.getTapChangerControl(rc.ratioTapChanger);
        RegulatingControlMapping.RegulatingControl ptcControl = this.getTapChangerControl(rc.phaseTapChanger);
        this.setPhaseTapChangerControl(ptcControl, twt.getPhaseTapChanger(), (Connectable<?>)twt, "");
        this.setRatioTapChangerControl(rtcControl, twt.getRatioTapChanger());
    }

    private void applyTapChangersRegulatingControl(ThreeWindingsTransformer twt) {
        CgmesRegulatingControlForThreeWindingsTransformer rc = this.t3xMapping.get(twt.getId());
        if (rc == null) {
            return;
        }
        RegulatingControlMapping.RegulatingControl rtcControl1 = this.getTapChangerControl(rc.ratioTapChanger1);
        RegulatingControlMapping.RegulatingControl ptcControl1 = this.getTapChangerControl(rc.phaseTapChanger1);
        RegulatingControlMapping.RegulatingControl rtcControl2 = this.getTapChangerControl(rc.ratioTapChanger2);
        RegulatingControlMapping.RegulatingControl ptcControl2 = this.getTapChangerControl(rc.phaseTapChanger2);
        RegulatingControlMapping.RegulatingControl rtcControl3 = this.getTapChangerControl(rc.ratioTapChanger3);
        RegulatingControlMapping.RegulatingControl ptcControl3 = this.getTapChangerControl(rc.phaseTapChanger3);
        this.setPhaseTapChangerControl(ptcControl1, twt.getLeg1().getPhaseTapChanger(), (Connectable<?>)twt, "1");
        this.setRatioTapChangerControl(rtcControl1, twt.getLeg1().getRatioTapChanger());
        this.setPhaseTapChangerControl(ptcControl2, twt.getLeg2().getPhaseTapChanger(), (Connectable<?>)twt, "2");
        this.setRatioTapChangerControl(rtcControl2, twt.getLeg2().getRatioTapChanger());
        this.setPhaseTapChangerControl(ptcControl3, twt.getLeg3().getPhaseTapChanger(), (Connectable<?>)twt, "3");
        this.setRatioTapChangerControl(rtcControl3, twt.getLeg3().getRatioTapChanger());
    }

    private void setRatioTapChangerControl(RegulatingControlMapping.RegulatingControl control, RatioTapChanger rtc) {
        if (control == null || rtc == null) {
            return;
        }
        boolean okSet = false;
        if (RegulatingControlMapping.isControlModeVoltage(control.mode)) {
            okSet = this.setRtcRegulatingControlVoltage(control, rtc, this.context);
        } else if (!RegulatingControlMappingForTransformers.isControlModeFixed(control.mode)) {
            this.context.fixed(control.mode, "Unsupported regulation mode for Ratio tap changer. Considered as a fixed ratio tap changer.");
        }
        control.setCorrectlySet(okSet);
    }

    private boolean setRtcRegulatingControlVoltage(RegulatingControlMapping.RegulatingControl control, RatioTapChanger rtc, Context context) {
        Optional<Terminal> regulatingTerminal = RegulatingTerminalMapper.mapForVoltageControl(control.cgmesTerminal, context);
        if (regulatingTerminal.isEmpty()) {
            context.missing(String.format("IIDM terminal for this CGMES terminal: %s", control.cgmesTerminal));
            return false;
        }
        ((RatioTapChanger)rtc.setRegulationTerminal(regulatingTerminal.get())).setRegulationMode(RatioTapChanger.RegulationMode.VOLTAGE);
        return true;
    }

    private void setPhaseTapChangerControl(RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Connectable<?> twt, String end) {
        if (control == null || ptc == null) {
            return;
        }
        boolean okSet = false;
        if (control.mode.endsWith("currentflow")) {
            okSet = this.setPtcRegulatingControlCurrentFlow(control, ptc, this.context, twt, end);
        } else if (control.mode.endsWith("activepower")) {
            okSet = this.setPtcRegulatingControlActivePower(control, ptc, this.context, twt, end);
        }
        control.setCorrectlySet(okSet);
    }

    private boolean setPtcRegulatingControlCurrentFlow(RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Context context, Connectable<?> twt, String end) {
        return this.setPtcRegulatingControl(PhaseTapChanger.RegulationMode.CURRENT_LIMITER, control, ptc, context, twt, end);
    }

    private boolean setPtcRegulatingControlActivePower(RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Context context, Connectable<?> twt, String end) {
        return this.setPtcRegulatingControl(PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL, control, ptc, context, twt, end);
    }

    private boolean setPtcRegulatingControl(PhaseTapChanger.RegulationMode regulationMode, RegulatingControlMapping.RegulatingControl control, PhaseTapChanger ptc, Context context, Connectable<?> twt, String end) {
        RegulatingTerminalMapper.TerminalAndSign mappedRegulatingTerminal = RegulatingTerminalMapper.mapForFlowControl(control.cgmesTerminal, context).orElseGet(() -> new RegulatingTerminalMapper.TerminalAndSign(null, 1));
        if (mappedRegulatingTerminal.getTerminal() == null) {
            context.missing(String.format("IIDM terminal for this CGMES terminal: %s", control.cgmesTerminal));
            return false;
        }
        ((PhaseTapChanger)ptc.setRegulationTerminal(mappedRegulatingTerminal.getTerminal())).setRegulationMode(regulationMode);
        twt.setProperty("CGMES.terminalSign" + end, String.valueOf(mappedRegulatingTerminal.getSign()));
        return true;
    }

    private RegulatingControlMapping.RegulatingControl getTapChangerControl(CgmesRegulatingControl rc) {
        if (rc == null) {
            return null;
        }
        String controlId = rc.regulatingControlId;
        if (controlId == null) {
            LOG.trace("Regulating control Id not present for tap changer {}", (Object)rc.id);
            return null;
        }
        RegulatingControlMapping.RegulatingControl control = this.parent.cachedRegulatingControls().get(controlId);
        if (control == null) {
            this.context.missing(String.format("Regulating control %s", controlId));
            return null;
        }
        return control;
    }

    public static String getRegulatingControlId(PropertyBag p) {
        return p.getId(TAP_CHANGER_CONTROL);
    }

    public boolean getRegulating(String controlId) {
        return controlId != null;
    }

    private static boolean isControlModeFixed(String controlMode) {
        return controlMode != null && controlMode.endsWith("fixed");
    }

    private static final class CgmesRegulatingControlForTwoWindingsTransformer {
        CgmesRegulatingControlRatio ratioTapChanger;
        CgmesRegulatingControlPhase phaseTapChanger;

        private CgmesRegulatingControlForTwoWindingsTransformer() {
        }
    }

    public static class CgmesRegulatingControlRatio
    extends CgmesRegulatingControl {
        String tculControlMode;
    }

    public static class CgmesRegulatingControlPhase
    extends CgmesRegulatingControl {
    }

    private static final class CgmesRegulatingControlForThreeWindingsTransformer {
        CgmesRegulatingControlRatio ratioTapChanger1;
        CgmesRegulatingControlPhase phaseTapChanger1;
        CgmesRegulatingControlRatio ratioTapChanger2;
        CgmesRegulatingControlPhase phaseTapChanger2;
        CgmesRegulatingControlRatio ratioTapChanger3;
        CgmesRegulatingControlPhase phaseTapChanger3;

        private CgmesRegulatingControlForThreeWindingsTransformer() {
        }
    }

    private static class CgmesRegulatingControl {
        String id;
        String regulatingControlId;

        private CgmesRegulatingControl() {
        }
    }
}

