/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Map;

public class RegulatingControlMappingForVscConverters {
    private final Map<String, String> mapping;
    private final Context context;

    RegulatingControlMappingForVscConverters(Context context) {
        this.context = context;
        this.mapping = new HashMap<String, String>();
    }

    public static void initialize(VscConverterStationAdder adder) {
        adder.setVoltageRegulatorOn(false).setReactivePowerSetpoint(0.0);
    }

    public void add(String vscConverterId, PropertyBag sm) {
        if (this.mapping.containsKey(vscConverterId)) {
            throw new CgmesModelException("VscConverter already added, IIDM VscConverter Id: " + vscConverterId);
        }
        String pccTerminal = sm.getId("PccTerminal");
        this.mapping.put(vscConverterId, pccTerminal);
    }

    void applyRegulatingControls(Network network) {
        network.getVscConverterStationStream().forEach(this::apply);
    }

    private void apply(VscConverterStation vscConverter) {
        String pccTerminal = this.mapping.get(vscConverter.getId());
        if (pccTerminal == null) {
            return;
        }
        RegulatingTerminalMapper.TerminalAndSign mappedRegulatingTerminal = RegulatingTerminalMapper.mapForFlowControl(pccTerminal, this.context).orElseGet(() -> new RegulatingTerminalMapper.TerminalAndSign(vscConverter.getTerminal(), 1));
        vscConverter.setRegulatingTerminal(mappedRegulatingTerminal.getTerminal());
        vscConverter.setProperty("CGMES.terminalSign", String.valueOf(mappedRegulatingTerminal.getSign()));
    }
}

