/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.model.CgmesNames;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraverseResult;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RegulatingTerminalMapper {
    private RegulatingTerminalMapper() {
    }

    public static Optional<Terminal> mapForVoltageControl(String cgmesTerminalId, Context context) {
        return cgmesTerminalId == null ? Optional.empty() : RegulatingTerminalMapper.mapped(cgmesTerminalId, context).or(() -> new EquivalentTerminalFinderVoltageControl(cgmesTerminalId, context).find()).or(() -> Optional.ofNullable(context.terminalMapping().findFromTopologicalNode(context.terminalMapping().getTopologicalNode(cgmesTerminalId))));
    }

    public static Optional<TerminalAndSign> mapForFlowControl(String cgmesTerminalId, Context context) {
        return cgmesTerminalId == null ? Optional.empty() : RegulatingTerminalMapper.mapped(cgmesTerminalId, context).map(t -> new TerminalAndSign((Terminal)t, 1)).or(() -> new EquivalentTerminalFinderFlowControl(cgmesTerminalId, context).findWithSign());
    }

    public static Optional<Terminal> mapForTieFlow(String cgmesTerminalId, Context context) {
        return cgmesTerminalId == null ? Optional.empty() : RegulatingTerminalMapper.mapped(cgmesTerminalId, context).or(() -> new EquivalentTerminalFinderTieFlow(cgmesTerminalId, context).find());
    }

    private static Optional<Terminal> mapped(String cgmesTerminalId, Context context) {
        return Optional.ofNullable(context.terminalMapping().get(cgmesTerminalId));
    }

    private static boolean isBusbarSection(Terminal t) {
        return t.getConnectable().getType() == IdentifiableType.BUSBAR_SECTION;
    }

    private static boolean isEquipmentCapableOfVoltageControl(Terminal t) {
        IdentifiableType type = t.getConnectable().getType();
        return type == IdentifiableType.GENERATOR || type == IdentifiableType.SHUNT_COMPENSATOR || type == IdentifiableType.STATIC_VAR_COMPENSATOR || type == IdentifiableType.HVDC_CONVERTER_STATION;
    }

    private static <T> Stream<? extends Terminal> allTerminals(VoltageLevel vl, Set<T> vertices, Function<Terminal, T> terminalToVertex) {
        return vl.getConnectableStream().map(c -> c).flatMap(c -> c.getTerminals().stream()).filter(terminal -> terminal.getVoltageLevel() == vl).filter(terminal -> vertices.contains(terminalToVertex.apply((Terminal)terminal)));
    }

    private static Bus getTerminalBus(Terminal terminal) {
        return terminal.getBusBreakerView().getBus() != null ? terminal.getBusBreakerView().getBus() : terminal.getBusBreakerView().getConnectableBus();
    }

    static class EquivalentTerminalFinderTieFlow
    extends AbstractEquivalentTerminalFinder {
        EquivalentTerminalFinderTieFlow(String cgmesTerminalId, Context context) {
            super(cgmesTerminalId, context);
        }

        private static Optional<Terminal> best(Terminal terminalEnd1, Terminal terminalEnd2) {
            if (terminalEnd1 != null && terminalEnd1.getConnectable().getType() == IdentifiableType.DANGLING_LINE) {
                return Optional.of(terminalEnd1);
            }
            if (terminalEnd2 != null && terminalEnd2.getConnectable().getType() == IdentifiableType.DANGLING_LINE) {
                return Optional.of(terminalEnd2);
            }
            return Optional.empty();
        }

        @Override
        Optional<Terminal> find() {
            if (this.sw == null) {
                return Optional.empty();
            }
            return this.isNodeBreaker ? this.findNodeBreaker() : this.findBusBranch();
        }

        private Optional<Terminal> findNodeBreaker() {
            int end1 = this.vl.getNodeBreakerView().getNode1(this.sw.getId());
            int end2 = this.vl.getNodeBreakerView().getNode2(this.sw.getId());
            Terminal terminalEnd1 = this.findForFlow(end1, end2);
            Terminal terminalEnd2 = this.findForFlow(end2, end1);
            return EquivalentTerminalFinderTieFlow.best(terminalEnd1, terminalEnd2);
        }

        private Optional<Terminal> findBusBranch() {
            Bus end1 = this.vl.getBusBreakerView().getBus1(this.sw.getId());
            Bus end2 = this.vl.getBusBreakerView().getBus2(this.sw.getId());
            Terminal terminalEnd1 = this.findForFlow(end1, end2);
            Terminal terminalEnd2 = this.findForFlow(end2, end1);
            return EquivalentTerminalFinderTieFlow.best(terminalEnd1, terminalEnd2);
        }
    }

    static class EquivalentTerminalFinderFlowControl
    extends AbstractEquivalentTerminalFinder {
        private final int cgmesTerminalEnd;

        EquivalentTerminalFinderFlowControl(String cgmesTerminalId, Context context) {
            super(cgmesTerminalId, context);
            this.cgmesTerminalEnd = context.cgmes().terminal(cgmesTerminalId).getSequenceNumber();
        }

        private static Optional<TerminalAndSign> best(int cgmesTerminalEnd, Terminal iidmTerminalEnd1, Terminal iidmTerminalEnd2) {
            if (cgmesTerminalEnd == 1 && iidmTerminalEnd2 != null) {
                return Optional.of(new TerminalAndSign(iidmTerminalEnd2, 1));
            }
            if (cgmesTerminalEnd == 2 && iidmTerminalEnd1 != null) {
                return Optional.of(new TerminalAndSign(iidmTerminalEnd1, 1));
            }
            if (cgmesTerminalEnd == 1 && iidmTerminalEnd1 != null) {
                return Optional.of(new TerminalAndSign(iidmTerminalEnd1, -1));
            }
            if (cgmesTerminalEnd == 2 && iidmTerminalEnd2 != null) {
                return Optional.of(new TerminalAndSign(iidmTerminalEnd2, -1));
            }
            return Optional.empty();
        }

        @Override
        Optional<TerminalAndSign> findWithSign() {
            return this.sw == null ? Optional.empty() : this.findWithSign(this.cgmesTerminalEnd);
        }

        Optional<TerminalAndSign> findWithSign(int cgmesTerminalEnd) {
            if (this.isNodeBreaker) {
                return this.findWithSignNodeBreaker(cgmesTerminalEnd);
            }
            return this.findWithSignBusBranch(cgmesTerminalEnd);
        }

        private Optional<TerminalAndSign> findWithSignNodeBreaker(int cgmesTerminalEnd) {
            int end1 = this.vl.getNodeBreakerView().getNode1(this.sw.getId());
            int end2 = this.vl.getNodeBreakerView().getNode2(this.sw.getId());
            Terminal terminalEnd1 = this.findForFlow(end1, end2);
            Terminal terminalEnd2 = this.findForFlow(end2, end1);
            return EquivalentTerminalFinderFlowControl.best(cgmesTerminalEnd, terminalEnd1, terminalEnd2);
        }

        private Optional<TerminalAndSign> findWithSignBusBranch(int cgmesTerminalEnd) {
            Bus end1 = this.vl.getBusBreakerView().getBus1(this.sw.getId());
            Bus end2 = this.vl.getBusBreakerView().getBus2(this.sw.getId());
            Terminal terminalEnd1 = this.findForFlow(end1, end2);
            Terminal terminalEnd2 = this.findForFlow(end2, end1);
            return EquivalentTerminalFinderFlowControl.best(cgmesTerminalEnd, terminalEnd1, terminalEnd2);
        }
    }

    public static class TerminalAndSign {
        private final Terminal terminal;
        private final int sign;

        TerminalAndSign(Terminal terminal, int sign) {
            this.terminal = terminal;
            this.sign = sign;
        }

        Terminal getTerminal() {
            return this.terminal;
        }

        int getSign() {
            return this.sign;
        }
    }

    static class EquivalentTerminalFinderVoltageControl
    extends AbstractEquivalentTerminalFinder {
        EquivalentTerminalFinderVoltageControl(String cgmesTerminalId, Context context) {
            super(cgmesTerminalId, context);
        }

        private static Set<Integer> allNodesReachableBySwitches(VoltageLevel voltageLevel, int node) {
            HashSet<Integer> nodes = new HashSet<Integer>();
            nodes.add(node);
            voltageLevel.getNodeBreakerView().traverse(node, (node1, sw, node2) -> {
                nodes.add(node2);
                return TraverseResult.CONTINUE;
            });
            return nodes;
        }

        private static Set<Bus> allBusesReachableBySwitches(VoltageLevel voltageLevel, Bus bus) {
            HashSet<Bus> buses = new HashSet<Bus>();
            buses.add(bus);
            voltageLevel.getBusBreakerView().traverse(bus, (bus1, sw, bus2) -> {
                buses.add(bus2);
                return TraverseResult.CONTINUE;
            });
            return buses;
        }

        private static <T> List<Terminal> allTerminals(VoltageLevel vl, Set<T> vertices, Function<Terminal, T> terminalToVertex) {
            return RegulatingTerminalMapper.allTerminals(vl, vertices, terminalToVertex).collect(Collectors.toList());
        }

        private static Optional<Terminal> best(List<Terminal> terminals) {
            return terminals.stream().filter(RegulatingTerminalMapper::isBusbarSection).findFirst().or(() -> terminals.stream().filter(RegulatingTerminalMapper::isEquipmentCapableOfVoltageControl).findFirst()).or(() -> terminals.stream().findFirst());
        }

        @Override
        Optional<Terminal> find() {
            if (this.sw == null) {
                return Optional.empty();
            }
            return this.isNodeBreaker ? this.findNodeBreaker() : this.findBusBranch();
        }

        private Optional<Terminal> findNodeBreaker() {
            int end1 = this.vl.getNodeBreakerView().getNode1(this.sw.getId());
            List<Terminal> terminals = this.findTerminalsNodeBreaker(end1);
            return EquivalentTerminalFinderVoltageControl.best(terminals);
        }

        private Optional<Terminal> findBusBranch() {
            Bus end1 = this.vl.getBusBreakerView().getBus1(this.sw.getId());
            List<Terminal> terminals = this.findTerminalsBusBranch(end1);
            return EquivalentTerminalFinderVoltageControl.best(terminals);
        }

        protected List<Terminal> findTerminalsNodeBreaker(int node) {
            Set<Integer> nodes = EquivalentTerminalFinderVoltageControl.allNodesReachableBySwitches(this.vl, node);
            return EquivalentTerminalFinderVoltageControl.allTerminals(this.vl, nodes, t -> t.getNodeBreakerView().getNode());
        }

        private List<Terminal> findTerminalsBusBranch(Bus end) {
            Set<Bus> buses = EquivalentTerminalFinderVoltageControl.allBusesReachableBySwitches(this.vl, end);
            return EquivalentTerminalFinderVoltageControl.allTerminals(this.vl, buses, RegulatingTerminalMapper::getTerminalBus);
        }
    }

    static abstract class AbstractEquivalentTerminalFinder {
        protected final VoltageLevel vl;
        protected final Switch sw;
        protected final boolean isNodeBreaker;

        AbstractEquivalentTerminalFinder(String cgmesTerminalId, Context context) {
            this.sw = AbstractEquivalentTerminalFinder.atSwitchEnd(cgmesTerminalId, context);
            this.vl = this.sw == null ? null : this.sw.getVoltageLevel();
            this.isNodeBreaker = this.vl != null && this.vl.getTopologyKind() == TopologyKind.NODE_BREAKER;
        }

        private static Switch atSwitchEnd(String cgmesTerminalId, Context context) {
            Objects.requireNonNull(cgmesTerminalId);
            CgmesTerminal cgmesTerminal = context.cgmes().terminal(cgmesTerminalId);
            if (cgmesTerminal != null && AbstractEquivalentTerminalFinder.isSwitch(cgmesTerminal.conductingEquipmentType())) {
                return context.network().getSwitch(cgmesTerminal.conductingEquipment());
            }
            return null;
        }

        private static boolean isSwitch(String conductingEquipmentType) {
            return CgmesNames.SWITCH_TYPES.contains(conductingEquipmentType);
        }

        private static Set<Integer> allNodesReachableBySwitchesExceptSwitch(VoltageLevel voltageLevel, int node, Switch exceptSwitch) {
            HashSet<Integer> nodes = new HashSet<Integer>();
            nodes.add(node);
            voltageLevel.getNodeBreakerView().traverse(node, (node1, sw, node2) -> {
                if (sw == exceptSwitch) {
                    return TraverseResult.TERMINATE_PATH;
                }
                nodes.add(node2);
                return TraverseResult.CONTINUE;
            });
            return nodes;
        }

        private static Set<Bus> allBusesReachableBySwitchesExceptSwitch(VoltageLevel voltageLevel, Bus bus, Switch exceptSwitch) {
            HashSet<Bus> buses = new HashSet<Bus>();
            buses.add(bus);
            voltageLevel.getBusBreakerView().traverse(bus, (bus1, sw, bus2) -> {
                if (sw == exceptSwitch) {
                    return TraverseResult.TERMINATE_PATH;
                }
                buses.add(bus2);
                return TraverseResult.CONTINUE;
            });
            return buses;
        }

        private static <T> Terminal selectValidTerminalForFlow(VoltageLevel vl, Set<T> vertices, Function<Terminal, T> terminalToVertex) {
            List terminals = RegulatingTerminalMapper.allTerminals(vl, vertices, terminalToVertex).filter(terminal -> terminal.getConnectable().getType() != IdentifiableType.BUSBAR_SECTION).collect(Collectors.toList());
            return terminals.size() == 1 ? (Terminal)terminals.get(0) : null;
        }

        Optional<Terminal> find() {
            return Optional.empty();
        }

        Optional<TerminalAndSign> findWithSign() {
            return Optional.empty();
        }

        protected Terminal findForFlow(int end, int otherEnd) {
            Set<Integer> nodes = AbstractEquivalentTerminalFinder.allNodesReachableBySwitchesExceptSwitch(this.vl, end, this.sw);
            if (nodes.contains(otherEnd)) {
                return null;
            }
            return AbstractEquivalentTerminalFinder.selectValidTerminalForFlow(this.vl, nodes, t -> t.getNodeBreakerView().getNode());
        }

        protected Terminal findForFlow(Bus end, Bus otherEnd) {
            Set<Bus> buses = AbstractEquivalentTerminalFinder.allBusesReachableBySwitchesExceptSwitch(this.vl, end, this.sw);
            if (buses.contains(otherEnd)) {
                return null;
            }
            return AbstractEquivalentTerminalFinder.selectValidTerminalForFlow(this.vl, buses, RegulatingTerminalMapper::getTerminalBus);
        }
    }
}

