/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.conversion.CgmesImportPostProcessor;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.modification.topology.RemoveFeederBay;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.triplestore.api.TripleStore;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={CgmesImportPostProcessor.class})
public class RemoveGroundsPostProcessor
implements CgmesImportPostProcessor {
    public static final String NAME = "RemoveGrounds";
    private static final Logger LOG = LoggerFactory.getLogger(RemoveGroundsPostProcessor.class);

    public RemoveGroundsPostProcessor() {
        this(PlatformConfig.defaultConfig());
    }

    public RemoveGroundsPostProcessor(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void process(Network network, TripleStore tripleStore) {
        Objects.requireNonNull(network);
        LOG.info("Execute {} post processor on network {}", (Object)this.getName(), (Object)network.getId());
        List<String> grounds = network.getGroundStream().map(Identifiable::getId).toList();
        grounds.forEach(g -> new RemoveFeederBay(g).apply(network));
    }
}

