/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.elements.ACLineSegmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AsynchronousMachineConversion;
import com.powsybl.cgmes.conversion.elements.ControlAreaConversion;
import com.powsybl.cgmes.conversion.elements.EnergyConsumerConversion;
import com.powsybl.cgmes.conversion.elements.EnergySourceConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentBranchConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentInjectionConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentShuntConversion;
import com.powsybl.cgmes.conversion.elements.ExternalNetworkInjectionConversion;
import com.powsybl.cgmes.conversion.elements.GroundConversion;
import com.powsybl.cgmes.conversion.elements.NodeConversion;
import com.powsybl.cgmes.conversion.elements.SeriesCompensatorConversion;
import com.powsybl.cgmes.conversion.elements.ShuntConversion;
import com.powsybl.cgmes.conversion.elements.StaticVarCompensatorConversion;
import com.powsybl.cgmes.conversion.elements.SvInjectionConversion;
import com.powsybl.cgmes.conversion.elements.SwitchConversion;
import com.powsybl.cgmes.conversion.elements.SynchronousMachineConversion;
import com.powsybl.cgmes.conversion.elements.TerminalConversion;
import com.powsybl.cgmes.conversion.elements.TieLineConversion;
import com.powsybl.cgmes.conversion.elements.VoltageLevelConversion;
import com.powsybl.cgmes.conversion.elements.dc.HvdcLineConversion;
import com.powsybl.cgmes.conversion.elements.transformers.ThreeWindingsTransformerConversion;
import com.powsybl.cgmes.conversion.elements.transformers.TwoWindingsTransformerConversion;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.Switch;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Update {
    private static final String UNEXPECTED_ORIGINAL_CLASS = "Unexpected originalClass ";
    private static final PropertyBag EMPTY_PROPERTY_BAG = new PropertyBag(Collections.emptyList(), false);

    private Update() {
    }

    static void updateLoads(Network network, CgmesModel cgmes, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.LOAD.name()));
        HashMap<String, PropertyBag> equipmentIdPropertyBag = new HashMap<String, PropertyBag>();
        Update.addPropertyBags(cgmes.energyConsumers(), "EnergyConsumer", equipmentIdPropertyBag);
        Update.addPropertyBags(cgmes.energySources(), "EnergySource", equipmentIdPropertyBag);
        Update.addPropertyBags(cgmes.asynchronousMachines(), "AsynchronousMachine", equipmentIdPropertyBag);
        network.getLoads().forEach(load -> Update.updateLoad(load, Update.getPropertyBag(load.getId(), equipmentIdPropertyBag), context));
        context.popReportNode();
    }

    private static void updateLoad(Load load, PropertyBag cgmesData, Context context) {
        if (!load.isFictitious()) {
            String originalClass;
            switch (originalClass = load.getProperty("CGMES.originalClass")) {
                case "EnergySource": {
                    EnergySourceConversion.update(load, cgmesData, context);
                    break;
                }
                case "AsynchronousMachine": {
                    AsynchronousMachineConversion.update(load, cgmesData, context);
                    break;
                }
                case "ConformLoad": 
                case "NonConformLoad": 
                case "StationSupply": 
                case "EnergyConsumer": {
                    EnergyConsumerConversion.update(load, cgmesData, context);
                    break;
                }
                default: {
                    throw new ConversionException(UNEXPECTED_ORIGINAL_CLASS + originalClass + " for Load: " + load.getId());
                }
            }
        }
    }

    static void updateGenerators(Network network, CgmesModel cgmes, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.GENERATOR.name()));
        HashMap<String, PropertyBag> equipmentIdPropertyBag = new HashMap<String, PropertyBag>();
        Update.addPropertyBags(cgmes.synchronousMachinesForUpdate(), "SynchronousMachine", equipmentIdPropertyBag);
        Update.addPropertyBags(cgmes.equivalentInjections(), "EquivalentInjection", equipmentIdPropertyBag);
        Update.addPropertyBags(cgmes.externalNetworkInjections(), "ExternalNetworkInjection", equipmentIdPropertyBag);
        network.getGenerators().forEach(generator -> Update.updateGenerator(generator, equipmentIdPropertyBag, context));
        context.popReportNode();
    }

    private static void updateGenerator(Generator generator, Map<String, PropertyBag> equipmentIdPropertyBag, Context context) {
        String originalClass;
        switch (originalClass = generator.getProperty("CGMES.originalClass")) {
            case "SynchronousMachine": {
                SynchronousMachineConversion.update(generator, Update.getPropertyBag(generator.getId(), equipmentIdPropertyBag), context);
                break;
            }
            case "EquivalentInjection": {
                EquivalentInjectionConversion.update(generator, Update.getEquivalentInjectionPropertyBag(generator.getId(), context), context);
                break;
            }
            case "ExternalNetworkInjection": {
                ExternalNetworkInjectionConversion.update(generator, Update.getPropertyBag(generator.getId(), equipmentIdPropertyBag), context);
                break;
            }
            default: {
                throw new ConversionException(UNEXPECTED_ORIGINAL_CLASS + originalClass + " for Generator: " + generator.getId());
            }
        }
    }

    static void updateTransformers(Network network, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.TWO_WINDINGS_TRANSFORMER.name()));
        network.getTwoWindingsTransformers().forEach(t2w -> TwoWindingsTransformerConversion.update(t2w, context));
        context.popReportNode();
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.THREE_WINDINGS_TRANSFORMER.name()));
        network.getThreeWindingsTransformers().forEach(t3w -> ThreeWindingsTransformerConversion.update(t3w, context));
        context.popReportNode();
    }

    static void updateStaticVarCompensators(Network network, CgmesModel cgmes, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.STATIC_VAR_COMPENSATOR.name()));
        HashMap<String, PropertyBag> equipmentIdPropertyBag = new HashMap<String, PropertyBag>();
        Update.addPropertyBags(cgmes.staticVarCompensators(), "StaticVarCompensator", equipmentIdPropertyBag);
        network.getStaticVarCompensators().forEach(staticVarCompensator -> StaticVarCompensatorConversion.update(staticVarCompensator, Update.getPropertyBag(staticVarCompensator.getId(), equipmentIdPropertyBag), context));
        context.popReportNode();
    }

    static void updateShuntCompensators(Network network, CgmesModel cgmes, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.SHUNT_COMPENSATOR.name()));
        HashMap<String, PropertyBag> equipmentIdPropertyBag = new HashMap<String, PropertyBag>();
        Update.addPropertyBags(cgmes.shuntCompensators(), "ShuntCompensator", equipmentIdPropertyBag);
        Update.addPropertyBags(cgmes.equivalentShunts(), "EquivalentShunt", equipmentIdPropertyBag);
        network.getShuntCompensators().forEach(shuntCompensator -> Update.updateShuntCompensator(shuntCompensator, Update.getPropertyBag(shuntCompensator.getId(), equipmentIdPropertyBag), context));
        context.popReportNode();
    }

    private static void updateShuntCompensator(ShuntCompensator shuntCompensator, PropertyBag cgmesData, Context context) {
        String isEquivalentShunt = shuntCompensator.getProperty("CGMES.isEquivalentShunt");
        if (Boolean.parseBoolean(isEquivalentShunt)) {
            EquivalentShuntConversion.update(shuntCompensator, context);
        } else {
            ShuntConversion.update(shuntCompensator, cgmesData, context);
        }
    }

    static void updateHvdcLines(Network network, CgmesModel cgmes, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.HVDC_LINE.name()));
        HashMap<String, PropertyBag> equipmentIdPropertyBag = new HashMap<String, PropertyBag>();
        Update.addPropertyBags(cgmes.acDcConverters(), "ACDCConverter", equipmentIdPropertyBag);
        network.getHvdcLines().forEach(hvdcLine -> HvdcLineConversion.update(hvdcLine, Update.getPropertyBag(hvdcLine.getConverterStation1().getId(), equipmentIdPropertyBag), Update.getPropertyBag(hvdcLine.getConverterStation2().getId(), equipmentIdPropertyBag), context));
        context.popReportNode();
    }

    static void updateDanglingLines(Network network, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.DANGLING_LINE.name()));
        network.getDanglingLines().forEach(danglingLine -> Update.updateDanglingLine(danglingLine, context));
        context.popReportNode();
    }

    private static void updateDanglingLine(DanglingLine danglingLine, Context context) {
        String originalClass;
        switch (originalClass = danglingLine.getProperty("CGMES.originalClass")) {
            case "ACLineSegment": {
                ACLineSegmentConversion.update(danglingLine, context);
                break;
            }
            case "PowerTransformer": {
                TwoWindingsTransformerConversion.update(danglingLine, context);
                break;
            }
            case "EquivalentBranch": {
                EquivalentBranchConversion.update(danglingLine, context);
                break;
            }
            case "Switch": {
                SwitchConversion.update(danglingLine, Update.getSwitchPropertyBag(danglingLine.getId(), context), context);
                break;
            }
            default: {
                throw new ConversionException(UNEXPECTED_ORIGINAL_CLASS + originalClass + " for DanglingLine: " + danglingLine.getId());
            }
        }
    }

    static void updateLines(Network network, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.LINE.name()));
        network.getLines().forEach(line -> Update.updateLine(line, context));
        context.popReportNode();
    }

    private static void updateLine(Line line, Context context) {
        String originalClass;
        switch (originalClass = line.getProperty("CGMES.originalClass")) {
            case "ACLineSegment": {
                ACLineSegmentConversion.update(line, context);
                break;
            }
            case "EquivalentBranch": {
                EquivalentBranchConversion.update(line, context);
                break;
            }
            case "SeriesCompensator": {
                SeriesCompensatorConversion.update(line, context);
                break;
            }
            default: {
                throw new ConversionException(UNEXPECTED_ORIGINAL_CLASS + originalClass + " for Line: " + line.getId());
            }
        }
    }

    static void updateSwitches(Network network, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.SWITCH.name()));
        network.getSwitches().forEach(sw -> Update.updateSwitch(sw, context));
        context.popReportNode();
    }

    private static void updateSwitch(Switch sw, Context context) {
        String originalClass;
        if (sw.getProperty("CGMES.isCreatedForDisconnectedTerminal") != null) {
            TerminalConversion.update(sw, context);
            return;
        }
        switch (originalClass = sw.getProperty("CGMES.originalClass")) {
            case "ACLineSegment": {
                ACLineSegmentConversion.update(sw, context);
                break;
            }
            case "EquivalentBranch": {
                EquivalentBranchConversion.update(sw, context);
                break;
            }
            case "SeriesCompensator": {
                SeriesCompensatorConversion.update(sw, context);
                break;
            }
            case "Switch": 
            case "Breaker": 
            case "Disconnector": 
            case "LoadBreakSwitch": 
            case "ProtectedSwitch": 
            case "GroundDisconnector": 
            case "Jumper": {
                SwitchConversion.update(sw, Update.getSwitchPropertyBag(sw.getId(), context), context);
                break;
            }
            default: {
                throw new ConversionException(UNEXPECTED_ORIGINAL_CLASS + originalClass + " for Switch: " + sw.getId());
            }
        }
    }

    static void createFictitiousSwitchesForDisconnectedTerminalsDuringUpdate(Network network, CgmesModel cgmes, Context context) {
        if (Update.createFictitiousSwitches(context)) {
            context.pushReportNode(CgmesReports.convertingDuringUpdateElementTypeReport(context.getReportNode(), "Terminal"));
            cgmes.terminals().forEach(cgmesTerminal -> TerminalConversion.create(network, cgmesTerminal, context));
            context.popReportNode();
        }
    }

    private static boolean createFictitiousSwitches(Context context) {
        return context.config().getCreateFictitiousSwitchesForDisconnectedTerminalsMode() != CgmesImport.FictitiousSwitchesCreationMode.NEVER;
    }

    static void createTieLinesWhenThereAreMoreThanTwoDanglingLinesAtBoundaryNodeDuringUpdate(Network network, Context context) {
        context.pushReportNode(CgmesReports.convertingDuringUpdateElementTypeReport(context.getReportNode(), IdentifiableType.TIE_LINE.name()));
        TieLineConversion.createDuringUpdate(network, context);
        context.popReportNode();
    }

    static void updateVoltageLevels(Network network, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.VOLTAGE_LEVEL.name()));
        network.getVoltageLevels().forEach(voltageLevel -> VoltageLevelConversion.update(voltageLevel, context));
        context.popReportNode();
    }

    static void updateGrounds(Network network, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.GROUND.name()));
        network.getGrounds().forEach(ground -> GroundConversion.update(ground, context));
        context.popReportNode();
    }

    static void createFictitiousLoadsForSvInjectionsDuringUpdate(Network network, CgmesModel cgmes, Context context) {
        if (context.config().convertSvInjections()) {
            context.pushReportNode(CgmesReports.convertingDuringUpdateElementTypeReport(context.getReportNode(), "SvInjection"));
            cgmes.svInjections().forEach(svInjection -> SvInjectionConversion.create(network, svInjection));
            context.popReportNode();
        }
    }

    static void updateAreas(Network network, CgmesModel cgmes, Context context) {
        context.pushReportNode(CgmesReports.updatingElementTypeReport(context.getReportNode(), IdentifiableType.AREA.name()));
        HashMap<String, PropertyBag> equipmentIdPropertyBag = new HashMap<String, PropertyBag>();
        Update.addPropertyBags(cgmes.controlAreas(), "ControlArea", equipmentIdPropertyBag);
        network.getAreas().forEach(area -> ControlAreaConversion.update(area, Update.getPropertyBag(area.getId(), equipmentIdPropertyBag), context));
        context.popReportNode();
    }

    static void updateAndCompleteVoltageAndAngles(Network network, Context context) {
        context.pushReportNode(CgmesReports.settingVoltagesAndAnglesReport(context.getReportNode()));
        network.getBusView().getBuses().forEach(bus -> NodeConversion.update(bus, context));
        network.getDanglingLineStream(DanglingLineFilter.UNPAIRED).forEach(AbstractConductingEquipmentConversion::calculateVoltageAndAngleInBoundaryBus);
        network.getTieLines().forEach(tieLine -> AbstractConductingEquipmentConversion.calculateVoltageAndAngleInBoundaryBus(tieLine.getDanglingLine1(), tieLine.getDanglingLine2()));
        network.getThreeWindingsTransformers().forEach(ThreeWindingsTransformerConversion::calculateVoltageAndAngleInStarBus);
        context.popReportNode();
    }

    private static void addPropertyBags(PropertyBags propertyBags, String idTag, Map<String, PropertyBag> equipmentIdPropertyBag) {
        propertyBags.forEach(propertyBag -> equipmentIdPropertyBag.put(propertyBag.getId(idTag), (PropertyBag)propertyBag));
    }

    private static PropertyBag getPropertyBag(String identifiableId, Map<String, PropertyBag> equipmentIdPropertyBag) {
        return equipmentIdPropertyBag.getOrDefault(identifiableId, EMPTY_PROPERTY_BAG);
    }

    private static PropertyBag getEquivalentInjectionPropertyBag(String equivalentInjectionId, Context context) {
        PropertyBag cgmesData = context.equivalentInjection(equivalentInjectionId);
        return cgmesData != null ? cgmesData : EMPTY_PROPERTY_BAG;
    }

    private static PropertyBag getSwitchPropertyBag(String switchId, Context context) {
        PropertyBag cgmesData = context.cgmesSwitch(switchId);
        return cgmesData != null ? cgmesData : EMPTY_PROPERTY_BAG;
    }
}

