/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.OperationalLimitConversion;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;

public abstract class AbstractBranchConversion
extends AbstractConductingEquipmentConversion {
    protected AbstractBranchConversion(String type, PropertyBag p, Context context) {
        super(type, p, context, 2);
    }

    @Override
    public boolean valid() {
        if (!super.valid()) {
            return false;
        }
        String node1 = this.nodeId(1);
        String node2 = this.nodeId(2);
        if (this.context.boundary().containsNode(node1) || this.context.boundary().containsNode(node2)) {
            this.invalid("Has " + this.nodeIdPropertyName() + " on boundary");
            return false;
        }
        if (!this.p.containsKey((Object)"r") || !this.p.containsKey((Object)"x")) {
            this.invalid("No r,x attributes");
            return false;
        }
        return true;
    }

    protected void convertBranch(double r, double x, double gch, double bch, String originalClass) {
        if (this.isZeroImpedanceInsideVoltageLevel(r, x)) {
            Switch sw;
            boolean normalOpen = false;
            if (this.context.nodeBreaker()) {
                VoltageLevel.NodeBreakerView.SwitchAdder adder = (VoltageLevel.NodeBreakerView.SwitchAdder)this.voltageLevel().getNodeBreakerView().newSwitch().setKind(SwitchKind.BREAKER).setOpen(normalOpen).setRetained(true).setFictitious(true);
                this.identify((IdentifiableAdder<?, ?>)adder);
                this.connectWithOnlyEq(adder);
                sw = adder.add();
            } else {
                VoltageLevel.BusBreakerView.SwitchAdder adder = (VoltageLevel.BusBreakerView.SwitchAdder)this.voltageLevel().getBusBreakerView().newSwitch().setOpen(normalOpen).setFictitious(true);
                this.identify((IdentifiableAdder<?, ?>)adder);
                this.connectWithOnlyEq(adder);
                sw = adder.add();
            }
            this.addAliasesAndProperties((Identifiable<?>)sw);
            sw.setProperty("CGMES.originalClass", originalClass);
            sw.setProperty("CGMES.normalOpen", String.valueOf(normalOpen));
        } else {
            LineAdder adder = ((LineAdder)this.context.network().newLine().setEnsureIdUnicity(this.context.config().isEnsureIdAliasUnicity())).setR(r).setX(x).setG1(gch / 2.0).setG2(gch / 2.0).setB1(bch / 2.0).setB2(bch / 2.0);
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connectWithOnlyEq((BranchAdder<?, ?>)adder);
            Line l = adder.add();
            this.addAliasesAndProperties((Identifiable<?>)l);
            this.convertedTerminalsWithOnlyEq(l.getTerminal1(), l.getTerminal2());
            l.setProperty("CGMES.originalClass", originalClass);
        }
    }

    private boolean isZeroImpedanceInsideVoltageLevel(double r, double x) {
        Optional<VoltageLevel> vl1 = this.voltageLevel(1);
        Optional<VoltageLevel> vl2 = this.voltageLevel(2);
        if (vl1.isPresent()) {
            if (vl2.isPresent() && vl1.get() == vl2.get()) {
                return r == 0.0 && x == 0.0;
            }
            return false;
        }
        if (vl2.isPresent()) {
            return false;
        }
        return r == 0.0 && x == 0.0;
    }

    protected static void updateBranch(Line line, Context context) {
        AbstractBranchConversion.updateTerminals(line, context, new Terminal[]{line.getTerminal1(), line.getTerminal2()});
        line.getOperationalLimitsGroups1().forEach(operationalLimitsGroup -> OperationalLimitConversion.update(operationalLimitsGroup, context));
        line.getOperationalLimitsGroups2().forEach(operationalLimitsGroup -> OperationalLimitConversion.update(operationalLimitsGroup, context));
    }

    protected static void updateBranch(Switch sw, Context context) {
        boolean isOpen = AbstractBranchConversion.isOpenFromAtLeastOneTerminal(sw, context).orElse(AbstractBranchConversion.getDefaultIsOpen(sw, context));
        sw.setOpen(isOpen);
    }
}

