/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentInjectionConversion;
import com.powsybl.cgmes.conversion.elements.OperationalLimitConversion;
import com.powsybl.cgmes.extensions.CgmesDanglingLineBoundaryNodeAdder;
import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.SV;
import com.powsybl.iidm.network.util.TieLineUtil;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractConductingEquipmentConversion
extends AbstractIdentifiedObjectConversion {
    private static final PropertyBag EMPTY_PROPERTY_BAG = new PropertyBag(Collections.emptyList(), false);
    private final int numTerminals;
    private final TerminalData[] terminals;

    protected AbstractConductingEquipmentConversion(String type, PropertyBag p, Context context) {
        super(type, p, context);
        this.numTerminals = 1;
        this.terminals = new TerminalData[]{null, null, null};
        this.terminals[0] = new TerminalData("Terminal", p, context);
    }

    protected AbstractConductingEquipmentConversion(String type, PropertyBag p, Context context, int numTerminals) {
        super(type, p, context);
        if (numTerminals > 3) {
            throw new IllegalArgumentException("Invalid number of terminals at " + this.id + ": " + numTerminals);
        }
        this.terminals = new TerminalData[]{null, null, null};
        this.numTerminals = numTerminals;
        for (int k = 1; k <= numTerminals; ++k) {
            int k0 = k - 1;
            this.terminals[k0] = new TerminalData("Terminal" + k, p, context);
        }
    }

    protected AbstractConductingEquipmentConversion(String type, PropertyBags ps, Context context) {
        super(type, ps, context);
        this.numTerminals = ps.size();
        this.terminals = new TerminalData[]{null, null, null};
        if (this.numTerminals > 3) {
            throw new IllegalStateException("numTerminals should be less or equal to 3 but is " + this.numTerminals);
        }
        for (int k = 1; k <= this.numTerminals; ++k) {
            int k0 = k - 1;
            this.terminals[k0] = new TerminalData("Terminal", (PropertyBag)ps.get(k0), context);
        }
    }

    public String findPairingKey(String boundaryNode) {
        return AbstractConductingEquipmentConversion.findPairingKey(this.context, boundaryNode);
    }

    public static String findPairingKey(Context context, String boundaryNode) {
        return context.boundary().nameAtBoundary(boundaryNode);
    }

    public String boundaryNode() {
        if (this.isBoundary(1)) {
            return this.nodeId(1);
        }
        if (this.isBoundary(2)) {
            return this.nodeId(2);
        }
        return null;
    }

    @Override
    public boolean insideBoundary() {
        for (int k = 1; k <= this.numTerminals; ++k) {
            if (this.context.boundary().containsNode(this.nodeId(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void convertInsideBoundary() {
        if (this.context.config().convertBoundary() && this.valid()) {
            this.convert();
        }
    }

    @Override
    public boolean valid() {
        for (int k = 1; k <= this.numTerminals; ++k) {
            if (this.nodeId(k) == null) {
                this.missing(this.nodeIdPropertyName() + k);
                return false;
            }
            if (!this.voltageLevel(k).isEmpty()) continue;
            this.missing(String.format("VoltageLevel of terminal %d %s (iidm %s)", k, this.cgmesVoltageLevelId(k), this.iidmVoltageLevelId(k)));
            return false;
        }
        return true;
    }

    boolean validNodes() {
        for (int k = 1; k <= this.numTerminals; ++k) {
            if (this.nodeId(k) != null) continue;
            this.missing(this.nodeIdPropertyName() + k);
            return false;
        }
        return true;
    }

    protected String nodeIdPropertyName() {
        return this.context.nodeBreaker() ? "ConnectivityNode" : "TopologicalNode";
    }

    String terminalId() {
        return this.terminals[0].t.id();
    }

    String terminalId(int n) {
        return this.terminals[n - 1].t.id();
    }

    protected String nodeId() {
        return this.context.nodeBreaker() ? this.terminals[0].t.connectivityNode() : this.terminals[0].t.topologicalNode();
    }

    protected String nodeId(int n) {
        return this.context.nodeBreaker() ? this.terminals[n - 1].t.connectivityNode() : this.terminals[n - 1].t.topologicalNode();
    }

    protected String topologicalNodeId(int n) {
        return this.terminals[n - 1].t.topologicalNode();
    }

    protected String connectivityNodeId(int n) {
        return this.terminals[n - 1].t.connectivityNode();
    }

    protected boolean isBoundary(int n) {
        return this.voltageLevel(n).isEmpty() || this.context.boundary().containsNode(this.nodeId(n));
    }

    public DanglingLine convertToDanglingLine(String eqInstance, int boundarySide, String originalClass) {
        return this.convertToDanglingLine(eqInstance, boundarySide, 0.0, 0.0, 0.0, 0.0, originalClass);
    }

    public DanglingLine convertToDanglingLine(String eqInstance, int boundarySide, double r, double x, double gch, double bch, String originalClass) {
        DanglingLine dl;
        int modelSide = 3 - boundarySide;
        String boundaryNode = this.nodeId(boundarySide);
        if (!this.isBoundary(boundarySide) || this.isBoundary(modelSide)) {
            throw new PowsyblException(String.format("Unexpected boundarySide and modelSide at boundaryNode: %s", boundaryNode));
        }
        DanglingLineAdder dlAdder = this.voltageLevel(modelSide).map(vl -> ((DanglingLineAdder)vl.newDanglingLine().setEnsureIdUnicity(this.context.config().isEnsureIdAliasUnicity())).setR(r).setX(x).setG(gch).setB(bch).setPairingKey(this.findPairingKey(boundaryNode))).orElseThrow(() -> new CgmesModelException("Dangling line " + this.id + " has no container"));
        this.identify((IdentifiableAdder<?, ?>)dlAdder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)dlAdder, modelSide);
        Optional<EquivalentInjectionConversion> equivalentInjectionConversion = AbstractConductingEquipmentConversion.getEquivalentInjectionConversionForDanglingLine(this.context, boundaryNode, eqInstance);
        if (equivalentInjectionConversion.isPresent()) {
            dl = equivalentInjectionConversion.get().convertOverDanglingLine(dlAdder);
            Optional.ofNullable(dl.getGeneration()).ifPresent(equivalentInjectionConversion.get()::convertReactiveLimits);
        } else {
            dl = dlAdder.setP0(Double.NaN).setQ0(Double.NaN).add();
        }
        this.context.terminalMapping().add(this.terminalId(boundarySide), dl.getBoundary(), 2);
        dl.addAlias(this.terminalId(boundarySide), "CGMES.Terminal_Boundary");
        dl.setProperty("CGMES.Terminal_Boundary", this.terminalId(boundarySide));
        dl.addAlias(this.terminalId(boundarySide == 1 ? 2 : 1), "CGMES.Terminal1");
        dl.setProperty("CGMES.Terminal", this.terminalId(boundarySide == 1 ? 2 : 1));
        Optional.ofNullable(this.topologicalNodeId(boundarySide)).ifPresent(tn -> {
            if (this.isTopologicalNodeDefinedAtBoundary((String)tn, boundarySide)) {
                dl.setProperty("CGMES.TopologicalNode_Boundary", tn);
            }
        });
        Optional.ofNullable(this.connectivityNodeId(boundarySide)).ifPresent(cn -> dl.setProperty("CGMES.ConnectivityNode_Boundary", cn));
        this.setBoundaryNodeInfo(boundaryNode, dl);
        this.context.convertedTerminalWithOnlyEq(this.terminalId(modelSide), dl.getTerminal(), 1);
        dl.setProperty("CGMES.originalClass", originalClass);
        return dl;
    }

    private boolean isTopologicalNodeDefinedAtBoundary(String topologicalNode, int boundarySide) {
        return this.context.boundary().containsNode(topologicalNode) || this.connectivityNodeId(boundarySide) == null;
    }

    protected static void updateDanglingLine(DanglingLine danglingLine, boolean isBoundaryTerminalConnected, Context context) {
        AbstractConductingEquipmentConversion.updateTerminals(danglingLine, context, new Terminal[]{danglingLine.getTerminal()});
        AbstractConductingEquipmentConversion.updateTargetsAndRegulationAndOperationalLimits(danglingLine, isBoundaryTerminalConnected, context);
        AbstractConductingEquipmentConversion.computeFlowsOnModelSide(danglingLine, context);
    }

    private static void updateTargetsAndRegulationAndOperationalLimits(DanglingLine danglingLine, boolean isConnectedOnBoundarySide, Context context) {
        EquivalentInjectionConversion.update(danglingLine, isConnectedOnBoundarySide, context);
        danglingLine.getOperationalLimitsGroups().forEach(operationalLimitsGroup -> OperationalLimitConversion.update(operationalLimitsGroup, context));
    }

    public static boolean isBoundaryTerminalConnected(DanglingLine danglingLine, Context context) {
        return AbstractConductingEquipmentConversion.getBoundaryCgmesTerminal(danglingLine, context).map(cgmesTerminalData -> cgmesTerminalData.asBoolean("connected", true)).orElse(true);
    }

    private static Optional<PropertyBag> getBoundaryCgmesTerminal(DanglingLine danglingLine, Context context) {
        String cgmesTerminalId = danglingLine.getAliasFromType("CGMES.Terminal_Boundary").orElse(null);
        return cgmesTerminalId != null ? Optional.ofNullable(context.cgmesTerminal(cgmesTerminalId)) : Optional.empty();
    }

    protected static void computeFlowsOnModelSide(DanglingLine danglingLine, Context context) {
        if (context.config().computeFlowsAtBoundaryDanglingLines() && danglingLine.getTerminal().isConnected() && !AbstractConductingEquipmentConversion.isFlowOnModelSideDefined(danglingLine)) {
            if (AbstractConductingEquipmentConversion.isZ0(danglingLine)) {
                Optional<DanglingLine.Generation> generation = Optional.ofNullable(danglingLine.getGeneration());
                danglingLine.getTerminal().setP(danglingLine.getP0() - generation.map(DanglingLine.Generation::getTargetP).orElse(0.0));
                danglingLine.getTerminal().setQ(danglingLine.getQ0() - generation.map(DanglingLine.Generation::getTargetQ).orElse(0.0));
            } else {
                AbstractConductingEquipmentConversion.setDanglingLineModelSideFlow(danglingLine, context);
            }
        }
    }

    private static boolean isFlowOnModelSideDefined(DanglingLine danglingLine) {
        return Double.isFinite(danglingLine.getTerminal().getP()) && Double.isFinite(danglingLine.getTerminal().getQ());
    }

    public static void calculateVoltageAndAngleInBoundaryBus(DanglingLine dl) {
        double angle;
        double v = dl.getBoundary().getV();
        if (AbstractConductingEquipmentConversion.isVoltageDefined(v, angle = dl.getBoundary().getAngle())) {
            AbstractConductingEquipmentConversion.setVoltageProperties(dl, v, angle);
        }
    }

    public static void calculateVoltageAndAngleInBoundaryBus(DanglingLine dl1, DanglingLine dl2) {
        double angle;
        double v = TieLineUtil.getBoundaryV((DanglingLine)dl1, (DanglingLine)dl2);
        if (!AbstractConductingEquipmentConversion.isVoltageDefined(v, angle = TieLineUtil.getBoundaryAngle((DanglingLine)dl1, (DanglingLine)dl2))) {
            v = dl1.getBoundary().getV();
            angle = dl1.getBoundary().getAngle();
        }
        if (!AbstractConductingEquipmentConversion.isVoltageDefined(v, angle)) {
            v = dl2.getBoundary().getV();
            angle = dl2.getBoundary().getAngle();
        }
        if (AbstractConductingEquipmentConversion.isVoltageDefined(v, angle)) {
            AbstractConductingEquipmentConversion.setVoltageProperties(dl1, v, angle);
            AbstractConductingEquipmentConversion.setVoltageProperties(dl2, v, angle);
        }
    }

    private static boolean isVoltageDefined(double v, double angle) {
        return !Double.isNaN(v) && !Double.isNaN(angle);
    }

    private static void setVoltageProperties(DanglingLine dl, double v, double angle) {
        dl.setProperty("v", Double.toString(v));
        dl.setProperty("angle", Double.toString(angle));
    }

    private void setBoundaryNodeInfo(String boundaryNode, DanglingLine dl) {
        if (this.context.boundary().isHvdc(boundaryNode) || this.context.boundary().lineAtBoundary(boundaryNode) != null) {
            ((CgmesDanglingLineBoundaryNodeAdder)dl.newExtension(CgmesDanglingLineBoundaryNodeAdder.class)).setHvdc(this.context.boundary().isHvdc(boundaryNode)).setLineEnergyIdentificationCodeEic(this.context.boundary().lineAtBoundary(boundaryNode)).add();
            if (this.context.boundary().isHvdc(boundaryNode)) {
                dl.setProperty("isHvdc", "true");
            }
            if (this.context.boundary().lineAtBoundary(boundaryNode) != null) {
                dl.setProperty("lineEnergyIdentificationCodeEIC", this.context.boundary().lineAtBoundary(boundaryNode));
            }
        }
    }

    private static boolean isZ0(DanglingLine dl) {
        return dl.getR() == 0.0 && dl.getX() == 0.0 && dl.getG() == 0.0 && dl.getB() == 0.0;
    }

    private static void setDanglingLineModelSideFlow(DanglingLine dl, Context context) {
        double angle;
        Optional<PropertyBag> svVoltage = AbstractConductingEquipmentConversion.getCgmesSvVoltageOnBoundarySide(dl, context);
        if (svVoltage.isEmpty()) {
            return;
        }
        double v = svVoltage.get().asDouble("v", Double.NaN);
        if (!AbstractConductingEquipmentConversion.isVoltageDefined(v, angle = svVoltage.get().asDouble("angle", Double.NaN))) {
            return;
        }
        Optional<DanglingLine.Generation> generation = Optional.ofNullable(dl.getGeneration());
        double p = dl.getP0() - generation.map(DanglingLine.Generation::getTargetP).orElse(0.0);
        double q = dl.getQ0() - generation.map(DanglingLine.Generation::getTargetQ).orElse(0.0);
        SV svboundary = new SV(-p, -q, v, angle, TwoSides.ONE);
        double g = dl.getG() / 2.0;
        double b = dl.getB() / 2.0;
        SV svmodel = svboundary.otherSide(dl.getR(), dl.getX(), g, b, g, b, 1.0, 0.0);
        dl.getTerminal().setP(svmodel.getP());
        dl.getTerminal().setQ(svmodel.getQ());
    }

    private static Optional<PropertyBag> getCgmesSvVoltageOnBoundarySide(DanglingLine danglingLine, Context context) {
        String topologicalNodeIdOnBoundarySide = AbstractConductingEquipmentConversion.getTopologicalNodeIdOnBoundarySide(danglingLine, context);
        if (topologicalNodeIdOnBoundarySide != null) {
            return Optional.ofNullable(context.svVoltage(topologicalNodeIdOnBoundarySide));
        }
        return Optional.empty();
    }

    private static String getTopologicalNodeIdOnBoundarySide(DanglingLine danglingLine, Context context) {
        PropertyBag cgmesTerminal;
        String topologicalNodeIdOnBoundarySide = danglingLine.getProperty("CGMES.TopologicalNode_Boundary");
        if (topologicalNodeIdOnBoundarySide != null) {
            return topologicalNodeIdOnBoundarySide;
        }
        String terminalIdOnBoundarySide = danglingLine.getProperty("CGMES.Terminal_Boundary");
        if (terminalIdOnBoundarySide != null && (cgmesTerminal = context.cgmesTerminal(terminalIdOnBoundarySide)) != null) {
            return cgmesTerminal.getId("TopologicalNode");
        }
        return null;
    }

    private static Optional<EquivalentInjectionConversion> getEquivalentInjectionConversionForDanglingLine(Context context, String boundaryNode, String eqInstance) {
        List<PropertyBag> eis = context.boundary().equivalentInjectionsAtNode(boundaryNode);
        if (eis.isEmpty()) {
            return Optional.empty();
        }
        if (eis.size() == 1) {
            return Optional.of(new EquivalentInjectionConversion(eis.get(0), context));
        }
        String eqInstancePropertyName = "graph";
        List<PropertyBag> eisEqInstance = eis.stream().filter(eik -> eik.getId(eqInstancePropertyName).equals(eqInstance)).toList();
        if (eisEqInstance.size() == 1) {
            return Optional.of(new EquivalentInjectionConversion(eisEqInstance.get(0), context));
        }
        context.invalid("Boundary node " + boundaryNode, "Assembled model does not contain only one equivalent injection in the same graph " + eqInstance);
        return Optional.empty();
    }

    int iidmNode() {
        return this.iidmNode(1);
    }

    int iidmNode(int n) {
        if (!this.context.nodeBreaker()) {
            throw new ConversionException("Can't request an iidmNode if conversion context is not node-breaker");
        }
        VoltageLevel vl = this.terminals[n - 1].voltageLevel;
        CgmesTerminal t = this.terminals[n - 1].t;
        return this.context.nodeMapping().iidmNodeForTerminal(t, vl);
    }

    String busId() {
        return this.terminals[0].busId;
    }

    String busId(int n) {
        return this.terminals[n - 1].busId;
    }

    boolean terminalConnected(int n) {
        return this.terminals[n - 1].t.connected();
    }

    String cgmesVoltageLevelId(int n) {
        return this.terminals[n - 1].cgmesVoltageLevelId;
    }

    String iidmVoltageLevelId(int n) {
        return this.terminals[n - 1].iidmVoltageLevelId;
    }

    protected VoltageLevel voltageLevel() {
        if (this.terminals[0].iidmVoltageLevelId != null) {
            VoltageLevel vl = this.context.network().getVoltageLevel(this.terminals[0].iidmVoltageLevelId);
            if (vl != null) {
                return vl;
            }
            throw new CgmesModelException(this.type + " " + this.id + " voltage level " + this.terminals[0].iidmVoltageLevelId + " has not been created in IIDM");
        }
        if (this.terminals[0].voltageLevel != null) {
            return this.terminals[0].voltageLevel;
        }
        throw new CgmesModelException(this.type + " " + this.id + " has no container");
    }

    Optional<VoltageLevel> voltageLevel(int n) {
        if (this.terminals[n - 1].iidmVoltageLevelId != null) {
            return Optional.ofNullable(this.context.network().getVoltageLevel(this.terminals[n - 1].iidmVoltageLevelId));
        }
        if (this.terminals[n - 1].voltageLevel != null) {
            return Optional.of(this.terminals[n - 1].voltageLevel);
        }
        return Optional.empty();
    }

    protected Optional<Substation> substation() {
        return this.terminals[0].voltageLevel != null ? this.terminals[0].voltageLevel.getSubstation() : Optional.empty();
    }

    protected void convertedTerminalsWithOnlyEq(Terminal ... ts) {
        if (ts.length != this.numTerminals) {
            throw new IllegalArgumentException();
        }
        for (int k = 0; k < ts.length; ++k) {
            int n = k + 1;
            Terminal t = ts[k];
            this.context.convertedTerminalWithOnlyEq(this.terminalId(n), t, n);
        }
    }

    public static void updateTerminals(Connectable<?> connectable, Context context, Terminal ... ts) {
        PropertyBags cgmesTerminals = AbstractConductingEquipmentConversion.getCgmesTerminals(connectable, context, ts.length);
        for (int k = 0; k < ts.length; ++k) {
            AbstractConductingEquipmentConversion.updateTerminal((PropertyBag)cgmesTerminals.get(k), ts[k], context);
        }
    }

    private static void updateTerminal(PropertyBag cgmesTerminal, Terminal terminal, Context context) {
        PowerFlow f;
        if (AbstractConductingEquipmentConversion.updateConnect(terminal, context)) {
            boolean connectedInUpdate = cgmesTerminal.asBoolean("connected", true);
            if (!terminal.isConnected() && connectedInUpdate) {
                terminal.connect();
            } else if (terminal.isConnected() && !connectedInUpdate) {
                terminal.disconnect();
            }
        }
        if (AbstractConductingEquipmentConversion.setPQAllowed(terminal) && (f = new PowerFlow(cgmesTerminal, "p", "q")).defined()) {
            terminal.setP(f.p());
            terminal.setQ(f.q());
        }
    }

    private static boolean updateConnect(Terminal terminal, Context context) {
        if (terminal.getVoltageLevel().getTopologyKind().equals((Object)TopologyKind.NODE_BREAKER)) {
            return context.config().updateTerminalConnectionInNodeBreakerVoltageLevel();
        }
        return true;
    }

    private static boolean setPQAllowed(Terminal t) {
        return t.getConnectable().getType() != IdentifiableType.BUSBAR_SECTION;
    }

    private static PropertyBag getCgmesTerminal(Connectable<?> connectable, Context context) {
        return (PropertyBag)AbstractConductingEquipmentConversion.getCgmesTerminals(connectable, context, 1).get(0);
    }

    private static PropertyBags getCgmesTerminals(Connectable<?> connectable, Context context, int numTerminals) {
        PropertyBags propertyBags = new PropertyBags();
        AbstractConductingEquipmentConversion.getTerminalTags(numTerminals).forEach(terminalTag -> propertyBags.add((Object)connectable.getAliasFromType("CGMES." + terminalTag).map(cgmesTerminalId -> AbstractConductingEquipmentConversion.getCgmesTerminal(cgmesTerminalId, context)).orElse(EMPTY_PROPERTY_BAG)));
        return propertyBags;
    }

    private static List<String> getTerminalTags(int numTerminals) {
        return switch (numTerminals) {
            case 1 -> List.of("Terminal1");
            case 2 -> List.of("Terminal1", "Terminal2");
            case 3 -> List.of("Terminal1", "Terminal2", "Terminal3");
            default -> throw new PowsyblException("unexpected number of terminals " + numTerminals);
        };
    }

    private static PropertyBag getCgmesTerminal(String cgmesTerminalId, Context context) {
        return context.cgmesTerminal(cgmesTerminalId) != null ? context.cgmesTerminal(cgmesTerminalId) : EMPTY_PROPERTY_BAG;
    }

    public void connectWithOnlyEq(InjectionAdder<?, ?> adder) {
        if (this.context.nodeBreaker()) {
            adder.setNode(this.iidmNode());
        } else {
            adder.setBus(null).setConnectableBus(this.busId());
        }
    }

    public void connectWithOnlyEq(InjectionAdder<?, ?> adder, int terminal) {
        if (this.context.nodeBreaker()) {
            adder.setNode(this.iidmNode(terminal));
        } else {
            adder.setBus(null).setConnectableBus(this.busId(terminal));
        }
    }

    public void connectWithOnlyEq(BranchAdder<?, ?> adder) {
        if (this.context.nodeBreaker()) {
            adder.setVoltageLevel1(this.iidmVoltageLevelId(1)).setVoltageLevel2(this.iidmVoltageLevelId(2)).setNode1(this.iidmNode(1)).setNode2(this.iidmNode(2));
        } else {
            String busId1 = this.busId(1);
            String busId2 = this.busId(2);
            adder.setVoltageLevel1(this.iidmVoltageLevelId(1)).setVoltageLevel2(this.iidmVoltageLevelId(2)).setBus1(null).setBus2(null).setConnectableBus1(busId1).setConnectableBus2(busId2);
        }
    }

    public void connectWithOnlyEq(VoltageLevel.NodeBreakerView.SwitchAdder adder) {
        if (!this.context.nodeBreaker()) {
            throw new ConversionException("Not in node breaker context");
        }
        adder.setNode1(this.iidmNode(1)).setNode2(this.iidmNode(2));
    }

    public void connectWithOnlyEq(VoltageLevel.BusBreakerView.SwitchAdder adder) {
        adder.setBus1(this.busId(1)).setBus2(this.busId(2));
    }

    public void connectWithOnlyEq(ThreeWindingsTransformerAdder.LegAdder adder, int terminal) {
        if (this.context.nodeBreaker()) {
            adder.setVoltageLevel(this.iidmVoltageLevelId(terminal)).setNode(this.iidmNode(terminal));
        } else {
            adder.setVoltageLevel(this.iidmVoltageLevelId(terminal)).setBus(null).setConnectableBus(this.busId(terminal));
        }
    }

    protected void addAliasesAndProperties(Identifiable<?> identifiable) {
        int i = 1;
        for (TerminalData td : this.terminals) {
            if (td == null) break;
            identifiable.addAlias(td.t.id(), "CGMES.Terminal" + i, this.context.config().isEnsureIdAliasUnicity());
            ++i;
        }
    }

    protected static PowerFlow updatedPowerFlow(Connectable<?> connectable, PropertyBag cgmesData, Context context) {
        PowerFlow steadyStateHypothesisPowerFlow = new PowerFlow(cgmesData, "p", "q");
        if (steadyStateHypothesisPowerFlow.defined()) {
            return steadyStateHypothesisPowerFlow;
        }
        PropertyBag cgmesTerminal = AbstractConductingEquipmentConversion.getCgmesTerminal(connectable, context);
        PowerFlow stateVariablesPowerFlow = new PowerFlow(cgmesTerminal, "p", "q");
        if (stateVariablesPowerFlow.defined()) {
            return stateVariablesPowerFlow;
        }
        return PowerFlow.UNDEFINED;
    }

    protected static Optional<PropertyBag> findCgmesRegulatingControl(Connectable<?> connectable, Context context) {
        String regulatingControlId = connectable.getProperty("CGMES.RegulatingControl");
        return regulatingControlId != null ? Optional.ofNullable(context.regulatingControl(regulatingControlId)) : Optional.empty();
    }

    protected static int findTerminalSign(Connectable<?> connectable) {
        return AbstractConductingEquipmentConversion.findTerminalSign(connectable, "");
    }

    protected static int findTerminalSign(Connectable<?> connectable, String end) {
        String terminalSign = connectable.getProperty("CGMES.terminalSign" + end);
        return terminalSign != null ? Integer.parseInt(terminalSign) : 1;
    }

    protected static double findTargetV(PropertyBag regulatingControl, double defaultValue, DefaultValueUse use) {
        return AbstractConductingEquipmentConversion.findTargetV(regulatingControl, "targetValue", defaultValue, use);
    }

    protected static double findTargetV(PropertyBag regulatingControl, String propertyTag, double defaultValue, DefaultValueUse use) {
        double targetV = regulatingControl.asDouble(propertyTag);
        return AbstractConductingEquipmentConversion.useDefaultValue(regulatingControl.containsKey((Object)propertyTag), AbstractConductingEquipmentConversion.isValidTargetV(targetV), use) ? defaultValue : targetV;
    }

    protected static double findTargetQ(PropertyBag regulatingControl, int terminalSign, double defaultValue, DefaultValueUse use) {
        return AbstractConductingEquipmentConversion.findTargetValue(regulatingControl, terminalSign, defaultValue, use);
    }

    protected static double findTargetQ(PropertyBag regulatingControl, String propertyTag, int terminalSign, double defaultValue, DefaultValueUse use) {
        return AbstractConductingEquipmentConversion.findTargetValue(regulatingControl, propertyTag, terminalSign, defaultValue, use);
    }

    protected static double findTargetValue(PropertyBag regulatingControl, int terminalSign, double defaultValue, DefaultValueUse use) {
        return AbstractConductingEquipmentConversion.findTargetValue(regulatingControl, "targetValue", terminalSign, defaultValue, use);
    }

    protected static double findTargetValue(PropertyBag regulatingControl, String propertyTag, int terminalSign, double defaultValue, DefaultValueUse use) {
        double targetValue = regulatingControl.asDouble(propertyTag);
        return AbstractConductingEquipmentConversion.useDefaultValue(regulatingControl.containsKey((Object)propertyTag), AbstractConductingEquipmentConversion.isValidTargetValue(targetValue), use) ? defaultValue : targetValue * (double)terminalSign;
    }

    protected static double findTargetDeadband(PropertyBag regulatingControl, double defaultValue, DefaultValueUse use) {
        double targetDeadband = regulatingControl.asDouble("targetDeadband");
        return AbstractConductingEquipmentConversion.useDefaultValue(regulatingControl.containsKey((Object)"targetDeadband"), AbstractConductingEquipmentConversion.isValidTargetDeadband(targetDeadband), use) ? defaultValue : targetDeadband;
    }

    protected static boolean findRegulatingOn(PropertyBag regulatingControl, boolean defaultValue, DefaultValueUse use) {
        return AbstractConductingEquipmentConversion.findRegulatingOn(regulatingControl, "enabled", defaultValue, use);
    }

    protected static boolean findRegulatingOn(PropertyBag regulatingControl, String propertyTag, boolean defaultValue, DefaultValueUse use) {
        Optional isRegulatingOn = regulatingControl.asBoolean(propertyTag);
        return AbstractConductingEquipmentConversion.useDefaultValue(isRegulatingOn.isPresent(), true, use) ? defaultValue : isRegulatingOn.orElse(false);
    }

    private static boolean useDefaultValue(boolean isDefined, boolean isValid, DefaultValueUse use) {
        return use == DefaultValueUse.ALWAYS || use == DefaultValueUse.NOT_DEFINED && !isDefined || use == DefaultValueUse.NOT_VALID && !isValid;
    }

    protected static boolean isValidTargetV(double targetV) {
        return targetV > 0.0;
    }

    protected static boolean isValidTargetQ(double targetQ) {
        return AbstractConductingEquipmentConversion.isValidTargetValue(targetQ);
    }

    protected static boolean isValidTargetValue(double targetValue) {
        return Double.isFinite(targetValue);
    }

    protected static boolean isValidTargetDeadband(double targetDeadband) {
        return targetDeadband >= 0.0;
    }

    protected static Optional<Boolean> isOpenFromAtLeastOneTerminal(Switch sw, Context context) {
        Optional<Boolean> connected1 = AbstractConductingEquipmentConversion.isTerminalConnected(sw, context, TwoSides.ONE);
        Optional<Boolean> connected2 = AbstractConductingEquipmentConversion.isTerminalConnected(sw, context, TwoSides.TWO);
        return connected1.flatMap(c1 -> connected2.map(c2 -> c1 == false || c2 == false)).or(() -> connected1.map(c1 -> c1 == false)).or(() -> connected2.map(c2 -> c2 == false));
    }

    private static Optional<Boolean> isTerminalConnected(Switch sw, Context context, TwoSides side) {
        return sw.getAliasFromType("CGMES.Terminal" + side.getNum()).flatMap(cgmesTerminalId -> Optional.ofNullable(context.cgmesTerminal((String)cgmesTerminalId))).flatMap(cgmesTerminal -> cgmesTerminal.asBoolean("connected"));
    }

    protected static boolean getDefaultIsOpen(Switch sw, Context context) {
        String normalOpen = sw.getProperty("CGMES.normalOpen");
        return AbstractConductingEquipmentConversion.getDefaultValue(normalOpen != null ? Boolean.valueOf(Boolean.parseBoolean(normalOpen)) : null, sw.isOpen(), false, false, context);
    }

    static class TerminalData {
        private final CgmesTerminal t;
        private final String busId;
        private final String cgmesVoltageLevelId;
        private final String iidmVoltageLevelId;
        private final VoltageLevel voltageLevel;

        TerminalData(String terminalPropertyName, PropertyBag p, Context context) {
            this.t = context.cgmes().terminal(p.getId(terminalPropertyName));
            String nodeId = context.nodeBreaker() ? this.t.connectivityNode() : this.t.topologicalNode();
            this.busId = context.namingStrategy().getIidmId("Bus", nodeId);
            this.cgmesVoltageLevelId = context.config().convertBoundary() && context.boundary().containsNode(nodeId) ? Context.boundaryVoltageLevelId(nodeId) : TerminalData.findCgmesVoltageLevelIdForContainer(nodeId, context);
            if (this.cgmesVoltageLevelId != null) {
                String iidmVl = context.namingStrategy().getIidmId("VoltageLevel", this.cgmesVoltageLevelId);
                this.iidmVoltageLevelId = context.nodeContainerMapping().voltageLevelIidm(iidmVl);
                this.voltageLevel = context.network().getVoltageLevel(this.iidmVoltageLevelId);
            } else {
                this.iidmVoltageLevelId = null;
                this.voltageLevel = null;
            }
        }

        private static String findCgmesVoltageLevelIdForContainer(String nodeId, Context context) {
            String cgmesVoltageLevelId = null;
            Optional cgmesContainer = context.cgmes().nodeContainer(nodeId);
            if (cgmesContainer.isPresent() && (cgmesVoltageLevelId = ((CgmesContainer)cgmesContainer.get()).voltageLevel()) == null) {
                cgmesVoltageLevelId = context.nodeContainerMapping().getFictitiousVoltageLevelForContainer(((CgmesContainer)cgmesContainer.get()).id(), nodeId);
            }
            return cgmesVoltageLevelId;
        }
    }

    protected static enum DefaultValueUse {
        NEVER,
        NOT_DEFINED,
        NOT_VALID,
        ALWAYS;

    }
}

