/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.Conversion;
import com.powsybl.cgmes.conversion.elements.AbstractObjectConversion;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.List;

public abstract class AbstractIdentifiedObjectConversion
extends AbstractObjectConversion {
    protected final String id;
    protected final String name;

    public AbstractIdentifiedObjectConversion(String type, PropertyBag properties, Context context) {
        super(type, properties, context);
        this.id = properties.getId(type);
        this.name = (String)this.p.get((Object)"name");
        if (this.name == null) {
            this.missing("name");
        }
    }

    public AbstractIdentifiedObjectConversion(String type, PropertyBags propertiess, Context context) {
        super(type, propertiess, context);
        this.id = ((PropertyBag)this.ps.get(0)).getId(type);
        this.name = (String)((PropertyBag)this.ps.get(0)).get((Object)"name");
        if (this.name == null) {
            this.missing("name");
        }
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String iidmId() {
        return this.context.namingStrategy().getIidmId(this.type, this.id);
    }

    public String iidmName() {
        return this.context.namingStrategy().getIidmName(this.type, this.name);
    }

    public void identify(IdentifiableAdder<?, ?> adder) {
        this.identify(adder, this.iidmId(), this.iidmName());
    }

    public void identify(IdentifiableAdder<?, ?> adder, String duplicatedTag) {
        this.identify(adder, this.iidmId() + duplicatedTag, this.iidmName() + duplicatedTag);
    }

    public void identify(IdentifiableAdder<?, ?> adder, String id, String name) {
        AbstractIdentifiedObjectConversion.identify(this.context, adder, id, name);
    }

    public static void identify(Context context, IdentifiableAdder<?, ?> adder, String id, String name) {
        adder.setId(id).setName(name).setEnsureIdUnicity(context.config().isEnsureIdAliasUnicity());
    }

    @Override
    public String what() {
        if (this.name != null) {
            return String.format("%s %s (%s)", this.type, this.name, this.id);
        }
        return String.format("%s %s", this.type, this.id);
    }

    @Override
    protected String complete(String what) {
        if (this.name != null) {
            return String.format("%s at %s %s (%s)", what, this.type, this.name, this.id);
        }
        return String.format("%s at %s %s", what, this.type, this.id);
    }

    protected static double getDefaultValue(Double equipmentValue, Double previousValue, Double defaultValue, double emptyValue, Context context) {
        Double properPreviousValue = previousValue == null || Double.isNaN(previousValue) ? null : previousValue;
        return AbstractIdentifiedObjectConversion.getDefaultValue(equipmentValue, properPreviousValue, defaultValue, Double.valueOf(emptyValue), context.config().updateDefaultValuesPriority());
    }

    protected static int getDefaultValue(Integer equipmentValue, Integer previousValue, Integer defaultValue, int emptyValue, Context context) {
        return AbstractIdentifiedObjectConversion.getDefaultValue(equipmentValue, previousValue, defaultValue, Integer.valueOf(emptyValue), context.config().updateDefaultValuesPriority());
    }

    protected static boolean getDefaultValue(Boolean equipmentValue, Boolean previousValue, Boolean defaultValue, boolean emptyValue, Context context) {
        return AbstractIdentifiedObjectConversion.getDefaultValue(equipmentValue, previousValue, defaultValue, Boolean.valueOf(emptyValue), context.config().updateDefaultValuesPriority());
    }

    private static <T> T getDefaultValue(T equipmentValue, T previousValue, T defaultValue, T emptyValue, List<Conversion.Config.DefaultValue> selectors) {
        for (Conversion.Config.DefaultValue selector : selectors) {
            if (selector == Conversion.Config.DefaultValue.EQ && equipmentValue != null) {
                return equipmentValue;
            }
            if (selector == Conversion.Config.DefaultValue.PREVIOUS && previousValue != null) {
                return previousValue;
            }
            if (selector == Conversion.Config.DefaultValue.DEFAULT && defaultValue != null) {
                return defaultValue;
            }
            if (selector != Conversion.Config.DefaultValue.EMPTY) continue;
            return emptyValue;
        }
        return emptyValue;
    }
}

