/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.google.common.collect.Range;
import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMapping;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.ReactiveCapabilityCurveAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class AbstractReactiveLimitsOwnerConversion
extends AbstractConductingEquipmentConversion {
    public AbstractReactiveLimitsOwnerConversion(String type, PropertyBag p, Context context) {
        super(type, p, context);
    }

    private void getReactiveCapabilityCurveData(PropertyBag propertyBag, Map<Double, Range<Double>> qRanges) {
        double maxQ;
        double minQ;
        double p = propertyBag.asDouble("xvalue");
        if (!this.checkPointValidity(p, minQ = propertyBag.asDouble("y1value"), maxQ = propertyBag.asDouble("y2value"))) {
            return;
        }
        Range<Double> qRange = this.fixedMinMaxQ("ReactiveCapabilityCurve Point", minQ, maxQ);
        Range<Double> prev = qRanges.get(p);
        if (prev != null) {
            if (prev.isConnected(qRange)) {
                this.fixed("reactive capability curve", () -> String.format("point merged with another one with same p (%f)", p));
                qRanges.put(p, (Range<Double>)prev.span(qRange));
            } else {
                this.ignored("reactive capability curve point", () -> String.format("another point with same p (%f) and a disconnected reactive range", p));
            }
        } else {
            qRanges.put(p, qRange);
        }
    }

    protected void convertReactiveLimits(ReactiveLimitsHolder g) {
        if (this.p.containsKey((Object)"ReactiveCapabilityCurve")) {
            String curveId = this.p.getId("ReactiveCapabilityCurve");
            PropertyBags curveData = this.context.reactiveCapabilityCurveData(curveId);
            HashMap qRanges = new HashMap();
            curveData.forEach(d -> this.getReactiveCapabilityCurveData((PropertyBag)d, qRanges));
            if (qRanges.size() >= 2) {
                ReactiveCapabilityCurveAdder rcca = g.newReactiveCapabilityCurve();
                for (Map.Entry e : qRanges.entrySet()) {
                    double p = (Double)e.getKey();
                    Range qRange = (Range)e.getValue();
                    rcca.beginPoint().setP(p).setMinQ(((Double)qRange.lowerEndpoint()).doubleValue()).setMaxQ(((Double)qRange.upperEndpoint()).doubleValue()).endPoint();
                }
                rcca.add();
            } else if (qRanges.size() == 1) {
                this.fixed("reactive capability curve", "only one point");
                Map.Entry e = qRanges.entrySet().iterator().next();
                Range qRange = (Range)e.getValue();
                g.newMinMaxReactiveLimits().setMinQ(((Double)qRange.lowerEndpoint()).doubleValue()).setMaxQ(((Double)qRange.upperEndpoint()).doubleValue()).add();
            } else {
                this.missing("Empty curve");
                this.convertMinMaxQ(g);
            }
        } else {
            this.convertMinMaxQ(g);
        }
    }

    private void convertMinMaxQ(ReactiveLimitsHolder g) {
        if (this.p.containsKey((Object)"minQ") && this.p.containsKey((Object)"maxQ")) {
            double minQ = this.p.asDouble("minQ");
            double maxQ = this.p.asDouble("maxQ");
            Range<Double> qRange = this.fixedMinMaxQ("Reactive Limits", minQ, maxQ);
            g.newMinMaxReactiveLimits().setMinQ(((Double)qRange.lowerEndpoint()).doubleValue()).setMaxQ(((Double)qRange.upperEndpoint()).doubleValue()).add();
        } else {
            this.missing("minQ/maxQ are missing, default to unbounded reactive limits");
        }
    }

    private boolean checkPointValidity(double p, double minQ, double maxQ) {
        if (Double.isNaN(p) || Double.isNaN(minQ) || Double.isNaN(maxQ)) {
            Supplier<String> reason = () -> String.format("Incomplete point p, minQ, maxQ = %f, %f, %f", p, minQ, maxQ);
            this.ignored("ReactiveCapabilityCurvePoint", reason);
            return false;
        }
        return true;
    }

    private Range<Double> fixedMinMaxQ(String context, double minQ, double maxQ) {
        if (minQ > maxQ) {
            Supplier<String> reason = () -> String.format("minQ > maxQ (%.4f > %.4f)", minQ, maxQ);
            this.fixed(context, reason);
            return Range.closed((Comparable)Double.valueOf(maxQ), (Comparable)Double.valueOf(minQ));
        }
        return Range.closed((Comparable)Double.valueOf(minQ), (Comparable)Double.valueOf(maxQ));
    }

    protected void setMinPMaxP(GeneratorAdder adder, double minP, double maxP) {
        if (minP > maxP) {
            this.context.fixed("Active power limits", String.format("minP (%f) > maxP (%f)", minP, maxP));
            adder.setMinP(maxP).setMaxP(minP);
            return;
        }
        adder.setMinP(minP).setMaxP(maxP);
    }

    protected static void updateRegulatingControl(Generator generator, Boolean controlEnabled, Context context) {
        String mode = generator.getProperty("CGMES.mode");
        if (RegulatingControlMapping.isControlModeVoltage(mode)) {
            AbstractReactiveLimitsOwnerConversion.updateRegulatingControlVoltage(generator, controlEnabled, context);
        } else if (RegulatingControlMapping.isControlModeReactivePower(mode)) {
            AbstractReactiveLimitsOwnerConversion.updateRegulatingControlReactivePower(generator, controlEnabled, context);
        } else {
            context.ignored(mode, "Unsupported regulation mode for generator " + generator.getId());
        }
    }

    private static void updateRegulatingControlVoltage(Generator generator, Boolean controlEnabled, Context context) {
        Optional<PropertyBag> cgmesRegulatingControl = AbstractReactiveLimitsOwnerConversion.findCgmesRegulatingControl(generator, context);
        double defaultTargetV = AbstractReactiveLimitsOwnerConversion.getDefaultTargetV(generator, context);
        double targetV = cgmesRegulatingControl.map(propertyBag -> AbstractReactiveLimitsOwnerConversion.findTargetV(propertyBag, defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_VALID)).orElse(defaultTargetV);
        boolean defaultRegulatingOn = AbstractReactiveLimitsOwnerConversion.getDefaultRegulatingOn(generator, context);
        boolean updatedControlEnabled = controlEnabled != null ? controlEnabled : defaultRegulatingOn;
        boolean regulatingOn = cgmesRegulatingControl.map(propertyBag -> AbstractReactiveLimitsOwnerConversion.findRegulatingOn(propertyBag, defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
        boolean validTargetV = AbstractReactiveLimitsOwnerConversion.isValidTargetV(targetV);
        if (!validTargetV) {
            context.invalid(generator.getId(), "Regulating control has a bad target voltage " + targetV);
            CgmesReports.badVoltageTargetValueRegulatingControlReport(context.getReportNode(), generator.getId(), targetV);
        }
        AbstractReactiveLimitsOwnerConversion.setVoltageRegulation(generator, targetV, regulatingOn && updatedControlEnabled && validTargetV);
    }

    private static void setVoltageRegulation(Generator generator, double targetV, boolean regulatingOn) {
        if (regulatingOn) {
            generator.setTargetV(targetV).setVoltageRegulatorOn(true);
        } else {
            generator.setVoltageRegulatorOn(false).setTargetV(targetV);
        }
    }

    private static void updateRegulatingControlReactivePower(Generator generator, Boolean controlEnabled, Context context) {
        RemoteReactivePowerControl remoteReactivePowerControl = (RemoteReactivePowerControl)generator.getExtension(RemoteReactivePowerControl.class);
        if (remoteReactivePowerControl == null || remoteReactivePowerControl.getRegulatingTerminal() == null) {
            return;
        }
        Optional<PropertyBag> cgmesRegulatingControl = AbstractReactiveLimitsOwnerConversion.findCgmesRegulatingControl(generator, context);
        int terminalSign = AbstractReactiveLimitsOwnerConversion.findTerminalSign(generator);
        double defaultTargetQ = AbstractReactiveLimitsOwnerConversion.getDefaultTargetQ(remoteReactivePowerControl, context);
        boolean defaultRegulatingOn = AbstractReactiveLimitsOwnerConversion.getDefaultRegulatingOn(remoteReactivePowerControl, context);
        boolean updatedControlEnabled = controlEnabled != null ? controlEnabled : defaultRegulatingOn;
        double targetQ = cgmesRegulatingControl.map(propertyBag -> AbstractReactiveLimitsOwnerConversion.findTargetQ(propertyBag, terminalSign, defaultTargetQ, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetQ);
        boolean regulatingOn = cgmesRegulatingControl.map(propertyBag -> AbstractReactiveLimitsOwnerConversion.findRegulatingOn(propertyBag, defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
        AbstractReactiveLimitsOwnerConversion.setReactivePowerRegulation(remoteReactivePowerControl, targetQ, regulatingOn && updatedControlEnabled && AbstractReactiveLimitsOwnerConversion.isValidTargetQ(targetQ));
    }

    private static void setReactivePowerRegulation(RemoteReactivePowerControl remoteReactivePowerControl, double targetQ, boolean regulatingOn) {
        if (regulatingOn) {
            remoteReactivePowerControl.setTargetQ(targetQ).setEnabled(true);
        } else {
            remoteReactivePowerControl.setEnabled(false).setTargetQ(targetQ);
        }
    }

    private static double getDefaultTargetV(Generator generator, Context context) {
        double defaultTargetV = Optional.ofNullable(generator.getRegulatingTerminal()).orElse(generator.getTerminal()).getVoltageLevel().getNominalV();
        return AbstractReactiveLimitsOwnerConversion.getDefaultValue(null, generator.getTargetV(), defaultTargetV, Double.NaN, context);
    }

    private static boolean getDefaultRegulatingOn(Generator generator, Context context) {
        return AbstractReactiveLimitsOwnerConversion.getDefaultValue(false, generator.isVoltageRegulatorOn(), false, false, context);
    }

    private static double getDefaultTargetQ(RemoteReactivePowerControl remoteReactivePowerControl, Context context) {
        return AbstractReactiveLimitsOwnerConversion.getDefaultValue(null, remoteReactivePowerControl.getTargetQ(), Double.NaN, Double.NaN, context);
    }

    private static boolean getDefaultRegulatingOn(RemoteReactivePowerControl remoteReactivePowerControl, Context context) {
        return AbstractReactiveLimitsOwnerConversion.getDefaultValue(false, remoteReactivePowerControl.isEnabled(), false, false, context);
    }
}

