/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;

public class AsynchronousMachineConversion
extends AbstractConductingEquipmentConversion {
    public AsynchronousMachineConversion(PropertyBag asm, Context context) {
        super("AsynchronousMachine", asm, context);
    }

    @Override
    public void convert() {
        LoadType loadType = this.id.contains("fict") ? LoadType.FICTITIOUS : LoadType.UNDEFINED;
        LoadAdder adder = this.voltageLevel().newLoad().setLoadType(loadType);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
        Load newLoad = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)newLoad);
        this.convertedTerminalsWithOnlyEq(newLoad.getTerminal());
        AsynchronousMachineConversion.addSpecificProperties(newLoad);
    }

    private static void addSpecificProperties(Load newLoad) {
        newLoad.setProperty("CGMES.originalClass", "AsynchronousMachine");
    }

    public static void update(Load load, PropertyBag cgmesData, Context context) {
        AsynchronousMachineConversion.updateTerminals(load, context, new Terminal[]{load.getTerminal()});
        PowerFlow updatedPowerFlow = AsynchronousMachineConversion.updatedPowerFlow(load, cgmesData, context);
        load.setP0(updatedPowerFlow.defined() ? updatedPowerFlow.p() : AsynchronousMachineConversion.getDefaultP0(load, context));
        load.setQ0(updatedPowerFlow.defined() ? updatedPowerFlow.q() : AsynchronousMachineConversion.getDefaultQ0(load, context));
    }

    private static double getDefaultP0(Load load, Context context) {
        return AsynchronousMachineConversion.getDefaultValue(null, load.getP0(), 0.0, Double.NaN, context);
    }

    private static double getDefaultQ0(Load load, Context context) {
        return AsynchronousMachineConversion.getDefaultValue(null, load.getQ0(), 0.0, Double.NaN, context);
    }
}

