/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.extensions.LoadDetailAdder;
import com.powsybl.triplestore.api.PropertyBag;

public class EnergyConsumerConversion
extends AbstractConductingEquipmentConversion {
    private final String loadKind;

    public EnergyConsumerConversion(PropertyBag ec, Context context) {
        super("EnergyConsumer", ec, context);
        this.loadKind = ec.getLocal("type");
    }

    @Override
    public void convert() {
        LoadType loadType = this.loadKind.equals("StationSupply") ? LoadType.AUXILIARY : (this.id.contains("fict") ? LoadType.FICTITIOUS : LoadType.UNDEFINED);
        double pFixed = this.p.asDouble("pFixed", 0.0);
        double qFixed = this.p.asDouble("qFixed", 0.0);
        LoadAdder adder = this.voltageLevel().newLoad().setLoadType(loadType);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
        this.model(adder);
        Load newLoad = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)newLoad);
        this.convertedTerminalsWithOnlyEq(newLoad.getTerminal());
        EnergyConsumerConversion.setLoadDetail(this.loadKind, newLoad, pFixed, qFixed);
        this.addSpecificProperties(newLoad, pFixed, qFixed);
    }

    private void addSpecificProperties(Load newLoad, double pFixed, double qFixed) {
        newLoad.setProperty("CGMES.originalClass", this.loadKind);
        newLoad.setProperty("CGMES.pFixed", String.valueOf(pFixed));
        newLoad.setProperty("CGMES.qFixed", String.valueOf(qFixed));
    }

    private void model(LoadAdder adder) {
        this.p.asBoolean("exponentModel").ifPresent(exponentModel -> {
            if (Boolean.TRUE.equals(exponentModel)) {
                boolean constantPower;
                double pVoltageExponent = this.p.asDouble("pVoltageExponent", 0.0);
                double qVoltageExponent = this.p.asDouble("qVoltageExponent", 0.0);
                boolean bl = constantPower = pVoltageExponent == 0.0 && qVoltageExponent == 0.0;
                if (!constantPower) {
                    adder.newExponentialModel().setNp(pVoltageExponent).setNq(qVoltageExponent).add();
                }
            } else {
                this.addZipModel(adder);
            }
        });
    }

    private void addZipModel(LoadAdder adder) {
        double pConstantPower = this.p.asDouble("pConstantPower");
        double pConstantCurrent = this.p.asDouble("pConstantCurrent");
        double pConstantImpedance = this.p.asDouble("pConstantImpedance");
        double qConstantPower = this.p.asDouble("qConstantPower");
        double qConstantCurrent = this.p.asDouble("qConstantCurrent");
        double qConstantImpedance = this.p.asDouble("qConstantImpedance");
        if (!(Double.isNaN(pConstantPower) || Double.isNaN(pConstantCurrent) || Double.isNaN(pConstantImpedance) || Double.isNaN(qConstantPower) || Double.isNaN(qConstantCurrent) || Double.isNaN(qConstantImpedance))) {
            boolean constantPower;
            boolean bl = constantPower = pConstantPower == 1.0 && pConstantCurrent == 0.0 && pConstantImpedance == 0.0 && qConstantPower == 1.0 && qConstantCurrent == 0.0 && qConstantImpedance == 0.0;
            if (!constantPower) {
                double qSum;
                double pSum = pConstantPower + pConstantCurrent + pConstantImpedance;
                if (Math.abs(pSum - 1.0) > 1.0E-8) {
                    pConstantPower /= pSum;
                    pConstantCurrent /= pSum;
                    pConstantImpedance /= pSum;
                    this.fixed("active coefficients of zip load", "sum of pConstantPower, pConstantCurrent and pConstantImpedance is not equals to 1");
                }
                if (Math.abs((qSum = qConstantPower + qConstantCurrent + qConstantImpedance) - 1.0) > 1.0E-8) {
                    qConstantPower /= qSum;
                    qConstantCurrent /= qSum;
                    qConstantImpedance /= qSum;
                    this.fixed("reactive coefficients of zip load", "sum of qConstantPower, qConstantCurrent and qConstantImpedance is not equals to 1");
                }
                adder.newZipModel().setC0p(pConstantPower).setC1p(pConstantCurrent).setC2p(pConstantImpedance).setC0q(qConstantPower).setC1q(qConstantCurrent).setC2q(qConstantImpedance).add();
            }
        }
    }

    private static void setLoadDetail(String type, Load newLoad, double pFixed, double qFixed) {
        if (type.equals("ConformLoad")) {
            ((LoadDetailAdder)newLoad.newExtension(LoadDetailAdder.class)).withFixedActivePower(0.0).withFixedReactivePower(0.0).withVariableActivePower((double)((float)pFixed)).withVariableReactivePower((double)((float)qFixed)).add();
        } else if (type.equals("NonConformLoad")) {
            ((LoadDetailAdder)newLoad.newExtension(LoadDetailAdder.class)).withFixedActivePower((double)((float)pFixed)).withFixedReactivePower((double)((float)qFixed)).withVariableActivePower(0.0).withVariableReactivePower(0.0).add();
        }
    }

    public static void update(Load load, PropertyBag cgmesData, Context context) {
        EnergyConsumerConversion.updateTerminals(load, context, new Terminal[]{load.getTerminal()});
        double pFixed = Double.parseDouble(load.getProperty("CGMES.pFixed", "0.0"));
        double qFixed = Double.parseDouble(load.getProperty("CGMES.qFixed", "0.0"));
        PowerFlow updatedPowerFlow = EnergyConsumerConversion.updatedPowerFlow(load, cgmesData, context);
        load.setP0(updatedPowerFlow.defined() ? updatedPowerFlow.p() : EnergyConsumerConversion.getDefaultP0(load, pFixed, context));
        load.setQ0(updatedPowerFlow.defined() ? updatedPowerFlow.q() : EnergyConsumerConversion.getDefaultQ0(load, qFixed, context));
        EnergyConsumerConversion.updateLoadDetail(load, load.getProperty("CGMES.originalClass"), pFixed, qFixed);
    }

    private static double getDefaultP0(Load load, double pFixed, Context context) {
        return EnergyConsumerConversion.getDefaultValue(pFixed, load.getP0(), 0.0, Double.NaN, context);
    }

    private static double getDefaultQ0(Load load, double qFixed, Context context) {
        return EnergyConsumerConversion.getDefaultValue(qFixed, load.getQ0(), 0.0, Double.NaN, context);
    }

    private static void updateLoadDetail(Load load, String type, double pFixed, double qFixed) {
        if (type == null) {
            return;
        }
        LoadDetail loadDetail = (LoadDetail)load.getExtension(LoadDetail.class);
        if (loadDetail == null) {
            return;
        }
        if (type.equals("ConformLoad")) {
            loadDetail.setVariableActivePower(Double.isFinite(load.getP0()) ? load.getP0() : pFixed).setVariableReactivePower(Double.isFinite(load.getQ0()) ? load.getQ0() : qFixed);
        } else if (type.equals("NonConformLoad")) {
            loadDetail.setFixedActivePower(Double.isFinite(load.getP0()) ? load.getP0() : pFixed).setFixedReactivePower(Double.isFinite(load.getQ0()) ? load.getQ0() : qFixed);
        }
    }
}

