/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.elements.AbstractBranchConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Switch;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;
import org.apache.commons.math3.complex.Complex;

public class EquivalentBranchConversion
extends AbstractBranchConversion
implements EquipmentAtBoundaryConversion {
    private DanglingLine danglingLine;
    private static final String IGNORED_UPDATE_PARAMS_DIFFERENT_NOMINALV_WHAT = "EquivalentBranch potential parameter update if different nominal voltages ";

    public EquivalentBranchConversion(PropertyBag b, Context context) {
        super("EquivalentBranch", b, context);
    }

    @Override
    public boolean valid() {
        return this.validNodes();
    }

    @Override
    public void convert() {
        double r = this.p.asDouble("r");
        double x = this.p.asDouble("x");
        double r21 = this.p.asDouble("r21", r);
        double x21 = this.p.asDouble("x21", x);
        if (r21 != r || x21 != x) {
            this.invalid("Impedance 21 different of impedance 12 not supported");
        }
        double gch = 0.0;
        double bch = 0.0;
        this.convertBranch(r, x, gch, bch, "EquivalentBranch");
        this.updateParametersForEquivalentBranchWithDifferentNominalVoltages();
    }

    @Override
    public void convertAtBoundary() {
        if (this.isBoundary(1)) {
            this.convertEquivalentBranchAtBoundary(1);
        } else if (this.isBoundary(2)) {
            this.convertEquivalentBranchAtBoundary(2);
        } else {
            throw new ConversionException("Boundary must be at one end of the equivalent branch");
        }
    }

    @Override
    public Optional<DanglingLine> getDanglingLine() {
        return Optional.ofNullable(this.danglingLine);
    }

    private void convertEquivalentBranchAtBoundary(int boundarySide) {
        double r = this.p.asDouble("r");
        double x = this.p.asDouble("x");
        double bch = 0.0;
        double gch = 0.0;
        if (this.context.config().convertBoundary()) {
            String message = "When convertBoundary is active, boundaries have been mapped to fictitious substations inside the Network.This method should not be called, the mapping has already been performed in ::convert";
            throw new PowsyblException(message);
        }
        String eqInstance = (String)this.p.get((Object)"graph");
        this.danglingLine = this.convertToDanglingLine(eqInstance, boundarySide, r, x, gch, bch, "EquivalentBranch");
    }

    private void updateParametersForEquivalentBranchWithDifferentNominalVoltages() {
        Complex y2l;
        Complex y1l;
        Complex ytrl;
        double vnom2;
        Line line = this.context.network().getLine(this.iidmId());
        if (line == null) {
            return;
        }
        double vnom1 = line.getTerminal1().getVoltageLevel().getNominalV();
        if (vnom1 == (vnom2 = line.getTerminal2().getVoltageLevel().getNominalV())) {
            return;
        }
        double baseVoltage = this.p.asDouble("baseVoltageNominalVoltage");
        Complex ztr = new Complex(line.getR(), line.getX());
        Complex ytr = ztr.reciprocal();
        Complex y1 = new Complex(line.getG1(), line.getB1());
        Complex y2 = new Complex(line.getG2(), line.getB2());
        if (baseVoltage == vnom1) {
            double ratio2 = vnom2 / vnom1;
            double ratio2Squared = ratio2 * ratio2;
            ytrl = ytr.multiply(1.0 / ratio2);
            y1l = ytr.multiply(1.0 - 1.0 / ratio2).add(y1);
            y2l = ytr.multiply(1.0 / ratio2Squared - 1.0 / ratio2).add(y2.divide(ratio2Squared));
        } else if (baseVoltage == vnom2) {
            double ratio1 = vnom1 / vnom2;
            double ratio1Squared = ratio1 * ratio1;
            ytrl = ytr.multiply(1.0 / ratio1);
            y1l = ytr.multiply(1.0 / ratio1Squared - 1.0 / ratio1).add(y1.divide(ratio1Squared));
            y2l = ytr.multiply(1.0 - 1.0 / ratio1).add(y2);
        } else {
            this.context.ignored(IGNORED_UPDATE_PARAMS_DIFFERENT_NOMINALV_WHAT + this.iidmId(), "EquivalentBranch has been converted to a Line, but base voltage is different of nominal voltages of ends 1 and 2");
            return;
        }
        Complex ztrl = ytrl.reciprocal();
        line.setR(ztrl.getReal());
        line.setX(ztrl.getImaginary());
        line.setG1(y1l.getReal());
        line.setB1(y1l.getImaginary());
        line.setG2(y2l.getReal());
        line.setB2(y2l.getImaginary());
    }

    public static void update(Line line, Context context) {
        EquivalentBranchConversion.updateBranch(line, context);
    }

    public static void update(Switch sw, Context context) {
        EquivalentBranchConversion.updateBranch(sw, context);
    }

    public static void update(DanglingLine danglingLine, Context context) {
        EquivalentBranchConversion.updateDanglingLine(danglingLine, EquivalentBranchConversion.isBoundaryTerminalConnected(danglingLine, context), context);
    }
}

