/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;

public class EquivalentInjectionConversion
extends AbstractReactiveLimitsOwnerConversion {
    public EquivalentInjectionConversion(PropertyBag ei, Context context) {
        super("EquivalentInjection", ei, context);
    }

    @Override
    public void convertInsideBoundary() {
        if (this.context.config().convertBoundary()) {
            if (this.valid()) {
                this.convert();
            }
        } else {
            this.context.boundary().addEquivalentInjectionAtNode(this.p, this.nodeId());
        }
    }

    @Override
    public void convert() {
        this.convertToGenerator();
    }

    public DanglingLine convertOverDanglingLine(DanglingLineAdder adder) {
        boolean regulationCapability = this.p.asBoolean("regulationCapability", false);
        DanglingLine dl = regulationCapability ? adder.setP0(Double.NaN).setQ0(Double.NaN).newGeneration().setVoltageRegulationOn(false).setMinP(-1.7976931348623157E308).setMaxP(Double.MAX_VALUE).setTargetP(Double.NaN).setTargetQ(Double.NaN).setTargetV(Double.NaN).add().add() : adder.setP0(Double.NaN).setQ0(Double.NaN).add();
        dl.setProperty("CGMES.EquivalentInjection", this.id);
        CgmesTerminal cgmesTerminal = this.context.cgmes().terminal(this.terminalId());
        if (cgmesTerminal != null) {
            dl.setProperty("CGMES.EquivalentInjectionTerminal", cgmesTerminal.id());
        }
        return dl;
    }

    private void convertToGenerator() {
        double minP = this.p.asDouble("minP", -1.7976931348623157E308);
        double maxP = this.p.asDouble("maxP", Double.MAX_VALUE);
        GeneratorAdder adder = this.voltageLevel().newGenerator();
        this.setMinPMaxP(adder, minP, maxP);
        adder.setEnergySource(EnergySource.OTHER);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
        Generator g = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)g);
        this.convertedTerminalsWithOnlyEq(g.getTerminal());
        this.convertReactiveLimits((ReactiveLimitsHolder)g);
        EquivalentInjectionConversion.addSpecificProperties(g, this.p);
    }

    private static void addSpecificProperties(Generator generator, PropertyBag propertyBag) {
        generator.setProperty("CGMES.originalClass", "EquivalentInjection");
        generator.setProperty("CGMES.regulationCapability", (String)propertyBag.getOrDefault((Object)"regulationCapability", (Object)"false"));
    }

    public static void update(Generator generator, PropertyBag cgmesData, Context context) {
        EquivalentInjectionConversion.updateTerminals(generator, context, new Terminal[]{generator.getTerminal()});
        boolean regulationCapability = Boolean.parseBoolean(generator.getProperty("CGMES.originalClassregulationCapability"));
        PowerFlow updatedPowerFlow = EquivalentInjectionConversion.updatedPowerFlow(generator, cgmesData, context);
        double defaultTargetV = EquivalentInjectionConversion.getDefaultTargetV(generator, context);
        double targetV = EquivalentInjectionConversion.findTargetV(cgmesData, "regulationTarget", defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED);
        boolean defaultRegulatingOn = EquivalentInjectionConversion.getDefaultRegulatingOn(generator, context);
        boolean regulatingOn = EquivalentInjectionConversion.findRegulatingOn(cgmesData, "regulationStatus", defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED);
        generator.setTargetP(EquivalentInjectionConversion.getTargetP(updatedPowerFlow, generator, context)).setTargetQ(EquivalentInjectionConversion.getTargetQ(updatedPowerFlow, generator, context)).setTargetV(targetV).setVoltageRegulatorOn(regulatingOn && regulationCapability && EquivalentInjectionConversion.isValidTargetV(targetV));
    }

    private static double getTargetP(PowerFlow updatedPowerFlow, Generator generator, Context context) {
        return updatedPowerFlow.defined() ? -updatedPowerFlow.p() : EquivalentInjectionConversion.getDefaultTargetP(generator, context);
    }

    private static double getDefaultTargetP(Generator generator, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, generator.getTargetP(), 0.0, 0.0, context);
    }

    private static double getTargetQ(PowerFlow updatedPowerFlow, Generator generator, Context context) {
        return updatedPowerFlow.defined() ? -updatedPowerFlow.q() : EquivalentInjectionConversion.getDefaultTargetQ(generator, context);
    }

    private static double getDefaultTargetQ(Generator generator, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, generator.getTargetQ(), 0.0, 0.0, context);
    }

    private static double getDefaultTargetV(Generator generator, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, generator.getTargetV(), Double.NaN, Double.NaN, context);
    }

    private static boolean getDefaultRegulatingOn(Generator generator, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(false, generator.isVoltageRegulatorOn(), false, false, context);
    }

    public static void update(DanglingLine danglingLine, boolean isConnectedOnBoundarySide, Context context) {
        if (!isConnectedOnBoundarySide && danglingLine.getTerminal().isConnected()) {
            EquivalentInjectionConversion.updateWhenIsConnectedAndBoundarySideIsOpen(danglingLine, context);
        } else {
            EquivalentInjectionConversion.update(danglingLine, context);
        }
    }

    private static void updateWhenIsConnectedAndBoundarySideIsOpen(DanglingLine danglingLine, Context context) {
        if (danglingLine.getGeneration() != null) {
            Optional<PropertyBag> cgmesEquivalentInjection = EquivalentInjectionConversion.getCgmesEquivalentInjection(danglingLine, context);
            double defaultTargetV = EquivalentInjectionConversion.getDefaultTargetV(danglingLine.getGeneration(), context);
            double targetV = cgmesEquivalentInjection.map(propertyBag -> EquivalentInjectionConversion.findTargetV(propertyBag, "regulationTarget", defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetV);
            danglingLine.getGeneration().setTargetP(0.0);
            danglingLine.getGeneration().setTargetQ(0.0);
            EquivalentInjectionConversion.setRegulation(danglingLine, targetV, false);
        }
        danglingLine.setP0(0.0);
        danglingLine.setQ0(0.0);
    }

    private static void update(DanglingLine danglingLine, Context context) {
        Optional<PropertyBag> cgmesEquivalentInjection = EquivalentInjectionConversion.getCgmesEquivalentInjection(danglingLine, context);
        PowerFlow updatedPowerFlow = cgmesEquivalentInjection.map(propertyBag -> EquivalentInjectionConversion.updatedPowerFlow(danglingLine, propertyBag, context)).orElse(PowerFlow.UNDEFINED);
        if (danglingLine.getGeneration() != null) {
            double defaultTargetV = EquivalentInjectionConversion.getDefaultTargetV(danglingLine.getGeneration(), context);
            double targetV = cgmesEquivalentInjection.map(propertyBag -> EquivalentInjectionConversion.findTargetV(propertyBag, "regulationTarget", defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetV);
            boolean defaultRegulatingOn = EquivalentInjectionConversion.getDefaultRegulatingOn(danglingLine.getGeneration(), context);
            boolean regulatingOn = cgmesEquivalentInjection.map(propertyBag -> EquivalentInjectionConversion.findRegulatingOn(propertyBag, "regulationStatus", defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
            danglingLine.setP0(0.0);
            danglingLine.setQ0(0.0);
            danglingLine.getGeneration().setTargetP(EquivalentInjectionConversion.getTargetP(updatedPowerFlow, danglingLine.getGeneration(), context));
            danglingLine.getGeneration().setTargetQ(EquivalentInjectionConversion.getTargetQ(updatedPowerFlow, danglingLine.getGeneration(), context));
            EquivalentInjectionConversion.setRegulation(danglingLine, targetV, regulatingOn && EquivalentInjectionConversion.isValidTargetV(targetV));
        } else {
            danglingLine.setP0(EquivalentInjectionConversion.getTargetP(updatedPowerFlow, danglingLine, context));
            danglingLine.setQ0(EquivalentInjectionConversion.getTargetQ(updatedPowerFlow, danglingLine, context));
        }
    }

    private static void setRegulation(DanglingLine danglingLine, double targetV, boolean regulatingOn) {
        if (regulatingOn) {
            danglingLine.getGeneration().setTargetV(targetV).setVoltageRegulationOn(true);
        } else {
            danglingLine.getGeneration().setVoltageRegulationOn(false).setTargetV(targetV);
        }
    }

    private static Optional<PropertyBag> getCgmesEquivalentInjection(DanglingLine danglingLine, Context context) {
        String equivalentInjectionId = danglingLine.getProperty("CGMES.EquivalentInjection");
        return equivalentInjectionId != null ? Optional.ofNullable(context.equivalentInjection(equivalentInjectionId)) : Optional.empty();
    }

    private static double getTargetP(PowerFlow updatedPowerFlow, DanglingLine danglingLine, Context context) {
        return updatedPowerFlow.defined() ? updatedPowerFlow.p() : EquivalentInjectionConversion.getDefaultTargetP(danglingLine, context);
    }

    private static double getDefaultTargetP(DanglingLine danglingLine, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, danglingLine.getP0(), 0.0, 0.0, context);
    }

    private static double getTargetP(PowerFlow updatedPowerFlow, DanglingLine.Generation generation, Context context) {
        return updatedPowerFlow.defined() ? -updatedPowerFlow.p() : EquivalentInjectionConversion.getDefaultTargetP(generation, context);
    }

    private static double getDefaultTargetP(DanglingLine.Generation generation, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, generation.getTargetP(), 0.0, 0.0, context);
    }

    private static double getTargetQ(PowerFlow updatedPowerFlow, DanglingLine danglingLine, Context context) {
        return updatedPowerFlow.defined() ? updatedPowerFlow.q() : EquivalentInjectionConversion.getDefaultTargetQ(danglingLine, context);
    }

    private static double getDefaultTargetQ(DanglingLine danglingLine, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, danglingLine.getQ0(), 0.0, 0.0, context);
    }

    private static double getTargetQ(PowerFlow updatedPowerFlow, DanglingLine.Generation generation, Context context) {
        return updatedPowerFlow.defined() ? -updatedPowerFlow.q() : EquivalentInjectionConversion.getDefaultTargetQ(generation, context);
    }

    private static double getDefaultTargetQ(DanglingLine.Generation generation, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, generation.getTargetQ(), 0.0, 0.0, context);
    }

    private static double getDefaultTargetV(DanglingLine.Generation generation, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(null, generation.getTargetV(), Double.NaN, Double.NaN, context);
    }

    private static boolean getDefaultRegulatingOn(DanglingLine.Generation generation, Context context) {
        return EquivalentInjectionConversion.getDefaultValue(false, generation.isVoltageRegulationOn(), false, false, context);
    }
}

