/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.CountryConversion;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConversion
extends AbstractIdentifiedObjectConversion {
    private static final Logger LOG = LoggerFactory.getLogger(NodeConversion.class);

    public NodeConversion(String nodeTypeName, PropertyBag n, Context context) {
        super(nodeTypeName, n, context);
    }

    @Override
    public boolean insideBoundary() {
        return this.context.boundary().containsNode(this.id);
    }

    @Override
    public void convertInsideBoundary() {
        if (this.context.config().convertBoundary()) {
            if (this.context.nodeBreaker()) {
                this.newNode(this.newBoundarySubstationVoltageLevel());
            } else {
                this.newBus(this.newBoundarySubstationVoltageLevel());
            }
        }
    }

    private VoltageLevel newBoundarySubstationVoltageLevel() {
        double nominalVoltage = this.context.cgmes().nominalVoltage(this.p.getId("BaseVoltage"));
        if (LOG.isWarnEnabled()) {
            LOG.warn("Boundary node will be converted {}, nominalVoltage {} from base voltage {}", new Object[]{this.id, nominalVoltage, this.p.getId("BaseVoltage")});
        }
        String substationId = Context.boundarySubstationId(this.id);
        String vlId = Context.boundaryVoltageLevelId(this.id);
        String substationName = "boundary";
        String vlName = "boundary";
        SubstationAdder adder = ((SubstationAdder)((SubstationAdder)this.context.network().newSubstation().setId(this.context.namingStrategy().getIidmId("Substation", substationId))).setName(substationName)).setCountry(this.boundaryCountryCode());
        if (this.boundaryCountryCode() != null) {
            adder.setGeographicalTags(new String[]{this.boundaryCountryCode().toString()});
        }
        Substation substation = adder.add();
        return ((VoltageLevelAdder)((VoltageLevelAdder)substation.newVoltageLevel().setId(this.context.namingStrategy().getIidmId("VoltageLevel", vlId))).setName(vlName)).setNominalV(nominalVoltage).setTopologyKind(this.context.nodeBreaker() ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER).add();
    }

    private Country boundaryCountryCode() {
        return CountryConversion.fromIsoCode(this.p.getLocal("fromEndIsoCode")).orElseGet(() -> CountryConversion.fromIsoCode(this.p.getLocal("toEndIsoCode")).orElseGet(() -> {
            Supplier<String> countryCodes = () -> String.format("Country. ISO codes %s %s", this.p.getLocal("fromEndIsoCode"), this.p.getLocal("toEndIsoCode"));
            this.ignored(countryCodes);
            return null;
        }));
    }

    @Override
    public boolean valid() {
        if (this.voltageLevel() == null) {
            this.missing(String.format("VoltageLevel %s", this.p.getId("VoltageLevel")));
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        VoltageLevel vl = this.voltageLevel();
        Objects.requireNonNull(vl);
        if (this.context.nodeBreaker()) {
            this.newNode(vl);
        } else {
            this.newBus(vl);
        }
    }

    private VoltageLevel voltageLevel() {
        if (this.insideBoundary() && this.context.config().convertBoundary()) {
            return this.context.network().getVoltageLevel(Context.boundaryVoltageLevelId(this.id));
        }
        if (!this.insideBoundary()) {
            String containerId = this.p.getId("ConnectivityNodeContainer");
            String cgmesId = this.context.cgmes().container(containerId).voltageLevel();
            if (cgmesId == null) {
                cgmesId = this.context.nodeContainerMapping().getFictitiousVoltageLevelForContainer(containerId, this.id);
            }
            String iidm = this.context.namingStrategy().getIidmId("VoltageLevel", cgmesId);
            String iidmId = this.context.nodeContainerMapping().voltageLevelIidm(iidm);
            return iidmId != null ? this.context.network().getVoltageLevel(iidmId) : null;
        }
        return null;
    }

    private void newNode(VoltageLevel vl) {
        VoltageLevel.NodeBreakerView nbv = vl.getNodeBreakerView();
        int iidmNode = this.context.nodeMapping().iidmNodeForConnectivityNode(this.id, vl);
        if (this.context.config().createBusbarSectionForEveryConnectivityNode()) {
            BusbarSection bus = ((BusbarSectionAdder)((BusbarSectionAdder)nbv.newBusbarSection().setId(this.context.namingStrategy().getIidmId("Bus", this.id))).setName(this.context.namingStrategy().getIidmName("Bus", this.name))).setNode(iidmNode).add();
            LOG.debug("    BusbarSection added at node {} : {} {} : {}", new Object[]{iidmNode, this.id, this.name, bus});
        }
    }

    private void newBus(VoltageLevel voltageLevel) {
        ((BusAdder)((BusAdder)voltageLevel.getBusBreakerView().newBus().setId(this.context.namingStrategy().getIidmId("Bus", this.id))).setName(this.context.namingStrategy().getIidmName("Bus", this.name))).add();
    }

    private static boolean valid(double v, double angle) {
        return v > 0.0 && Double.isFinite(angle);
    }

    public static void update(Bus bus, Context context) {
        if (bus.getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER) {
            NodeConversion.updateBusBreakerBus(bus, context);
        } else {
            NodeConversion.updateNodeBreakerBus(bus, context);
        }
    }

    private static void updateBusBreakerBus(Bus bus, Context context) {
        bus.getConnectedTerminalStream().map(terminal -> NodeConversion.getBusBreakerSvVoltage(terminal, context)).flatMap(Optional::stream).findFirst().ifPresent(svVoltage -> NodeConversion.updateVoltageMagnitudeAndAngle(svVoltage, bus, context));
    }

    private static Optional<PropertyBag> getBusBreakerSvVoltage(Terminal terminal, Context context) {
        return NodeConversion.getSvVoltage(terminal.getBusBreakerView().getBus().getId(), context);
    }

    private static void updateNodeBreakerBus(Bus bus, Context context) {
        bus.getConnectedTerminalStream().map(terminal -> NodeConversion.getNodeBreakerSvVoltage(terminal, context)).flatMap(Optional::stream).findFirst().ifPresent(svVoltage -> NodeConversion.updateVoltageMagnitudeAndAngle(svVoltage, bus, context));
    }

    private static void updateVoltageMagnitudeAndAngle(PropertyBag svVoltage, Bus bus, Context context) {
        double angle;
        double v = svVoltage.asDouble("v");
        if (NodeConversion.valid(v, angle = svVoltage.asDouble("angle"))) {
            bus.setV(v).setAngle(angle);
        } else {
            CgmesReports.invalidAngleVoltageReport(context.getReportNode(), bus, v, angle);
        }
    }

    private static Optional<PropertyBag> getNodeBreakerSvVoltage(Terminal terminal, Context context) {
        return NodeConversion.getTerminalId(terminal.getConnectable(), terminal.getSide()).flatMap(terminalId -> NodeConversion.getTopologicalNodeId(terminalId, context)).flatMap(topologicalNodeId -> NodeConversion.getSvVoltage(topologicalNodeId, context));
    }

    private static Optional<String> getTerminalId(Connectable<?> connectable, ThreeSides side) {
        if (side == null) {
            return connectable.getAliasFromType("CGMES.Terminal").or(() -> connectable.getAliasFromType("CGMES.Terminal1"));
        }
        return switch (side) {
            default -> throw new MatchException(null, null);
            case ThreeSides.ONE -> connectable.getAliasFromType("CGMES.Terminal1").or(() -> connectable.getAliasFromType("CGMES.Terminal"));
            case ThreeSides.TWO -> connectable.getAliasFromType("CGMES.Terminal2");
            case ThreeSides.THREE -> connectable.getAliasFromType("CGMES.Terminal3");
        };
    }

    private static Optional<String> getTopologicalNodeId(String terminalId, Context context) {
        return Optional.ofNullable(context.cgmesTerminal(terminalId)).map(cgmesTerminal -> cgmesTerminal.getId("TopologicalNode"));
    }

    private static Optional<PropertyBag> getSvVoltage(String topologicalNodeId, Context context) {
        return Optional.ofNullable(context.svVoltage(topologicalNodeId));
    }
}

