/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Supplier;

public class OperationalLimitConversion
extends AbstractIdentifiedObjectConversion {
    private static final String LIMIT_TYPE = "limitType";
    private static final String OPERATIONAL_LIMIT = "Operational limit";
    private static final String OPERATIONAL_LIMIT_TYPE_NAME = "operationalLimitTypeName";
    private static final String OPERATIONAL_LIMIT_SUBCLASS = "OperationalLimitSubclass";
    private static final String OPERATIONAL_LIMIT_SET_ID = "OperationalLimitSet";
    private static final String OPERATIONAL_LIMIT_SET_NAME = "OperationalLimitSetName";
    private static final String PERMANENT_LIMIT = "Permanent Limit";
    private static final String TEMPORARY_LIMIT = "Temporary Limit";
    private final String terminalId;
    private final String equipmentId;
    private final String limitSubclass;
    private OLGA olga;
    private OLGA olga1;
    private OLGA olga2;
    private OLGA olga3;
    private VoltageLevel vl;

    public OperationalLimitConversion(PropertyBag l, Context context) {
        super("OperationalLimit", l, context);
        this.limitSubclass = Objects.requireNonNull(this.p.getLocal(OPERATIONAL_LIMIT_SUBCLASS));
        this.terminalId = l.getId("Terminal");
        this.equipmentId = l.getId("Equipment");
        Terminal terminal = null;
        if (this.isLoadingLimits()) {
            if (this.terminalId != null) {
                terminal = context.terminalMapping().findForFlowLimits(this.terminalId);
            }
            if (terminal != null) {
                this.checkAndCreateLimitsAdder(context.terminalMapping().number(this.terminalId), (Identifiable<?>)terminal.getConnectable());
            } else if (this.equipmentId != null) {
                Identifiable identifiable = context.network().getIdentifiable(this.equipmentId);
                this.checkAndCreateLimitsAdder(-1, identifiable);
            }
        } else if (this.isVoltageLimits()) {
            if (this.terminalId != null) {
                terminal = context.terminalMapping().findForVoltageLimits(this.terminalId);
            }
            this.setVoltageLevelForVoltageLimit(terminal);
        } else {
            this.notAssigned();
        }
    }

    private boolean isLoadingLimits() {
        return "ActivePowerLimit".equals(this.limitSubclass) || "ApparentPowerLimit".equals(this.limitSubclass) || "CurrentLimit".equals(this.limitSubclass);
    }

    private boolean isVoltageLimits() {
        return "VoltageLimit".equals(this.limitSubclass);
    }

    private void setVoltageLevelForVoltageLimit(Terminal terminal) {
        if (terminal != null) {
            this.vl = terminal.getVoltageLevel();
        } else if (this.equipmentId != null) {
            Identifiable i = this.context.network().getIdentifiable(this.equipmentId);
            if (i == null) {
                this.vl = this.context.network().getVoltageLevel(this.p.getId("EquipmentContainer"));
            } else if (i instanceof Injection) {
                Injection injection = (Injection)i;
                this.vl = injection.getTerminal().getVoltageLevel();
            }
        }
    }

    private void addProperties(OperationalLimitsGroup limitsGroup, String limitSetId, String limitSetName) {
        limitsGroup.setProperty("CGMES.OperationalLimitSetRdfID", limitSetId);
        limitsGroup.setProperty("CGMES.OperationalLimitSetName", limitSetName);
    }

    private void createLimitsAdder(int terminalNumber, String limitSubclass, String limitSetId, String limitSetName, Branch<?> b) {
        if (terminalNumber == 1) {
            OperationalLimitsGroup limitsGroup = b.getOperationalLimitsGroup1(limitSetId).orElseGet(() -> {
                OperationalLimitsGroup newLimitsGroup = b.newOperationalLimitsGroup1(limitSetId);
                this.addProperties(newLimitsGroup, limitSetId, limitSetName);
                return newLimitsGroup;
            });
            this.olga1 = new OLGA(limitsGroup, this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubclass));
        } else if (terminalNumber == 2) {
            OperationalLimitsGroup limitsGroup = b.getOperationalLimitsGroup2(limitSetId).orElseGet(() -> {
                OperationalLimitsGroup newLimitsGroup = b.newOperationalLimitsGroup2(limitSetId);
                this.addProperties(newLimitsGroup, limitSetId, limitSetName);
                return newLimitsGroup;
            });
            this.olga2 = new OLGA(limitsGroup, this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubclass));
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void createLimitsAdder(String limitSubclass, String limitSetId, String limitSetName, DanglingLine dl) {
        OperationalLimitsGroup limitsGroup = dl.getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
            OperationalLimitsGroup newLimitsGroup = dl.newOperationalLimitsGroup(limitSetId);
            this.addProperties(newLimitsGroup, limitSetId, limitSetName);
            return newLimitsGroup;
        });
        this.olga = new OLGA(limitsGroup, this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubclass));
    }

    private void createLimitsAdder(int terminalNumber, String limitSubclass, String limitSetId, String limitSetName, ThreeWindingsTransformer twt) {
        if (terminalNumber == 1) {
            OperationalLimitsGroup limitsGroup = twt.getLeg1().getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
                OperationalLimitsGroup newLimitsGroup = twt.getLeg1().newOperationalLimitsGroup(limitSetId);
                this.addProperties(newLimitsGroup, limitSetId, limitSetName);
                return newLimitsGroup;
            });
            this.olga1 = new OLGA(limitsGroup, this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubclass));
        } else if (terminalNumber == 2) {
            OperationalLimitsGroup limitsGroup = twt.getLeg2().getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
                OperationalLimitsGroup newLimitsGroup = twt.getLeg2().newOperationalLimitsGroup(limitSetId);
                this.addProperties(newLimitsGroup, limitSetId, limitSetName);
                return newLimitsGroup;
            });
            this.olga2 = new OLGA(limitsGroup, this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubclass));
        } else if (terminalNumber == 3) {
            OperationalLimitsGroup limitsGroup = twt.getLeg3().getOperationalLimitsGroup(limitSetId).orElseGet(() -> {
                OperationalLimitsGroup newLimitsGroup = twt.getLeg3().newOperationalLimitsGroup(limitSetId);
                this.addProperties(newLimitsGroup, limitSetId, limitSetName);
                return newLimitsGroup;
            });
            this.olga3 = new OLGA(limitsGroup, this.context.loadingLimitsMapping().getLoadingLimitsAdder(limitsGroup, limitSubclass));
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void checkAndCreateLimitsAdder(int terminalNumber, Identifiable<?> identifiable) {
        String limitSetId = this.p.getId(OPERATIONAL_LIMIT_SET_ID);
        String limitSetName = this.p.getLocal(OPERATIONAL_LIMIT_SET_NAME);
        String string = limitSetName = limitSetName != null ? limitSetName : limitSetId;
        if (identifiable instanceof Branch) {
            this.checkAndCreateLimitsAdderBranch((Branch)identifiable, terminalNumber, limitSetId, limitSetName);
        } else if (identifiable instanceof DanglingLine) {
            DanglingLine dl = (DanglingLine)identifiable;
            this.createLimitsAdder(this.limitSubclass, limitSetId, limitSetName, dl);
        } else if (identifiable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer t3w = (ThreeWindingsTransformer)identifiable;
            this.checkAndCreateLimitsAdderThreeWindingsTransformers(t3w, terminalNumber, limitSetId, limitSetName);
        } else if (identifiable instanceof Switch) {
            Switch aswitch = this.context.network().getSwitch(this.equipmentId);
            this.notAssigned((Identifiable<?>)aswitch);
        } else {
            this.notAssigned(identifiable);
        }
    }

    private void checkAndCreateLimitsAdderBranch(Branch<?> b, int terminalNumber, String limitSetId, String limitSetName) {
        if (terminalNumber == 1 || terminalNumber == 2) {
            this.createLimitsAdder(terminalNumber, this.limitSubclass, limitSetId, limitSetName, b);
        } else if (terminalNumber == -1 && b instanceof Line) {
            this.createLimitsAdder(1, this.limitSubclass, limitSetId, limitSetName, b);
            this.createLimitsAdder(2, this.limitSubclass, limitSetId, limitSetName, b);
        } else {
            if (terminalNumber == -1 && b instanceof TwoWindingsTransformer) {
                this.context.ignored(this.limitSubclass, "Defined for Equipment TwoWindingsTransformer. Should be defined for one Terminal of Two");
            }
            this.notAssigned((Identifiable<?>)b);
        }
    }

    private void checkAndCreateLimitsAdderThreeWindingsTransformers(ThreeWindingsTransformer t3w, int terminalNumber, String limitSetId, String limitSetName) {
        if (terminalNumber == 1 || terminalNumber == 2 || terminalNumber == 3) {
            this.createLimitsAdder(terminalNumber, this.limitSubclass, limitSetId, limitSetName, t3w);
        } else {
            if (terminalNumber == -1) {
                this.context.ignored(this.limitSubclass, "Defined for Equipment ThreeWindingsTransformer. Should be defined for one Terminal of Three");
            }
            this.notAssigned((Identifiable<?>)t3w);
        }
    }

    @Override
    public boolean valid() {
        if (this.vl == null && this.olga == null && this.olga1 == null && this.olga2 == null && this.olga3 == null) {
            this.missing(String.format("Terminal %s or Equipment %s", this.terminalId, this.equipmentId));
            return false;
        }
        return true;
    }

    @Override
    public void convert() {
        double value = OperationalLimitConversion.getNormalValueFromEQ(this.p);
        if (Double.isNaN(value)) {
            this.context.ignored(OPERATIONAL_LIMIT, "value is not defined");
            return;
        }
        if (value <= 0.0) {
            this.context.ignored(OPERATIONAL_LIMIT, "value is <= 0");
            return;
        }
        if (this.vl != null) {
            this.convertVoltageLimit(value);
        } else if (this.isPatl()) {
            this.convertPatl(value);
        } else if (this.isTatl()) {
            this.convertTatl(value);
        }
    }

    private static double getNormalValueFromEQ(PropertyBag p) {
        return p.asOptionalDouble("normalValue").orElse(p.asOptionalDouble("value").orElse(Double.NaN));
    }

    private void convertVoltageLimit(double value) {
        String operationalLimitId = this.p.getId("OperationalLimit");
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        if (limitTypeName.equalsIgnoreCase("highvoltage") || "LimitTypeKind.highVoltage".equals(limitType)) {
            this.convertHighVoltageLimit(operationalLimitId, value);
        } else if (limitTypeName.equalsIgnoreCase("lowvoltage") || "LimitTypeKind.lowVoltage".equals(limitType)) {
            this.convertLowVoltageLimit(operationalLimitId, value);
        } else {
            this.notAssigned((Identifiable<?>)this.vl);
        }
    }

    private void convertHighVoltageLimit(String operationalLimitId, double value) {
        OperationalLimitConversion.addVoltageLimitIdProperty(this.vl, "highVoltageLimit", operationalLimitId);
        if (value < this.vl.getLowVoltageLimit()) {
            this.context.ignored("HighVoltageLimit", "Inconsistent with low voltage limit (" + this.vl.getLowVoltageLimit() + "kV)");
        } else if (value < this.vl.getHighVoltageLimit() || Double.isNaN(this.vl.getHighVoltageLimit())) {
            this.vl.setHighVoltageLimit(value);
            OperationalLimitConversion.addVoltageLimitNormalValueProperty(this.vl, "highVoltageLimit", value);
        }
    }

    private void convertLowVoltageLimit(String operationalLimitId, double value) {
        OperationalLimitConversion.addVoltageLimitIdProperty(this.vl, "lowVoltageLimit", operationalLimitId);
        if (value > this.vl.getHighVoltageLimit()) {
            this.context.ignored("LowVoltageLimit", "Inconsistent with high voltage limit (" + this.vl.getHighVoltageLimit() + "kV)");
        } else if (value > this.vl.getLowVoltageLimit() || Double.isNaN(this.vl.getLowVoltageLimit())) {
            this.vl.setLowVoltageLimit(value);
            OperationalLimitConversion.addVoltageLimitNormalValueProperty(this.vl, "lowVoltageLimit", value);
        }
    }

    private boolean isPatl() {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        return limitTypeName.equals("PATL") || "LimitTypeKind.patl".equals(limitType) || "LimitKind.patl".equals(limitType);
    }

    private boolean addPatl(double value, LoadingLimitsAdder<?, ?> adder) {
        if (Double.isNaN(adder.getPermanentLimit())) {
            adder.setPermanentLimit(value);
            return true;
        }
        if (this.terminalId != null) {
            this.context.fixed(PERMANENT_LIMIT, () -> String.format("Several permanent limits defined for Terminal %s. Only the lowest is kept.", this.terminalId));
        } else {
            this.context.fixed(PERMANENT_LIMIT, () -> String.format("Several permanent limits defined for Equipment %s. Only the lowest is kept.", this.equipmentId));
        }
        if (adder.getPermanentLimit() > value) {
            adder.setPermanentLimit(value);
            return true;
        }
        return false;
    }

    private void convertPatl(double value) {
        String operationalLimitId = this.p.getId("OperationalLimit");
        if (this.olga != null && this.addPatl(value, this.olga.loadingLimitsAdder)) {
            this.addPermanentOperationalLimitProperties(this.olga.operationalLimitsGroup, operationalLimitId, value);
        } else {
            if (this.olga1 != null && this.addPatl(value, this.olga1.loadingLimitsAdder)) {
                this.addPermanentOperationalLimitProperties(this.olga1.operationalLimitsGroup, operationalLimitId, value);
            }
            if (this.olga2 != null && this.addPatl(value, this.olga2.loadingLimitsAdder)) {
                this.addPermanentOperationalLimitProperties(this.olga2.operationalLimitsGroup, operationalLimitId, value);
            }
            if (this.olga3 != null && this.addPatl(value, this.olga3.loadingLimitsAdder)) {
                this.addPermanentOperationalLimitProperties(this.olga3.operationalLimitsGroup, operationalLimitId, value);
            }
        }
    }

    private boolean isTatl() {
        String limitTypeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String limitType = this.p.getLocal(LIMIT_TYPE);
        return limitTypeName.equals("TATL") || "LimitTypeKind.tatl".equals(limitType) || "LimitKind.tatl".equals(limitType);
    }

    private boolean addTatl(String name, double value, int acceptableDuration, LoadingLimitsAdder<?, ?> adder) {
        if (Double.isNaN(value)) {
            this.context.ignored(TEMPORARY_LIMIT, "Temporary limit value is undefined");
            return false;
        }
        if (Double.isNaN(adder.getTemporaryLimitValue(acceptableDuration))) {
            adder.beginTemporaryLimit().setAcceptableDuration(acceptableDuration).setName(name).setValue(value).ensureNameUnicity().endTemporaryLimit();
            return true;
        }
        if (this.terminalId != null) {
            this.context.fixed(TEMPORARY_LIMIT, () -> String.format("Several temporary limits defined for same acceptable duration (%d s) for Terminal %s. Only the lowest is kept.", acceptableDuration, this.terminalId));
        } else {
            this.context.fixed(TEMPORARY_LIMIT, () -> String.format("Several temporary limits defined for same acceptable duration (%d s) for Equipment %s. Only the lowest is kept.", acceptableDuration, this.equipmentId));
        }
        if (adder.getTemporaryLimitValue(acceptableDuration) > value) {
            adder.beginTemporaryLimit().setAcceptableDuration(acceptableDuration).setName(name).setValue(value).ensureNameUnicity().endTemporaryLimit();
            return true;
        }
        return false;
    }

    private void convertTatl(double value) {
        int acceptableDuration = this.p.containsKey((Object)"acceptableDuration") ? (int)this.p.asDouble("acceptableDuration") : Integer.MAX_VALUE;
        String direction = this.p.getId("direction");
        if (direction == null || direction.endsWith("high") || direction.endsWith("absoluteValue")) {
            String operationalLimitId = this.p.getId("OperationalLimit");
            String name = Optional.ofNullable(this.p.getId("shortName")).orElse(this.p.getId("name"));
            this.addTemporaryLoadingLimits(name, value, acceptableDuration, operationalLimitId);
        } else if (direction.endsWith("low")) {
            this.context.invalid(TEMPORARY_LIMIT, () -> String.format("TATL %s is a low limit", this.id));
        } else {
            this.context.invalid(TEMPORARY_LIMIT, () -> String.format("TATL %s does not have a valid direction", this.id));
        }
    }

    private void addTemporaryLoadingLimits(String name, double value, int acceptableDuration, String operationalLimitId) {
        if (this.olga != null && this.addTatl(name, value, acceptableDuration, this.olga.loadingLimitsAdder)) {
            this.addTemporaryOperationalLimitProperties(this.olga.operationalLimitsGroup, acceptableDuration, operationalLimitId, value);
        } else {
            if (this.olga1 != null && this.addTatl(name, value, acceptableDuration, this.olga1.loadingLimitsAdder)) {
                this.addTemporaryOperationalLimitProperties(this.olga1.operationalLimitsGroup, acceptableDuration, operationalLimitId, value);
            }
            if (this.olga2 != null && this.addTatl(name, value, acceptableDuration, this.olga2.loadingLimitsAdder)) {
                this.addTemporaryOperationalLimitProperties(this.olga2.operationalLimitsGroup, acceptableDuration, operationalLimitId, value);
            }
            if (this.olga3 != null && this.addTatl(name, value, acceptableDuration, this.olga3.loadingLimitsAdder)) {
                this.addTemporaryOperationalLimitProperties(this.olga3.operationalLimitsGroup, acceptableDuration, operationalLimitId, value);
            }
        }
    }

    private void addTemporaryOperationalLimitProperties(OperationalLimitsGroup operationalLimitsGroup, int duration, String operationalLimitId, double value) {
        operationalLimitsGroup.setProperty(OperationalLimitConversion.getPropertyName(this.limitSubclass, false, duration, "OperationalLimit"), operationalLimitId);
        operationalLimitsGroup.setProperty(OperationalLimitConversion.getPropertyName(this.limitSubclass, false, duration, "normalValue"), String.valueOf(value));
    }

    private void addPermanentOperationalLimitProperties(OperationalLimitsGroup operationalLimitsGroup, String operationalLimitId, double value) {
        operationalLimitsGroup.setProperty(OperationalLimitConversion.getPropertyName(this.limitSubclass, true, 0, "OperationalLimit"), operationalLimitId);
        operationalLimitsGroup.setProperty(OperationalLimitConversion.getPropertyName(this.limitSubclass, true, 0, "normalValue"), String.valueOf(value));
    }

    private static void addVoltageLimitNormalValueProperty(VoltageLevel voltageLevel, String limitType, double value) {
        voltageLevel.setProperty(OperationalLimitConversion.getPropertyName(limitType, "normalValue"), String.valueOf(value));
    }

    private static void addVoltageLimitIdProperty(VoltageLevel voltageLevel, String limitType, String operationalLimitId) {
        String propertyName = OperationalLimitConversion.getPropertyName(limitType, "OperationalLimit");
        String operationalLimitIds = voltageLevel.hasProperty(propertyName) ? String.join((CharSequence)";", voltageLevel.getProperty(propertyName), operationalLimitId) : operationalLimitId;
        voltageLevel.setProperty(propertyName, operationalLimitIds);
    }

    private void notAssigned() {
        this.notAssigned(null);
    }

    private void notAssigned(Identifiable<?> eq) {
        String type = this.p.getLocal(LIMIT_TYPE);
        String typeName = this.p.getLocal(OPERATIONAL_LIMIT_TYPE_NAME);
        String subclass = this.p.getLocal(OPERATIONAL_LIMIT_SUBCLASS);
        Supplier<String> reason = () -> String.format("Not assigned for %s %s. Limit id, type, typeName, subClass, terminal : %s, %s, %s, %s, %s", eq != null ? OperationalLimitConversion.className(eq) : "", eq != null ? eq.getId() : "", this.id, type, typeName, subclass, this.terminalId);
        this.context.pending(OPERATIONAL_LIMIT, reason);
    }

    private static String className(Identifiable<?> o) {
        String s = o.getClass().getName();
        int dot = s.lastIndexOf(46);
        if (dot >= 0) {
            s = s.substring(dot + 1);
        }
        s = s.replace("Impl", "");
        return s;
    }

    protected static void update(VoltageLevel voltageLevel, Context context) {
        voltageLevel.setLowVoltageLimit(OperationalLimitConversion.getValue(voltageLevel, "lowVoltageLimit", voltageLevel.getLowVoltageLimit(), context));
        voltageLevel.setHighVoltageLimit(OperationalLimitConversion.getValue(voltageLevel, "highVoltageLimit", voltageLevel.getHighVoltageLimit(), context));
    }

    public static void update(OperationalLimitsGroup operationalLimitsGroup, Context context) {
        operationalLimitsGroup.getActivePowerLimits().ifPresent(activePowerLimits -> OperationalLimitConversion.updateLoadingLimits("ActivePowerLimit", (LoadingLimits)activePowerLimits, operationalLimitsGroup, context));
        operationalLimitsGroup.getApparentPowerLimits().ifPresent(apparentPowerLimits -> OperationalLimitConversion.updateLoadingLimits("ApparentPowerLimit", (LoadingLimits)apparentPowerLimits, operationalLimitsGroup, context));
        operationalLimitsGroup.getCurrentLimits().ifPresent(currentLimits -> OperationalLimitConversion.updateLoadingLimits("CurrentLimit", (LoadingLimits)currentLimits, operationalLimitsGroup, context));
    }

    private static void updateLoadingLimits(String limitSubclass, LoadingLimits loadingLimits, OperationalLimitsGroup operationalLimitsGroup, Context context) {
        loadingLimits.setPermanentLimit(OperationalLimitConversion.getValue(limitSubclass, true, 0, operationalLimitsGroup, loadingLimits.getPermanentLimit(), context));
        loadingLimits.getTemporaryLimits().forEach(temporaryLimit -> {
            int duration = temporaryLimit.getAcceptableDuration();
            loadingLimits.setTemporaryLimitValue(duration, OperationalLimitConversion.getValue(limitSubclass, false, duration, operationalLimitsGroup, temporaryLimit.getValue(), context));
        });
    }

    private static double getValue(String limitSubclass, boolean isInfiniteDuration, int duration, OperationalLimitsGroup operationalLimitsGroup, double previousValue, Context context) {
        String operationalLimitId = OperationalLimitConversion.getOperationalLimitId(OperationalLimitConversion.getPropertyName(limitSubclass, isInfiniteDuration, duration, "OperationalLimit"), operationalLimitsGroup);
        double defaultLimitValue = OperationalLimitConversion.getDefaultValue(OperationalLimitConversion.getNormalValue(OperationalLimitConversion.getPropertyName(limitSubclass, isInfiniteDuration, duration, "normalValue"), operationalLimitsGroup), previousValue, context);
        return OperationalLimitConversion.updatedValue(operationalLimitId, context).orElse(defaultLimitValue);
    }

    private static OptionalDouble updatedValue(String operationalLimitId, Context context) {
        PropertyBag p = context.operationalLimit(operationalLimitId);
        return p == null ? OptionalDouble.empty() : p.asOptionalDouble("value");
    }

    private static List<String> getOperationalLimitIds(String limitType, VoltageLevel voltageLevel) {
        String propertyName = OperationalLimitConversion.getPropertyName(limitType, "OperationalLimit");
        String ids = voltageLevel.getProperty(propertyName);
        if (ids == null || ids.isEmpty()) {
            return List.of();
        }
        return Arrays.stream(ids.split(";")).toList();
    }

    private static String getOperationalLimitId(String propertyName, OperationalLimitsGroup operationalLimitsGroup) {
        return operationalLimitsGroup.getProperty(propertyName);
    }

    private static Double getNormalValue(String propertyName, OperationalLimitsGroup operationalLimitsGroup) {
        return operationalLimitsGroup.getProperty(propertyName) != null ? Double.valueOf(Double.parseDouble(operationalLimitsGroup.getProperty(propertyName))) : null;
    }

    private static String getPropertyName(String limitSubclass, boolean isInfiniteDuration, int duration, String tagProperty) {
        if (isInfiniteDuration) {
            return "CGMES." + tagProperty + "_" + limitSubclass + "_patl";
        }
        return "CGMES." + tagProperty + "_" + limitSubclass + "_tatl_" + duration;
    }

    private static double getDefaultValue(Double normalValue, double previousValue, Context context) {
        return OperationalLimitConversion.getDefaultValue(normalValue, previousValue, normalValue, normalValue != null ? normalValue : previousValue, context);
    }

    private static double getValue(VoltageLevel voltageLevel, String limitType, double previousValue, Context context) {
        List<String> operationalLimitIds = OperationalLimitConversion.getOperationalLimitIds(limitType, voltageLevel);
        return OperationalLimitConversion.updatedValue(limitType, operationalLimitIds, context).orElseGet(() -> {
            Double normalValue = OperationalLimitConversion.getNormalValue(limitType, voltageLevel);
            Double voltageLevelNormalValue = OperationalLimitConversion.getVoltageLevelNormalValue(voltageLevel, limitType);
            return OperationalLimitConversion.getDefaultValue(normalValue != null ? normalValue : voltageLevelNormalValue, previousValue, context);
        });
    }

    private static OptionalDouble updatedValue(String limitType, List<String> operationalLimitIds, Context context) {
        return operationalLimitIds.stream().map(operationalLimitId -> OperationalLimitConversion.updatedValue(operationalLimitId, context)).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble).reduce(OperationalLimitConversion.getUpperBound(limitType) ? Double::max : Double::min);
    }

    private static boolean getUpperBound(String limitType) {
        return "lowVoltageLimit".equals(limitType);
    }

    private static Double getNormalValue(String limitType, VoltageLevel voltageLevel) {
        String propertyName = OperationalLimitConversion.getPropertyName(limitType, "normalValue");
        return voltageLevel.getProperty(propertyName) != null ? Double.valueOf(Double.parseDouble(voltageLevel.getProperty(propertyName))) : null;
    }

    private static Double getVoltageLevelNormalValue(VoltageLevel voltageLevel, String limitType) {
        String propertyName = "CGMES." + limitType;
        return voltageLevel.getProperty(propertyName) != null ? Double.valueOf(Double.parseDouble(voltageLevel.getProperty(propertyName))) : null;
    }

    private static String getPropertyName(String limitType, String tagProperty) {
        return "CGMES." + tagProperty + "_" + limitType;
    }

    private record OLGA(OperationalLimitsGroup operationalLimitsGroup, LoadingLimitsAdder<?, ?> loadingLimitsAdder) {
    }
}

