/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModelAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Comparator;
import java.util.Optional;
import java.util.OptionalInt;

public class ShuntConversion
extends AbstractConductingEquipmentConversion {
    private static final String SECTION_NUMBER = "sectionNumber";

    public ShuntConversion(PropertyBag sh, Context context) {
        super("ShuntCompensator", sh, context);
    }

    @Override
    public void convert() {
        int maximumSections = this.p.asInt("maximumSections", 0);
        int normalSections = this.p.asInt("normalSections", 0);
        ShuntCompensatorAdder adder = this.voltageLevel().newShuntCompensator().setSectionCount(0);
        String shuntType = this.p.getId("type");
        if ("LinearShuntCompensator".equals(shuntType)) {
            double bPerSection = this.p.asDouble("bPerSection", (double)1.4E-45f);
            double gPerSection = this.p.asDouble("gPerSection", Double.NaN);
            adder.newLinearModel().setBPerSection(bPerSection).setGPerSection(gPerSection).setMaximumSectionCount(maximumSections).add();
        } else if ("NonlinearShuntCompensator".equals(shuntType)) {
            ShuntCompensatorNonLinearModelAdder modelAdder = adder.newNonLinearModel();
            PropertyBags ss = this.context.nonlinearShuntCompensatorPoints(this.id);
            ss.stream().filter(s -> s.asInt(SECTION_NUMBER) > 0).sorted(Comparator.comparing(s -> s.asInt(SECTION_NUMBER))).forEach(sec -> {
                int sectionNumber = sec.asInt(SECTION_NUMBER);
                modelAdder.beginSection().setB(ss.stream().filter(s -> s.asInt(SECTION_NUMBER) <= sectionNumber).map(s -> s.asDouble("b")).reduce(0.0, Double::sum).doubleValue()).setG(ss.stream().filter(s -> s.asInt(SECTION_NUMBER) <= sectionNumber).map(s -> s.asDouble("g")).reduce(0.0, Double::sum).doubleValue()).endSection();
            });
            modelAdder.add();
        } else {
            throw new IllegalStateException("Unexpected shunt type: " + shuntType);
        }
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
        ShuntCompensator shunt = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)shunt);
        this.convertedTerminalsWithOnlyEq(shunt.getTerminal());
        this.context.regulatingControlMapping().forShuntCompensators().add(shunt.getId(), this.p);
        shunt.setProperty("CGMES.normalSections", String.valueOf(normalSections));
    }

    public static void update(ShuntCompensator shuntCompensator, PropertyBag cgmesData, Context context) {
        ShuntConversion.updateTerminals(shuntCompensator, context, new Terminal[]{shuntCompensator.getTerminal()});
        ShuntConversion.updateSections(shuntCompensator, cgmesData, context);
        Boolean controlEnabled = cgmesData.asBoolean("controlEnabled").orElse(null);
        ShuntConversion.updateRegulatingControl(shuntCompensator, controlEnabled, context);
    }

    private static void updateSections(ShuntCompensator shuntCompensator, PropertyBag cgmesData, Context context) {
        int defaultSections = ShuntConversion.getDefaultSections(shuntCompensator, ShuntConversion.getNormalSections(shuntCompensator), context);
        int sections = ShuntConversion.getSections(cgmesData).orElse(defaultSections);
        shuntCompensator.setSectionCount(Math.min(sections, shuntCompensator.getMaximumSectionCount()));
        ShuntConversion.getSolvedSections(cgmesData).ifPresent(arg_0 -> ((ShuntCompensator)shuntCompensator).setSolvedSectionCount(arg_0));
    }

    private static Integer getNormalSections(ShuntCompensator shuntCompensator) {
        String property = shuntCompensator.getProperty("CGMES.normalSections");
        return property != null ? Integer.valueOf(Integer.parseInt(property)) : null;
    }

    private static OptionalInt getSections(PropertyBag cgmesData) {
        double sections = cgmesData.asDouble("SSHsections", cgmesData.asDouble("SVsections"));
        return Double.isFinite(sections) ? OptionalInt.of(Math.abs(ShuntConversion.fromContinuous(sections))) : OptionalInt.empty();
    }

    private static OptionalInt getSolvedSections(PropertyBag cgmesData) {
        double sections = cgmesData.asDouble("SVsections");
        return Double.isFinite(sections) ? OptionalInt.of(Math.abs(ShuntConversion.fromContinuous(sections))) : OptionalInt.empty();
    }

    private static int getDefaultSections(ShuntCompensator shuntCompensator, Integer normalSections, Context context) {
        return ShuntConversion.getDefaultValue(normalSections, shuntCompensator.getSectionCount(), 0, 0, context);
    }

    private static void updateRegulatingControl(ShuntCompensator shuntCompensator, Boolean controlEnabled, Context context) {
        boolean updatedControlEnabled;
        boolean defaultRegulatingOn = ShuntConversion.getDefaultRegulatingOn(shuntCompensator, context);
        boolean bl = updatedControlEnabled = controlEnabled != null ? controlEnabled : defaultRegulatingOn;
        if (ShuntConversion.isDefaultRegulatingControl(shuntCompensator, updatedControlEnabled)) {
            ShuntConversion.setDefaultRegulatingControl(shuntCompensator);
            return;
        }
        double defaultTargetV = ShuntConversion.getDefaultTargetV(shuntCompensator, context);
        double defaultTargetDeadband = ShuntConversion.getDefaultTargetDeadband(shuntCompensator, context);
        Optional<PropertyBag> cgmesRegulatingControl = ShuntConversion.findCgmesRegulatingControl(shuntCompensator, context);
        double targetV = cgmesRegulatingControl.map(propertyBag -> ShuntConversion.findTargetV(propertyBag, defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetV);
        double targetDeadband = cgmesRegulatingControl.map(propertyBag -> ShuntConversion.findTargetDeadband(propertyBag, defaultTargetDeadband, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetDeadband);
        boolean enabled = cgmesRegulatingControl.map(propertyBag -> ShuntConversion.findRegulatingOn(propertyBag, defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
        ShuntConversion.setRegulation(shuntCompensator, targetV, targetDeadband, updatedControlEnabled && enabled && ShuntConversion.isValidTargetV(targetV) && ShuntConversion.isValidTargetDeadband(targetDeadband));
    }

    private static void setRegulation(ShuntCompensator shuntCompensator, double targetV, double targetDeadband, boolean regulatingOn) {
        if (regulatingOn) {
            shuntCompensator.setTargetV(targetV).setTargetDeadband(targetDeadband).setVoltageRegulatorOn(true);
        } else {
            shuntCompensator.setVoltageRegulatorOn(false).setTargetV(targetV).setTargetDeadband(targetDeadband);
        }
    }

    private static double getDefaultTargetV(ShuntCompensator shuntCompensator, Context context) {
        return ShuntConversion.getDefaultValue(null, shuntCompensator.getTargetV(), Double.NaN, Double.NaN, context);
    }

    private static double getDefaultTargetDeadband(ShuntCompensator shuntCompensator, Context context) {
        return ShuntConversion.getDefaultValue(null, shuntCompensator.getTargetDeadband(), 0.0, 0.0, context);
    }

    private static boolean getDefaultRegulatingOn(ShuntCompensator shuntCompensator, Context context) {
        return ShuntConversion.getDefaultValue(null, shuntCompensator.isVoltageRegulatorOn(), false, false, context);
    }

    private static boolean isDefaultRegulatingControl(ShuntCompensator shuntCompensator, boolean controlEnabled) {
        String regulatingControlId = shuntCompensator.getProperty("CGMES.RegulatingControl");
        return regulatingControlId == null && controlEnabled;
    }

    private static void setDefaultRegulatingControl(ShuntCompensator shuntCompensator) {
        shuntCompensator.setTargetV(Optional.ofNullable(shuntCompensator.getRegulatingTerminal().getBusView().getBus()).map(Bus::getV).filter(v -> !Double.isNaN(v)).orElse(shuntCompensator.getRegulatingTerminal().getVoltageLevel().getNominalV()).doubleValue()).setTargetDeadband(0.0).setVoltageRegulatorOn(true);
    }
}

