/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForStaticVarCompensators;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.VoltagePerReactivePowerControlAdder;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;

public class StaticVarCompensatorConversion
extends AbstractConductingEquipmentConversion {
    public StaticVarCompensatorConversion(PropertyBag svc, Context context) {
        super("StaticVarCompensator", svc, context);
    }

    @Override
    public void convert() {
        double slope = this.checkSlope(this.p.asDouble("slope"));
        double capacitiveRating = this.p.asDouble("capacitiveRating", 0.0);
        double inductiveRating = this.p.asDouble("inductiveRating", 0.0);
        StaticVarCompensatorAdder adder = this.voltageLevel().newStaticVarCompensator().setBmin(this.getB(inductiveRating, "inductive")).setBmax(this.getB(capacitiveRating, "capacitive"));
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
        RegulatingControlMappingForStaticVarCompensators.initialize(adder);
        StaticVarCompensator svc = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)svc);
        this.convertedTerminalsWithOnlyEq(svc.getTerminal());
        if (slope >= 0.0) {
            ((VoltagePerReactivePowerControlAdder)svc.newExtension(VoltagePerReactivePowerControlAdder.class)).withSlope(slope).add();
        }
        this.context.regulatingControlMapping().forStaticVarCompensators().add(svc.getId(), this.p);
    }

    private double getB(double rating, String name) {
        if (rating == 0.0) {
            this.fixed(name + "Rating", "Undefined or equal to 0. Corresponding susceptance is Double.MAX_VALUE");
            return name.equals("inductive") ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        return 1.0 / rating;
    }

    private double checkSlope(double slope) {
        if (Double.isNaN(slope)) {
            this.missing("slope");
        }
        if (slope < 0.0) {
            this.ignored("Slope must be positive");
        }
        return slope;
    }

    public static void update(StaticVarCompensator staticVarCompensator, PropertyBag cgmesData, Context context) {
        StaticVarCompensatorConversion.updateTerminals(staticVarCompensator, context, new Terminal[]{staticVarCompensator.getTerminal()});
        double defaultQ = cgmesData.asDouble("q");
        Boolean controlEnabled = cgmesData.asBoolean("controlEnabled").orElse(null);
        StaticVarCompensatorConversion.updateRegulatingControl(staticVarCompensator, defaultQ, controlEnabled, context);
    }

    private static void updateRegulatingControl(StaticVarCompensator staticVarCompensator, double defaultQ, Boolean controlEnabled, Context context) {
        Optional<PropertyBag> cgmesRegulatingControl = StaticVarCompensatorConversion.findCgmesRegulatingControl(staticVarCompensator, context);
        boolean defaultRegulatingOn = StaticVarCompensatorConversion.getDefaultRegulatingOn(staticVarCompensator, context);
        boolean updatedControlEnabled = controlEnabled != null ? controlEnabled : defaultRegulatingOn;
        boolean regulatingOn = cgmesRegulatingControl.map(propertyBag -> StaticVarCompensatorConversion.findRegulatingOn(propertyBag, defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
        if (staticVarCompensator.getRegulationMode() == StaticVarCompensator.RegulationMode.VOLTAGE) {
            double defaultTargetV = StaticVarCompensatorConversion.getDefaultTargetV(staticVarCompensator, context);
            double targetV = cgmesRegulatingControl.map(propertyBag -> StaticVarCompensatorConversion.findTargetV(propertyBag, defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetV);
            boolean regulating = updatedControlEnabled && regulatingOn && StaticVarCompensatorConversion.isValidTargetV(targetV);
            staticVarCompensator.setVoltageSetpoint(targetV).setRegulating(regulating);
        } else if (staticVarCompensator.getRegulationMode() == StaticVarCompensator.RegulationMode.REACTIVE_POWER) {
            double defaultTargetQ = StaticVarCompensatorConversion.getDefaultTargetQ(staticVarCompensator, defaultQ, context);
            int terminalSign = StaticVarCompensatorConversion.findTerminalSign(staticVarCompensator);
            double targetQ = cgmesRegulatingControl.map(propertyBag -> StaticVarCompensatorConversion.findTargetQ(propertyBag, terminalSign, defaultTargetQ, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetQ);
            boolean regulating = updatedControlEnabled && regulatingOn && StaticVarCompensatorConversion.isValidTargetQ(targetQ);
            staticVarCompensator.setReactivePowerSetpoint(targetQ).setRegulating(regulating);
        }
    }

    private static double findDefaultEquipmentTargetV(StaticVarCompensator staticVarCompensator) {
        String defaultTargetVoltage = staticVarCompensator.getProperty("CGMES.svcEquipmentVoltageSetPoint");
        return defaultTargetVoltage != null ? Double.parseDouble(defaultTargetVoltage) : Double.NaN;
    }

    private static double getDefaultTargetV(StaticVarCompensator staticVarCompensator, Context context) {
        return StaticVarCompensatorConversion.getDefaultValue(StaticVarCompensatorConversion.findDefaultEquipmentTargetV(staticVarCompensator), staticVarCompensator.getVoltageSetpoint(), Double.NaN, Double.NaN, context);
    }

    private static double getDefaultTargetQ(StaticVarCompensator staticVarCompensator, double defaultTargetQ, Context context) {
        return StaticVarCompensatorConversion.getDefaultValue(null, staticVarCompensator.getReactivePowerSetpoint(), defaultTargetQ, Double.NaN, context);
    }

    private static boolean getDefaultRegulatingOn(StaticVarCompensator staticVarCompensator, Context context) {
        return StaticVarCompensatorConversion.getDefaultValue(null, staticVarCompensator.isRegulating(), false, false, context);
    }
}

