/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.elements.TerminalConversion;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;

public final class SvInjectionConversion {
    private SvInjectionConversion() {
    }

    public static void create(Network network, PropertyBag svInjection) {
        SvInjectionConversion.findTerminal(network, svInjection).ifPresentOrElse(terminal -> {
            if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
                SvInjectionConversion.createNodeBreakerLoad(terminal, svInjection);
            } else {
                SvInjectionConversion.createBusBreakerLoad(terminal.getBusBreakerView().getConnectableBus(), svInjection);
            }
        }, () -> SvInjectionConversion.findBus(network, svInjection).ifPresent(bus -> SvInjectionConversion.createBusBreakerLoad(bus, svInjection)));
    }

    private static Optional<Terminal> findTerminal(Network network, PropertyBag svInjection) {
        String terminalId = svInjection.getId("Terminal");
        Connectable connectable = terminalId != null ? network.getConnectable(terminalId) : null;
        return connectable != null ? Optional.ofNullable(TerminalConversion.getTerminal(connectable, terminalId)) : Optional.empty();
    }

    private static Optional<Bus> findBus(Network network, PropertyBag svInjection) {
        String topologicalNodeId = svInjection.getId("TopologicalNode");
        return topologicalNodeId != null ? Optional.ofNullable(network.getBusBreakerView().getBus(topologicalNodeId)) : Optional.empty();
    }

    private static void createNodeBreakerLoad(Terminal terminal, PropertyBag svInjection) {
        String id = svInjection.getId("SvInjection");
        double p0 = svInjection.asDouble("pInjection");
        double q0 = svInjection.asDouble("qInjection", 0.0);
        int node = terminal.getNodeBreakerView().getNode();
        int newNode = terminal.getVoltageLevel().getNodeBreakerView().getMaximumNodeIndex() + 1;
        terminal.getVoltageLevel().getNodeBreakerView().newInternalConnection().setNode1(node).setNode2(newNode).add();
        Load load = ((LoadAdder)((LoadAdder)((LoadAdder)((LoadAdder)terminal.getVoltageLevel().newLoad().setId(id)).setName(id)).setP0(p0).setQ0(q0).setFictitious(true)).setLoadType(LoadType.FICTITIOUS).setNode(newNode)).add();
        load.getTerminal().setP(p0).setQ(q0);
    }

    private static void createBusBreakerLoad(Bus bus, PropertyBag svInjection) {
        String id = svInjection.getId("SvInjection");
        double p0 = svInjection.asDouble("pInjection");
        double q0 = svInjection.asDouble("qInjection", 0.0);
        Load load = ((LoadAdder)((LoadAdder)((LoadAdder)((LoadAdder)((LoadAdder)bus.getVoltageLevel().newLoad().setId(id)).setName(id)).setP0(p0).setQ0(q0).setFictitious(true)).setLoadType(LoadType.FICTITIOUS).setConnectableBus(bus.getId())).setBus(bus.getId())).add();
        load.getTerminal().setP(p0).setQ(q0);
    }
}

