/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchConversion
extends AbstractConductingEquipmentConversion
implements EquipmentAtBoundaryConversion {
    private DanglingLine danglingLine;
    private static final Logger LOG = LoggerFactory.getLogger(SwitchConversion.class);

    public SwitchConversion(PropertyBag sw, Context context) {
        super("Switch", sw, context, 2);
    }

    @Override
    public boolean valid() {
        if (!this.validNodes()) {
            return false;
        }
        if (this.busId(1).equals(this.busId(2))) {
            this.ignored("end buses are the same bus " + this.busId(1));
            return false;
        }
        if ((this.isBoundary(1) || this.isBoundary(2)) && LOG.isWarnEnabled()) {
            LOG.warn("Switch {} has at least one end in the boundary", (Object)this.id);
            LOG.warn("    busId1, voltageLevel1 : {} {}", (Object)this.busId(1), this.voltageLevel(1).orElse(null));
            LOG.warn("    side 1 is boundary    : {}", (Object)this.isBoundary(1));
            LOG.warn("    busId2, voltageLevel2 : {} {}", (Object)this.busId(2), this.voltageLevel(2).orElse(null));
            LOG.warn("    side 2 is boundary    : {}", (Object)this.isBoundary(2));
        }
        return true;
    }

    @Override
    public void convert() {
        this.convertToSwitch();
    }

    @Override
    public void convertAtBoundary() {
        if (this.isBoundary(1)) {
            this.convertSwitchAtBoundary(1);
        } else if (this.isBoundary(2)) {
            this.convertSwitchAtBoundary(2);
        } else {
            throw new ConversionException("Boundary must be at one end of the switch");
        }
    }

    @Override
    public Optional<DanglingLine> getDanglingLine() {
        return Optional.ofNullable(this.danglingLine);
    }

    private Switch convertToSwitch() {
        Switch s;
        boolean normalOpen = this.p.asBoolean("normalOpen", false);
        if (this.context.nodeBreaker()) {
            VoltageLevel.NodeBreakerView.SwitchAdder adder = this.voltageLevel().getNodeBreakerView().newSwitch().setKind(this.kind());
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connectWithOnlyEq(adder);
            boolean retained = this.p.asBoolean("retained", false);
            s = adder.setOpen(normalOpen).setRetained(retained).add();
        } else {
            VoltageLevel.BusBreakerView.SwitchAdder adder = this.voltageLevel().getBusBreakerView().newSwitch();
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connectWithOnlyEq(adder);
            s = adder.setOpen(normalOpen).add();
        }
        this.addAliasesAndProperties((Identifiable<?>)s);
        s.setProperty("CGMES.originalClass", this.p.getLocal("type"));
        s.setProperty("CGMES.normalOpen", String.valueOf(normalOpen));
        return s;
    }

    private void convertSwitchAtBoundary(int boundarySide) {
        if (this.context.config().convertBoundary()) {
            this.convertToSwitch().setRetained(true);
        } else {
            this.warnDanglingLineCreated();
            String eqInstance = (String)this.p.get((Object)"graph");
            this.danglingLine = this.convertToDanglingLine(eqInstance, boundarySide, "Switch");
            boolean normalOpen = this.p.asBoolean("normalOpen", false);
            this.danglingLine.setProperty("CGMES.normalOpen", String.valueOf(normalOpen));
        }
    }

    private SwitchKind kind() {
        String type;
        return switch (type = this.p.getLocal("type")) {
            case "Disconnector", "GroundDisconnector", "Jumper" -> SwitchKind.DISCONNECTOR;
            case "LoadBreakSwitch" -> SwitchKind.LOAD_BREAK_SWITCH;
            case "Breaker" -> SwitchKind.BREAKER;
            default -> SwitchKind.DISCONNECTOR;
        };
    }

    private void warnDanglingLineCreated() {
        this.fixed("Dangling line with low impedance", "Connected to a boundary node");
    }

    public static void update(DanglingLine danglingLine, PropertyBag cgmesData, Context context) {
        boolean isClosed = cgmesData.asBoolean("open").orElse(SwitchConversion.defaultOpen(danglingLine, context)) == false;
        SwitchConversion.updateDanglingLine(danglingLine, SwitchConversion.isBoundaryTerminalConnected(danglingLine, context) && isClosed, context);
    }

    private static boolean defaultOpen(DanglingLine danglingLine, Context context) {
        return SwitchConversion.getDefaultValue(SwitchConversion.getNormalOpen(danglingLine), false, false, false, context);
    }

    private static Boolean getNormalOpen(DanglingLine danglingLine) {
        String property = danglingLine.getProperty("CGMES.normalOpen");
        return property != null ? Boolean.valueOf(Boolean.parseBoolean(property)) : null;
    }

    public static void update(Switch sw, PropertyBag cgmesData, Context context) {
        boolean isOpenFromAtLeastOneTerminal = sw.getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER && SwitchConversion.isOpenFromAtLeastOneTerminal(sw, context).orElse(false) != false;
        boolean isOpen = cgmesData.asBoolean("open").orElse(SwitchConversion.getDefaultIsOpen(sw, context));
        sw.setOpen(isOpen || isOpenFromAtLeastOneTerminal);
    }
}

