/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForGenerators;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.iidm.network.extensions.ReferencePriority;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Arrays;
import java.util.Optional;

public class SynchronousMachineConversion
extends AbstractReactiveLimitsOwnerConversion {
    private final boolean isCondenser;

    public SynchronousMachineConversion(PropertyBag sm, Context context) {
        super("SynchronousMachine", sm, context);
        String type = this.p.getLocal("type");
        this.isCondenser = "SynchronousMachineKind.condenser".equals(type);
    }

    @Override
    public void convert() {
        double minP = this.p.asDouble("minP", this.isCondenser ? 0.0 : -1.7976931348623157E308);
        double maxP = this.p.asDouble("maxP", this.isCondenser ? 0.0 : Double.MAX_VALUE);
        double ratedS = this.p.asDouble("ratedS");
        ratedS = ratedS > 0.0 ? ratedS : Double.NaN;
        GeneratorAdder adder = this.voltageLevel().newGenerator();
        RegulatingControlMappingForGenerators.initialize(adder);
        this.setMinPMaxP(adder, minP, maxP);
        adder.setEnergySource(this.energySourceFromGeneratingUnitType()).setRatedS(ratedS);
        this.identify((IdentifiableAdder<?, ?>)adder);
        this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
        adder.setCondenser(this.isCondenser);
        Generator g = adder.add();
        this.addAliasesAndProperties((Identifiable<?>)g);
        this.convertedTerminalsWithOnlyEq(g.getTerminal());
        this.convertReactiveLimits((ReactiveLimitsHolder)g);
        if (!this.isCondenser) {
            this.convertGenerator(g);
        }
        this.context.regulatingControlMapping().forGenerators().add(g.getId(), this.p);
        SynchronousMachineConversion.addSpecificProperties(g, this.p);
    }

    private static void addSpecificProperties(Generator generator, PropertyBag p) {
        String operatingMode;
        generator.setProperty("CGMES.originalClass", "SynchronousMachine");
        String type = p.getLocal("type");
        if (type != null) {
            generator.setProperty("CGMES.synchronousMachineType", type.replace("SynchronousMachineKind.", ""));
        }
        if ((operatingMode = p.getLocal("operatingMode")) != null) {
            generator.setProperty("CGMES.synchronousMachineOperatingMode", operatingMode.replace("SynchronousMachineOperatingMode.", ""));
        }
    }

    private void convertGenerator(Generator g) {
        String generatingUnit = this.p.getId("GeneratingUnit");
        if (generatingUnit != null) {
            g.setProperty("CGMES.GeneratingUnit", generatingUnit);
        }
        SynchronousMachineConversion.addGeneratingUnitProperties(g, this.p);
    }

    private static void addGeneratingUnitProperties(Generator generator, PropertyBag p) {
        String windGenUnitType;
        String fossilFuelType;
        String hydroPlantStorageType;
        String initialP = p.getLocal("initialP");
        if (initialP != null) {
            generator.setProperty("CGMES.initialP", initialP);
        }
        if ((hydroPlantStorageType = p.getLocal("hydroPlantStorageType")) != null) {
            generator.setProperty("CGMES.hydroPlantStorageKind", hydroPlantStorageType.replace("HydroPlantStorageKind.", ""));
        }
        if (!(fossilFuelType = String.join((CharSequence)";", Arrays.stream(p.getLocals("fossilFuelTypeList", ";")).map(ff -> ff.replace("FuelType.", "")).toList())).isEmpty()) {
            generator.setProperty("CGMES.fuelType", fossilFuelType);
        }
        if ((windGenUnitType = p.getLocal("windGenUnitType")) != null) {
            generator.setProperty("CGMES.windGenUnitType", windGenUnitType.replace("WindGenUnitKind.", ""));
        }
    }

    private EnergySource energySourceFromGeneratingUnitType() {
        String gut = this.p.getLocal("generatingUnitType");
        EnergySource es = EnergySource.OTHER;
        if (gut != null) {
            if (gut.contains("HydroGeneratingUnit")) {
                es = EnergySource.HYDRO;
            } else if (gut.contains("NuclearGeneratingUnit")) {
                es = EnergySource.NUCLEAR;
            } else if (gut.contains("ThermalGeneratingUnit")) {
                es = EnergySource.THERMAL;
            } else if (gut.contains("WindGeneratingUnit")) {
                es = EnergySource.WIND;
            } else if (gut.contains("SolarGeneratingUnit")) {
                es = EnergySource.SOLAR;
            }
        }
        return es;
    }

    public static void update(Generator generator, PropertyBag cgmesData, Context context) {
        String operatingMode;
        SynchronousMachineConversion.updateTerminals(generator, context, new Terminal[]{generator.getTerminal()});
        int referencePriority = cgmesData.asInt("referencePriority", 0);
        if (referencePriority > 0) {
            ReferencePriority.set((Injection)generator, (int)referencePriority);
        }
        double targetP = SynchronousMachineConversion.getDefaultValue(SynchronousMachineConversion.getInitialP(generator), generator.getTargetP(), 0.0, 0.0, context);
        double targetQ = SynchronousMachineConversion.getDefaultValue(null, generator.getTargetQ(), 0.0, 0.0, context);
        PowerFlow updatedPowerFlow = SynchronousMachineConversion.updatedPowerFlow(generator, cgmesData, context);
        if (updatedPowerFlow.defined()) {
            targetP = -updatedPowerFlow.p();
            targetQ = -updatedPowerFlow.q();
        }
        generator.setTargetP(targetP).setTargetQ(targetQ);
        String generatingUnitId = generator.getProperty("CGMES.GeneratingUnit");
        if (generatingUnitId != null) {
            SynchronousMachineConversion.updateGeneratingUnit(generator, generatingUnitId, context);
        }
        if ((operatingMode = cgmesData.getLocal("operatingMode")) != null) {
            generator.setProperty("CGMES.synchronousMachineOperatingMode", operatingMode.replace("SynchronousMachineOperatingMode.", ""));
        }
        Boolean controlEnabled = cgmesData.asBoolean("controlEnabled").orElse(null);
        SynchronousMachineConversion.updateRegulatingControl(generator, controlEnabled, context);
    }

    private static double getInitialP(Generator generator) {
        String initialP = generator.getProperty("CGMES.initialP");
        return initialP != null ? Double.parseDouble(initialP) : 0.0;
    }

    private static void updateGeneratingUnit(Generator generator, String generatingUnitId, Context context) {
        SynchronousMachineConversion.findCgmesGeneratingUnit(generatingUnitId, context).ifPresent(generatingUnit -> {
            double normalPF = generatingUnit.asDouble("normalPF");
            if (!Double.isNaN(normalPF)) {
                SynchronousMachineConversion.updateNormalPF(generator, normalPF, context);
            }
        });
    }

    private static Optional<PropertyBag> findCgmesGeneratingUnit(String generatingUnitId, Context context) {
        return generatingUnitId != null ? Optional.ofNullable(context.generatingUnit(generatingUnitId)) : Optional.empty();
    }

    private static void updateNormalPF(Generator generator, double normalPF, Context context) {
        ActivePowerControl activePowerControl = (ActivePowerControl)generator.getExtension(ActivePowerControl.class);
        if (activePowerControl != null) {
            activePowerControl.setParticipationFactor(normalPF);
        } else if (context.config().createActivePowerControlExtension()) {
            ((ActivePowerControlAdder)generator.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withParticipationFactor(normalPF).add();
        } else {
            generator.setProperty("CGMES.normalPF", String.valueOf(normalPF));
        }
    }
}

