/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.HashMap;
import java.util.Optional;

public final class TerminalConversion {
    private TerminalConversion() {
    }

    public static void create(Network network, PropertyBag cgmesTerminal, Context context) {
        boolean connected;
        String cgmesTerminalId = cgmesTerminal.getId("Terminal");
        if (TerminalConversion.createFictitiousSwitch(network, cgmesTerminalId, connected = cgmesTerminal.asBoolean("connected", true))) {
            TerminalConversion.create(network, cgmesTerminalId, context);
        }
    }

    private static boolean createFictitiousSwitch(Network network, String cgmesTerminalId, boolean connected) {
        if (cgmesTerminalId == null || connected) {
            return false;
        }
        Identifiable identifiable = network.getIdentifiable(cgmesTerminalId);
        return identifiable == null || identifiable.getType() != IdentifiableType.BUSBAR_SECTION;
    }

    private static void create(Network network, String cgmesTerminalId, Context context) {
        Identifiable identifiable = network.getIdentifiable(cgmesTerminalId);
        if (TerminalConversion.createFictitiousSwitch(identifiable, context)) {
            Connectable connectable;
            Terminal terminal;
            if (identifiable instanceof Switch) {
                Switch sw = (Switch)identifiable;
                if (TerminalConversion.createFictitiousSwitch(sw)) {
                    TerminalConversion.createSwitchForSwitch(sw, TerminalConversion.getNode(sw, cgmesTerminalId), cgmesTerminalId, context);
                }
            } else if (identifiable instanceof Connectable && TerminalConversion.createFictitiousSwitch(terminal = TerminalConversion.getTerminal(connectable = (Connectable)identifiable, cgmesTerminalId))) {
                TerminalConversion.createSwitchForTerminal(terminal, cgmesTerminalId, context);
            }
        }
    }

    private static boolean createFictitiousSwitch(Identifiable<?> identifiable, Context context) {
        return switch (context.config().getCreateFictitiousSwitchesForDisconnectedTerminalsMode()) {
            default -> throw new MatchException(null, null);
            case CgmesImport.FictitiousSwitchesCreationMode.NEVER -> false;
            case CgmesImport.FictitiousSwitchesCreationMode.ALWAYS -> {
                if (identifiable != null) {
                    yield true;
                }
                yield false;
            }
            case CgmesImport.FictitiousSwitchesCreationMode.ALWAYS_EXCEPT_SWITCHES -> identifiable != null && identifiable.getType() != IdentifiableType.SWITCH;
        };
    }

    private static boolean createFictitiousSwitch(Switch sw) {
        return sw.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER;
    }

    private static boolean createFictitiousSwitch(Terminal terminal) {
        return terminal != null && terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER;
    }

    private static int getNode(Switch sw, String terminalId) {
        String aliasType = sw.getAliasType(terminalId).orElse("");
        if (aliasType.equals("CGMES.Terminal1")) {
            return sw.getVoltageLevel().getNodeBreakerView().getNode1(sw.getId());
        }
        if (aliasType.equals("CGMES.Terminal2")) {
            return sw.getVoltageLevel().getNodeBreakerView().getNode2(sw.getId());
        }
        throw new PowsyblException("Unexpected terminal " + terminalId + " in the switch " + sw.getId());
    }

    private static void createSwitchForSwitch(Switch sw, int node, String cgmesTerminalId, Context context) {
        int newNode = sw.getVoltageLevel().getNodeBreakerView().getMaximumNodeIndex() + 1;
        if (node == sw.getVoltageLevel().getNodeBreakerView().getNode1(sw.getId())) {
            TerminalConversion.createSwitch(sw.getVoltageLevel(), cgmesTerminalId, node, newNode, context);
        } else {
            TerminalConversion.createSwitch(sw.getVoltageLevel(), cgmesTerminalId, newNode, node, context);
        }
        TerminalConversion.moveSwitchNode(sw, node, newNode);
    }

    private static void moveSwitchNode(Switch sw, int node, int newNode) {
        int node1 = sw.getVoltageLevel().getNodeBreakerView().getNode1(sw.getId());
        int node2 = sw.getVoltageLevel().getNodeBreakerView().getNode2(sw.getId());
        VoltageLevel.NodeBreakerView.SwitchAdder adder = (VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)sw.getVoltageLevel().getNodeBreakerView().newSwitch().setId(sw.getId())).setName(sw.getNameOrId())).setNode1(node1 == node ? newNode : node1).setNode2(node2 == node ? newNode : node2).setKind(sw.getKind()).setRetained(sw.isRetained()).setOpen(sw.isOpen()).setFictitious(sw.isFictitious());
        HashMap<String, String> properties = new HashMap<String, String>();
        sw.getPropertyNames().forEach(propertyName -> properties.put((String)propertyName, sw.getProperty(propertyName)));
        HashMap<String, String> aliases = new HashMap<String, String>();
        sw.getAliases().forEach(alias -> aliases.put((String)alias, sw.getAliasType(alias).orElse("")));
        sw.getVoltageLevel().getNodeBreakerView().removeSwitch(sw.getId());
        Switch newSw = adder.add();
        properties.forEach((arg_0, arg_1) -> ((Switch)newSw).setProperty(arg_0, arg_1));
        aliases.forEach((arg_0, arg_1) -> ((Switch)newSw).addAlias(arg_0, arg_1));
    }

    private static void createSwitchForTerminal(Terminal terminal, String cgmesTerminalId, Context context) {
        int node = terminal.getNodeBreakerView().getNode();
        int newNode = terminal.getVoltageLevel().getNodeBreakerView().getMaximumNodeIndex() + 1;
        TerminalConversion.createSwitch(terminal.getVoltageLevel(), cgmesTerminalId, node, newNode, context);
        terminal.getNodeBreakerView().moveConnectable(newNode, terminal.getVoltageLevel().getId());
    }

    private static void createSwitch(VoltageLevel voltageLevel, String cgmesTerminalId, int node1, int node2, Context context) {
        String switchId = cgmesTerminalId + "_SW_fict";
        Switch sw = ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)voltageLevel.getNodeBreakerView().newSwitch().setFictitious(true)).setId(switchId)).setName(cgmesTerminalId)).setNode1(node1).setNode2(node2).setOpen(true).setKind(SwitchKind.BREAKER).setEnsureIdUnicity(context.config().isEnsureIdAliasUnicity())).add();
        sw.setProperty("CGMES.isCreatedForDisconnectedTerminal", "true");
        sw.setProperty("CGMES.Terminal", cgmesTerminalId);
    }

    static Terminal getTerminal(Connectable<?> connectable, String terminalId) {
        String aliasType;
        return switch (aliasType = connectable.getAliasType(terminalId).orElse("")) {
            case "CGMES.Terminal", "CGMES.Terminal1" -> (Terminal)connectable.getTerminals().get(0);
            case "CGMES.Terminal2" -> (Terminal)connectable.getTerminals().get(1);
            case "CGMES.Terminal3" -> (Terminal)connectable.getTerminals().get(2);
            case "CGMES.Terminal_Boundary" -> null;
            default -> throw new PowsyblException("Unexpected terminal " + terminalId + " in the connectable " + connectable.getId());
        };
    }

    public static void update(Switch sw, Context context) {
        boolean isOpen = TerminalConversion.getIsTerminalOpen(sw, context).orElse(AbstractConductingEquipmentConversion.getDefaultIsOpen(sw, context));
        sw.setOpen(isOpen);
    }

    private static Optional<Boolean> getIsTerminalOpen(Switch sw, Context context) {
        return TerminalConversion.getIsTerminalConnected(sw, context).map(connected -> connected == false);
    }

    private static Optional<Boolean> getIsTerminalConnected(Switch sw, Context context) {
        String cgmesTerminalId = sw.getProperty("CGMES.Terminal");
        return cgmesTerminalId != null ? Optional.ofNullable(context.cgmesTerminal(cgmesTerminalId)).flatMap(cgmesTerminal -> cgmesTerminal.asBoolean("connected")) : Optional.empty();
    }
}

