/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.triplestore.api.PropertyBag;

public class TieFlowConversion
extends AbstractIdentifiedObjectConversion {
    public TieFlowConversion(PropertyBag tieFlow, Context context) {
        super("TieFlow", tieFlow, context);
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void convert() {
        String controlAreaId = this.p.getId("ControlArea");
        Area area = this.context.network().getArea(controlAreaId);
        if (area == null) {
            this.context.ignored("Tie Flow", String.format("Tie Flow %s refers to a non-existing control area", this.p.getId("TieFlow")));
            return;
        }
        String terminalId = this.p.getId("Terminal");
        boolean isAc = this.isConsideredAcTieFlow(terminalId);
        Boundary boundary = this.context.terminalMapping().findBoundary(terminalId, this.context.cgmes());
        if (boundary != null) {
            area.newAreaBoundary().setAc(isAc).setBoundary(boundary).add();
            return;
        }
        RegulatingTerminalMapper.mapForTieFlow(terminalId, this.context).ifPresent(t -> area.newAreaBoundary().setAc(isAc).setTerminal(t).add());
    }

    private boolean isConsideredAcTieFlow(String terminalId) {
        CgmesTerminal cgmesTerminal = this.context.cgmes().terminal(terminalId);
        String node = cgmesTerminal.topologicalNode() == null ? cgmesTerminal.connectivityNode() : cgmesTerminal.topologicalNode();
        boolean isDc = this.context.boundary().isHvdc(node);
        return !isDc;
    }
}

