/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.TieLineUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class TieLineConversion {
    private TieLineConversion() {
    }

    public static void create(String node, EquipmentAtBoundaryConversion conversion1, EquipmentAtBoundaryConversion conversion2, Context context) {
        conversion1.convertAtBoundary();
        Optional<DanglingLine> dl1 = conversion1.getDanglingLine();
        conversion2.convertAtBoundary();
        Optional<DanglingLine> dl2 = conversion2.getDanglingLine();
        if (dl1.isPresent() && dl2.isPresent()) {
            String regionName1 = TieLineConversion.obtainRegionName(dl1.get().getTerminal().getVoltageLevel());
            String regionName2 = TieLineConversion.obtainRegionName(dl2.get().getTerminal().getVoltageLevel());
            String pairingKey1 = dl1.get().getPairingKey();
            String pairingKey2 = dl2.get().getPairingKey();
            if (pairingKey1 == null || !pairingKey1.equals(pairingKey2)) {
                context.ignored(node, "Both dangling lines do not have the same pairingKey: we do not consider them as a merged line");
            } else if (regionName1 != null && regionName1.equals(regionName2)) {
                context.ignored(node, "Both dangling lines are in the same region: we do not consider them as a merged line");
            } else if (dl2.get().getId().compareTo(dl1.get().getId()) >= 0) {
                TieLineConversion.convertToTieLine(context, dl1.get(), dl2.get());
            } else {
                TieLineConversion.convertToTieLine(context, dl2.get(), dl1.get());
            }
        }
    }

    private static String obtainRegionName(VoltageLevel voltageLevel) {
        return voltageLevel.getSubstation().map(s -> s.getProperty("CGMES.regionName")).orElse(null);
    }

    private static void convertToTieLine(Context context, DanglingLine dl1, DanglingLine dl2) {
        TieLineAdder adder = context.network().newTieLine().setDanglingLine1(dl1.getId()).setDanglingLine2(dl2.getId());
        AbstractIdentifiedObjectConversion.identify(context, adder, context.namingStrategy().getIidmId("TieLine", TieLineUtil.buildMergedId((String)dl1.getId(), (String)dl2.getId())), TieLineUtil.buildMergedName((String)dl1.getId(), (String)dl2.getId(), (String)dl1.getNameOrId(), (String)dl2.getNameOrId()));
        adder.add();
    }

    public static void createDuringUpdate(Network network, Context context) {
        network.getDanglingLineStream().filter(danglingLine -> !danglingLine.isPaired()).collect(Collectors.groupingBy(DanglingLine::getPairingKey)).values().forEach(danglingLinesList -> {
            List<DanglingLine> connectedDanglingLines = danglingLinesList.stream().filter(danglingLine -> TieLineConversion.isConnected(danglingLine, context)).sorted(Comparator.comparing(Identifiable::getId)).toList();
            if (connectedDanglingLines.size() == 2 && !TieLineConversion.isSameRegion(connectedDanglingLines.get(0), connectedDanglingLines.get(1))) {
                TieLineConversion.convertToTieLine(context, connectedDanglingLines.get(0), connectedDanglingLines.get(1));
            }
        });
    }

    private static boolean isConnected(DanglingLine danglingLine, Context context) {
        return danglingLine.getAliasFromType("CGMES.Terminal1").map(context::cgmesTerminal).map(cgmesData -> cgmesData.asBoolean("connected", true)).orElse(true);
    }

    private static boolean isSameRegion(DanglingLine danglingLine1, DanglingLine danglingLine2) {
        String region1 = TieLineConversion.obtainRegionName(danglingLine1.getTerminal().getVoltageLevel());
        String region2 = TieLineConversion.obtainRegionName(danglingLine2.getTerminal().getVoltageLevel());
        return region1 != null && region1.equals(region2);
    }
}

