/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.dc.DCEquipment;
import com.powsybl.cgmes.conversion.elements.dc.DCIsland;
import com.powsybl.cgmes.conversion.elements.dc.DCIslandEnd;
import com.powsybl.cgmes.conversion.elements.dc.DCLink;
import com.powsybl.cgmes.conversion.elements.dc.DCPole;
import com.powsybl.cgmes.conversion.elements.dc.HvdcConverterConversion;
import com.powsybl.cgmes.conversion.elements.dc.HvdcLineConversion;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.commons.PowsyblException;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class DCConversion {
    private final Context context;
    private PropertyBags cgmesDcTerminalNodes;
    private PropertyBags cgmesAcDcConverters;
    private PropertyBags cgmesDcLineSegments;
    private PropertyBags cgmesDcSwitches;
    private PropertyBags cgmesDcGrounds;
    private final Map<String, String> dcTerminalNodes = new HashMap<String, String>();
    private final Set<DCEquipment> dcEquipments = new HashSet<DCEquipment>();
    private final Set<DCIslandEnd> dcIslandEnds = new HashSet<DCIslandEnd>();
    private final Set<DCIsland> dcIslands = new HashSet<DCIsland>();

    public DCConversion(CgmesModel cgmesModel, Context context) {
        this.context = Objects.requireNonNull(context);
        this.cacheCgmesData(cgmesModel);
        this.computeDcData();
        this.convert();
    }

    private void cacheCgmesData(CgmesModel cgmesModel) {
        this.cgmesDcTerminalNodes = cgmesModel.dcTerminals();
        this.cgmesAcDcConverters = cgmesModel.acDcConverters();
        this.cgmesDcLineSegments = cgmesModel.dcLineSegments();
        this.cgmesDcSwitches = cgmesModel.dcSwitches();
        this.cgmesDcGrounds = cgmesModel.dcGrounds();
    }

    private void computeDcData() {
        this.computeDcEquipments();
        this.computeDcIslandEnds();
        this.computeDcIslands();
    }

    private void computeDcEquipments() {
        String node = this.context.nodeBreaker() ? "DCNode" : "DCTopologicalNode";
        this.cgmesDcTerminalNodes.forEach(t -> this.dcTerminalNodes.put(t.getId("DCTerminal"), t.getId(node)));
        this.cgmesAcDcConverters.forEach(c -> this.addDcEquipment((PropertyBag)c, "ACDCConverter"));
        this.cgmesDcLineSegments.forEach(l -> this.addDcEquipment((PropertyBag)l, "DCLineSegment"));
        this.cgmesDcSwitches.forEach(s -> this.addDcEquipment((PropertyBag)s, "DCSwitch"));
        this.cgmesDcGrounds.forEach(g -> this.addDcEquipment((PropertyBag)g, "DCGround"));
    }

    private void addDcEquipment(PropertyBag propertyBag, String type) {
        this.dcEquipments.add(new DCEquipment(propertyBag.getId(type), "ACDCConverter".equals(type) ? propertyBag.getLocal("type") : type, this.terminalNode(propertyBag.getId("DCTerminal1")), "DCGround".equals(type) ? null : this.terminalNode(propertyBag.getId("DCTerminal2"))));
    }

    private String terminalNode(String terminalId) {
        if (!this.dcTerminalNodes.containsKey(terminalId)) {
            throw new PowsyblException("DCTerminal not found");
        }
        return this.dcTerminalNodes.get(terminalId);
    }

    private void computeDcIslandEnds() {
        HashSet visitedDcEquipments = new HashSet();
        this.dcEquipments.stream().filter(DCEquipment::isConverter).forEach(acDcConverter -> {
            if (!visitedDcEquipments.contains(acDcConverter)) {
                HashSet<DCEquipment> dcIslandEnd = new HashSet<DCEquipment>();
                this.getAdjacentDcEquipments((DCEquipment)acDcConverter, (Set<DCEquipment>)dcIslandEnd);
                visitedDcEquipments.addAll(dcIslandEnd);
                this.dcIslandEnds.add(new DCIslandEnd(dcIslandEnd));
            }
        });
        HashSet<DCEquipment> notVisitedDcEquipments = new HashSet<DCEquipment>(this.dcEquipments);
        notVisitedDcEquipments.removeAll(visitedDcEquipments);
        notVisitedDcEquipments.forEach(dcEquipment -> CgmesReports.notVisitedDcEquipmentReport(this.context.getReportNode(), dcEquipment.id()));
    }

    private void getAdjacentDcEquipments(DCEquipment dcEquipment, Set<DCEquipment> dcIslandEnd) {
        if (!dcIslandEnd.contains(dcEquipment)) {
            dcIslandEnd.add(dcEquipment);
            if (!dcEquipment.isLine()) {
                this.dcEquipments.stream().filter(e -> e != dcEquipment && e.isAdjacentTo(dcEquipment) && !dcIslandEnd.contains(e)).forEach(e -> this.getAdjacentDcEquipments((DCEquipment)e, dcIslandEnd));
            }
        }
    }

    private void computeDcIslands() {
        HashSet visitedDcIslandEnds = new HashSet();
        this.dcIslandEnds.forEach(dcIslandEnd -> {
            if (!visitedDcIslandEnds.contains(dcIslandEnd)) {
                HashSet<DCIslandEnd> dcIsland = new HashSet<DCIslandEnd>();
                this.getAdjacentDcIslandEnds((DCIslandEnd)dcIslandEnd, (Set<DCIslandEnd>)dcIsland);
                visitedDcIslandEnds.addAll(dcIsland);
                this.dcIslands.add(new DCIsland(dcIsland));
            }
        });
    }

    private void getAdjacentDcIslandEnds(DCIslandEnd dcIslandEnd, Set<DCIslandEnd> dcIsland) {
        if (!dcIsland.contains(dcIslandEnd)) {
            dcIsland.add(dcIslandEnd);
            this.dcIslandEnds.stream().filter(end -> end != dcIslandEnd && end.isAdjacentTo(dcIslandEnd) && !dcIsland.contains(end)).forEach(end -> this.getAdjacentDcIslandEnds((DCIslandEnd)end, dcIsland));
        }
    }

    private void convert() {
        for (DCIsland dcIsland : this.dcIslands) {
            if (!dcIsland.valid(this.context)) continue;
            this.convertDcLinks(dcIsland);
        }
    }

    private void convertDcLinks(DCIsland dcIsland) {
        List<DCPole> dcPoles = this.getDcPoles(dcIsland);
        ArrayList<DCLink> dcLinks = new ArrayList<DCLink>();
        for (DCPole dcPole : dcPoles) {
            PropertyBag converter1 = this.getConverterBag(dcPole.getConverter1A());
            PropertyBag converter2 = this.getConverterBag(dcPole.getConverter2A());
            PropertyBag dcLine1 = this.getDcLineSegmentBag(dcPole.getDcLine1());
            PropertyBag dcLine2 = null;
            if (dcPole.getDcLine2() != null) {
                dcLine2 = this.getDcLineSegmentBag(dcPole.getDcLine2());
                if (dcPole.isHalfOfBipole()) {
                    dcLine2.put((Object)"r", (Object)"0");
                }
            }
            if (dcPole.getConverter1B() == null) {
                dcLinks.add(new DCLink(converter1, converter2, dcLine1, dcLine2));
                continue;
            }
            PropertyBag converter1B = this.getConverterBag(dcPole.getConverter1B());
            PropertyBag converter2B = this.getConverterBag(dcPole.getConverter2B());
            PropertyBag dcLine1B = this.splitDcLineSegmentBag(dcLine1);
            dcLinks.add(new DCLink(converter1, converter2, dcLine1, dcLine2));
            dcLinks.add(new DCLink(converter1B, converter2B, dcLine1B, null));
        }
        dcLinks.forEach(dcLink -> {
            new HvdcConverterConversion(dcLink.getConverter1(), this.context).convert();
            new HvdcConverterConversion(dcLink.getConverter2(), this.context).convert();
            new HvdcLineConversion((DCLink)dcLink, this.context).convert();
        });
    }

    private List<DCPole> getDcPoles(DCIsland dcIsland) {
        List<DCIslandEnd> islandEnds = dcIsland.dcIslandEnds().stream().sorted(Comparator.comparingLong(e -> e.getDcLineSegments().stream().filter(l -> e.dcEquipments().stream().anyMatch(eq -> !eq.equals(l) && eq.isConnectedTo(l.node1()))).count()).reversed().thenComparing(e -> e.getAcDcConverters().stream().map(DCEquipment::id).min(Comparator.naturalOrder()).orElseThrow())).toList();
        List<DCEquipment> converters1 = islandEnds.get(0).getAcDcConverters();
        List<DCEquipment> dcLineSegments = islandEnds.get(0).getDcLineSegments();
        boolean isBipole = converters1.size() > 1 && dcLineSegments.size() > 1;
        DCEquipment dMRLine = null;
        ArrayList<DCEquipment> energizedLines = new ArrayList<DCEquipment>(dcLineSegments);
        if (this.hasDMRLine(converters1.size(), dcLineSegments.size())) {
            dMRLine = this.getDMRLine(dcIsland, dcLineSegments);
            energizedLines.remove(dMRLine);
        }
        ArrayList<DCPole> dcPoles = new ArrayList<DCPole>();
        HashSet<DCEquipment> usedConverters1 = new HashSet<DCEquipment>();
        HashSet<DCEquipment> usedConverters2 = new HashSet<DCEquipment>();
        for (DCEquipment dcLineSegment : energizedLines) {
            Predicate<DCEquipment> eligibleConverter1 = e -> e.isConverter() && !usedConverters1.contains(e);
            DCEquipment converter1 = islandEnds.get(0).getNearestConverter(dcLineSegment, eligibleConverter1);
            usedConverters1.add(converter1);
            Predicate<DCEquipment> eligibleConverter2 = e -> e.type().equals(converter1.type()) && !usedConverters2.contains(e);
            DCEquipment converter2 = islandEnds.get(1).getNearestConverter(dcLineSegment, eligibleConverter2);
            usedConverters2.add(converter2);
            dcPoles.add(new DCPole(converter1, converter2, dcLineSegment, isBipole));
        }
        HashSet<DCEquipment> unmappedConverters1 = new HashSet<DCEquipment>(converters1);
        HashSet eligibleConverters1A = new HashSet(usedConverters1);
        unmappedConverters1.removeAll(usedConverters1);
        for (DCEquipment converter1B : unmappedConverters1) {
            Predicate<DCEquipment> eligibleConverter1A = e -> e.type().equals(converter1B.type()) && eligibleConverters1A.contains(e);
            DCEquipment converter1A = islandEnds.get(0).getNearestConverter(converter1B, eligibleConverter1A);
            eligibleConverters1A.remove(converter1A);
            DCPole dcPole = dcPoles.stream().filter(p -> p.getConverter1A().equals(converter1A)).findFirst().orElseThrow();
            DCEquipment converter2A = dcPole.getConverter2A();
            Predicate<DCEquipment> eligibleConverter2B = e -> e.type().equals(converter1B.type()) && !usedConverters2.contains(e);
            DCEquipment converter2B = islandEnds.get(1).getNearestConverter(converter2A, eligibleConverter2B);
            usedConverters2.add(converter2B);
            dcPole.addSecondBridge(converter1B, converter2B);
        }
        ((DCPole)dcPoles.get(0)).addMetallicReturnLine(dMRLine);
        return dcPoles;
    }

    private boolean hasDMRLine(int numberOfConverters, int numberOfLines) {
        return numberOfConverters == 1 && numberOfLines > 1 || numberOfLines > 2;
    }

    private DCEquipment getDMRLine(DCIsland dcIsland, List<DCEquipment> dcLineSegments) {
        List<DCEquipment> groundedLines = dcLineSegments.stream().filter(dcIsland::isGrounded).toList();
        if (groundedLines.size() == 1) {
            return groundedLines.get(0);
        }
        return dcLineSegments.get(dcLineSegments.size() - 1);
    }

    private PropertyBag splitDcLineSegmentBag(PropertyBag dcLineSegment) {
        double r = dcLineSegment.asDouble("r");
        r = Double.isNaN(r) ? 0.1 : r / 2.0;
        dcLineSegment.put((Object)"r", (Object)Double.toString(r));
        PropertyBag otherDcLineSegment = (PropertyBag)dcLineSegment.clone();
        otherDcLineSegment.put((Object)"DCLineSegment", (Object)((String)otherDcLineSegment.get((Object)"DCLineSegment") + "-1"));
        otherDcLineSegment.put((Object)"DCTerminal1", (Object)((String)otherDcLineSegment.get((Object)"DCTerminal1") + "-1"));
        otherDcLineSegment.put((Object)"DCTerminal2", (Object)((String)otherDcLineSegment.get((Object)"DCTerminal2") + "-1"));
        otherDcLineSegment.put((Object)"name", (Object)((String)otherDcLineSegment.get((Object)"name") + "-1"));
        return otherDcLineSegment;
    }

    private PropertyBag getConverterBag(DCEquipment acDcConverter) {
        return this.getPropertyBag(acDcConverter, this.cgmesAcDcConverters, "ACDCConverter");
    }

    private PropertyBag getDcLineSegmentBag(DCEquipment dcLineSegment) {
        return this.getPropertyBag(dcLineSegment, this.cgmesDcLineSegments, "DCLineSegment");
    }

    private PropertyBag getPropertyBag(DCEquipment dcEquipment, PropertyBags cachedPropertyBags, String propertyKey) {
        return cachedPropertyBags.stream().filter(b -> b.getId(propertyKey).equals(dcEquipment.id())).findFirst().orElseThrow();
    }
}

