/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.dc.DCConfiguration;
import com.powsybl.cgmes.conversion.elements.dc.DCEquipment;
import com.powsybl.cgmes.conversion.elements.dc.DCIslandEnd;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public record DCIsland(Set<DCIslandEnd> dcIslandEnds) {
    public boolean valid(Context context) {
        boolean validDcLineSegments = this.validDcLineSegments(context);
        boolean validAcDcConverters = this.validAcDcConverters(context);
        boolean validConfiguration = this.validConfiguration(context);
        return validDcLineSegments && validAcDcConverters && validConfiguration;
    }

    private boolean validDcLineSegments(Context context) {
        boolean valid = true;
        Map<DCEquipment, Long> dcLineSegmentsOccurrences = this.dcIslandEnds.stream().flatMap(end -> end.dcEquipments().stream()).filter(DCEquipment::isLine).collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        for (Map.Entry<DCEquipment, Long> dcLineSegmentOccurrences : dcLineSegmentsOccurrences.entrySet()) {
            if (dcLineSegmentOccurrences.getValue() == 2L) continue;
            CgmesReports.dcLineSegmentNotInTwoDCIslandEndReport(context.getReportNode(), dcLineSegmentOccurrences.getKey().id());
            valid = false;
        }
        return valid;
    }

    private boolean validAcDcConverters(Context context) {
        DCConfiguration dcConfiguration = this.getDcConfiguration();
        if (dcConfiguration == DCConfiguration.POINT_TO_POINT) {
            List ends = this.dcIslandEnds.stream().toList();
            long numberOfCsConverters1 = ((DCIslandEnd)ends.get(0)).dcEquipments().stream().filter(DCEquipment::isCsConverter).count();
            long numberOfCsConverters2 = ((DCIslandEnd)ends.get(1)).dcEquipments().stream().filter(DCEquipment::isCsConverter).count();
            long numberOfVsConverters1 = ((DCIslandEnd)ends.get(0)).dcEquipments().stream().filter(DCEquipment::isVsConverter).count();
            long numberOfVsConverters2 = ((DCIslandEnd)ends.get(1)).dcEquipments().stream().filter(DCEquipment::isVsConverter).count();
            if (numberOfCsConverters1 != numberOfCsConverters2 || numberOfVsConverters1 != numberOfVsConverters2) {
                CgmesReports.inconsistentNumberOfConvertersReport(context.getReportNode(), this.getConverterIds());
                return false;
            }
        }
        return true;
    }

    private boolean validConfiguration(Context context) {
        int numberOfConverterPairs;
        DCConfiguration dcConfiguration = this.getDcConfiguration();
        if (dcConfiguration != DCConfiguration.POINT_TO_POINT) {
            CgmesReports.unsupportedDcConfigurationReport(context.getReportNode(), this.getConverterIds(), dcConfiguration.name());
            return false;
        }
        List ends = this.dcIslandEnds.stream().toList();
        int numberOfLines = ((DCIslandEnd)ends.get(0)).getDcLineSegments().size();
        if (numberOfLines > (numberOfConverterPairs = ((DCIslandEnd)ends.get(0)).getAcDcConverters().size()) + 1 || numberOfConverterPairs > 2 * numberOfLines) {
            CgmesReports.unexpectedPointToPointDcConfigurationReport(context.getReportNode(), this.getConverterIds(), numberOfLines, numberOfConverterPairs);
            return false;
        }
        return true;
    }

    private DCConfiguration getDcConfiguration() {
        if (this.dcIslandEnds.size() > 2) {
            return DCConfiguration.MULTI_TERMINAL;
        }
        if (this.dcIslandEnds.size() == 2) {
            return DCConfiguration.POINT_TO_POINT;
        }
        return DCConfiguration.BACK_TO_BACK;
    }

    private String getConverterIds() {
        return String.join((CharSequence)", ", this.dcIslandEnds.stream().flatMap(end -> end.dcEquipments().stream()).filter(DCEquipment::isConverter).map(DCEquipment::id).sorted().toList());
    }

    public boolean isGrounded(DCEquipment dcEquipment) {
        return this.dcIslandEnds.stream().flatMap(e -> e.dcEquipments().stream()).filter(DCEquipment::isGround).anyMatch(g -> g.isAdjacentTo(dcEquipment));
    }
}

