/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.cgmes.conversion.elements.dc.DCEquipment;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public record DCIslandEnd(Set<DCEquipment> dcEquipments) {
    boolean isAdjacentTo(DCIslandEnd otherDcIslandEnd) {
        Set commonDcLineSegments = this.dcEquipments.stream().filter(DCEquipment::isLine).collect(Collectors.toSet());
        commonDcLineSegments.retainAll(otherDcIslandEnd.dcEquipments);
        return !commonDcLineSegments.isEmpty();
    }

    public List<DCEquipment> getAcDcConverters() {
        return this.dcEquipments.stream().filter(DCEquipment::isConverter).sorted(Comparator.comparing(DCEquipment::id)).toList();
    }

    public List<DCEquipment> getDcLineSegments() {
        return this.dcEquipments.stream().filter(DCEquipment::isLine).sorted(Comparator.comparing(this::getTotalDistanceToConverters).reversed().thenComparing(DCEquipment::id)).toList();
    }

    public DCEquipment getNearestConverter(DCEquipment dcEquipment, Predicate<DCEquipment> isEligibleConverter) {
        return this.getEquipmentDistances(dcEquipment).entrySet().stream().filter(e -> !((DCEquipment)e.getKey()).equals(dcEquipment) && isEligibleConverter.test((DCEquipment)e.getKey())).min(Map.Entry.comparingByValue().thenComparing(e -> ((DCEquipment)e.getKey()).id())).map(Map.Entry::getKey).orElseThrow();
    }

    private Integer getTotalDistanceToConverters(DCEquipment dcEquipment) {
        return this.getEquipmentDistances(dcEquipment).entrySet().stream().filter(e -> ((DCEquipment)e.getKey()).isConverter()).map(Map.Entry::getValue).mapToInt(Integer::intValue).sum();
    }

    private Map<DCEquipment, Integer> getEquipmentDistances(DCEquipment dcEquipment) {
        HashMap<DCEquipment, Integer> equipmentDistances = new HashMap<DCEquipment, Integer>();
        this.computeEquipmentDistances(dcEquipment, 0, equipmentDistances);
        return equipmentDistances;
    }

    private void computeEquipmentDistances(DCEquipment dcEquipment, int distance, Map<DCEquipment, Integer> equipmentDistances) {
        if (equipmentDistances.computeIfAbsent(dcEquipment, e -> Integer.MAX_VALUE) > distance) {
            equipmentDistances.put(dcEquipment, distance);
            Set nextDcEquipments = this.dcEquipments.stream().filter(e -> e != dcEquipment && e.isAdjacentTo(dcEquipment)).collect(Collectors.toSet());
            for (DCEquipment nextDcEquipment : nextDcEquipments) {
                this.computeEquipmentDistances(nextDcEquipment, distance + 1, equipmentDistances);
            }
        }
    }
}

